.386P
.MODEL FLAT , STDCALL
JUMPS
LOCALS

UNICODE=0
INCLUDE 	W32.inc
INCLUDE 	BasicWiz.inc
INCLUDE		Resource.ash

PUBLICDLL	BuildSkeleton

EXTRN		wsprintf	: PROC
EXTRN		MakeMappedFile	: PROC
EXTRN		EndMappedFile	: PROC

.data
g_hInst		DD	0
WizardStruc	WIZARDINPUT	<0>
szAppName	DB	30 dup (0)
szResDefh	DB	30 dup (0)
szResDefAsh	DB	"%s.ash", 0
StrBuffer	DB	100 dup(0)

; File names
szStartUp	DB	"%s\%s.asm", 0
szWinMain	DB	"%s\WinMain.asm", 0
szMainData	DB	"%s\MainData.asm", 0
szWinDef	DB	"%s\%s.def", 0
szMakeFile	DB	"%s\Makefile", 0
szDoBat		DB	"%s\Do.bat", 0
.code

Start:
; initialization

;------------------------------------------------------------------------------
DllMain		PROC	hInst: HINSTANCE, fdwRazao: DWORD, pvReservado: PVOID
	push	ebx ecx edx esi edi
	mov	eax, fdwRazao
@@0:	cmp	eax, 0
	jnz	@@1
; DLL_PROCESS_DETACH
	jmp	@@ReturnTrue
@@1:	cmp	eax, 1
	jnz	@@2
; DLL_PROCESS_ATACH
	mov	eax, hInst
	mov	g_hInst, eax	
	jmp	@@ReturnTrue
@@2:	cmp	eax, 2
	jnz	@@3
; DLL_THREAD_DETACH
	jmp	@@ReturnTrue
@@3:	cmp	eax, 3
	jnz	@@ReturnTrue
; DLL_THREAD_DETACH
	jmp	@@ReturnTrue
@@ReturnTrue:
	mov 	eax, TRUE
	jmp	@@End
@@ReturnFalse:
	mov	eax, FALSE
@@End:
	pop	edi esi edx ecx ebx	
	ret
DllMain		ENDP

;------------------------------------------------------------------------------
BuildSkeleton		PROC	BasicParams:DWORD
	push	ebx ecx edx esi edi
; copy parameters to our internal structure
	call	CopyParameters, BasicParams
; check parameters
	call	CheckParameters
	cmp	eax, FALSE
	jz	@@ReturnFalse
; get Application file name based on .RC file
	call	GetAppName
; create AppName.asm file
	call	CreateStartUp
	cmp	eax, FALSE
	jz	@@ReturnFalse
; create WinMain.asm file
	call	CreateWinMain
	cmp	eax, FALSE
	jz	@@ReturnFalse
; create MainData file
	call	CreateMainData
	cmp	eax, FALSE
	jz	@@ReturnFalse
; create AppName.def file
	call	CreateDef
	cmp	eax, FALSE
	jz	@@ReturnFalse
; create MAKEFILE file
	call	CreateMakefile
	cmp	eax, FALSE
	jz	@@ReturnFalse
; create Do.bat file
	call	CreateDoBat
	cmp	eax, FALSE
	jz	@@ReturnFalse

	jmp	@@ReturnTrue	

@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE
@@End:
	pop	edi esi edx ecx ebx
	ret
BuildSkeleton		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CopyParameters		PROC	BasicParams:DWORD
	push	ebx ecx edx esi edi
; verify if BasicParams is a valid pointer
	call	IsBadReadPtr, BasicParams, WIZARDINPUT_
	cmp 	eax, TRUE
	jz	@@ReturnFalse
; copy structure
	mov	esi, BasicParams
	lea	edi, WizardStruc
	mov	ecx, WIZARDINPUT_
	cld
	rep	movsb
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CopyParameters		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CheckParameters		PROC
	push	ebx ecx edx esi edi
	call	IsBadStringPtr, WizardStruc.AppTitle, 200
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.AppPath, MAX_PATH
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.RCFileName, MAX_PATH
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.RCDefFileName, MAX_PATH
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.MainClass, 30
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.MainMenu, 30
	cmp	eax, TRUE
	jz	@@ReturnFalse
	call	IsBadStringPtr, WizardStruc.ClassStyle, 200
	cmp	eax, TRUE
	jz	@@ReturnFalse
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CheckParameters		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateStartUp		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get AppName.asm skeleton
	call	FindResource, g_hInst, IDF_STARTUP, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of AppName skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, WizardStruc.AppTitle
	add	edx, eax			; add AppTitle str size
	call	StrLen, WizardStruc.RCDefFileName
	add	edx, eax			; add Res Def File str size
	add	edx, 2				; add (XXXX.ash - XXXX.h)
	sub	edx, 4				; sub 2 x "%s"
	mov	FileSize, edx
; allocate space to hold file AppName.asm file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; create Asm resource filename (ResDef.ash)
	call	StrLen, WizardStruc.RCDefFileName
	mov	ecx, eax
	mov	esi, WizardStruc.RCDefFileName
	lea	edi, szResDefh
	cld
	rep	movsb
	mov	byte ptr [edi-2], 0
	call	wsprintf, offset StrBuffer, offset szResDefAsh, offset szResDefh
	add	esp, 12
	
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, WizardStruc.AppTitle, offset StrBuffer
; create file name
	call	wsprintf, offset StrBuffer, offset szStartUp, WizardStruc.AppPath, offset szAppName
	add	esp, 16
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close AppName.asm file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateStartUp		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateWinMain		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get WinMain.asm skeleton
	call	FindResource, g_hInst, IDF_WINMAIN, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of WinMain skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, WizardStruc.AppTitle
	add	edx, eax			; add AppTitle str size
	call	StrLen, WizardStruc.ClassStyle	
	add	edx, eax			; add ClassStyle str size
	call	StrLen, WizardStruc.MainIcon	
	add	edx, eax			; add MainIcon str size
	call	StrLen, WizardStruc.MainMenu	
	add	edx, eax			; add MainMenu str size
	sub	edx, 8				; sub 4 x "%s"
	mov	FileSize, edx
; allocate space to hold file WinMain.asm file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, WizardStruc.AppTitle, WizardStruc.ClassStyle, WizardStruc.MainIcon, WizardStruc.MainMenu
	add	esp, 24
; create file name
	call	wsprintf, offset StrBuffer, offset szWinMain, WizardStruc.AppPath
	add	esp, 12
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close WinMain.asm file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateWinMain		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateMainData		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get MainData.asm skeleton
	call	FindResource, g_hInst, IDF_MAINDATA, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of MainData skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, WizardStruc.AppTitle
	add	edx, eax			; add AppTitle str size
	call	StrLen, WizardStruc.AppTitle	
	add	edx, eax			; add AppTitle str size
	call	StrLen, WizardStruc.MainClass	
	add	edx, eax			; add MainClass str size
	sub	edx, 6				; sub 3 x "%s"
	mov	FileSize, edx

; allocate space to hold file MainData.asm file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, WizardStruc.AppTitle, WizardStruc.AppTitle, WizardStruc.MainClass
	add	esp, 20
; create file name
	call	wsprintf, offset StrBuffer, offset szMainData, WizardStruc.AppPath
	add	esp, 12
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close MainData.asm file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateMainData		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateDef		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get AppName.def skeleton
	call	FindResource, g_hInst, IDF_WINDEF, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of AppName.def skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, offset szAppName
	add	edx, eax			; add szAppName str size
	call	StrLen, WizardStruc.AppTitle	
	add	edx, eax			; add AppTitle str size
	sub	edx, 4				; sub 2 x "%s"
	mov	FileSize, edx
; allocate space to hold file AppName.def file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, offset szAppName, WizardStruc.AppTitle
	add	esp, 16
; create file name
	call	wsprintf, offset StrBuffer, offset szWinDef, WizardStruc.AppPath, offset szAppName
	add	esp, 16
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close AppName.def file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateDef		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateMakefile		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get Makefile skeleton
	call	FindResource, g_hInst, IDF_MAKEFILE, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of MainData skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, WizardStruc.AppTitle
	add	edx, eax			; add AppTitle str size
	call	StrLen, offset szAppName	
	add	edx, eax			; add szAppName str size
	sub	edx, 4				; sub 2 x "%s"
	mov	FileSize, edx
; allocate space to hold file Makefile file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, WizardStruc.AppTitle, offset szAppName
	add	esp, 16
; create file name
	call	wsprintf, offset StrBuffer, offset szMakeFile, WizardStruc.AppPath
	add	esp, 12
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close Makefile file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateMakefile		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
CreateDoBat		PROC
	LOCAL	ResourceAddr:DWORD, FileSize:DWORD, ContentsAddr:DWORD
	push	ebx ecx edx esi edi
; get Do.bat skeleton
	call	FindResource, g_hInst, IDF_DOBAT, FILETYPE
	call	LoadResource, g_hInst, eax
	call	LockResource, eax
	mov	ResourceAddr, eax
; get size of Do.bat skeleton
	call	StrLen, ResourceAddr
	mov	edx, eax
; calculate size for the target file
	call	StrLen, WizardStruc.AppTitle
	add	edx, eax			; add AppTitle str size
	call	StrLen, WizardStruc.RCDefFileName	
	add	edx, eax			; add RCDefFileName str size
	sub	edx, 4				; sub 2 x "%s"
	mov	FileSize, edx
; allocate space to hold file Do.bat file contents
	call	VirtualAlloc, NULL, FileSize, MEM_COMMIT, PAGE_READWRITE
	cmp	eax, NULL
	jz	@@ReturnFalse
	mov	ContentsAddr, eax
; update content of file
	call	MakeString, ContentsAddr, ResourceAddr, WizardStruc.AppTitle, WizardStruc.RCDefFileName
	add	esp, 16
; create file name
	call	wsprintf, offset StrBuffer, offset szDoBat, WizardStruc.AppPath
	add	esp, 12
; create file
	call	MakeMappedFile, 0, offset StrBuffer, FileSize, CREATE_ALWAYS
	cmp	eax, FALSE
	jz	@@ReturnFalse
; copy contents to file
	mov	esi, ContentsAddr
	mov	edi, eax
	mov	ecx, FileSize
	cld
	rep	movsb
; free allocated memory
	call	VirtualFree, ContentsAddr, FileSize, MEM_DECOMMIT
; close Do.bat file
	call	EndMappedFile, 0
	jmp	@@ReturnTrue
@@ReturnFalse:
	mov	eax, FALSE
	jmp	@@End
@@ReturnTrue:
	mov	eax, TRUE	
@@End:
	pop	edi esi edx ecx ebx
	ret
CreateDoBat		ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
StrLen	PROC	StrOffset:DWORD
	push 	ecx edi
	mov	edi, StrOffset
	xor	eax, eax
	mov	ecx, -1
	repnz	scasb
	not	ecx
	dec 	ecx
	mov	eax, ecx	
	pop	edi ecx
	ret
StrLen	ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
GetAppName	PROC
	pusha
; make	Application name
	mov 	esi, WizardStruc.RCFileName
	lea	edi, szAppName
	call	StrLen, esi
	mov	ecx, eax
	sub	ecx, 3
	cld
	rep	movsb
	mov	byte ptr [edi], 0
	popa
	ret
GetAppName	ENDP
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
MakeString:
	push	ebp
	mov	ebp, esp
	push	eax ebx ecx edx esi edi
	mov 	edi, [ebp+8]
	mov	esi, [ebp+12]
	mov	ebx, ebp
	add	ebx, 16
@@Loop1:
	cmp	byte ptr [esi], 0
	jz	@@End
	cmp	word ptr [esi], "s%"
	jz	@@InsertString
	movsb
	jmp	@@Loop1
@@InsertString:
	push	esi
	mov	edx, [ebx]
	mov	esi, edx
	call	StrLen, esi
	mov	ecx, eax
	rep	movsb
	pop	esi
	add	esi, 2
	add 	ebx, 4
	jmp	@@Loop1
@@End:

	pop	edi esi edx ecx ebx eax
	pop	ebp
	ret
;------------------------------------------------------------------------------

ends
end Start
