#include <stdio.h>
#include <fastgraf.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>


void test_args(int argc,char **argv,char *giffile);
void convert_gif(char *giffile);
void usage_exit(void);



int main (int argc, char **argv)
{
   char giffile[2000];

   test_args(argc,argv,giffile);
   convert_gif(giffile);
   printf("Done.\n");
   return 0;
}

void test_args(int argc, char **argv, char *giffile)
{
   int x=0;

   if (argc!=2) usage_exit();
   strcpy(giffile,argv[1]);
   while (argv[1][x]!='.' && argv[1][x]!='\0') x++;
   if (argv[1][x]!='.')
      strcat(giffile,".gif");
}

void usage_exit(void)
{
   printf("GREY: a color to greyscale converter for GIF files\n");
   printf("USAGE: grey <giffile[.gif]>\n");
   printf("		the .gif extension is assumed and optional.\n");
   printf("		WARNING: grey creates a new .gif called NEWGREY.GIF\n");
   printf("			and will overwrite any file by this name.\n");
   exit(0);
}

void convert_gif(char *giffile)
{
   int oldmode=0,x=0,y,pixel;
   int r,g,b;
   int rgbs[256];

   oldmode=fg_getmode();
   fg_setmode(23);
   x=fg_showgif(giffile,0);
   if (x!=0)
   {
      fg_setmode(oldmode);
      if (x==1)
	 printf("file %s not found.\n",giffile);
      else if (x==2)
	 printf("file %s not a valid GIF file\n",giffile);
      exit(0);
   }
   for (x=0;x<256;x++)
   {                                          //map luminosities
      fg_getrgb(x,&r,&g,&b);
      rgbs[x]=(int)(0.299*r+0.587*g+0.114*b);
   }


   for (x=0;x<320;x++)
      for (y=0;y<480;y++)
      {
	 pixel=fg_getpixel(x,y);
	 fg_setcolor(rgbs[pixel]*4);
	 fg_point(x,y);
      }

     for (x=0;x<256;x++)
     {                                      //map palettes
	fg_setrgb(x,x/4,x/4,x/4);
     }

   fg_makegif(0,319,0,479,"NEWGREY.GIF");
   fg_setmode(oldmode);
}
