; By UncleVan
		TITLE Convert - converts hex dump from ASCII back to binary
		INCLUDE	COMMON.INC

		.DATA
szConvertError	SBYTE "Some error converting source!"
szOpenError	sbyte	"Error opening file!",0Ah,0Ah
szReadError	sbyte	"Error reading file!",0Ah,0Ah
szMemError	sbyte "Error allocating memory!",0Ah, 0Ah
szCreateError	sbyte "Error creating new file!",0Ah, 0Ah

dwFlag		DWORD 0h

		.DATA?
dwBytesRead	DWORD ?
dwFileSize      DWORD ?
dwPtrBuffer	DWORD ?
dwPtrDest	DWORD ?
dwNBytes	DWORD ?
hDestAlloc	HANDLE ?
hSourceAlloc	HANDLE ?
		.CODE


; Opens the target reads it in and closes it:
Read            proc	stdcall uses esi edi
		and	dwFlag, 0h
		cmp	hFile, 0h
		jz	@F
		invoke	CloseHandle, hFile
		
@@:		invoke 	CreateFile, addr szFile, GENERIC_READ, 3h, 0h, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0h
		cmp 	eax, INVALID_HANDLE_VALUE
		jz	errorOpen		
		mov 	hFile, eax
		invoke 	GetFileSize, hFile, 0h
		mov	ebx, eax
		mov     dwFileSize, eax
		invoke	GlobalAlloc, 2h, eax
		mov	hSourceAlloc, eax
		invoke	GlobalLock, eax
		test	eax, eax
		jz	errorMem
		mov     dwPtrBuffer, eax
		invoke	ReadFile, hFile, eax, ebx, addr dwBytesRead, 0h
		test 	eax, eax
		jz	errorRead
		or	dwFlag, 1h ; <======== set OK flag for convert
		jmp	exit


errorRead:	INVOKE	GetLastError
		invoke MessageBox, hMainWnd, ADDR szReadError, ADDR szClassName, MB_OK + MB_ICONERROR
		jmp	exit		
errorOpen:	INVOKE	GetLastError
		invoke MessageBox, hMainWnd, ADDR szOpenError, ADDR szClassName, MB_OK + MB_ICONERROR
		jmp	exit
errorMem:	INVOKE	GetLastError
		invoke MessageBox, hMainWnd, ADDR szMemError, ADDR szClassName, MB_OK + MB_ICONERROR


exit:		ret
Read            endp


;converts the bufffer 
Convert		proc	stdcall	uses edi esi edx
		cmp	dwFlag, 0h 	; read OK?
		jz	toEnd		; nothing to do...	
		invoke	GlobalAlloc, 2h, dwFileSize
		mov	hDestAlloc, eax
		invoke	GlobalLock, eax
		test	eax, eax
		jz	toError
		mov	dwPtrDest, eax
		mov	edi, dwPtrDest
		mov 	esi, dwPtrBuffer
		mov	dwNBytes, edi ; <====== for counter
		cld
		mov	ecx, dwFileSize
		mov	edx, 02h ; <=== the Pair advisor
		xor	eax, eax

; convert section:
next:		lodsb
		cmp	al, '0'
		jb	toLoop
		cmp	al, '9'
		jbe	isDigit
isUpper:	cmp	al, 'A'
		jb	toLoop
		cmp	al, 'F'
		jbe	isUpperHex
isLower:	cmp	al, 'a'
		jb	toLoop
		cmp	al, 'f'
		jbe	isLowerHex
		jmp	toLoop
isDigit:	sub	al, '0'
		jmp	pairIt
isUpperHex:	sub	al, 37h
		jmp	pairIt
isLowerHex:	sub   	al, 57h

pairIt:		dec	edx
		jz	arePair
		xchg	al, bl
		shl	bl, 04h
		jmp	toLoop
arePair:	or	al, bl
		stosb
		mov	edx, 02h
toLoop:		loop	next

		or	eax, 01h ; <===== return OK
		cmp	edx, 01h
		jnz	toWrite
		or	al, bl ;   <===== in case of odd file size
		stosb

; write section
toWrite:	sub	edi, dwNBytes ; now EDI=number of bytes read 
		movzx	eax, ofn.nFileExtension ; to strip
		add	eax, OFFSET szFile	; the old extension
 		mov	dword ptr [eax], "nib"	; and add ours
		mov	byte ptr [eax+3h], 0h	; ...don't forget the Terminator
		invoke 	CreateFile, addr szFile, GENERIC_WRITE, 3h, 0h, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0h
		cmp 	eax, INVALID_HANDLE_VALUE
		jz	toCreateError
		mov	hFile, eax
		invoke	WriteFile, hFile, dwPtrDest, edi, addr dwBytesRead, 0h

		invoke	CloseHandle, hFile
		invoke	CloseHandle, hDestAlloc
		invoke	CloseHandle, hSourceAlloc
		jmp	toEnd

toError:	INVOKE	GetLastError
		invoke MessageBox, hMainWnd, ADDR szMemError, ADDR szClassName, MB_OK + MB_ICONERROR
		xor	eax, eax ; <===== return FALSE
		jmp	toEnd
toCreateError:	INVOKE	GetLastError
		invoke MessageBox, hMainWnd, ADDR szCreateError, ADDR szClassName, MB_OK + MB_ICONERROR
		xor	eax, eax ; <===== return FALSE
		
toEnd:		ret
Convert		endp	
		end
