// ExpDlg.cpp : implementation file
//
// This module implements the Export Options dialog.
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include "stdafx.h"
#include "OpenTrap.h"
#include "OTExtern.h"
#include "ExpDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExpDlg dialog


CExpDlg::CExpDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExpDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExpDlg)
	m_bUseFilters = FALSE;
	m_intFormat = -1;
	m_bRecNums = FALSE;
	//}}AFX_DATA_INIT
}


void CExpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExpDlg)
	DDX_Control(pDX, IDC_chkUseFilters, m_chkUseFilters);
	DDX_Check(pDX, IDC_chkUseFilters, m_bUseFilters);
	DDX_Radio(pDX, IDC_optFormat, m_intFormat);
	DDX_Check(pDX, IDC_chkRecNums, m_bRecNums);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExpDlg, CDialog)
	//{{AFX_MSG_MAP(CExpDlg)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_CONTEXT_HELP, OnContextHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExpDlg message handlers

BOOL CExpDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// Disable the Filtered Records Only checkbox if there are no filters in effect.
	m_chkUseFilters.EnableWindow(g_bUseFilters);
	return TRUE;	              
}

// Handler for right-mouse help.
void CExpDlg::OnContextMenu(CWnd* pWnd, CPoint point)
{
	CPoint ptClient = point;
	CWnd* wndTarget;
	UINT id = 0;
	ScreenToClient(&ptClient);
	wndTarget = ChildWindowFromPoint(ptClient, CWP_SKIPTRANSPARENT);
	if (wndTarget == this)
		wndTarget = ChildWindowFromPoint(ptClient);
	if (wndTarget)
		id = wndTarget->GetDlgCtrlID();
	if (id == 0 || id == IDOK || id == IDCANCEL)
		return;
	else
		m_intHelpContext = id + 0x40000;
	CMenu my_menu;
	my_menu.CreatePopupMenu();
	my_menu.AppendMenu(MF_ENABLED, ID_CONTEXT_HELP, "What's this?");
	my_menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, point.x, point.y, this);
}

void CExpDlg::OnContextHelp()
{
	WinHelp(m_intHelpContext, HELP_CONTEXTPOPUP);
}
