// OpenTrap.cpp : Defines the class behaviors for the application.
//
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include "stdafx.h"
#include <afxpriv.h>		//Required for override of OnUpdateRecentFileMenu();
#include "OpenTrap.h"

#include "MainFrm.h"
#include "OTDoc.h"
#include "OTView.h"
#include "OTextern.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyCmdLine class for processing custom command line options
// If a given setting or group of settings was specified on the command line,
// this routine sets all the global variables in that category appropriately
// (either to their defaults, or the value specified on the command line)
// and sets a flag indicating it has done so.
class CMyCmdLine : public CCommandLineInfo
{
	// Functions
public:
	CMyCmdLine();	
	// All we really need is an override of ParseParam
	virtual void ParseParam(LPCTSTR lpsxParam, BOOL bFlag, BOOL bLast);

	// Member variables.
public:
	BOOL m_bUninstall;
	BOOL m_bAutoStart;
	BOOL m_bExportOptsSet;
	BOOL m_bLogSizeSet;
	BOOL m_bLogOptsSet;
	BOOL m_bShowNumsSet;
	BOOL m_bFilterOptsSet;
};

CMyCmdLine::CMyCmdLine() : CCommandLineInfo()
{
	// Initialize our member variables.
	m_bUninstall		= FALSE;
	m_bAutoStart		= FALSE;
	m_bExportOptsSet	= FALSE;
	m_bLogSizeSet		= FALSE;
	m_bLogOptsSet		= FALSE;
	m_bShowNumsSet		= FALSE;
	m_bFilterOptsSet	= FALSE;
}

// Parses individual parameters and sets global variables accordingly.
// Note that this function requires using the function form of toupper()
// so that the pointer "p" gets incremented properly in the switch statements.
void CMyCmdLine::ParseParam(LPCTSTR lpszParam, BOOL bFlag, BOOL bLast)
{
	const char *p = lpszParam;

	if (bFlag)
	{	
		switch ((toupper)(*p++))					// Test current char, point to next.
		{
		case 'U': m_bUninstall = TRUE; break;		// Uninstall
		case 'A': m_bAutoStart = TRUE; break;		// AutoStart
		case 'E':								// Export options:
			m_bExportOptsSet = TRUE;
			while (*p)
			{	
				switch ((toupper)(*p++))			// Test current char, point to next.
				{
				case 'R': g_bExportRecNums = TRUE; break;		// Record numbers
				case 'C': g_bCommaDelimited = TRUE; break;		// Comma-delimited
				case 'F': g_bWriteFiltered = TRUE;				// Write with filters.
				}
			}
			break;
		case 'F':								// Filter Options:
			m_bFilterOptsSet = TRUE;
			switch ((toupper)(*p++))
			{
			case 'B':						// Base name filter.
				if (*p)
				{
					g_strFilterFileName = p;
					g_strFilterFileName.MakeUpper();
				}
				g_bFilterFileName = !g_strFilterFileName.IsEmpty();
				break;
			case 'T':						// Event type
				while (*p)
				{
					switch ((toupper)(*p++))	// Test current char, point to next.
					{
					case 'O': g_intFilterEvents = 1; break;		// Opens only.
					case 'E': g_bFilterErrorsOnly = TRUE;		// Errors only.
					}
				}
				break;
			case 'M':						// Module Name
				g_strFilterModuleName = p;
				g_bFilterModule = TRUE;
				g_strFilterModuleName = g_strFilterModuleName.Left(8);
				g_strFilterModuleName.MakeUpper();
				break;
			case 'E':						// File Extension
				g_strFilterFileExt = p;
				g_strFilterFileExt.MakeUpper();
				g_bFilterFileExt = TRUE;
			}
			break;
		case 'L':								// Logging options:
			m_bLogOptsSet = TRUE;
			while (*p)
			{
				switch ((toupper)(*p++))						// Test current char, point to next.
				{
				case 'H': g_bHide = TRUE; break;				// Hide to system tray.
				case 'E': g_bLogErrorsOnly = TRUE; break;		// Log errors only.
				case 'O': g_bLogOpensOnly = TRUE; break;		// Log opens only.
				case 'A': g_dwWatchVM = LOG_ALL; break;			// Log all apps.
				case 'D': g_dwWatchVM = LOG_ALL_DOS; break;		// DOS apps only.
				case 'W': g_dwWatchVM = LOG_WINDOWS_ONLY;		// Win apps only.
				}
			}
			break;
		case 'B':									// Buffer Size.
			m_bLogSizeSet = TRUE;
			g_intLogSizeK = atoi(p);
			if (g_intLogSizeK > 2048) 
				g_intLogSizeK = 2048;
			else
				if (g_intLogSizeK < 64) 
					g_intLogSizeK = 64;
			break;
		case 'R':									// Record numbers.
			m_bShowNumsSet = TRUE;
			g_bShowNums = ((toupper)(*p) == 'S');
			break;
		default:	// Call base class if switch was not one of ours.
			CCommandLineInfo::ParseParam(lpszParam, bFlag, bLast);
		}
	}
	else	// Call base class if parm was not a switch.
		CCommandLineInfo::ParseParam(lpszParam, bFlag, bLast);
	if (bLast)	// Once the last parm has been processed,
		if (!m_strFileName.IsEmpty())			// See if filename was specified.
			if (m_strFileName.Find('.') == -1)	// If so, does it contain a "."?
				m_strFileName += ".otl";		// If not, append extension.
}

/////////////////////////////////////////////////////////////////////////////
// COpenTrapApp

BEGIN_MESSAGE_MAP(COpenTrapApp, CWinApp)
	//{{AFX_MSG_MAP(COpenTrapApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	// Intercept File MRU commands.
	ON_UPDATE_COMMAND_UI(ID_FILE_MRU_FILE1, OnUpdateRecentFileMenu)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenTrapApp construction

COpenTrapApp::COpenTrapApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only COpenTrapApp object

COpenTrapApp theApp;

/////////////////////////////////////////////////////////////////////////////
// COpenTrapApp initialization

BOOL COpenTrapApp::InitInstance()
{
	// First, make sure we're running under Win 95.
	if (!Check_Version())
	{
		::MessageBox(NULL, "This program runs only under Windows 95", "OpenTrap", MB_ICONSTOP);
		return FALSE;
	}
	myAtom = ::GlobalFindAtom("OpenTrap running");

// Code allows developer to delete the atom in the Debug version in the
// event that the program terminates abnormally and fails to delete its global atom.
// If you take advantage of this, make _sure_ that no other instances of
// the program are running before answering "Yes" to the "delete it?" prompt.
// Because of the #ifdef directive, this code will not appear in the Release build.
#ifdef _DEBUG
	if (myAtom)
	{
		if (::MessageBox(NULL, "Atom exists, delete it?", "OpenTrap", MB_YESNO) == IDYES)
		{
			GlobalDeleteAtom(myAtom);
			myAtom = 0;
		}
	}
#endif

	if (myAtom)
	{
		::MessageBox(NULL, "OpenTrap is already running.\n", "OpenTrap", MB_OK);
		myAtom = 0;
		return FALSE;
	}
	else
	{
		myAtom = ::GlobalAddAtom("OpenTrap running");
	}
	SetRegistryKey("PC Magazine");
	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(COpenTrapDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(COpenTrapView));
	AddDocTemplate(pDocTemplate);
	pDocTemplate->GetDocString(m_strRegDocType, CDocTemplate::regFileTypeId);
	// Parse command line
	CMyCmdLine cmdInfo;
	ParseCommandLine(cmdInfo);
	if (cmdInfo.m_bUninstall)						// If uninstall was specified,
	{
		if (::MessageBox(NULL,						// Ask user if he that's what
			"Uninstall option (/U) specified.\n\n"	// he really wants.
			"This will remove all of OpenTrap's\n"
			"data from the Registry.\n\n"
			"Are you sure you wish to proceed?",
			"OpenTrap", MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON2) == IDYES)
		{
			m_bUninstall = TRUE;					// If so, set flag and
			return FALSE;							// exit application.
		}
		else										// Otherwise, launch normally.
			::MessageBox(NULL, "Uninstall cancelled.", "OpenTrap", MB_OK);
	}
	LoadStdProfileSettings(4);  // Load standard INI file options (including MRU)
	// If a specific setting or group of settings was not specified
	// on the command line, load them from the Registry.
	if (!cmdInfo.m_bLogSizeSet)
		g_intLogSizeK = GetProfileInt(g_szLogKey, "BufferSizeK", 64);
	if (!cmdInfo.m_bLogOptsSet)
	{
		g_bLogErrorsOnly = GetProfileInt(g_szLogKey, "LogErrorsOnly", FALSE);
		g_dwWatchVM = GetProfileInt(g_szLogKey, "WatchVMs", LOG_ALL);
		g_bLogOpensOnly = GetProfileInt(g_szLogKey, "LogActions", FALSE);
		g_bHide = GetProfileInt(g_szLogKey, "UseTaskBar", FALSE);
	}
	if (!cmdInfo.m_bShowNumsSet)
		g_bShowNums = GetProfileInt(g_szViewKey, "ShowNums", FALSE);
	if (!cmdInfo.m_bExportOptsSet)
	{
		g_bExportRecNums = GetProfileInt(g_szExportKey, "RecNums", FALSE);
		g_bCommaDelimited = GetProfileInt(g_szExportKey, "Delimited", FALSE);
		g_bWriteFiltered = GetProfileInt(g_szExportKey, "Filtered", FALSE);
	}
	if (!cmdInfo.m_bFilterOptsSet)
	{
		g_bFilterFileName = GetProfileInt(g_szViewKey, "UseBase", FALSE);
		g_strFilterFileName = GetProfileString(g_szViewKey, "Base", "");
		g_bFilterFileExt = GetProfileInt(g_szViewKey, "UseExt", FALSE);
		g_strFilterFileExt = GetProfileString(g_szViewKey, "Ext", "");
		g_bFilterModule = GetProfileInt(g_szViewKey, "UseModule", FALSE);
		g_strFilterModuleName = GetProfileString(g_szViewKey, "Module", "");
		g_intFilterEvents = GetProfileInt(g_szViewKey, "Events", 0);
		g_bFilterErrorsOnly = GetProfileInt(g_szViewKey, "Errors", FALSE);
	}
	RegisterShellFileTypes(TRUE);		// Set association for .OTL files.
	EnableShellOpen();				// Allow launching .OTL files from Explorer.
	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
	g_hWndMainFrame = m_pMainWnd->m_hWnd;
	// If /S specified, post message to start logging immediately.
	if (cmdInfo.m_bAutoStart)
		::PostMessage(m_pMainWnd->m_hWnd, WM_COMMAND, ID_LOGGING_START, 0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void COpenTrapApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// COpenTrapApp commands

int COpenTrapApp::ExitInstance() 
{
	if (g_pBufferStart != NULL)		// If buffer is still allocated,
	{
		delete [] g_pBufferStart;	// release it.
		g_pBufferStart = NULL;
	}
	if (myAtom)						// Delete atom used to detect multiple instances.
		::GlobalDeleteAtom(myAtom);
	if (!m_bUninstall)				// If uninstall not specified, save settings.
	{
		WriteProfileInt(g_szViewKey, "ShowNums", g_bShowNums);
		WriteProfileInt(g_szExportKey, "RecNums", g_bExportRecNums);
		WriteProfileInt(g_szExportKey, "Delimited", g_bCommaDelimited);
		WriteProfileInt(g_szExportKey, "Filtered", g_bWriteFiltered);
	}
	else
	{
		Do_Uninstall();
	}
	return CWinApp::ExitInstance();
}

BOOL COpenTrapApp::Check_Version(void)
{
	OSVERSIONINFO vi;

	vi.dwOSVersionInfoSize = sizeof(vi);
	GetVersionEx(&vi);
	return (vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS);
}

// Handles uninstall.
void COpenTrapApp::Do_Uninstall(void)
{
	HKEY base_key;
	LONG result;
	unsigned char buf[256];
	DWORD chars_read, reg_type;
	BOOL flag;

	// Open registry key for PC Mag utils.
	result = RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\PC Magazine", 0, KEY_ALL_ACCESS, &base_key);
	if (SUCCEEDED(result))
	{
		result |= RegDeleteKey(base_key, "OpenTrap");		// Delete our settings.
		result |= RegCloseKey(base_key);
		if (SUCCEEDED(result))								// If ok so far,
		{													// Check file association.
			result = RegOpenKeyEx(HKEY_CLASSES_ROOT, ".otl", 0, KEY_QUERY_VALUE, &base_key);
			if (SUCCEEDED(result))
			{
				chars_read = 256;							// Retrieve default file type string.
				result = RegQueryValueEx(base_key, "", 0, &reg_type, buf, &chars_read);
				if (SUCCEEDED(result))
				{
					RegCloseKey(base_key);					// Is it the correct string?
					flag = m_strRegDocType.CompareNoCase((const char *) buf) == 0;
					if (!flag)								// Ask user if he wants to remove
						flag =	::MessageBox(NULL, 			// The association.
								"The .OTL extension is apparently associated\n"
								"with a different application. Do you wish to\n"
								"remove the association anyway?",
								"Uninstall OpenTrap",
								MB_ICONQUESTION | MB_YESNO) == IDYES;
					if (flag)								// If user said yes, remove the association.
					{
						result |= RegDeleteKey(HKEY_CLASSES_ROOT, ".otl");
						result |= RegDeleteKey(HKEY_CLASSES_ROOT, m_strRegDocType);
					}
					else
						result = 0;							// Otherwise indicate success.
				}
				else
				{
					RegCloseKey(base_key);					// Make sure the key is closed!
				}
			}
		}
	}
	if (SUCCEEDED(result))			// Report sucess or failure.
	{
		::MessageBox(NULL,
			"Uninstall successful. You may\n"
			"now delete OpenTrap's files\n"
			"from your hard disk\n\n"
			"Be sure to delete any shortcuts to\n"
			"OPENTRAP.EXE that you may have created!", "OpenTrap", MB_ICONINFORMATION | MB_OK);
		::MessageBox(NULL,
			"IMPORTANT NOTE: If you also have the PC Magazine\n"
			"Utility \"BigBin\" installed on your system,\n"
			"do NOT delete the FUNCTRAP.VXD device driver\n"
			"or BigBin will be unable to function.", "OpenTrap", MB_ICONSTOP | MB_OK);
	}
	else
		::MessageBox(NULL, "Uninstall failed.", "OpenTrap", MB_ICONSTOP);
}

// Handles File MRU list update. Frankly, this is sneaky.
// The MFC framework has built-in support for the MRU
// list, but it doesn't provide for disabling the MRU entries if
// their use is not appropriate in the program's current state.
// In our case, we need to disable the File MRU commands while logging
// is in progress.
//
// Unlike other menu commands, you cannot use a standard
// OnUpdate() handler to control the MRU entries.
// None of this stuff is documented, so I spent quite a bit of
// time digging through the MFC core code to figure out how to do this.
// The CWinApp class includes the protected member variable m_pRecentFileList,
// which is a pointer to an object of Class "CRecentFileList".
// That class is also not documented, but if you let MFC do its thing with the
// MRU list, the m_nSize member variable indicates the number of entries in the
// list, as established by the CWinApp::LoadStdProfileSettings() member function.
// The m_arrNames[] member variable is an array of CStrings. If the first element
// in the array is empty, the entire MRU list is empty. If any other element of the
// array is empty, there is no corresponding File MRU command on the menu.
void COpenTrapApp::OnUpdateRecentFileMenu(CCmdUI* pCmdUI)
{
	// Call base class to update the MRU list and enable all the items.
	// The mechanism maintains the m_arrNames[] array so that it is always
	// "packed"; the MRU file names are stored contiguously beginning
	// with the first CString in the array (m_arrNames[0]).
	CWinApp::OnUpdateRecentFileMenu(pCmdUI);
	// If we're logging,
	if (g_bIsLogging)
		// Disable each existing File MRU command.
		for (int i = 0;
			i < m_pRecentFileList->m_nSize && !m_pRecentFileList->m_arrNames[i].IsEmpty();
			i++)
			pCmdUI->m_pMenu->EnableMenuItem(ID_FILE_MRU_FILE1 + i, MF_GRAYED);
}
