// OTglobal.cpp
// Global functions and data.
//
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include "stdafx.h"
#include <sys\timeb.h>
#include <time.h>
#include <process.h>
#include "OTglobal.h"

#define WM_MY_STOP_LOG	(WM_USER + 1)

DWORD  __stdcall do_getcalls()
{

   //Set up the callback with the VxD (note: VxD will get the
   //id for this thread and use it and the callback address to
   //inform us about file opens)
	DeviceIoControl(g_hVXD, VXD_REGISTER_CB, &g_tcCond1,
				   (sizeof(struct trap_criteria)),&g_dwCondition1,
				   sizeof(g_dwCondition1), NULL, NULL );
	// If user is only logging file open events, there's no need
	// to establish the second trap condition record.
	if (!g_bLogOpensOnly)
		DeviceIoControl(g_hVXD, VXD_REGISTER_CB, &g_tcCond2,
					   (sizeof(struct trap_criteria)),&g_dwCondition2,
					   sizeof(g_dwCondition2), NULL, NULL ); 
	// Now just wait until the g_hStopFlag event is signaled.
	while( WaitForSingleObjectEx(g_hStopFlag, INFINITE, TRUE) == WAIT_IO_COMPLETION);
	return 0;
}

void __stdcall our_callback(DWORD trap_rec_ptr)
{
	append_log_record((struct trap_record *) trap_rec_ptr);
	release_rec(trap_rec_ptr);
}

// Appends one trap record to the buffer, packing the data to reduce the storage required.
// Record is packed by copying static elements of the trap_record structure (minus the two
// 256-byte string buffers). The first string buffer is stored as an ASCIIZ string following
// the packed structure.
// The records are stored as a doubly-linked list; since each record is of variable length,
// we need to be able to walk the list in both directions while the log is stored in memory.
// Note that the global variable g_pLastRecord is always maintained to point
// to the last record in the file unless the file is empty, in which
// case it is NULL.
void append_log_record (struct trap_record * tr_ptr)
{
	static packed_record pr;
	int len;

	if (g_bLogErrorsOnly)					// Logging errors only?
		if (tr_ptr->tr_error == 0)			// Was operation successful?
			return;							// Nothing to do if so.
	if (g_bLogFull)							// Is buffer full?
		return;								// Nothing to do if so.
	EnterCriticalSection(&g_csCritical);
	_ftime(&pr.pr_time);					// Get current time.
	pr.prev_record = g_pLastRecord;			// Set previous record pointer.
	if (g_pLastRecord != NULL)				// If not null, set that record's next record pointer.
		g_pLastRecord->next_record = (packed_record *) g_pNextRec;
	g_pLastRecord = (packed_record *) g_pNextRec;	// Save pointer to this record.
	pr.next_record = NULL;					// There is no next record after this one.
	++g_intRecCount;						// Bump record count.
	pr.pr_function = tr_ptr->tr_function;	// Transfer data to packed record structure.
	pr.pr_handle = tr_ptr->tr_handle;
	memcpy(pr.pr_program, tr_ptr->tr_program, 9);
	pr.pr_error = tr_ptr->tr_error;
	pr.pr_file1 = (g_pNextRec + sizeof(pr));	// Calculate postion of filename string and set pointer.
	memcpy(g_pNextRec, &pr, sizeof(pr));		// Copy packed record to buffer.
	len = strlen(tr_ptr->tr_file1) + 1;			// Get length of filename string, including terminating null.
	if (lstrcpy(pr.pr_file1, tr_ptr->tr_file1) == NULL)	// Copy string to buffer.
	{	// Write empty string if copy failed.
		len = 1;
		*pr.pr_file1 = '\0';
	}
	g_pNextRec = pr.pr_file1 + len;		// Calculate position for next record.
	if (g_pNextRec > g_pBufSafeEnd)		// If it's past the safe endpoint,
	{
		g_bLogFull = TRUE;				// Set full flag
		PostMessage(g_hWndMainFrame, WM_MY_STOP_LOG, 0, 0);		// Tell main process that buffer is full.
	}
	LeaveCriticalSection(&g_csCritical);	// And we're outta here.
}

void release_rec(DWORD rec_address)
{
	DeviceIoControl(g_hVXD, VXD_REC_DONE,
		(void *) &rec_address, 4, NULL, 0, NULL, NULL );
}
