// OTglobal.h
// Global Structure and function declartions for OpenTrap
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#define VXD_NAME		"\\\\.\\functrap.VXD"

#define VXD_GET_VER 1
#define VXD_REGISTER_CB 2       //register a callback and logging conditions
#define VXD_REC_DONE    3       //release the buffer VxD reported to us
#define VXD_UPDATE 4            //update logging conditions
#define VXD_GET_VER 1

#define DISABLE_LOGGING 1
#define APP_EXITING 16
#define IFSFN_OPEN 36           //function codes for file system operations
#define IFSFN_READ 0
#define IFSFN_CLOSE  11         
#define IFSFN_DELETE 31
#define LOG_ALL 0x0ffffffff
#define LOG_ALL_DOS 0x0fffffffe
#define LOG_WINDOWS_ONLY 0x1
#define LOG_ONLY_ERRORS 0xfffe
#include "OTStruct.h"

// Variables
struct  trap_criteria   g_tcCond1 = {IFSFN_OPEN ,(DWORD) LOG_ALL,(DWORD) LOG_ALL,(DWORD) LOG_ALL ,(WORD) LOG_ALL,NULL,(WORD) 0};
struct  trap_criteria   g_tcCond2 = {IFSFN_CLOSE ,(DWORD) LOG_ALL,(DWORD) LOG_ALL,(DWORD) LOG_ALL ,(WORD) LOG_ALL,NULL,(WORD) 0};
struct  upcall  g_ucUpdate;
DWORD   g_dwCondition1;               //how vxd references our callback
DWORD   g_dwCondition2;              //how vxd references our callback
char * g_pNextRec = NULL;
char * g_pBufferStart = NULL;
char * g_pBufSafeEnd = NULL;
struct packed_record * g_pLastRecord = NULL;
CRITICAL_SECTION   g_csCritical; 
DWORD		g_dwThreadID;
HANDLE		g_hStopFlag;
HANDLE		g_hThread;
HANDLE		g_hVXD		= INVALID_HANDLE_VALUE;
UINT		g_intRecCount = 0;
BOOL		g_bIsLogging = FALSE;		// Flag indicating whether VXD is active.
BOOL		g_bLogFull = FALSE;
BOOL		g_bLogErrorsOnly = FALSE;	// Flag used to log errors only.
UINT		g_intLogSizeK = 64;
HWND		g_hWndMainFrame = NULL;

// Functions
void __stdcall our_callback(DWORD);
void append_log_record (struct trap_record *);
void    release_rec(DWORD);
DWORD  __stdcall do_getcalls();

// Option settings
BOOL g_bShowNums = TRUE;
BOOL g_bCommaDelimited = FALSE;
BOOL g_bWriteFiltered = FALSE;
BOOL g_bExportRecNums = FALSE;
BOOL g_intFilterEvents = 0;
BOOL g_bFilterErrorsOnly = FALSE;
CString g_strFilterModuleName = "";
CString g_strFilterFileExt = "";
CString g_strFilterFileName = "";
BOOL g_bFilterModule = FALSE;
BOOL g_bFilterFileExt = FALSE;
BOOL g_bFilterFileName = FALSE;
BOOL g_bUseFilters = FALSE;
BOOL g_bLogOpensOnly = FALSE;
DWORD g_dwWatchVM = 0;
BOOL g_bHide = FALSE;

// Strings
// Format string for WindowPosition save/load.
TCHAR g_szFormat[] = _T("%u,%u,%d,%d,%d,%d,%d,%d,%d,%d");
TCHAR g_szFontFormat[] = _T("%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i");
// Registry key names for saving/loading settings.
TCHAR g_szSettingKey[] = _T("1.0\\Settings");
TCHAR g_szViewKey[] = _T("1.0\\View");
TCHAR g_szLogKey[] = _T("1.0\\Logging");
TCHAR g_szExportKey[] = _T("1.0\\Export");
TCHAR g_szFontKey[] = _T("1.0\\View\\Font");
