// OTStruct.h
// Structure declarations for OpenTrap.
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.
#include <sys\timeb.h>
#pragma pack(1)
struct trap_criteria
{
	DWORD          tc_func_num;	//function app wants trapped (-1 = all)
	DWORD          tc_drive;       //drive (-1 = all drives)
	DWORD          tc_proc_handle; //process (-1 if all processes)
	DWORD          tc_vm_num;      //VMs (-1 if all) (0x0fffffffe if only DOS)
	WORD           tc_status;      //error code (-1 if all status)
	DWORD          tc_callback;    //address to call back
	WORD           tc_misc;        //misc flags for OpenTrap
};

struct trap_record
{
	DWORD           tr_function;   
	DWORD           tr_drive;      
	unsigned char   tr_ir_flags;   
	WORD            tr_ir_options; 
	DWORD           tr_res_type;   
	DWORD           tr_handle;
	char            tr_file1[MAX_PATH];
	char            tr_file2[MAX_PATH];
	char            tr_program[9];
	DWORD           tr_vm;         
	DWORD           tr_proc_handle;
	WORD            tr_error;      
	DWORD           tr_drv_context;
	WORD            tr_drv_status;
	WORD            tr_drv_miscflag;
};

struct packed_record
{
	packed_record *	prev_record;
	packed_record *	next_record;
	DWORD           pr_function;
	DWORD           pr_handle;
	char *			pr_file1;		// ptr to first ASCIIZ string.
	char			pr_program[9];
	WORD            pr_error;
	struct _timeb	pr_time;
};

struct upcall
{
	DWORD           trap_rec_num;
	DWORD           trap_dat_ptr;
	WORD            trap_dat_len;
};
