// OTView.h : interface of the COpenTrapView class
//
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.
/////////////////////////////////////////////////////////////////////////////

class COpenTrapView : public CScrollView
{
protected: // create from serialization only
	COpenTrapView();
	DECLARE_DYNCREATE(COpenTrapView)

// Attributes
public:
	// Member functions
	COpenTrapDoc *	GetDocument();

	// Member variables
	CFont *						m_fontCustom;
	UINT						m_intCurrent_Page;
	UINT						m_intPage_Count;
	UINT						m_intFilt_Rec_Count;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenTrapView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenTrapView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(COpenTrapView)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	// Variables
	int		m_intLines_Per_Page;
	CSize	m_sizeCurrent_Page;
	struct filter_list
	{
		packed_record *	pRec;
		UINT			rec_num;
	} *	m_pFiltered_Recs;

	// Functions
	void Build_Record_List(void);
	void Calc_Scroll_Sizes(BOOL page_change);
	void Start_New_Page(CDC* pDC, CFont* old_font);
};

#ifndef _DEBUG  // debug version in OTView.cpp
inline COpenTrapDoc* COpenTrapView::GetDocument()
   { return (COpenTrapDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
