

#include "ext.h"
#include "frig.h"

#ifdef FRIG
byte conv_array [CONV_ARRAYS][256] = {
	{
	0x00,0x40,0x08,0x30,0x20,0x21,0x28,0x8C,
	0x02,0xA0,0xC0,0xE0,0x60,0x8A,0x23,0x74,
	0x10,0x90,0x18,0x19,0x41,0x4A,0x45,0x71,
	0x24,0x13,0xC4,0x4D,0x70,0x63,0x2B,0xF8,
	0x80,0x84,0x12,0x54,0x14,0x61,0x62,0x2D,
	0x05,0xD0,0x94,0x4B,0xB0,0xAA,0xB2,0xF4,
	0x06,0x0D,0x51,0x5A,0x43,0xF0,0xD2,0xE6,
	0x86,0x17,0xC3,0x3B,0xA9,0xB6,0xD9,0xCF,
	0x01,0x50,0x82,0x98,0x42,0xA2,0x15,0x96,
	0x22,0x16,0x34,0x72,0x07,0x9A,0x59,0x6B,
	0x0C,0x83,0xA1,0x0F,0x2C,0x4E,0x35,0xB3,
	0x1A,0x3A,0x1E,0x73,0xD1,0xDC,0x67,0x3F,
	0x44,0x85,0x91,0xB8,0x89,0xE8,0x65,0x1F,
	0x2A,0x93,0xCA,0x2F,0xC5,0xF2,0x3D,0xE7,
	0x58,0x53,0x78,0xCB,0xC9,0xAE,0xEC,0x7B,
	0xA6,0xE9,0x76,0xBD,0xB9,0x5F,0x77,0xEF,
	0x04,0x11,0x48,0xC2,0x88,0x25,0x68,0xA3,
	0x03,0x0E,0x26,0x2E,0xA4,0x5C,0xCC,0x5B,
	0x0A,0xC1,0x29,0x36,0x64,0x3C,0x1B,0x9B,
	0x49,0x33,0x66,0x8F,0x8E,0x5D,0xBC,0x9F,
	0x81,0x31,0x46,0xE1,0x1C,0xAC,0xD4,0xD5,
	0xA8,0x56,0x6C,0x6D,0xB1,0xD6,0xF1,0xEB,
	0x0B,0x1D,0xE2,0xBA,0x55,0x4F,0x9E,0x7D,
	0x9C,0x97,0xDA,0xD7,0x57,0xBE,0xB7,0xFE,
	0x09,0x32,0x52,0x27,0x38,0x99,0x39,0xAD,
	0x4C,0xB4,0x8B,0xB5,0x95,0x75,0x6E,0xF9,
	0xC8,0xA5,0x6A,0x79,0x87,0x7A,0xCD,0xF5,
	0xE4,0x37,0x3E,0x7E,0xA7,0xF6,0xF3,0xDF,
	0x92,0x69,0xD8,0x9D,0xC6,0xCE,0xE5,0xDD,
	0x8D,0xC7,0xAB,0xEE,0x7C,0xBB,0xDB,0xFD,
	0x47,0xE3,0x5E,0xFC,0xEA,0xFA,0xED,0xF7,
	0xD3,0x6F,0xAF,0x7F,0xDE,0xFB,0xBF,0xFF,
},

	{
	0x00,0x02,0x10,0x28,0x04,0x0C,0x03,0x4C,
	0x01,0x12,0x90,0x49,0x18,0x8C,0x51,0x4D,
	0x40,0x14,0x41,0xB0,0x48,0x29,0xC1,0x96,
	0x21,0x46,0x94,0xC3,0x92,0x17,0xB2,0xF4,
	0x80,0x30,0x05,0x23,0x50,0xC4,0xD0,0x66,
	0x60,0x8A,0x54,0x55,0x64,0x3C,0x36,0x9B,
	0x11,0xE0,0x25,0x47,0x15,0x63,0x1D,0xCD,
	0x07,0xB1,0x95,0x37,0x74,0xE6,0x2F,0xF3,
	0x20,0x42,0xC0,0x1C,0x44,0x89,0xA4,0x78,
	0xA0,0x26,0x68,0xA3,0x98,0x0F,0xC5,0x6D,
	0x84,0xC2,0x31,0x1B,0x38,0xD1,0xAC,0x3E,
	0x62,0xCA,0xC9,0x6B,0x99,0xA7,0xB9,0xEB,
	0x22,0x4A,0x91,0x33,0x19,0x2E,0x5A,0x5B,
	0x43,0xA6,0x3A,0xB6,0xD4,0xBA,0x7C,0xD7,
	0x2A,0x8B,0x2B,0xDA,0xD2,0x79,0x9D,0x77,
	0x59,0xE3,0xCE,0xED,0xD6,0xDD,0x7D,0xF7,
	0x08,0x88,0x24,0x85,0x09,0xA8,0x45,0x53,
	0x81,0x52,0x2C,0x4B,0x34,0xF0,0xA5,0x1F,
	0x0A,0x83,0x16,0x9A,0xA1,0x87,0x56,0xF2,
	0x86,0x6C,0xA9,0xB3,0x1E,0x3D,0x4F,0x5F,
	0x82,0x70,0x0B,0xC6,0x61,0x27,0x9C,0xAD,
	0x1A,0xE2,0x2D,0x9E,0xCC,0x5D,0xE9,0xF5,
	0xA2,0xE8,0xAA,0x73,0x93,0x6E,0xAB,0x7E,
	0xD8,0xBC,0xD3,0xCF,0xF1,0xEE,0xFC,0xFE,
	0x06,0xC8,0x0D,0x8D,0x0E,0x8E,0xB8,0x76,
	0x32,0x69,0xE1,0xEA,0x71,0xD9,0x97,0x7B,
	0x58,0x5C,0xB4,0x7A,0x4E,0xEC,0x8F,0xB7,
	0x65,0xAE,0xD5,0xF6,0x57,0xBB,0xDB,0xEF,
	0x13,0x35,0x39,0xDC,0xE4,0x67,0xC7,0x6F,
	0x6A,0x75,0x5E,0xBE,0xB5,0x3F,0xBD,0xFD,
	0x72,0xCB,0x3B,0xDE,0xE5,0xE7,0xFA,0xBF,
	0xF8,0x9F,0xF9,0x7F,0xAF,0xDF,0xFB,0xFF,
},

	{
	0x00,0x10,0x01,0x48,0x04,0x60,0x82,0x38,
	0x20,0x50,0x14,0xA4,0x22,0x32,0x91,0xA5,
	0x80,0x42,0xC0,0x1A,0xA0,0xC8,0x8A,0x95,
	0x0C,0x51,0x89,0xD8,0x54,0xAA,0x4D,0xCD,
	0x02,0x81,0x84,0x31,0x11,0x83,0x46,0xE2,
	0x88,0x2C,0x29,0xCA,0x70,0x1E,0x0F,0x3D,
	0x90,0x61,0x34,0x39,0x4A,0x87,0x1D,0xD3,
	0x26,0x53,0xC9,0xCE,0xA6,0xAD,0xC7,0xFC,
	0x40,0x30,0x06,0x1C,0x05,0x4C,0x68,0xD1,
	0x18,0x07,0x0B,0x74,0x23,0x36,0xC6,0x6D,
	0x03,0x62,0xA8,0x47,0x86,0x1B,0x69,0x6E,
	0x25,0x56,0x2E,0x9E,0x9C,0xBA,0xB3,0xEE,
	0x44,0x92,0x0E,0x5C,0xD0,0x3A,0x2D,0xF4,
	0xC4,0x4E,0xB8,0xA7,0x55,0x5D,0xE3,0xB7,
	0x16,0xD4,0x35,0x7C,0xE1,0x9D,0x6B,0xDD,
	0x59,0x9B,0x67,0xBE,0xD6,0x7D,0xF9,0xFE,
	0x08,0x21,0x24,0x43,0x28,0x13,0x0D,0x8D,
	0x0A,0xB0,0x15,0x27,0xE0,0x3C,0x4B,0x5B,
	0x09,0xC2,0x52,0xB1,0xA2,0xD2,0xAC,0xB6,
	0xA1,0xC5,0xCC,0x73,0x65,0x5E,0xF1,0x9F,
	0x12,0xC1,0x85,0xC3,0x2A,0x17,0x99,0x37,
	0x8C,0xA3,0x63,0x79,0x6C,0xD9,0xEC,0xDE,
	0x45,0x33,0xE8,0xDA,0xE4,0xF2,0x4F,0x7E,
	0xB2,0xCB,0xAB,0x3F,0x2F,0xED,0x5F,0xDF,
	0x41,0x49,0x98,0x2B,0x64,0x66,0x96,0x57,
	0x19,0xB4,0xF0,0xAE,0xA9,0xEA,0xE6,0x77,
	0x94,0x93,0x5A,0xB5,0x78,0x97,0x7A,0x7B,
	0x8B,0xB9,0x3E,0xD7,0x76,0x6F,0xDB,0xBF,
	0x58,0x72,0x71,0xE9,0x8E,0xE5,0xF8,0xF3,
	0x6A,0x75,0xD5,0xBD,0x3B,0xFA,0xEB,0xFD,
	0x9A,0xBC,0xDC,0xF6,0x1F,0xE7,0xF5,0x7F,
	0x8F,0xCF,0xBB,0xFB,0xAF,0xF7,0xEF,0xFF,
},

	{
	0x00,0x02,0x40,0x41,0x10,0x12,0x42,0x86,
	0x08,0x28,0x18,0x26,0x81,0xC8,0xC2,0xE4,
	0x01,0x11,0xC0,0x85,0x24,0x2C,0x15,0xA3,
	0x50,0x38,0x94,0xAA,0x98,0xCA,0x4E,0xE3,
	0x04,0xA0,0x05,0xA1,0x03,0x58,0xD0,0xE2,
	0x0A,0x52,0x8A,0xE1,0x62,0x6A,0x95,0xE9,
	0x06,0xB0,0x89,0x5A,0x8C,0x72,0x55,0xA7,
	0xC1,0xB4,0x78,0xE6,0x93,0x7A,0xD6,0xF3,
	0x20,0x0C,0x88,0x51,0x44,0x49,0x31,0x2E,
	0x14,0x34,0x4A,0x9C,0x83,0x33,0x69,0x79,
	0x90,0x68,0x25,0x74,0xA2,0xC5,0x5C,0xD5,
	0x92,0x96,0x9A,0x9B,0x53,0x7C,0x8F,0xBD,
	0x84,0x0E,0x16,0x39,0x91,0x2B,0x1D,0xBC,
	0x45,0xB2,0xF0,0xBA,0x1E,0x3B,0xCD,0xFC,
	0xC4,0x35,0x65,0xB9,0x2D,0x3D,0xAE,0x7E,
	0x99,0xB5,0xF4,0x7D,0x9E,0xFA,0xD7,0xDF,
	0x80,0x60,0x48,0x1C,0x30,0x43,0x29,0x8B,
	0x09,0xE0,0x2A,0xE8,0x19,0x27,0x4D,0x6B,
	0x21,0x32,0x70,0xC6,0x61,0x66,0x4B,0x37,
	0x4C,0x3C,0x8E,0x57,0xB1,0xD3,0x75,0xBE,
	0x22,0x1A,0xA4,0x47,0x46,0xC9,0xA6,0xAD,
	0x54,0x17,0x36,0xF2,0x59,0xE5,0xAB,0xDB,
	0xA8,0xCC,0x3A,0x5E,0x6C,0xF8,0xDC,0x77,
	0xC3,0x5D,0x4F,0x5F,0x6E,0xBB,0xCF,0xFD,
	0x82,0x23,0x07,0x1B,0x0D,0x63,0xAC,0xB3,
	0x64,0xA5,0xD4,0xEA,0xB8,0x5B,0xDA,0xDE,
	0x0B,0xA9,0xD2,0xCE,0x87,0x3E,0x76,0xEB,
	0xD1,0x97,0x1F,0x3F,0xEC,0xF5,0xB7,0xFE,
	0x13,0x71,0x0F,0x2F,0x8D,0xB6,0xF1,0x7B,
	0x56,0x73,0x67,0xDD,0xC7,0xF6,0x9F,0xBF,
	0xD8,0x6D,0x9D,0xF9,0xD9,0xED,0x6F,0xEF,
	0xCB,0xAF,0xEE,0x7F,0xE7,0xFB,0xF7,0xFF,
},

	{
	0x00,0x40,0x01,0x11,0x10,0x42,0x50,0x68,
	0x20,0x12,0x90,0x4C,0x14,0x34,0x51,0x4E,
	0x80,0x09,0x82,0x45,0x84,0x2A,0x19,0xA9,
	0x44,0x1A,0xC4,0xC6,0xA8,0x47,0x3C,0xE6,
	0x02,0x21,0x48,0xE0,0x24,0x31,0x62,0x96,
	0x88,0x29,0x64,0x93,0x46,0x65,0xB4,0xEC,
	0x0C,0x92,0x0E,0xC5,0x13,0x99,0x9A,0xDC,
	0x4A,0x1E,0xF0,0x97,0x6C,0x7A,0x6D,0xD7,
	0x08,0x30,0x28,0xA2,0x18,0x8A,0x54,0x74,
	0x06,0x23,0x26,0x8B,0x85,0xD1,0x39,0xEA,
	0xA0,0x0D,0xA1,0x66,0xC2,0xAA,0xA6,0x5D,
	0x49,0x69,0x59,0xD3,0x8E,0xAD,0xE3,0xFA,
	0x60,0x89,0x16,0xCC,0x86,0x72,0x4B,0x57,
	0x94,0x6A,0xB1,0xE9,0x27,0xBC,0x3B,0xEE,
	0xC1,0xA3,0x2E,0xC7,0x87,0xCB,0xD6,0xBB,
	0x4D,0xF4,0xF2,0x5F,0x4F,0xF9,0xFC,0xFD,
	0x04,0xC0,0x41,0x07,0x22,0xD0,0x91,0xC9,
	0x05,0x52,0x0B,0xB2,0x58,0x8D,0x17,0x9E,
	0x03,0x38,0x2C,0x33,0x43,0x78,0xD2,0x3D,
	0x25,0x53,0x5A,0x6E,0x1D,0x9B,0xF1,0xAF,
	0x81,0xA4,0x98,0x56,0x1C,0xE2,0xD8,0xB3,
	0x32,0xB8,0x1B,0xA7,0xA5,0x67,0x5E,0xE7,
	0x8C,0xE1,0x9C,0xF8,0x0F,0xDA,0x79,0xB7,
	0x55,0xB6,0xAB,0xCF,0x3E,0x7B,0x77,0xFE,
	0x0A,0x61,0x70,0x35,0x15,0xE8,0x3A,0x76,
	0xC8,0x2B,0xCA,0x6B,0xC3,0x7C,0xD9,0xDE,
	0xB0,0xAC,0x5C,0x37,0x36,0xAE,0xCE,0xBD,
	0x71,0xD5,0xB5,0xDD,0xCD,0xF6,0xF5,0xFB,
	0x83,0x63,0x2D,0x5B,0xE4,0x9D,0x8F,0x3F,
	0x95,0xBA,0x73,0x7E,0xE5,0xF3,0xEB,0xDF,
	0xD4,0xB9,0x75,0x7D,0x2F,0x9F,0xED,0xEF,
	0x1F,0x6F,0xDB,0xBF,0xBE,0x7F,0xF7,0xFF,
},

	{
	0x00,0x20,0x01,0x28,0x02,0x82,0x44,0x15,
	0x04,0x0C,0x48,0x86,0x90,0x83,0x92,0x71,
	0x40,0x81,0x21,0xA1,0x60,0x31,0x1C,0x6C,
	0x11,0x94,0x52,0x47,0x0E,0x9C,0xC3,0x3B,
	0x08,0x14,0x41,0x89,0x84,0x64,0xC8,0x8D,
	0x24,0x29,0x13,0xAC,0x46,0x39,0xCC,0x3D,
	0x88,0x43,0x98,0x5A,0x4A,0x3A,0xC5,0xE3,
	0x49,0x99,0x33,0xCB,0x2D,0x73,0x6E,0xF5,
	0x10,0x42,0x03,0x07,0x30,0x91,0x26,0xB1,
	0xC0,0x2C,0x19,0xD1,0x8C,0x72,0x65,0x67,
	0xA0,0xC1,0xA8,0xE8,0x0B,0x0F,0x78,0xB5,
	0xC4,0x74,0xA6,0x4F,0x66,0xE5,0xE9,0xE7,
	0x50,0xD0,0x23,0x8B,0x62,0xC9,0xF0,0xD9,
	0x68,0x1D,0xCA,0x6B,0x63,0xCE,0xD5,0x7E,
	0xC2,0xB2,0xB4,0xAE,0xB8,0xF4,0xC7,0xBD,
	0x6A,0x9E,0xB3,0xDB,0x8F,0x7D,0xDD,0xEF,
	0x80,0x06,0x22,0xE0,0x0A,0x51,0x54,0x9A,
	0x18,0x34,0x16,0x2E,0x45,0x1E,0x69,0xDC,
	0x09,0xA2,0x38,0x35,0xB0,0x93,0x55,0x79,
	0x1A,0x59,0x8E,0x7A,0x4B,0x9D,0xE6,0xFA,
	0x12,0x8A,0x0D,0xE2,0x32,0x53,0xC6,0xAB,
	0x4C,0xD4,0x27,0xF8,0x87,0x2F,0x5B,0xCF,
	0x25,0x36,0xE4,0x3E,0x1B,0xEC,0x5D,0xD7,
	0xAA,0xBC,0xF2,0xEB,0x37,0xF3,0x6F,0xF7,
	0x05,0x85,0xA4,0x95,0x58,0x17,0x2B,0x1F,
	0x2A,0x96,0x56,0x75,0x4E,0xBA,0x5E,0x3F,
	0x61,0xA9,0x5C,0xB6,0xA5,0xA7,0xD6,0x5F,
	0x4D,0x6D,0xCD,0x9F,0xB9,0xAF,0xBB,0xFB,
	0x70,0xE1,0xA3,0x7C,0x3C,0xD3,0xEA,0xF6,
	0xD2,0x9B,0x97,0xDE,0x57,0x7B,0xEE,0xFE,
	0xD8,0xF1,0xDA,0xB7,0x76,0xED,0xF9,0xBF,
	0xAD,0x77,0xBE,0xDF,0xFC,0xFD,0x7F,0xFF,
},

	{
	0x00,0x10,0x01,0x30,0x02,0x0C,0x81,0x25,
	0x40,0x14,0x48,0x1A,0x09,0x34,0x1C,0xB2,
	0x80,0x11,0xA0,0x13,0x24,0x8C,0x52,0x1B,
	0x82,0x29,0xC1,0x96,0x4A,0x78,0xE1,0x4F,
	0x08,0x90,0x41,0x62,0x84,0xA1,0x58,0xCC,
	0x44,0x07,0x94,0x5A,0x31,0xA3,0x6A,0xD9,
	0x12,0x85,0x26,0xD8,0x0D,0x71,0x1D,0xC7,
	0x23,0x8B,0x55,0xE6,0x36,0xEC,0x97,0x5F,
	0x04,0x21,0x42,0xA8,0x88,0x16,0x0E,0x93,
	0x28,0xC4,0x2A,0x66,0x98,0x33,0x9A,0xF8,
	0xC0,0x0B,0xA4,0x6C,0x38,0x4B,0x8E,0xF1,
	0xC2,0xB1,0xE2,0xD5,0x2B,0x2F,0x67,0xED,
	0x60,0x68,0x19,0xF0,0x43,0xAA,0x0F,0x6B,
	0xD0,0xC3,0xD2,0xCE,0xD1,0x37,0xB5,0xEE,
	0x92,0xA6,0x53,0xE5,0x4E,0x3B,0xB6,0xF9,
	0x56,0x9B,0xCD,0xF3,0x76,0x7E,0x77,0xBF,
	0x20,0x03,0x06,0x2C,0x50,0x64,0xB0,0xC5,
	0x18,0xE0,0x46,0xA5,0x45,0x69,0x95,0xDA,
	0x0A,0x61,0x89,0x17,0x91,0x47,0x9C,0x3E,
	0xA2,0x4D,0x8D,0x1F,0x27,0xD3,0x9D,0xCF,
	0x05,0x86,0x4C,0x72,0x70,0xD4,0x63,0x6D,
	0x32,0x87,0x59,0x3D,0xA9,0xF2,0xB9,0xEB,
	0x54,0x99,0xE4,0xAB,0xCA,0x5D,0x5E,0x7B,
	0x1E,0xA7,0xB3,0x6F,0x5B,0xAF,0xD7,0xDF,
	0x22,0x8A,0x51,0x74,0x83,0xC9,0x65,0xAE,
	0xC8,0x35,0x3A,0xE9,0xE8,0xBA,0x9E,0xB7,
	0x15,0xB4,0x2D,0xF4,0xB8,0x75,0x7C,0xBE,
	0x3C,0x7A,0x57,0xE7,0x73,0x9F,0xBB,0xFB,
	0x49,0x5C,0xC6,0x79,0x39,0xBC,0xDC,0xFA,
	0x2E,0xEA,0xAD,0xDE,0x6E,0xDB,0xF5,0xF7,
	0xAC,0x8F,0xCB,0xFC,0xD6,0x7D,0xDD,0xEF,
	0xE3,0x3F,0xBD,0xFE,0xF6,0x7F,0xFD,0xFF,
},

	{
	0x00,0x20,0x40,0x41,0x08,0xC0,0x14,0x34,
	0x01,0x22,0x82,0x52,0xA0,0x23,0x45,0xD2,
	0x04,0x18,0x11,0x46,0x06,0x2A,0xC8,0x4E,
	0x24,0x8C,0x89,0xC3,0xE0,0x78,0xE2,0xEC,
	0x10,0x50,0x28,0x58,0x81,0x0E,0x49,0xA5,
	0x42,0x15,0x13,0x74,0x26,0xB8,0x96,0xCD,
	0x84,0x62,0x1A,0x3C,0x43,0xA9,0xB4,0xE3,
	0x98,0xB2,0x4B,0xB9,0x53,0x4F,0xDC,0xAF,
	0x80,0x48,0x88,0x8A,0x30,0xA4,0x86,0xF0,
	0x44,0x83,0x2C,0x47,0xA8,0x87,0xE1,0x7C,
	0x90,0x54,0x0D,0xCA,0x25,0x5C,0x1B,0xB3,
	0x1C,0x66,0x6C,0xE5,0xA6,0x7A,0x75,0xDB,
	0x0C,0xD0,0x16,0x9A,0x31,0x35,0x72,0xA7,
	0x29,0x2B,0x8E,0xF8,0x4D,0xCE,0x76,0xEE,
	0x19,0xC6,0xD1,0x3E,0xA3,0x57,0xAB,0xDD,
	0x17,0x2F,0x73,0xBB,0x9B,0x5F,0xFC,0x7F,
	0x02,0x60,0x09,0x91,0x05,0xA1,0x70,0xD4,
	0x0A,0x85,0x92,0xC9,0xA2,0x95,0x56,0xEA,
	0x03,0x94,0x32,0x6A,0x61,0x3A,0x0F,0xDA,
	0x68,0xE4,0x27,0x5D,0x71,0x8F,0x3B,0xED,
	0x21,0x51,0x07,0xE8,0xC2,0xAA,0x33,0x3D,
	0x64,0x8B,0x55,0x6E,0x65,0x79,0x6D,0x7E,
	0x38,0x39,0x5A,0xBA,0x99,0xD6,0x97,0xDE,
	0x1E,0xB6,0xCB,0xB7,0x1F,0xD7,0x6F,0xDF,
	0x12,0xC4,0x0B,0x93,0x4C,0xC5,0x63,0x9E,
	0x4A,0x2D,0x69,0xB5,0x1D,0x5B,0xF4,0xE7,
	0xB0,0xAC,0x59,0xBC,0xD8,0xAD,0x9D,0xEB,
	0x9C,0xF1,0xE9,0x7B,0x5E,0xF3,0xCF,0xFE,
	0xC1,0x2E,0x8D,0xC7,0xB1,0xD9,0x67,0x77,
	0x36,0x37,0xE6,0xBE,0xF2,0xFA,0xF5,0xFB,
	0xCC,0xD3,0x6B,0x7D,0xD5,0x3F,0xF9,0xEF,
	0xAE,0x9F,0xBD,0xFD,0xF6,0xBF,0xF7,0xFF,
},

	{
	0x00,0x40,0x10,0x11,0x08,0x50,0x0C,0xB0,
	0x80,0x14,0x41,0x94,0x05,0x38,0xC8,0x39,
	0x20,0x06,0x42,0x86,0x60,0x98,0x0E,0xA6,
	0x82,0x0B,0x2A,0x6C,0xA1,0x1B,0x2D,0xD5,
	0x01,0x03,0x48,0x31,0x28,0x89,0x83,0x8E,
	0x21,0x07,0x49,0x3C,0x70,0x87,0xE1,0xF4,
	0x0A,0x23,0xE0,0xD8,0x8C,0x78,0xB1,0xEC,
	0x32,0xCC,0x66,0xB5,0xC3,0xAB,0x6E,0xEB,
	0x04,0x84,0x22,0x45,0x44,0x54,0x4A,0x56,
	0x88,0x91,0x62,0x69,0xC4,0x1D,0x3A,0x8F,
	0xC0,0x1C,0x58,0xE4,0x52,0x17,0x4B,0x5B,
	0x15,0x65,0x1E,0xB6,0xAA,0xF8,0xD3,0x7D,
	0x81,0xC2,0x25,0xC5,0x4C,0x93,0x53,0xDA,
	0x8A,0x4E,0xF0,0xE6,0x72,0x37,0xE9,0xBD,
	0x13,0xC9,0x33,0x7C,0x2B,0x6B,0x79,0xAF,
	0xA9,0x3E,0xC7,0x3F,0x2F,0xDB,0xFC,0x7F,
	0x02,0xA0,0x30,0x26,0x24,0x1A,0xC1,0xB8,
	0x18,0x46,0xA4,0xB2,0x19,0x5C,0xB4,0x1F,
	0x90,0x85,0x0D,0xE2,0x68,0xAC,0x71,0xD6,
	0x2C,0x27,0x35,0x9D,0x95,0x6D,0x5E,0xF5,
	0x09,0x92,0xD0,0xA5,0x43,0xA3,0x9C,0x7A,
	0x61,0x55,0xD1,0x97,0x99,0x3D,0x4F,0xE7,
	0xA8,0x8D,0x96,0xF1,0x0F,0xBA,0xF2,0xBE,
	0xE8,0xE5,0x9E,0xEE,0x67,0xDE,0x5F,0xBF,
	0x12,0x64,0x34,0x63,0x29,0x47,0x36,0xE3,
	0x51,0x6A,0xCA,0xDC,0xD4,0xBC,0x75,0x9F,
	0x16,0x9A,0x4D,0x57,0xC6,0xA7,0xB9,0xD7,
	0xD2,0xCB,0x5D,0xFA,0x9B,0xBB,0x6F,0xEF,
	0xA2,0x59,0x5A,0xB3,0x74,0xAD,0x76,0xCF,
	0x2E,0x73,0x3B,0x7E,0xCD,0xDD,0xF6,0xFB,
	0x8B,0xCE,0xD9,0xB7,0xEA,0xF3,0xED,0xFE,
	0xAE,0x7B,0x77,0xDF,0xF9,0xFD,0xF7,0xFF,
},

	{
	0x00,0x02,0x80,0x0C,0x20,0x11,0x09,0x34,
	0x40,0x03,0x0A,0x0E,0x50,0x58,0x86,0x1B,
	0x10,0x05,0x24,0x0B,0x60,0x83,0x49,0x55,
	0xC0,0xE0,0x2A,0xCA,0x98,0xC9,0x3C,0xCE,
	0x04,0x41,0x88,0x94,0x06,0x2C,0x07,0xE4,
	0x84,0xC1,0x52,0x65,0x1C,0x71,0x4E,0x6E,
	0x30,0xC4,0x92,0x9A,0x26,0xE1,0xB1,0xE3,
	0x91,0x1E,0x5A,0xE5,0xA5,0x8F,0xB9,0xAF,
	0x01,0x42,0x14,0xA2,0x22,0x46,0x4C,0xB2,
	0x81,0xA4,0x15,0x2E,0x29,0x99,0xAC,0x37,
	0x28,0x8A,0x0D,0xC5,0x61,0x2B,0x6A,0x6D,
	0xA8,0xC3,0x5C,0xCB,0x0F,0x3D,0xF2,0xF3,
	0x48,0x70,0x51,0xCC,0x68,0xB8,0x47,0x4F,
	0xB0,0x9C,0x69,0xDA,0x4D,0xB3,0x79,0xDE,
	0x13,0xF0,0xAA,0xBC,0xE8,0x1F,0xF4,0xCF,
	0xD2,0x67,0xD6,0xBB,0x5E,0xDB,0x3F,0xBF,
	0x08,0x90,0x18,0xC2,0x21,0x1A,0x43,0x63,
	0x12,0x54,0x64,0x72,0x32,0xE2,0xA9,0xEC,
	0x44,0x45,0x38,0x78,0x19,0x6C,0xA3,0x75,
	0xA1,0x66,0xC6,0xE9,0x8E,0x9B,0xAB,0xFC,
	0x82,0x8C,0x25,0x35,0x85,0x95,0xD8,0xAE,
	0x31,0x39,0xA6,0x9E,0x8D,0xBA,0xD3,0xF6,
	0x16,0x96,0x33,0xE6,0x17,0xF1,0xA7,0x5F,
	0x87,0xF8,0x57,0xEE,0x7A,0x7D,0xB7,0xFD,
	0xA0,0xD0,0x89,0xB4,0x4A,0xD4,0x59,0xCD,
	0x62,0x27,0x2D,0xEA,0x3A,0x6B,0xD5,0x9F,
	0xC8,0x36,0x93,0xB5,0x8B,0x73,0x9D,0xF5,
	0xD1,0x76,0xC7,0xD7,0xD9,0x6F,0xF9,0xF7,
	0x23,0x74,0x53,0x5B,0x1D,0x3B,0x2F,0xEB,
	0x4B,0xAD,0x7C,0xBD,0x5D,0x7B,0xED,0xDF,
	0x56,0x97,0xB6,0xFA,0x3E,0xBE,0x7E,0xEF,
	0xDC,0x77,0xE7,0xFE,0xDD,0xFB,0x7F,0xFF,
},

	{
	0x00,0x10,0x02,0x21,0x20,0x82,0x90,0x0E,
	0x01,0x28,0x0C,0x64,0x14,0x4A,0x62,0x96,
	0x80,0x44,0x09,0x07,0x30,0x2A,0x0B,0xC5,
	0x84,0x61,0x45,0x8E,0x8A,0xC3,0x5C,0x57,
	0x04,0x05,0x11,0xA2,0x22,0x98,0x92,0xE2,
	0x03,0x0D,0x31,0x1E,0xC1,0x3C,0x78,0x3B,
	0x42,0x19,0x4C,0x4D,0x68,0x9C,0x1B,0x9D,
	0x70,0x59,0x72,0xAB,0x3A,0xA7,0x75,0x6F,
	0x08,0xC0,0x50,0x25,0x24,0x1C,0x34,0xB2,
	0x60,0x2C,0x94,0xB8,0x38,0x33,0x4E,0xBC,
	0x48,0x86,0x13,0xC6,0x32,0x93,0xD2,0xD5,
	0x49,0xB4,0x71,0x9E,0x1D,0x67,0x5B,0xDB,
	0x06,0xC4,0x54,0xA9,0x46,0xB1,0x2D,0xE9,
	0xB0,0xE1,0x35,0xBA,0x99,0xF2,0xCE,0xF9,
	0xC8,0xD4,0x63,0xEA,0x74,0x7C,0x7A,0xF3,
	0xCA,0x73,0xDC,0xBD,0xCB,0xF5,0x3F,0xEF,
	0x40,0x18,0x81,0xE0,0x41,0x8C,0x91,0xD1,
	0x88,0x52,0xD0,0x8B,0x29,0x87,0x8D,0xEC,
	0x12,0x26,0x43,0xF0,0x51,0xA6,0x66,0x4F,
	0xA8,0x55,0xE8,0x5E,0x4B,0xE3,0xAE,0x7D,
	0xA0,0x85,0xC2,0x17,0x16,0xA5,0xC9,0xF4,
	0x83,0x95,0x2B,0xE5,0x0F,0xE6,0x2F,0xFA,
	0x89,0x9A,0xAA,0xB9,0x65,0xAD,0x76,0xEE,
	0x36,0x37,0x9B,0x9F,0x79,0xBB,0xF6,0xFD,
	0x0A,0xA4,0x58,0x27,0xA1,0x6A,0x53,0x3E,
	0x15,0xD8,0x56,0x1F,0x5A,0xD3,0x6B,0xDD,
	0x1A,0xCC,0xE4,0xB3,0x6C,0x3D,0xF1,0x77,
	0xAC,0x6E,0xF8,0xCF,0xD6,0x7B,0xD7,0xBF,
	0x23,0x47,0x2E,0xB6,0xA3,0xC7,0x97,0x5F,
	0x39,0xB5,0xD9,0xE7,0x8F,0x7E,0xDE,0x7F,
	0x69,0xCD,0x6D,0xAF,0x5D,0xBE,0xEB,0xF7,
	0xDA,0xFC,0xED,0xFB,0xB7,0xFE,0xDF,0xFF,
},

	{
	0x00,0x01,0x04,0x41,0x10,0x28,0x50,0xA2,
	0x02,0x06,0x42,0x16,0x09,0x46,0x54,0xC5,
	0x20,0x18,0x21,0x4C,0x0A,0x38,0xB0,0x8D,
	0x03,0x8A,0x29,0x5C,0x2A,0x9C,0xA9,0xE6,
	0x08,0x11,0x22,0x0E,0x60,0x91,0xC4,0x6A,
	0x81,0x51,0x07,0x4E,0x1C,0xAC,0x2D,0x57,
	0x12,0x58,0x94,0x3C,0x0D,0x8B,0x17,0x3D,
	0x26,0x56,0x69,0x3E,0xF0,0xCB,0xDC,0xF9,
	0x80,0xA0,0xC0,0x61,0x82,0xA4,0x25,0xB8,
	0x48,0x13,0x68,0xD2,0x19,0x27,0x72,0xAD,
	0x44,0x32,0xC1,0x66,0x52,0xC3,0x63,0xBC,
	0x1A,0x4D,0x95,0x6E,0x74,0xCD,0xAE,0xFA,
	0x05,0x31,0x8C,0xA5,0x85,0xD1,0xC6,0xF1,
	0x86,0xE1,0x96,0xEA,0x4B,0x5E,0xD3,0xB7,
	0xC8,0x5A,0x35,0x1F,0x36,0xB3,0x5D,0x3F,
	0x39,0xD6,0x67,0xDB,0x3B,0xBE,0x77,0xFD,
	0x40,0x0C,0x88,0x98,0x24,0x23,0x70,0x6C,
	0x84,0x45,0xA1,0xE8,0x2C,0x93,0xE2,0x5B,
	0x90,0xD0,0xA8,0x0F,0x34,0xCA,0x1B,0xD9,
	0xE0,0xAA,0x2B,0x2F,0xA3,0xAB,0xF8,0xD7,
	0x30,0x83,0x64,0x1E,0x62,0x87,0x65,0x9D,
	0x49,0x71,0x8E,0xDA,0xA6,0xE5,0xD5,0xF3,
	0x15,0xB1,0xE4,0x4F,0x78,0xCE,0x37,0x6F,
	0x99,0xE9,0x75,0xDD,0xB5,0xBD,0xEE,0x7F,
	0x14,0x0B,0x89,0x59,0x4A,0x47,0xCC,0x6D,
	0xC2,0x55,0x53,0x76,0xD4,0xF4,0x7C,0xDE,
	0x92,0xC9,0xB4,0x7A,0x33,0x9E,0xBA,0xCF,
	0xB2,0x9B,0x73,0xF5,0xC7,0xBB,0x7B,0xFB,
	0x43,0x9A,0x3A,0x97,0x1D,0xE3,0xA7,0xFC,
	0xD8,0xB6,0x6B,0x7E,0xF2,0xF6,0xED,0xFE,
	0x2E,0x79,0x8F,0x7D,0xEC,0xE7,0xEB,0xDF,
	0xB9,0x9F,0xAF,0xBF,0x5F,0xF7,0xEF,0xFF,
},

	{
	0x00,0x40,0x08,0x05,0x01,0x24,0x84,0x23,
	0x02,0xA0,0x09,0x0B,0x03,0x15,0x49,0x87,
	0x80,0x0C,0x88,0x2C,0x48,0x45,0xC1,0x96,
	0x60,0x0D,0x31,0xAC,0x70,0xA3,0x27,0xE9,
	0x20,0x18,0x90,0x94,0x28,0x61,0x38,0xD4,
	0x12,0x26,0x4A,0x17,0xD0,0x9C,0xC9,0xBC,
	0x30,0x8A,0x32,0xCC,0xB0,0x1B,0x5A,0x5D,
	0xC4,0x56,0x5C,0xF4,0x35,0x75,0xD5,0xB7,
	0x10,0x42,0x44,0x13,0x22,0x46,0xA4,0x2E,
	0x82,0x89,0x54,0x2B,0x29,0xD2,0x2D,0xDA,
	0x11,0xA2,0x83,0xD8,0x1C,0xD1,0x33,0xAD,
	0x68,0x59,0x99,0x37,0x39,0x1F,0x67,0xBD,
	0x81,0x52,0x19,0x6A,0x4C,0x4E,0xB2,0xB3,
	0x25,0x71,0x63,0xF2,0x3C,0x6D,0xCB,0x7E,
	0xA1,0xF0,0x8B,0xAE,0x8D,0xF8,0x9B,0xFA,
	0x6C,0xC7,0x5E,0x3F,0xB6,0xEE,0xF5,0xDF,
	0x04,0xC0,0x21,0x92,0x41,0x51,0x85,0x72,
	0x50,0x2A,0x1A,0xE2,0xC2,0x74,0xE8,0x76,
	0x0A,0x16,0x62,0x65,0x58,0x55,0xE1,0xCD,
	0xC8,0x95,0xC3,0x4F,0x36,0xA7,0xEA,0xED,
	0x06,0xE0,0xA8,0xAA,0x34,0xA5,0xC6,0x9E,
	0x98,0xB1,0x8E,0xE3,0x53,0x3B,0xEC,0x5F,
	0x43,0xC5,0x69,0x9D,0x66,0x3D,0xB5,0xCF,
	0xA6,0x97,0x2F,0xDD,0x79,0xBB,0xFC,0x7F,
	0x14,0x86,0x0E,0xB8,0x64,0x3A,0xE4,0xD3,
	0x07,0x4B,0x4D,0xE6,0xA9,0xD6,0x7A,0xF3,
	0x91,0xB4,0x1D,0x3E,0xCA,0xD9,0x57,0xDE,
	0x93,0xBA,0x5B,0x7B,0x8F,0xE7,0x77,0xFE,
	0x8C,0x9A,0x47,0x6B,0x78,0xF1,0x6E,0x6F,
	0x0F,0x73,0xCE,0xF6,0xB9,0x7D,0xD7,0xFB,
	0x1E,0xE5,0x7C,0xEB,0xDC,0xBE,0xAF,0xFD,
	0xAB,0xDB,0xF9,0xF7,0x9F,0xBF,0xEF,0xFF,
},

	{
	0x00,0x10,0x04,0x0C,0x80,0x81,0x42,0x2A,
	0x08,0x09,0x88,0xC2,0x90,0x32,0x86,0xE1,
	0x40,0x06,0x48,0x98,0x44,0x31,0x91,0x69,
	0x28,0x25,0xE0,0x55,0x4A,0xA5,0x3C,0x3D,
	0x01,0x11,0x22,0x54,0x12,0x89,0x8A,0xB1,
	0x21,0x0D,0x70,0x4E,0x49,0x95,0xCC,0xF8,
	0xC0,0x51,0x1A,0xD1,0x68,0x27,0xE2,0x79,
	0x29,0x65,0x1D,0xEC,0x47,0x1F,0x9E,0xF9,
	0x02,0x0A,0x05,0x58,0x14,0xC8,0xB0,0xB4,
	0x24,0xA1,0x52,0x36,0x2C,0xAC,0xB8,0xCD,
	0x03,0x4C,0x15,0x56,0x26,0x33,0x17,0x9D,
	0x23,0x39,0xC6,0x6D,0x1B,0xE5,0xD9,0xF3,
	0x30,0x83,0xC4,0xC9,0x8C,0x72,0xC5,0x76,
	0x46,0xE4,0xA3,0xBA,0xCA,0xB3,0xD6,0xFA,
	0x92,0x63,0x1E,0x73,0xAA,0xBC,0x75,0x6F,
	0x3A,0xE6,0x4F,0xF5,0x37,0xAF,0xEE,0xFE,
	0x20,0x82,0x18,0x43,0x50,0x94,0x13,0x5A,
	0x41,0x62,0x34,0xD2,0x19,0x78,0x99,0xF1,
	0xA0,0xA8,0xA2,0x35,0x45,0x9A,0x53,0xF2,
	0x0B,0x8B,0xD8,0xD5,0xD4,0xD3,0xAB,0xBE,
	0x60,0x38,0x61,0x96,0xD0,0x2B,0x4D,0x5D,
	0x0E,0x0F,0x71,0x3B,0x2D,0xCE,0xE9,0xEB,
	0x07,0x6A,0x2E,0xC7,0xB2,0x6B,0xB5,0xB7,
	0x93,0x8F,0x97,0x7B,0x3E,0xFC,0xBD,0xFD,
	0x84,0x16,0xC1,0x59,0x85,0x74,0xE8,0xDA,
	0x64,0x8D,0xF0,0xCB,0x9C,0x7C,0x5B,0xBB,
	0xA4,0x6C,0x66,0xEA,0x8E,0x7A,0xF4,0xDD,
	0xA9,0xE3,0x6E,0xF6,0x57,0xED,0xDE,0x7F,
	0x1C,0xA6,0xC3,0x9B,0x5C,0xA7,0x67,0x9F,
	0x87,0xAD,0x2F,0x77,0xDC,0x7D,0x3F,0xBF,
	0x4B,0xB9,0xAE,0xCF,0x5E,0x7E,0x5F,0xEF,
	0xB6,0xD7,0xDB,0xF7,0xE7,0xDF,0xFB,0xFF,
},

	{
	0x00,0x10,0x08,0x44,0x20,0x14,0x11,0x54,
	0x01,0xA0,0x09,0x29,0x24,0x58,0x83,0x8D,
	0x02,0x12,0x84,0x4C,0x88,0x0E,0x51,0x65,
	0x48,0x31,0x23,0x27,0x1C,0x5C,0x56,0x5B,
	0x40,0x60,0x42,0x85,0x82,0x98,0x38,0xC5,
	0x0A,0xC1,0x64,0x1D,0x43,0x72,0x93,0xD9,
	0xC0,0x34,0x62,0xD1,0xC2,0x1B,0xE2,0x7A,
	0x4A,0x59,0xAA,0x67,0x6A,0x57,0x79,0xBD,
	0x04,0x06,0x41,0x2C,0x22,0x8C,0x19,0xE1,
	0x03,0x32,0xA8,0x1E,0xC8,0xE8,0x3C,0x9D,
	0x21,0x26,0x16,0x96,0x52,0x33,0xB4,0xC7,
	0xC4,0x47,0xA6,0xA7,0x55,0xBA,0x7C,0xF9,
	0x05,0x8A,0x07,0x4D,0xA4,0x9A,0x6C,0x3D,
	0x92,0x35,0x99,0xAE,0x36,0xCD,0x97,0xE7,
	0xB0,0xB1,0xF0,0x73,0x63,0xB6,0x6E,0xDE,
	0x3A,0xEA,0xD5,0xBB,0xAB,0xD7,0xCF,0xFB,
	0x80,0x30,0x28,0x15,0x50,0x0D,0xA1,0xA3,
	0x90,0xD0,0x2A,0xA9,0x68,0x17,0x2B,0x4F,
	0x0C,0x61,0x45,0x2E,0x91,0xD4,0xD8,0x5E,
	0x70,0x78,0x95,0xAD,0x4E,0x9B,0xF1,0xB7,
	0x81,0x49,0x25,0xCA,0x13,0xA5,0xC6,0x3B,
	0xE0,0xD2,0x4B,0xF4,0xCC,0xE3,0x2F,0xF6,
	0x0B,0xC9,0x2D,0x8F,0x71,0xE6,0x75,0xFC,
	0x69,0xDC,0x6B,0x77,0xCB,0xDD,0x7E,0xFE,
	0x18,0x1A,0x89,0xC3,0xA2,0x8E,0xB8,0xB9,
	0x94,0x87,0xAC,0xE5,0x5A,0xF8,0x9E,0xEE,
	0x86,0x0F,0xE4,0xE9,0x8B,0x5D,0xDA,0x3F,
	0x39,0xF2,0x37,0xEB,0xB5,0xDB,0x6F,0xEF,
	0x46,0x53,0x74,0xB3,0xB2,0xEC,0x3E,0xED,
	0x66,0xCE,0x6D,0xF5,0x76,0xAF,0x5F,0xDF,
	0x9C,0xD6,0x1F,0x9F,0xBC,0xBE,0x7B,0xBF,
	0xD3,0xF3,0x7D,0xF7,0xFA,0x7F,0xFD,0xFF,
},

	{
	0x00,0x10,0x04,0xC0,0x40,0x09,0xA0,0x0D,
	0x20,0x50,0x90,0x13,0x14,0x34,0x29,0x4D,
	0x02,0x82,0x41,0x38,0x0A,0x54,0x16,0x63,
	0x84,0xA4,0x23,0x36,0x1C,0xE2,0x99,0xCB,
	0x80,0x0C,0x30,0xC1,0x11,0x26,0x86,0xD4,
	0x03,0x43,0x85,0x5A,0x83,0x71,0x6A,0xDA,
	0x12,0x52,0x45,0x69,0x8C,0x9A,0xC3,0x7A,
	0x4C,0x6C,0xC9,0xD3,0xA6,0x37,0x5D,0xF3,
	0x08,0x06,0x44,0x19,0x28,0xA8,0x64,0x2D,
	0x24,0xD0,0x2C,0xCC,0x68,0x39,0xAC,0xB5,
	0x21,0x0B,0x15,0xF0,0x2A,0x9C,0x2B,0xAB,
	0xC8,0xB4,0x8D,0xF4,0xA3,0xE5,0xAE,0xDE,
	0x60,0xC4,0x89,0xD8,0x46,0xAA,0x2E,0x3E,
	0xC2,0x93,0xE8,0xCD,0x1E,0x5B,0xE3,0x77,
	0x4A,0x65,0xCA,0xCE,0x5C,0x6B,0x5E,0xBB,
	0x3C,0xDC,0xEA,0xEB,0xD9,0xDD,0xEE,0xF7,
	0x01,0x81,0x88,0x0E,0x18,0x94,0xA2,0x35,
	0x48,0xB0,0x92,0x55,0x62,0xA5,0x17,0xD5,
	0x42,0x32,0x70,0x53,0x8A,0x95,0x87,0x6E,
	0x31,0xD2,0x74,0xBA,0x72,0x67,0x57,0xB7,
	0x22,0x51,0xA1,0x3A,0xE0,0xC5,0x66,0x9D,
	0x25,0x96,0x4B,0xF8,0xA9,0x7C,0xA7,0xD7,
	0x91,0x27,0x1D,0xE9,0xD1,0xC7,0x8F,0xF6,
	0xE1,0xB6,0xD6,0xAF,0x79,0xE7,0xBD,0xFE,
	0x05,0x98,0x07,0xB8,0x58,0xB2,0x8E,0xE6,
	0x49,0x1B,0x8B,0x75,0x78,0x9B,0xAD,0x7E,
	0x1A,0x56,0x47,0xF1,0xC6,0x76,0x3D,0x7B,
	0xE4,0xBC,0x9E,0x3F,0xEC,0xBE,0x6F,0x7F,
	0x61,0x33,0x0F,0xB9,0x59,0x1F,0x97,0xFC,
	0xB1,0x2F,0x3B,0x5F,0xB3,0x7D,0xFA,0xBF,
	0x4E,0x6D,0x4F,0x9F,0xF2,0xF9,0xED,0xEF,
	0x73,0xCF,0xDB,0xFB,0xF5,0xDF,0xFD,0xFF,
},

	{
	0x00,0x40,0x10,0x0C,0x04,0x03,0x82,0x92,
	0x08,0xC0,0x21,0x83,0x24,0x94,0x29,0xAA,
	0x01,0x90,0x88,0xA8,0x30,0x19,0xA1,0xAC,
	0x41,0x4A,0x25,0xD8,0x34,0x3C,0x95,0x79,
	0x02,0x28,0x84,0x07,0x18,0x0E,0x52,0xE2,
	0x50,0x98,0x1A,0x2E,0x91,0x35,0x93,0x1F,
	0x22,0x1C,0x23,0xD2,0xC8,0x74,0x2B,0xA7,
	0x38,0xCA,0x87,0x3E,0x99,0x6D,0x75,0xE7,
	0x80,0x81,0x05,0x15,0x14,0x49,0xC4,0x1E,
	0x48,0x2C,0xA2,0xA5,0x89,0x66,0x17,0xAE,
	0xA0,0x46,0x0D,0x33,0x32,0xF0,0x36,0xB3,
	0x45,0xCC,0xA9,0x6B,0x8D,0x7C,0xBC,0x9F,
	0x60,0xD0,0xC2,0xB4,0x64,0x39,0x59,0x97,
	0x43,0x2D,0xC3,0xF4,0x53,0x67,0x6E,0x7E,
	0x13,0xB1,0x55,0x3D,0x96,0x9D,0xEA,0xED,
	0x27,0xE6,0xD3,0x3F,0xD6,0x77,0x7B,0xFB,
	0x20,0x06,0x44,0x86,0x11,0x2A,0x62,0xC6,
	0x42,0x31,0x70,0x6A,0x68,0xD4,0xA3,0xAD,
	0x12,0x26,0x61,0xE4,0x0B,0x1D,0x69,0x8F,
	0x4C,0x6C,0x4B,0x76,0x5A,0x9B,0x2F,0x6F,
	0x0A,0xA4,0x58,0x0F,0x16,0xB8,0x5C,0x5B,
	0x8A,0x71,0xB2,0xCE,0x4E,0xD5,0xCD,0xF5,
	0x54,0x8E,0x72,0xF8,0x8B,0xBA,0x5D,0xBB,
	0x56,0xB9,0x7A,0xEB,0xCB,0xB7,0xFA,0xFE,
	0x09,0xE0,0x51,0x78,0x8C,0xE1,0x3A,0xEC,
	0xB0,0xC5,0xA6,0xD9,0x9A,0xB6,0x73,0xAF,
	0xC1,0x4D,0x47,0xF2,0x9C,0x4F,0xE5,0xCF,
	0xE8,0x57,0xE9,0x5F,0xAB,0xF9,0xF6,0xBF,
	0x85,0x1B,0xD1,0x37,0xC9,0x5E,0xE3,0xDB,
	0x63,0xDA,0x9E,0xD7,0xF1,0xEE,0x7D,0xF7,
	0x65,0x3B,0xDC,0xDD,0xC7,0xFC,0xBD,0xFD,
	0xB5,0xBE,0xDE,0x7F,0xF3,0xEF,0xDF,0xFF,
},

	{
	0x00,0x01,0x02,0x18,0x10,0x03,0x22,0x38,
	0x20,0x21,0xA0,0x98,0x84,0x1C,0x43,0x96,
	0x80,0x60,0x41,0x85,0x28,0x13,0x2C,0x99,
	0x90,0x32,0x4C,0x6C,0xA4,0x27,0x2D,0xE9,
	0x40,0x82,0x0C,0x4A,0x24,0x49,0x19,0x36,
	0x42,0xC8,0xA8,0x72,0x0B,0x8D,0xF0,0xE5,
	0x09,0x0E,0xA1,0xC3,0xB0,0x6A,0xCA,0x4F,
	0x92,0x66,0x71,0xD5,0x59,0xCB,0xF1,0xFC,
	0x04,0x06,0x44,0x26,0x11,0xC4,0x52,0x78,
	0x30,0x8C,0x61,0xD1,0x15,0x35,0x1B,0xCE,
	0x48,0x94,0x25,0xE2,0x70,0x74,0xD8,0xB3,
	0x0D,0x39,0x4E,0x9B,0xB2,0x7C,0xB5,0x5F,
	0x81,0x91,0x31,0xE8,0x89,0x56,0x9A,0xF2,
	0x16,0x95,0xC6,0x67,0x4D,0xE3,0xAD,0x9F,
	0x46,0xA6,0x87,0xAB,0xA3,0x97,0xDC,0x7B,
	0xE4,0x73,0xD6,0x3F,0xBC,0xDE,0xFA,0xFD,
	0x08,0xC0,0x50,0xD0,0x14,0xC2,0x62,0x9C,
	0x0A,0xE0,0x07,0xB1,0x2A,0x65,0x0F,0x3E,
	0x88,0x8A,0x68,0xAA,0x45,0x3C,0x55,0x6B,
	0x54,0x5C,0xCC,0xF4,0x93,0xC7,0x3B,0xE7,
	0x12,0x1A,0x34,0xA9,0x23,0x1E,0x47,0xB9,
	0x29,0xE1,0x5A,0xE6,0x3A,0x9E,0xCD,0xEE,
	0xC1,0x8E,0x4B,0x3D,0x1D,0x5D,0x79,0xBB,
	0x8B,0x75,0xAE,0x7D,0x76,0xAF,0xEB,0xEF,
	0x05,0x58,0x51,0xA5,0x86,0xC9,0x33,0x37,
	0xA2,0x69,0x53,0xB6,0x2E,0x2F,0x6E,0xED,
	0x64,0xC5,0xD2,0x57,0x2B,0x9D,0xEC,0xBE,
	0xB4,0x7A,0xEA,0x77,0x6D,0xD7,0xDD,0xFB,
	0x83,0xAC,0x17,0xDA,0xD4,0xBA,0xA7,0x7E,
	0xB8,0x1F,0x8F,0xCF,0x5E,0xBD,0x6F,0xF7,
	0x63,0x5B,0xD9,0xF3,0xD3,0xF5,0xF9,0xBF,
	0xF8,0xDB,0xF6,0xDF,0xB7,0xFE,0x7F,0xFF,
},

	{
	0x00,0x10,0x20,0x28,0x40,0x82,0x41,0x54,
	0x02,0x22,0x18,0xC1,0x14,0x43,0x83,0x3C,
	0x01,0x09,0x84,0x26,0x06,0x68,0xA2,0xB8,
	0x44,0x91,0x32,0x8B,0x34,0x1B,0xA6,0xD5,
	0x80,0x60,0x03,0x0D,0x21,0x70,0x62,0x53,
	0x90,0x07,0x0E,0x55,0xA1,0xC3,0xB2,0x1F,
	0xA0,0x0B,0x13,0x4E,0xD0,0x1D,0x2E,0xEC,
	0xA4,0x9C,0x99,0xAB,0x39,0x9D,0x6E,0x5F,
	0x04,0x0C,0x50,0x4A,0x81,0x52,0x45,0x59,
	0x48,0x29,0x4C,0xD1,0x1A,0xCA,0x6A,0xB6,
	0x0A,0xC8,0x19,0xD8,0x2A,0x6C,0x5C,0x97,
	0x16,0xE8,0x66,0xD6,0xC9,0x6B,0x57,0xBD,
	0x11,0x89,0xE0,0x74,0x1C,0x2B,0xE1,0xF4,
	0x8A,0x0F,0x93,0xB3,0x1E,0xAE,0x8F,0xF5,
	0x49,0xE4,0xC5,0xC7,0x78,0x9E,0xBA,0xF9,
	0x72,0xD3,0xCD,0x77,0xCB,0xF6,0xBE,0x7F,
	0x08,0x05,0x12,0x85,0x30,0x38,0x2C,0x8E,
	0x24,0x92,0x15,0x4B,0x98,0xD2,0x17,0x37,
	0xC0,0xB0,0x58,0x96,0x46,0xAA,0x87,0x3D,
	0xA8,0x69,0xB1,0xEA,0x47,0x79,0xF8,0x7B,
	0x42,0x86,0x64,0x36,0x25,0x71,0x2D,0xE6,
	0x51,0xA9,0xF0,0xE9,0x3A,0xE5,0xDA,0xDE,
	0xC4,0x27,0xAC,0x2F,0x8D,0x73,0x5E,0xCF,
	0x95,0xF1,0x5D,0xBB,0xF2,0x7D,0xED,0xEF,
	0x88,0x8C,0x61,0x4D,0x23,0x35,0x56,0xD9,
	0x31,0xD4,0x5A,0xB9,0xA5,0xA7,0x3E,0x7E,
	0x94,0xE2,0xCC,0x6D,0x63,0xE3,0x67,0x3F,
	0xA3,0x9B,0xB5,0xD7,0x7A,0xDD,0xAF,0xDF,
	0xC2,0x33,0xB4,0x4F,0x65,0xAD,0xDC,0xEE,
	0x9A,0x75,0x5B,0xFC,0xCE,0x9F,0xE7,0xFB,
	0xC6,0x76,0x7C,0xEB,0x3B,0xF3,0x6F,0xF7,
	0xBC,0xFA,0xDB,0xFE,0xB7,0xBF,0xFD,0xFF,
},

	{
	0x00,0x01,0x04,0x12,0x20,0x11,0x30,0x49,
	0x80,0x0A,0x81,0x68,0x82,0x34,0x64,0xCA,
	0x10,0x84,0x42,0x83,0x0C,0xA2,0x07,0x8D,
	0x06,0xC1,0x45,0xA5,0x15,0x71,0xE1,0x76,
	0x40,0x90,0xC0,0xA4,0xA0,0x89,0x1A,0x87,
	0x22,0x2C,0x16,0x99,0x52,0x72,0x2B,0xF8,
	0x88,0xE0,0x19,0x8B,0xA1,0xC5,0x55,0xDA,
	0xC8,0x9C,0xA3,0x9D,0xC3,0x9B,0x8F,0xBD,
	0x08,0x24,0x03,0x43,0x14,0x8A,0x92,0xAC,
	0x05,0x98,0x4A,0x4E,0xB0,0x53,0xCC,0x3D,
	0x50,0x91,0x38,0x27,0xC4,0x4D,0xB2,0xD5,
	0x31,0x95,0xE8,0x7C,0x6A,0x5E,0x3B,0xF5,
	0x18,0x62,0x85,0x69,0x58,0x9A,0xE4,0xF4,
	0x54,0x3A,0x5C,0xF1,0x4B,0xCB,0xBC,0xE7,
	0x23,0xF0,0x47,0xE5,0x96,0xBA,0x75,0xEE,
	0xD4,0xEA,0xD9,0x7B,0xB3,0x5F,0xDB,0xEF,
	0x02,0x28,0x21,0x70,0x48,0xC2,0x1C,0xB8,
	0x60,0x46,0x0B,0x63,0x0D,0x0F,0x93,0xAD,
	0x09,0x94,0x61,0xA9,0x13,0xB1,0xC6,0x73,
	0x51,0x65,0x66,0xF2,0x17,0x6E,0x9E,0x6F,
	0x41,0x4C,0x0E,0x3C,0x26,0x2E,0x2D,0xAB,
	0x2A,0x8E,0xB4,0xC7,0x1E,0xB9,0x7A,0x7E,
	0x25,0xAA,0x5A,0x57,0xC9,0x2F,0x5D,0x7D,
	0x36,0xCD,0x67,0xED,0xE6,0xDD,0x9F,0xFD,
	0x44,0x29,0xA8,0x56,0x8C,0x78,0x33,0x97,
	0x32,0x1D,0x6C,0xA7,0x1B,0xD6,0x37,0xF6,
	0x86,0xD1,0xD8,0xB6,0xD2,0xD3,0x4F,0xF9,
	0xA6,0xDC,0xE9,0x77,0x3E,0xD7,0xDE,0xDF,
	0xD0,0xE2,0x39,0x1F,0x35,0x6D,0xEC,0xF3,
	0x74,0xCE,0xE3,0xAF,0x6B,0xB7,0x3F,0xFB,
	0x59,0xB5,0xAE,0xFA,0x79,0xFC,0xBE,0xF7,
	0x5B,0xEB,0xCF,0xFE,0xBB,0xBF,0x7F,0xFF,
},

	{
	0x00,0x40,0x20,0x05,0x08,0x0C,0x24,0x92,
	0x02,0x88,0x44,0x89,0x0A,0x70,0xA2,0x99,
	0x01,0x12,0x84,0x31,0x09,0xB0,0x98,0x4B,
	0xA0,0x43,0x54,0xA5,0xA1,0xD1,0xF0,0xBC,
	0x04,0x90,0x11,0x45,0x30,0x0E,0x13,0x9A,
	0x82,0xA4,0x4A,0x71,0x8C,0x2E,0x55,0xE6,
	0x18,0xE0,0xA8,0xAC,0x23,0x59,0x35,0xB9,
	0xC1,0x66,0x63,0xBA,0x3C,0xAB,0xF4,0x9F,
	0x80,0x14,0x60,0x25,0x42,0x86,0x32,0x5A,
	0x50,0x64,0x61,0x0F,0xC8,0x53,0x93,0x9B,
	0x03,0x85,0x2C,0x8E,0x94,0x74,0x65,0x6E,
	0x34,0x8B,0x39,0xCE,0xA3,0x3B,0x57,0x7E,
	0xC0,0x91,0x8A,0x87,0x2A,0x27,0xAA,0xAE,
	0x62,0xC3,0x1D,0xE5,0x6A,0x5B,0xD3,0x3F,
	0x46,0xE2,0xC9,0xCB,0x33,0xCD,0xB6,0xAF,
	0x69,0xEA,0x97,0xBE,0xEC,0xDD,0xE7,0xFE,
	0x10,0x21,0x81,0x1A,0x22,0x15,0x0B,0xE8,
	0x06,0x51,0xC4,0xE1,0x19,0x9C,0xD4,0xF8,
	0x41,0x1C,0x38,0xB1,0x49,0x2D,0xCA,0x1F,
	0x83,0xD2,0xC6,0x2F,0x6C,0xAD,0x9E,0xFC,
	0x48,0x68,0xD0,0x36,0x52,0xA6,0x72,0xD9,
	0x58,0x8D,0x56,0xDA,0xB4,0x6D,0x7A,0xBB,
	0x29,0xE4,0x96,0x76,0x1B,0x37,0x4F,0xF3,
	0xD8,0xE3,0xF1,0xF9,0x8F,0xEE,0xF5,0xBF,
	0x28,0x4C,0xC2,0x5C,0x16,0x1E,0xC5,0x67,
	0x07,0x17,0x4D,0x5E,0x3A,0xDC,0x6B,0xDB,
	0x0D,0xCC,0x47,0xE9,0x78,0xB3,0x3D,0xBD,
	0x95,0x73,0xD5,0x77,0xF2,0xEB,0xD7,0x7F,
	0x26,0xB2,0x2B,0x5D,0xA9,0xA7,0x9D,0x7D,
	0x4E,0x79,0xB5,0xDE,0xD6,0x6F,0xF6,0xFD,
	0xB8,0x7C,0x3E,0xCF,0x75,0xFA,0xED,0xFB,
	0xC7,0x5F,0xB7,0xF7,0x7B,0xDF,0xEF,0xFF,
},

	{
	0x00,0x10,0x40,0x81,0x04,0x0A,0x22,0x8A,
	0x20,0x09,0x03,0x2C,0x90,0x07,0x0B,0xD2,
	0x01,0xA0,0x42,0xA1,0x18,0x70,0x46,0x2D,
	0x88,0x43,0xA2,0xD1,0x92,0xAC,0x53,0x6E,
	0x08,0x06,0x84,0xA8,0x48,0x19,0x52,0x4D,
	0x24,0x8C,0x58,0xC9,0x4C,0xE1,0x5A,0xA7,
	0x12,0x26,0x16,0xB2,0x25,0xF0,0x71,0xD5,
	0x61,0x65,0x6C,0xB5,0x56,0xDA,0xAE,0x7B,
	0x02,0x50,0x82,0xA4,0x11,0x38,0x49,0x78,
	0x28,0x1A,0x0D,0xB1,0xC1,0x2E,0x35,0x3B,
	0x44,0x94,0x29,0x39,0x1C,0x9A,0xB8,0x2F,
	0x32,0xC5,0x55,0xCE,0x1B,0xD6,0x7A,0xCF,
	0x14,0x86,0x68,0x9C,0x98,0x87,0x4E,0xCB,
	0xC8,0xE4,0x93,0x97,0x74,0xF2,0xCD,0xF3,
	0xB0,0xCC,0x0F,0x5D,0x69,0x76,0x79,0xF5,
	0x2B,0xBC,0xD3,0x7D,0x37,0xDB,0xB7,0xF7,
	0x80,0x41,0x60,0x91,0x0C,0x34,0x0E,0x63,
	0x30,0x31,0x4A,0xCA,0x23,0xB4,0xC6,0x7C,
	0x05,0x2A,0xC2,0x1D,0x54,0x72,0x33,0x8F,
	0x64,0xA9,0x8D,0xAB,0x3C,0x57,0xBA,0x7E,
	0xC0,0x85,0x15,0xA5,0xE0,0xAA,0x1E,0xAD,
	0xD0,0x5C,0x95,0x3D,0xC3,0x73,0xB6,0xED,
	0x13,0xA3,0xD4,0x6B,0x36,0x75,0xC7,0xF9,
	0x66,0x9B,0x67,0xEE,0xE5,0xDE,0xF6,0xFE,
	0x21,0x89,0xC4,0x8E,0x62,0x6A,0xE8,0xE9,
	0x83,0x59,0xE2,0x5E,0xA6,0xD9,0xF4,0x6F,
	0x51,0x8B,0x3A,0x6D,0x96,0x9E,0xB9,0xE7,
	0x17,0xB3,0xDC,0x3F,0xF1,0x5F,0xBB,0x7F,
	0x45,0x4B,0x47,0xEA,0x27,0x5B,0xEC,0xFC,
	0xD8,0x4F,0xE3,0xFA,0x1F,0xBD,0xD7,0xDF,
	0x99,0xE6,0x9D,0x77,0xF8,0xAF,0xEB,0xFB,
	0x3E,0xBE,0x9F,0xEF,0xDD,0xBF,0xFD,0xFF,
},

	{
	0x00,0x10,0x08,0x0C,0x04,0x05,0x42,0xA1,
	0x40,0x48,0x50,0x31,0x44,0x89,0x4A,0x1B,
	0x01,0x06,0x0A,0xA8,0x84,0x70,0x68,0x8B,
	0x81,0x45,0x1A,0x9A,0x4C,0x5A,0x47,0xD5,
	0x80,0x88,0x21,0x26,0x90,0xC8,0x38,0x78,
	0x18,0xC2,0x43,0xB8,0x52,0xE8,0x1D,0xE6,
	0x22,0x29,0x0B,0x36,0x91,0x3C,0x72,0xB3,
	0x62,0xE4,0xB4,0xF1,0x8D,0x7A,0x5E,0xF3,
	0x02,0x82,0x09,0x8A,0x03,0x94,0x86,0x95,
	0x30,0x23,0x54,0xA5,0x0D,0xD8,0x96,0xD6,
	0x28,0x58,0x85,0x2E,0xE0,0xA3,0x0F,0x9E,
	0x32,0xB1,0x4D,0xCE,0x56,0xB9,0xAB,0xCF,
	0x12,0xA4,0x15,0x4E,0x25,0x59,0xD1,0x79,
	0x34,0xC5,0xB2,0x3B,0xE2,0x6B,0xD3,0xFC,
	0x8C,0x35,0x9C,0x5D,0x6C,0x1F,0x75,0x9F,
	0x65,0xB6,0x37,0x6F,0xF4,0xBB,0xB7,0xDF,
	0x20,0xA0,0xC0,0x2A,0x14,0x1C,0xC4,0xA6,
	0x11,0xC1,0xD0,0x71,0xA2,0xAA,0x6A,0x6E,
	0x41,0x0E,0x07,0x5C,0x2C,0xCC,0x87,0x6D,
	0x51,0xE1,0x39,0xD9,0xCA,0xF2,0xB5,0x7D,
	0x24,0x13,0x49,0xAC,0x46,0x93,0xD4,0x3D,
	0x92,0x74,0x2D,0xE3,0x99,0x5B,0xAD,0xBE,
	0x98,0x63,0xC3,0x57,0x17,0x73,0xE5,0xF6,
	0x8E,0xEA,0x76,0x7E,0xCB,0x7B,0x77,0xFD,
	0x60,0x16,0x64,0x3A,0x19,0x2B,0x33,0x2F,
	0x83,0x4B,0xC9,0xE9,0x27,0x9D,0xBC,0xDD,
	0x61,0x1E,0xF0,0xDA,0x66,0xC7,0xCD,0xD7,
	0x53,0xBA,0x9B,0xEE,0xA7,0xDB,0xED,0x7F,
	0xB0,0x55,0xD2,0xF8,0x69,0x97,0xAE,0xFA,
	0xC6,0xEC,0x4F,0xE7,0x8F,0xF5,0xEB,0xF7,
	0xA9,0xDC,0x3E,0xBD,0x7C,0xDE,0xF9,0xEF,
	0x67,0xAF,0x3F,0xFE,0x5F,0xFB,0xBF,0xFF,
},

	{
	0x00,0x10,0x01,0x41,0x40,0x22,0x82,0x25,
	0x80,0x05,0x30,0x83,0x06,0x0E,0x51,0x99,
	0x08,0x90,0x50,0x62,0x11,0x70,0xA8,0x69,
	0x12,0x1A,0x86,0x36,0xC1,0xC3,0x8E,0x97,
	0x02,0x14,0x42,0x54,0x81,0x85,0xC8,0x71,
	0x60,0x26,0x34,0x35,0xB0,0xB1,0xB4,0xC7,
	0x18,0x92,0xE0,0xA6,0x32,0x5A,0x6A,0xB9,
	0x64,0x1B,0xCC,0x9B,0xE1,0xCD,0xB6,0xDE,
	0x20,0x44,0x09,0xC4,0x48,0x8A,0x61,0xD1,
	0xC0,0x43,0x16,0xA9,0x68,0x0F,0x3A,0x8F,
	0x03,0xA4,0x31,0x8D,0x8C,0xA5,0x53,0xF4,
	0x29,0x72,0xC6,0x9D,0xC5,0xCE,0xF2,0xCF,
	0x88,0x4A,0x2A,0xE8,0x89,0xD4,0x87,0x9E,
	0xD0,0x56,0xCA,0x2F,0x78,0x7C,0x37,0x9F,
	0x4C,0x33,0xD8,0x73,0x4E,0x4F,0x5B,0xFC,
	0x74,0xAB,0x7A,0x3F,0xB3,0xF6,0x5F,0xBF,
	0x04,0xA0,0x21,0x38,0x0A,0x0D,0x46,0x93,
	0x0C,0xA2,0x49,0x63,0x2C,0x2D,0xAA,0x57,
	0x84,0xC2,0xA1,0x9C,0x07,0x17,0x27,0xD5,
	0x19,0x4B,0x3C,0x76,0x55,0x3B,0xE9,0xE7,
	0x24,0x91,0x58,0x59,0x98,0xD2,0xB8,0xB5,
	0x13,0x6C,0x66,0xA7,0x2E,0xD9,0xEC,0x7B,
	0x23,0xB2,0xAC,0xF8,0x1D,0xE5,0xF1,0xAF,
	0xA3,0xBA,0xDA,0xBE,0x6D,0xEE,0xF3,0x7F,
	0x28,0x94,0x1C,0x39,0x52,0x95,0xC9,0xEA,
	0x0B,0x65,0x4D,0xE6,0x9A,0x67,0x75,0xDD,
	0x45,0x5C,0x2B,0x5E,0xF0,0xBC,0x3D,0xDB,
	0xE4,0xD3,0x6E,0xF9,0xDC,0xED,0x77,0xF7,
	0x15,0x8B,0x96,0xE3,0x47,0x6B,0x1F,0xBD,
	0xE2,0xCB,0x5D,0xB7,0xAD,0x7D,0xD7,0xDF,
	0x1E,0x79,0xD6,0x7E,0x3E,0x6F,0xBB,0xFD,
	0xAE,0xF5,0xEB,0xFB,0xFA,0xEF,0xFE,0xFF,
},

	{
	0x00,0x40,0x10,0x0C,0x20,0x82,0x14,0x52,
	0x01,0x81,0x11,0xD0,0x05,0x15,0x8C,0x33,
	0x02,0x24,0x48,0x13,0x22,0x98,0x31,0x69,
	0x28,0xE0,0x58,0xA9,0x32,0x35,0x87,0xF1,
	0x08,0x44,0x0A,0x83,0x41,0xC8,0x26,0x4D,
	0x42,0x2A,0xC2,0x27,0x4A,0xE1,0x2B,0xF4,
	0x30,0x4C,0x94,0x99,0x45,0xAA,0x2E,0xCD,
	0x0E,0x5A,0x72,0x3D,0x56,0x57,0x9D,0x7B,
	0x80,0x50,0x21,0x54,0x84,0xA1,0x46,0xA6,
	0x90,0xA4,0x07,0x59,0x86,0xC6,0x2D,0x97,
	0xC0,0x43,0xA8,0x6A,0x61,0xAC,0xC5,0x5E,
	0x68,0x1B,0xB2,0xAE,0x0F,0x7C,0x8F,0xF9,
	0x03,0x85,0xC1,0x74,0x64,0xA5,0x47,0x4F,
	0x92,0x1D,0x65,0xE5,0xB4,0x5D,0x6D,0xFA,
	0x91,0x66,0x4B,0xDC,0xC9,0xE3,0xAB,0xF3,
	0xE8,0xCE,0x67,0xAF,0xEA,0x7E,0xDE,0xBF,
	0x04,0x18,0x88,0x19,0x12,0x1A,0x70,0xF0,
	0x09,0x1C,0xC4,0xB8,0xA2,0xE2,0x9A,0xF8,
	0x06,0x49,0x25,0x8E,0x38,0x93,0x39,0x76,
	0x89,0xCC,0x8B,0xD5,0xD8,0x9B,0xAD,0xB7,
	0xA0,0x2C,0x34,0x8D,0x0D,0x3A,0xA3,0x79,
	0x16,0x78,0x96,0x2F,0x3C,0x75,0xB9,0x9F,
	0x8A,0x17,0x55,0x1F,0xD1,0xC7,0x37,0x3F,
	0x9C,0xBA,0x3B,0xEB,0x7A,0xF6,0xED,0xFE,
	0x60,0xB0,0x62,0x1E,0x29,0xD4,0x95,0xB5,
	0x51,0x36,0x63,0xA7,0xCA,0xE9,0x9E,0xEE,
	0x23,0x71,0x53,0xE6,0x6C,0xB3,0xBC,0xD7,
	0xE4,0xF2,0xEC,0xFC,0xD3,0xF5,0xCF,0x7F,
	0x0B,0xC3,0xB1,0xCB,0x4E,0x5B,0x6B,0xDB,
	0xD2,0xD6,0xDA,0xDD,0xD9,0xBE,0xBD,0xEF,
	0x5C,0x3E,0x6E,0x7D,0x73,0xE7,0x77,0xFD,
	0xB6,0x5F,0x6F,0xF7,0xBB,0xFB,0xDF,0xFF,
},

	{
	0x00,0x01,0x20,0x14,0x04,0x90,0x0A,0x25,
	0x80,0x21,0x30,0x85,0x0C,0x0B,0x43,0x6C,
	0x02,0x84,0x11,0x68,0x44,0x45,0x19,0x72,
	0x28,0x91,0xC1,0x1B,0x0E,0xF0,0x59,0xD9,
	0x08,0x22,0x24,0x16,0xC0,0x8C,0x1A,0xCA,
	0x42,0x8A,0xE0,0x8D,0xD0,0xAA,0x47,0x97,
	0x03,0xC8,0x4C,0x87,0x92,0x71,0x5A,0x1F,
	0x32,0x2D,0x33,0x6D,0x9A,0xE6,0x4F,0xDE,
	0x10,0x18,0x12,0x61,0x05,0x89,0x70,0x27,
	0x09,0xC2,0xC4,0xC9,0x23,0x5C,0xA9,0xDC,
	0x82,0x62,0x2A,0xE1,0x0D,0xE2,0x4E,0xD6,
	0x83,0x39,0x35,0x73,0x3A,0x7C,0xF1,0x7B,
	0x88,0x51,0x54,0x66,0x46,0x4D,0xD2,0xE9,
	0xB0,0xA6,0x95,0x57,0x63,0x5D,0xBA,0xBD,
	0x31,0xC3,0x96,0x67,0x65,0xF8,0xE3,0x5F,
	0x74,0xB5,0xBC,0xBB,0xCB,0x7E,0xFC,0xDF,
	0x40,0xA0,0x50,0x94,0x48,0xA4,0x26,0xE4,
	0x60,0x58,0xA2,0x9C,0x13,0x69,0x3C,0xAB,
	0x41,0x2C,0xA8,0xD1,0x4A,0x6A,0x1D,0x3B,
	0x38,0x1E,0x4B,0x6E,0x8E,0x37,0xCD,0xF6,
	0x81,0x86,0x49,0x55,0x29,0xA3,0x93,0xE5,
	0x98,0xC5,0x0F,0xC7,0xB2,0xF4,0x2F,0xD7,
	0x07,0x2E,0xB8,0xA7,0x99,0x79,0xEC,0xED,
	0x56,0xAD,0xB9,0xBE,0x5B,0xE7,0x3F,0xFB,
	0x06,0xA1,0x52,0xAC,0x64,0xB1,0x53,0xB6,
	0x1C,0xD4,0x8B,0x9D,0xC6,0x3E,0x76,0xCF,
	0x34,0xB4,0xCC,0x9E,0x78,0xD3,0x75,0xF3,
	0x2B,0x3D,0xF2,0xF5,0x7A,0xDB,0x9F,0xFD,
	0x15,0x17,0xD8,0xEA,0xA5,0xAE,0xDA,0xFA,
	0xE8,0x6B,0xD5,0x77,0xB3,0xDD,0xAF,0xBF,
	0x36,0x5E,0x8F,0xF9,0xCE,0xEE,0xB7,0xF7,
	0x9B,0x6F,0xEB,0x7F,0x7D,0xFE,0xEF,0xFF,
},

	{
	0x00,0x10,0x40,0x81,0x02,0xC0,0x09,0x45,
	0x04,0x60,0x41,0x62,0x48,0x34,0x43,0x2D,
	0x08,0x24,0x82,0x8C,0x50,0x38,0x31,0x72,
	0x84,0x98,0x86,0xB4,0xB0,0xAA,0x2E,0xD6,
	0x01,0x44,0x21,0x91,0x11,0x2C,0x8A,0x59,
	0x12,0x0D,0xC1,0x78,0x0E,0x87,0xD1,0x9D,
	0x28,0x92,0x4A,0x17,0x1A,0xD2,0x55,0xB6,
	0x70,0x74,0x9C,0x6B,0xCA,0xF4,0xAB,0x9F,
	0x20,0x05,0x0A,0x46,0x22,0x15,0x68,0x47,
	0x88,0x4C,0x16,0xD4,0x85,0xE2,0xA6,0x97,
	0x0C,0xA2,0x64,0x1B,0x51,0xC3,0xB2,0x73,
	0x07,0x6A,0xA9,0x7C,0x33,0xE6,0xDC,0xF6,
	0x14,0x61,0xA1,0xA5,0x52,0x5A,0x3C,0x3D,
	0x32,0xC5,0x1E,0x9B,0xCC,0xA7,0x67,0x77,
	0xA8,0x99,0xE8,0x5B,0x2B,0x7A,0xCD,0xF3,
	0xE4,0x37,0xDA,0xEB,0xB5,0xDD,0xEE,0xF7,
	0x80,0x90,0x06,0x29,0x30,0x13,0x94,0x6C,
	0x18,0x23,0x1C,0x95,0x19,0x5C,0x66,0x5E,
	0x42,0x54,0x2A,0xAC,0xC4,0x4E,0x93,0xAE,
	0x83,0x9A,0xB8,0xD3,0x35,0xF8,0xCB,0xBD,
	0xA0,0x89,0xE0,0x69,0xD0,0xC6,0xA3,0xEA,
	0x25,0x56,0x0F,0x8F,0x36,0x6E,0x57,0xE7,
	0xC8,0x53,0xF0,0x6D,0x39,0x3E,0x2F,0xBB,
	0xB1,0xBC,0x4F,0xB7,0x1F,0x3F,0xDB,0xFD,
	0x03,0x58,0xA4,0xD8,0x0B,0x71,0x4B,0xB3,
	0x49,0x3A,0x4D,0x76,0x65,0xEC,0xE9,0x6F,
	0xC2,0x8D,0xE1,0x79,0x8E,0xAD,0xBA,0xF9,
	0x27,0xD5,0x5D,0xBE,0xE5,0xFA,0x7E,0xFB,
	0x26,0x63,0x1D,0xD9,0xC9,0xE3,0x9E,0x7B,
	0x96,0xF1,0xB9,0xCF,0x75,0xAF,0xFC,0x7F,
	0x8B,0xC7,0xCE,0x7D,0xF2,0x5F,0xED,0xDF,
	0x3B,0xF5,0xD7,0xBF,0xDE,0xEF,0xFE,0xFF,
},

	{
	0x00,0x01,0x80,0x11,0x08,0x90,0x21,0x4A,
	0x40,0x14,0xA0,0x0E,0x88,0x0D,0x16,0x4B,
	0x10,0x42,0x0C,0x98,0x48,0x8A,0x4C,0xB4,
	0x0A,0x91,0x29,0x33,0x8C,0x99,0x6C,0xEC,
	0x04,0x22,0x28,0x58,0x30,0x68,0xE0,0x9C,
	0x50,0xA1,0xA8,0xE2,0x94,0x93,0xAA,0x8F,
	0x09,0x1A,0x25,0x96,0xB0,0x1B,0x56,0xF2,
	0x13,0x39,0x72,0xB6,0xA3,0x4F,0x6D,0x6F,
	0x20,0x81,0x24,0x54,0x12,0x92,0x23,0x87,
	0xC0,0x85,0x45,0x2E,0x15,0x4D,0x47,0x3E,
	0x84,0xC8,0x61,0x35,0x89,0xD2,0x36,0x79,
	0x70,0x5C,0x8D,0xE3,0x59,0x5E,0x7C,0xEE,
	0x18,0x19,0x34,0xE1,0x0B,0xF0,0x65,0x3D,
	0x31,0xD4,0x8E,0xAE,0x2D,0x97,0xB3,0xBB,
	0x52,0x3C,0x2B,0xDA,0x27,0xBA,0xCE,0xDB,
	0xC6,0xB9,0xEA,0x7D,0x7A,0xCF,0xEB,0xFE,
	0x02,0x06,0x60,0x49,0x44,0xC4,0x07,0x0F,
	0x05,0xD0,0x64,0xC9,0xC1,0x8B,0x69,0x5D,
	0x82,0x62,0x32,0x3A,0x83,0xB2,0xB1,0x57,
	0x2C,0x55,0xC3,0x1F,0xAC,0x6E,0x67,0x77,
	0x41,0x38,0x26,0xE8,0x1C,0xD1,0x78,0xD3,
	0x2A,0x63,0xCA,0xE9,0x5A,0x73,0xCB,0xED,
	0xC2,0x53,0x1D,0x9D,0xC5,0xBC,0xA7,0xF5,
	0x1E,0x76,0xF1,0x5F,0xD9,0xE7,0xBE,0xDF,
	0x03,0x43,0xA2,0xD8,0xA4,0xA5,0x71,0xC7,
	0x86,0x4E,0x66,0xB5,0x74,0x2F,0xAD,0xD7,
	0x46,0x6A,0xB8,0xF8,0x9A,0x9E,0xF4,0x7E,
	0xCC,0x6B,0xE6,0xDD,0x75,0xFC,0xFA,0xFB,
	0x51,0xA9,0xE4,0x37,0x17,0xCD,0x9B,0x7B,
	0xA6,0x5B,0xE5,0x3F,0xD6,0xB7,0xBD,0xF7,
	0x95,0xD5,0x3B,0xF9,0xAB,0xAF,0xF6,0xEF,
	0xDC,0x9F,0xF3,0xBF,0xDE,0x7F,0xFD,0xFF,
},

	{
	0x00,0x40,0x80,0x81,0x10,0x90,0x50,0x0E,
	0x04,0x0C,0x24,0x26,0xA0,0x49,0x8A,0x9A,
	0x02,0x18,0x41,0x8C,0x0A,0x29,0x2A,0x8E,
	0xC0,0x91,0x23,0xA5,0x19,0x78,0xA3,0xF2,
	0x20,0x48,0x22,0xE0,0x21,0x98,0xA8,0xB1,
	0x44,0x07,0xA1,0xE1,0x54,0x93,0x4D,0x57,
	0x28,0x43,0x85,0x2D,0xC8,0x87,0x27,0xCB,
	0x89,0x95,0x4B,0x67,0x9C,0xE9,0xB9,0x6F,
	0x08,0x14,0x30,0x64,0x82,0x4A,0xA2,0x8B,
	0x88,0x61,0xB0,0x65,0x51,0x3C,0xA6,0xE6,
	0x11,0x32,0x94,0xCA,0x25,0x4E,0x5A,0xEA,
	0x0D,0xAA,0x63,0xF8,0x69,0x76,0xAD,0xF6,
	0x03,0x62,0x38,0xD8,0x4C,0x56,0xA9,0xF4,
	0x45,0xC3,0x1D,0xE3,0x5C,0x6B,0xDA,0x77,
	0x92,0xC6,0xAC,0xBA,0x96,0x4F,0x1F,0xEE,
	0x47,0xC7,0x3D,0xDE,0x6E,0xFC,0xF9,0xEF,
	0x01,0x09,0x05,0x0B,0x12,0x68,0x31,0xB8,
	0x42,0xC1,0xD0,0x3A,0x58,0x59,0xD4,0x5D,
	0x06,0x83,0x13,0xE4,0x86,0x6C,0x55,0x7C,
	0x34,0x2B,0x74,0x73,0x66,0xCD,0xD3,0xAF,
	0x60,0x15,0xA4,0x17,0x1C,0x53,0x99,0x7A,
	0x52,0x0F,0x33,0xAB,0x39,0xB3,0xEC,0x3F,
	0xC4,0xB2,0x35,0x8F,0xB4,0x9B,0x6D,0xBB,
	0x36,0x9E,0x2F,0xDD,0xA7,0x7D,0xE7,0xDF,
	0x84,0x70,0xC2,0x2E,0x46,0xF0,0xCC,0xF1,
	0x2C,0x8D,0x1E,0xD9,0x72,0xCE,0xB6,0x9F,
	0x1A,0xE8,0x6A,0xD5,0xE2,0xB5,0x75,0xFA,
	0xD1,0x5E,0x9D,0xEB,0xBC,0xED,0x5F,0xF7,
	0x16,0xC9,0xD2,0x79,0x71,0xE5,0xDC,0xCF,
	0xC5,0xD6,0x37,0xDB,0xAE,0xBD,0xB7,0x7F,
	0x1B,0x3E,0x3B,0x7B,0x5B,0x7E,0xF3,0xFE,
	0x97,0xBE,0xF5,0xFD,0xD7,0xBF,0xFB,0xFF,
},

	{
	0x00,0x10,0x08,0x42,0x80,0x12,0x24,0x07,
	0x20,0x22,0x44,0x23,0x48,0x0E,0x8A,0x74,
	0x01,0x82,0x05,0x4C,0x0A,0xC4,0x51,0x5A,
	0x90,0x61,0x31,0x0F,0x64,0x33,0x69,0xCE,
	0x40,0x09,0x14,0xA8,0x11,0xC1,0x58,0x17,
	0x84,0x15,0xA4,0x72,0x86,0xF0,0x66,0xC7,
	0x81,0xD0,0x25,0xD2,0xA2,0x6C,0x87,0x9E,
	0xE0,0xD4,0x8B,0x5D,0xE8,0x6D,0x37,0x77,
	0x02,0xC0,0x03,0x2A,0x41,0x29,0x68,0xD8,
	0x30,0x16,0x49,0xA9,0x0B,0xE4,0x93,0xB6,
	0x21,0x91,0x52,0x95,0x94,0x71,0xC5,0xB3,
	0x34,0x36,0x56,0xAD,0xE1,0x75,0xE5,0x9F,
	0x28,0x32,0x4A,0x5C,0x98,0xB8,0x2D,0xF4,
	0x2C,0xE2,0x1B,0xA7,0x8D,0xD6,0xDA,0xF3,
	0x1A,0x99,0x1E,0x73,0x1D,0x8F,0x7A,0xDD,
	0x65,0x5B,0xEC,0xF6,0xB9,0xED,0xE7,0x7F,
	0x04,0x88,0x50,0x92,0x18,0xC2,0x13,0x4B,
	0xA0,0x89,0x46,0xAA,0x0D,0xD1,0x2E,0xBA,
	0x06,0xC8,0xA1,0xA3,0xB0,0x63,0x35,0xD3,
	0x1C,0xAC,0xC6,0xE3,0x96,0x9B,0x6B,0xFC,
	0x0C,0x54,0x62,0xB4,0x19,0x6A,0xC3,0x76,
	0x85,0x39,0x8E,0x3B,0x3A,0xB5,0xE9,0xD7,
	0x26,0x27,0x3C,0xE6,0x78,0x4F,0x1F,0xBE,
	0x4E,0xBC,0xD5,0xAF,0x2F,0xF5,0x7B,0xEF,
	0x60,0x38,0x83,0xC9,0x8C,0x55,0x2B,0x3D,
	0x45,0x4D,0xA5,0xF2,0x59,0x6E,0xAE,0xBD,
	0x43,0xB1,0x53,0xCD,0x9C,0xAB,0x3E,0xBB,
	0xA6,0xCB,0x9D,0x5F,0xF8,0x3F,0xEB,0xFE,
	0x70,0xCA,0xCC,0x7C,0x47,0x5E,0x67,0xEE,
	0xB2,0x97,0x79,0x7D,0x57,0xDB,0x6F,0xFB,
	0x9A,0xDC,0xEA,0xFA,0xF1,0xCF,0xB7,0xF7,
	0xD9,0xDE,0x7E,0xDF,0xF9,0xBF,0xFD,0xFF,
},

	{
	0x00,0x10,0x40,0x81,0x04,0x48,0x90,0xA1,
	0x20,0x24,0x28,0x8C,0x22,0x15,0x91,0xCA,
	0x02,0x21,0x88,0x86,0x03,0x51,0x94,0x65,
	0x14,0x43,0xA4,0x3C,0x49,0x59,0xC9,0x67,
	0x80,0x11,0x50,0x89,0x84,0x26,0x0D,0x66,
	0x0A,0xD0,0x34,0x72,0xA8,0x93,0x5A,0xE9,
	0xC0,0x98,0x1A,0x9A,0x38,0xA3,0x8E,0xAE,
	0x2A,0xD4,0xC5,0xBC,0x96,0x73,0x5E,0x3F,
	0x01,0x12,0x09,0x54,0x30,0x70,0x25,0xB8,
	0x41,0x07,0x23,0x2B,0x61,0x39,0x2D,0x9D,
	0x18,0xC1,0xA2,0x53,0x13,0x63,0x2E,0xF4,
	0x46,0xE1,0x36,0xCE,0xD2,0x37,0xD6,0x6F,
	0x42,0x31,0x52,0x33,0x85,0xA5,0x27,0xEA,
	0x58,0x55,0x35,0x6D,0xF0,0xD3,0x97,0xF9,
	0x92,0x5C,0x95,0xDC,0x3A,0x3D,0xBA,0xB7,
	0x0F,0xE6,0x9B,0xED,0x3B,0x9F,0xF6,0xFE,
	0x08,0x60,0x06,0x2C,0x82,0x83,0x0E,0x4B,
	0x44,0x0B,0x4A,0xB2,0x32,0xAA,0xE2,0xDA,
	0x0C,0x64,0xC2,0x4D,0xB0,0xB4,0x6C,0x6E,
	0xC4,0x47,0xB1,0xE5,0x8D,0xAD,0xF1,0xD7,
	0xA0,0x68,0x19,0x17,0x62,0xAC,0xD1,0x2F,
	0x4C,0xCC,0x8B,0xC7,0x1B,0xF8,0x1F,0xAF,
	0x45,0xD8,0x1D,0xB5,0x78,0xCD,0xB3,0xCF,
	0xE8,0xB9,0xCB,0x77,0x3E,0xF3,0x5F,0xF7,
	0x05,0x16,0xC8,0x87,0x29,0xA9,0x99,0xD5,
	0x8A,0x9C,0x6A,0xEC,0x74,0x79,0x5B,0xE7,
	0x1C,0xA6,0xE4,0xA7,0x69,0x76,0x57,0xFC,
	0xC3,0x75,0xAB,0xDD,0x4F,0xBD,0xF5,0xFB,
	0xE0,0x4E,0x56,0xD9,0x71,0xE3,0x5D,0xEB,
	0xC6,0xB6,0x6B,0x7D,0x7A,0xFA,0xEE,0xDF,
	0x1E,0x9E,0xF2,0xDB,0x8F,0x7E,0xBB,0xBF,
	0x7C,0xDE,0xBE,0xFD,0x7B,0xEF,0x7F,0xFF,
},

	{
	0x00,0x10,0x20,0xA0,0x08,0x12,0x42,0xC4,
	0x80,0x05,0x50,0x25,0x24,0x8C,0x1C,0xA3,
	0x40,0x21,0x18,0x34,0x09,0xE0,0x94,0x9C,
	0x48,0x98,0x15,0x5C,0x45,0x8E,0x39,0x9D,
	0x04,0x06,0x11,0x0E,0x14,0xC2,0x4A,0x3C,
	0x84,0x86,0x83,0xF0,0x92,0x69,0x87,0x57,
	0x28,0xA8,0x51,0x5A,0x13,0x1B,0xC3,0x1F,
	0x32,0x1D,0x78,0x5D,0x56,0x3B,0xE5,0xBD,
	0x02,0x0A,0x22,0x29,0x30,0x0B,0x0D,0x55,
	0x88,0xB0,0x23,0xD4,0x1A,0xCA,0xE2,0xF8,
	0x41,0x4C,0x68,0xA9,0x26,0x93,0x2E,0xF4,
	0x52,0x33,0xB4,0xB6,0xAA,0x3E,0x7C,0xF3,
	0xC0,0x49,0x58,0xE8,0xA1,0x4B,0x8B,0xD5,
	0x91,0x6C,0x63,0xC7,0x36,0x6E,0xD9,0x7D,
	0x54,0x4D,0x59,0xB9,0x2D,0x97,0x76,0xB7,
	0xE1,0x3D,0xA7,0xE7,0xAD,0xBB,0x5F,0xFD,
	0x01,0x81,0x03,0x19,0x0C,0x2A,0xC8,0x53,
	0x60,0x2C,0x38,0xB1,0x61,0x17,0x74,0xB3,
	0x82,0x07,0xD0,0xE4,0x46,0x66,0xC5,0x79,
	0x62,0xC6,0xD2,0xAE,0x72,0xE9,0x9B,0xED,
	0x90,0xA2,0x85,0x1E,0x16,0x47,0xA6,0x4F,
	0xC1,0x95,0xA5,0xCD,0x99,0x6B,0x5B,0xDE,
	0x89,0x65,0x0F,0x5E,0xC9,0x7A,0xBC,0xCF,
	0x96,0xDA,0x37,0xEE,0xF2,0xF6,0x77,0x7F,
	0x44,0x43,0x31,0xAC,0xA4,0x8D,0x9A,0xEC,
	0x64,0xCC,0xB2,0x8F,0x71,0xEA,0x6D,0xAF,
	0x70,0xB8,0x2B,0xD3,0x4E,0x67,0x2F,0xFA,
	0x35,0xE3,0xBA,0x7B,0xE6,0x6F,0xDD,0xFE,
	0x8A,0x27,0x3A,0xDC,0x6A,0x73,0xCB,0xFC,
	0xD1,0xCE,0xF1,0x3F,0xB5,0xD7,0xF9,0xFB,
	0xD8,0x75,0x9E,0xDB,0xAB,0xEB,0xBE,0xEF,
	0xD6,0x7E,0x9F,0xF7,0xF5,0xDF,0xBF,0xFF,
},

	{
	0x00,0x40,0x04,0x81,0x02,0x12,0x88,0x26,
	0x01,0x18,0x05,0x23,0x0A,0xA2,0xC1,0x1B,
	0x10,0x28,0x48,0x70,0x03,0x98,0xA1,0xC6,
	0x21,0x4A,0x1A,0xC5,0x2C,0xB4,0xD8,0xAE,
	0x20,0x42,0x50,0x1C,0x24,0x61,0x07,0x56,
	0x22,0x19,0x38,0x1D,0x51,0x8B,0xB2,0x9B,
	0x0C,0x2A,0x15,0xA6,0x31,0x96,0xA9,0x73,
	0xC4,0x99,0x5C,0x75,0x63,0x7C,0xD3,0xFC,
	0x80,0x09,0x30,0x91,0x11,0x16,0x94,0xCA,
	0x60,0x0E,0x34,0x69,0x45,0xF0,0x36,0xD9,
	0x82,0xB0,0x83,0xD1,0x86,0x71,0xE4,0x9D,
	0x32,0x87,0x39,0xE5,0x78,0x7A,0x6B,0xED,
	0x14,0x4C,0x43,0x17,0x0B,0xE8,0x6C,0xB6,
	0x0D,0xCC,0x33,0xB9,0x9C,0xB5,0x6E,0x7B,
	0x68,0x27,0x55,0xDA,0x66,0xF1,0xBA,0x9F,
	0x4B,0xF8,0x8F,0xB7,0xDC,0xF6,0xEE,0xFD,
	0x08,0xC0,0x84,0x85,0x06,0x46,0x52,0x72,
	0x90,0x49,0x89,0x0F,0x58,0x5A,0x95,0x76,
	0x44,0x29,0xC8,0xE1,0xC2,0xC3,0x93,0xE3,
	0x25,0x6A,0x8D,0x67,0x35,0xA7,0x5E,0xBB,
	0x41,0x64,0x8A,0x2B,0x8C,0xC9,0x4E,0xD5,
	0xE0,0xA5,0x3C,0xD6,0x53,0x57,0xCD,0xEB,
	0xA4,0xA3,0x8E,0x1F,0xAA,0x37,0xEA,0xFA,
	0xD4,0xE6,0x5D,0x7D,0xAD,0xCF,0xDB,0xEF,
	0xA0,0x54,0xD0,0x2E,0xA8,0x1E,0x47,0xF2,
	0x13,0xB8,0x65,0x6D,0x3A,0xBC,0x97,0xD7,
	0x62,0x4D,0x59,0xCB,0x9A,0xC7,0x4F,0xF3,
	0xD2,0x3B,0x79,0xDE,0xE9,0xDD,0xE7,0x7F,
	0x92,0x74,0x2D,0x5B,0xB1,0x3E,0xCE,0x77,
	0xE2,0x2F,0xEC,0xBD,0x3D,0xF9,0x3F,0xBF,
	0xAC,0xF4,0x9E,0x7E,0xAB,0x5F,0xAF,0xDF,
	0xB3,0x6F,0xBE,0xF7,0xF5,0xFB,0xFE,0xFF,
},

	{
	0x00,0x01,0x20,0x0A,0x02,0x09,0x90,0xC4,
	0x80,0x11,0x21,0x46,0x82,0x2C,0x8C,0x36,
	0x08,0x05,0x12,0x85,0x03,0x98,0x16,0xE2,
	0x30,0x43,0x89,0x4B,0x38,0xC6,0xB4,0xC7,
	0x10,0xC0,0x18,0x15,0x42,0x26,0xB0,0x74,
	0x81,0x0D,0x51,0x96,0x29,0xAA,0x2D,0x5B,
	0x44,0xC8,0x4C,0x27,0x8A,0x2B,0x5A,0xEC,
	0x54,0x8D,0x8B,0xE9,0x93,0xAE,0xF4,0xF6,
	0x04,0x24,0x60,0x31,0x22,0x32,0x0B,0xF0,
	0x48,0x23,0x58,0x4D,0xC2,0x71,0xE4,0xF8,
	0xA0,0x61,0x07,0xA3,0x94,0xC3,0x59,0x5E,
	0xA4,0x78,0x3A,0xCE,0xB1,0x3B,0xE3,0xEE,
	0x06,0x45,0x64,0x9C,0xA8,0xA5,0xCC,0x1F,
	0x91,0x72,0x1E,0x9D,0x56,0x4F,0x6B,0xED,
	0x62,0x0F,0x63,0xB6,0x87,0x75,0xB3,0xE7,
	0x1B,0x7A,0xBC,0xDB,0x7C,0xEB,0xBB,0xFE,
	0x40,0x88,0x50,0x86,0x84,0x92,0x19,0xAC,
	0x0C,0xD0,0x2A,0x6A,0xE0,0x95,0x66,0xBA,
	0x41,0xA2,0x13,0x6C,0x0E,0x8E,0xD4,0xF1,
	0x83,0x69,0xC9,0x3D,0x4E,0x97,0x5D,0xCF,
	0x14,0x70,0x1C,0x47,0xC1,0x35,0xA6,0x6D,
	0x52,0xB2,0x33,0x57,0x39,0xA7,0x9E,0xBE,
	0x1A,0xA9,0x65,0xEA,0xD1,0x79,0xD9,0x7E,
	0x1D,0x73,0xE5,0xFC,0x3E,0xB7,0x7D,0x7F,
	0x28,0x25,0x34,0xD8,0x49,0x9A,0xCA,0xAD,
	0x4A,0x2E,0x17,0xD6,0x3C,0x76,0xAB,0xF9,
	0xA1,0xD2,0xC5,0xE6,0xE1,0xD5,0xDC,0x9F,
	0x55,0xCB,0xCD,0xFA,0xB5,0xD7,0xBD,0xDF,
	0x68,0x99,0x5C,0xD3,0x53,0xB9,0x6E,0x5F,
	0xB8,0x9B,0xF2,0x77,0xDA,0xDE,0x7B,0xFD,
	0xE8,0x8F,0x37,0xF3,0x67,0x6F,0x3F,0xF7,
	0x2F,0xF5,0xDD,0xBF,0xAF,0xFB,0xEF,0xFF,
},

	{
	0x00,0x10,0x40,0x05,0x04,0x90,0x12,0x89,
	0x08,0x44,0x81,0xC4,0x06,0x8A,0x51,0xD2,
	0x02,0x22,0x60,0x26,0x48,0x25,0x83,0xD4,
	0x42,0x4C,0x31,0x5C,0x68,0x63,0xC3,0x3D,
	0x01,0x88,0x50,0x49,0x11,0xE0,0x94,0x87,
	0x24,0x0D,0x19,0xA5,0x4A,0x2D,0x3A,0x73,
	0xC0,0x8C,0x15,0xC6,0x13,0x4B,0x96,0xD9,
	0x54,0x55,0xAC,0x1F,0x3C,0x8F,0xCD,0xE7,
	0x20,0x41,0xA0,0x46,0x28,0x2A,0xD0,0x6A,
	0x03,0x16,0xA4,0xE4,0x23,0xE2,0x33,0xF1,
	0x0C,0x61,0x1C,0x5A,0x58,0x8E,0x66,0x75,
	0xA8,0xF0,0x71,0x7C,0xB8,0xF8,0xEA,0xDE,
	0x18,0xC1,0x0B,0x95,0x70,0x1B,0x99,0xBC,
	0x85,0xCA,0x53,0x67,0x1E,0xB6,0x5D,0x5F,
	0x52,0x56,0x27,0x6D,0xB2,0xC7,0x9B,0x77,
	0x69,0xCB,0x37,0x6F,0xD6,0x7E,0xF6,0xBF,
	0x80,0x30,0x14,0x2C,0x82,0x1A,0x91,0x2B,
	0x21,0x38,0x92,0x39,0x62,0x78,0xD1,0x76,
	0x0A,0x43,0xC8,0x72,0x34,0x35,0x17,0xAB,
	0x0E,0x6C,0xC9,0x3E,0xA9,0xB9,0xE6,0xDD,
	0x84,0xA1,0x45,0xB1,0xB0,0x93,0xE8,0xE5,
	0xC2,0x4E,0xB4,0xA7,0x1D,0xF4,0x4F,0xAF,
	0x86,0xD8,0x74,0xAE,0x8B,0x2F,0xB5,0xCF,
	0x2E,0x7A,0x6B,0xBD,0x57,0xF9,0xD7,0xF7,
	0x09,0x64,0x07,0xC5,0x32,0x36,0xAA,0x5E,
	0xA2,0x9C,0x4D,0xD3,0xE1,0xE9,0x9E,0xEE,
	0x29,0xA6,0xCC,0x5B,0xA3,0xBA,0xEC,0xED,
	0x47,0x97,0xB3,0xBB,0xE3,0xFC,0x3F,0xEF,
	0x98,0x65,0x8D,0xDA,0x59,0xD5,0xDC,0xB7,
	0x9A,0x6E,0x9D,0xF3,0x79,0xDB,0x7B,0x7F,
	0x0F,0x3B,0xAD,0x7D,0xF2,0xFA,0x9F,0xFD,
	0xCE,0xEB,0xBE,0xFE,0xF5,0xDF,0xFB,0xFF,
},

	{
	0x00,0x01,0x20,0x30,0x10,0x81,0x90,0x64,
	0x08,0x48,0x60,0x83,0x12,0xA2,0x15,0x1B,
	0x80,0x03,0x82,0x07,0xA0,0xE0,0x2C,0x36,
	0x24,0x0E,0x0D,0xC5,0x8C,0x5A,0x27,0x3D,
	0x02,0x0A,0x84,0x85,0xC0,0xC1,0xA4,0x9C,
	0x50,0x8A,0x19,0x55,0x38,0xAC,0xC6,0x6B,
	0x21,0x16,0x32,0x4B,0x92,0xC3,0x17,0xF2,
	0x49,0x4E,0x2D,0xEC,0x95,0x67,0xE3,0xCF,
	0x40,0x06,0x28,0x62,0x44,0x46,0x26,0x56,
	0x11,0x52,0x45,0x66,0x58,0xCC,0x4D,0x37,
	0x18,0xD0,0x1A,0xF0,0x13,0x0F,0x3A,0x6D,
	0x31,0x6A,0x72,0x7C,0x59,0xE5,0xD6,0xBB,
	0x22,0xC2,0x61,0x71,0x25,0xC9,0x8D,0x97,
	0xA8,0xE2,0x1E,0xAB,0xE8,0xEA,0xF1,0xD7,
	0x89,0x8E,0xE4,0x9D,0x63,0x6E,0xE6,0xF5,
	0xB2,0x3B,0x79,0x77,0xB6,0xBE,0xF9,0xF7,
	0x04,0x41,0x14,0x54,0x09,0x23,0x4A,0x2B,
	0x42,0xB0,0x51,0xA5,0x98,0x5C,0x1D,0xCE,
	0x0C,0x2A,0x0B,0xA6,0x43,0x65,0xB4,0x5E,
	0xC8,0xE1,0x53,0xF4,0x33,0x2F,0xDA,0xB7,
	0x88,0x1C,0x34,0x35,0x94,0xD4,0x8B,0xF8,
	0xA1,0xD8,0xAA,0x75,0xB8,0xA7,0x3E,0xEE,
	0x86,0x96,0x78,0xBC,0x3C,0xD5,0x73,0x6F,
	0xD1,0xCD,0xCB,0xED,0x8F,0xE7,0xF6,0xEF,
	0x05,0x91,0x68,0x39,0x29,0xA9,0x74,0x7A,
	0xC4,0x47,0xA3,0xC7,0x6C,0x9B,0xAD,0x3F,
	0x70,0x2E,0xB1,0x76,0x69,0xB9,0xE9,0x7B,
	0x99,0x4F,0xBA,0xDE,0xDC,0xAF,0x7D,0xFE,
	0x4C,0xCA,0x93,0xD9,0x87,0x57,0xB5,0x7E,
	0x9A,0xAE,0xB3,0xEB,0xD3,0xDB,0x9F,0x7F,
	0xD2,0x5D,0x5B,0x5F,0x1F,0xFC,0xF3,0xFB,
	0x9E,0xDD,0xFA,0xFD,0xBD,0xBF,0xDF,0xFF,
},

	{
	0x00,0x40,0x10,0x0C,0x01,0x90,0x50,0x13,
	0x04,0x06,0x18,0x85,0x05,0x70,0x0E,0xA9,
	0x08,0x44,0x41,0x07,0x14,0x51,0xA4,0x9C,
	0x0A,0x98,0x25,0x4D,0x0D,0x33,0x6A,0xF4,
	0x80,0x48,0x11,0x54,0x28,0x0B,0xE0,0x17,
	0x81,0x64,0xB0,0x66,0xC1,0x56,0x39,0x79,
	0x09,0xA2,0xC2,0xD8,0x61,0xCA,0x36,0xAB,
	0x43,0x63,0x4E,0x3D,0xB1,0xD5,0xB6,0xBE,
	0x20,0x60,0x82,0x83,0x30,0x91,0x15,0x59,
	0x21,0x2A,0x19,0x69,0xA1,0xA5,0x5A,0x3B,
	0x12,0x92,0x45,0xAC,0x52,0xB2,0x47,0x73,
	0x46,0x8D,0x74,0xC7,0x53,0xBA,0x8F,0xFA,
	0x22,0x32,0x26,0x2D,0xC4,0x95,0x72,0x9B,
	0x16,0x65,0xF0,0x9E,0x3A,0x5B,0xF2,0xD7,
	0x49,0x0F,0x8B,0x67,0x9A,0x6E,0x9D,0xBD,
	0x1E,0xDA,0x6D,0xE7,0xEA,0xDE,0xB7,0x7F,
	0x02,0x03,0x42,0x38,0x88,0x1A,0x68,0xD2,
	0xC0,0xC8,0x89,0x8E,0xD0,0x55,0xCC,0xAE,
	0x84,0xA8,0x86,0xE8,0x29,0xE4,0xC5,0xE5,
	0x8A,0x3C,0x4B,0x6B,0xB8,0xDC,0x76,0x5F,
	0xA0,0x4A,0x94,0x27,0x31,0x87,0xAA,0x57,
	0x34,0x2B,0xC3,0x2F,0x93,0x4F,0x1F,0xF9,
	0x4C,0xA3,0x5C,0xB3,0x6C,0xCB,0xE3,0x9F,
	0xA6,0x97,0x7C,0x6F,0x5E,0xED,0xDB,0xF7,
	0x24,0x62,0x2C,0x1B,0x8C,0x96,0x78,0xD9,
	0x23,0xD4,0xC9,0x7A,0xE2,0xAD,0xE6,0x7B,
	0x58,0x35,0x2E,0xD3,0xC6,0xCD,0xA7,0xBB,
	0xB4,0x75,0xD6,0x7E,0x3E,0xF6,0xDD,0xBF,
	0x1C,0x99,0x71,0xB9,0xE1,0xB5,0xCE,0xAF,
	0xD1,0xF1,0x37,0xF3,0xEC,0xEB,0x77,0xFE,
	0x1D,0xBC,0x5D,0xCF,0xE9,0xF5,0x3F,0xDF,
	0xF8,0xFC,0xEE,0xFB,0x7D,0xFD,0xEF,0xFF,
},

	{
	0x00,0x10,0x02,0x24,0x80,0x30,0x14,0x32,
	0x01,0x48,0x81,0xE0,0x0C,0x98,0x13,0x55,
	0x08,0xC0,0x50,0x19,0x0A,0xC8,0xA1,0x36,
	0x42,0x46,0x8C,0xB1,0x31,0x1E,0xE2,0xE9,
	0x20,0x05,0x18,0x61,0x82,0x51,0xC2,0x66,
	0x28,0x94,0xC1,0x0F,0x89,0x8D,0x35,0xE3,
	0x12,0x70,0x83,0x8B,0x34,0x8E,0xD4,0xEA,
	0x23,0x53,0x5C,0x67,0x95,0x3D,0xD5,0xDE,
	0x04,0xA0,0x22,0x45,0x06,0x07,0x43,0x9C,
	0x03,0x0E,0xB0,0x2D,0x29,0x3A,0xE1,0x9B,
	0x84,0xA4,0x8A,0x3C,0x4C,0x74,0x56,0xBA,
	0x2A,0x99,0xA6,0xB9,0x9A,0xCD,0x57,0xF5,
	0x44,0x1C,0x25,0x71,0x62,0x65,0xD2,0x97,
	0x85,0xCC,0xA5,0xDA,0x2E,0xB3,0x6B,0xE7,
	0x0B,0x4E,0x78,0xDC,0x47,0xA7,0xCE,0x7E,
	0x1D,0xE5,0xBC,0x77,0xF1,0xFA,0xBE,0xFB,
	0x40,0x21,0x09,0x4A,0x60,0x58,0x16,0x27,
	0x41,0x92,0x52,0xC9,0xC4,0x63,0x5A,0x7A,
	0x90,0x64,0xD0,0x6A,0x49,0x2B,0x59,0x3E,
	0x15,0xB8,0xC6,0x5B,0x93,0xD6,0xAB,0xDB,
	0x88,0x68,0x54,0x6C,0x1A,0xAA,0xB2,0xEC,
	0x86,0xE4,0x4D,0x3B,0xC3,0x76,0xB5,0xAF,
	0xA2,0xA9,0x17,0xF4,0xA3,0xAD,0xD9,0xF6,
	0xF0,0x9E,0xF8,0x7B,0x5D,0xBB,0xD7,0x7F,
	0x11,0xA8,0x0D,0xD8,0x26,0xC5,0x39,0x4F,
	0x2C,0x33,0x72,0x8F,0xB4,0x37,0x2F,0xF3,
	0x91,0xAC,0x4B,0x5E,0xCA,0x7C,0x79,0xCF,
	0x1B,0xD3,0xF2,0xEB,0x1F,0xB7,0xDD,0xDF,
	0x38,0xD1,0x96,0x6E,0x87,0xC7,0xB6,0xEE,
	0x69,0x73,0xCB,0xBD,0xAE,0xF9,0x7D,0xFD,
	0xE8,0x75,0xE6,0x6F,0x9D,0x9F,0xFC,0xF7,
	0x6D,0x5F,0x3F,0xEF,0xED,0xBF,0xFE,0xFF,
},

	{
	0x00,0x10,0x40,0x03,0x08,0x28,0x18,0x89,
	0x20,0x11,0x22,0x2A,0x14,0x0B,0x8C,0x2E,
	0x04,0x42,0x44,0x29,0x06,0x43,0x0D,0xE2,
	0x0A,0xA8,0x52,0xD4,0x70,0xE4,0x56,0x6D,
	0x01,0x88,0x60,0xA4,0x84,0x8A,0x07,0xC6,
	0x48,0x98,0xB0,0x35,0x83,0xCC,0xB4,0xD3,
	0x30,0xD0,0x34,0xE8,0x2C,0xB8,0x59,0xDC,
	0x51,0x66,0xD1,0xF1,0x9C,0xF4,0x7C,0xF5,
	0x02,0x05,0xC0,0x0E,0x12,0xC1,0x94,0x33,
	0x21,0xE0,0xC2,0xA3,0x25,0xC3,0xAC,0x3D,
	0x09,0x85,0x45,0x8B,0xA2,0x72,0x8E,0xAE,
	0xC4,0x1D,0xA9,0xBC,0x74,0x97,0xDA,0x9F,
	0x81,0x68,0x32,0xF0,0x64,0x6A,0xA6,0xE6,
	0x38,0x0F,0xA5,0x73,0x5A,0xC7,0x5D,0xCF,
	0x16,0x8D,0x39,0xCE,0x9A,0x7A,0xB3,0x5F,
	0xE1,0x4F,0xA7,0xEB,0xEC,0xFC,0xBB,0xEF,
	0x80,0x90,0x82,0x1A,0x0C,0x62,0x26,0x47,
	0xA0,0x91,0x58,0xD2,0x54,0x53,0x4E,0x9B,
	0x50,0x92,0x23,0xC5,0x31,0x1E,0x55,0x79,
	0x15,0x71,0x78,0x6E,0x93,0x3B,0xD5,0x7E,
	0x24,0x4C,0xA1,0xC9,0x4A,0x1B,0xD8,0x37,
	0x1C,0x95,0xCA,0xBA,0x96,0x57,0xAD,0x7B,
	0x19,0x4B,0x63,0xE5,0x17,0xEA,0x9E,0xDB,
	0x3A,0xB5,0xB6,0x7D,0xD6,0xBE,0xF6,0xFD,
	0x41,0x13,0x86,0x65,0x61,0x5C,0x2B,0xF2,
	0xC8,0xB2,0x69,0x76,0x2D,0xB9,0x1F,0xED,
	0x49,0x36,0xAA,0x9D,0x6C,0xD9,0x6B,0xD7,
	0x4D,0xF8,0x2F,0x3F,0x8F,0xDD,0xBD,0xDF,
	0x46,0xB1,0x99,0x75,0x87,0x67,0xCB,0xF3,
	0x3C,0xE3,0x3E,0x6F,0x5E,0x77,0xF9,0xF7,
	0x27,0xCD,0xE9,0xE7,0xAB,0xB7,0xAF,0xFB,
	0x5B,0xEE,0xFA,0xBF,0xDE,0xFE,0x7F,0xFF,
},

	{
	0x00,0x10,0x02,0x82,0x01,0xA0,0x60,0x29,
	0x08,0x18,0x84,0x68,0x0A,0x8A,0x4A,0xD2,
	0x80,0x90,0x30,0x51,0x14,0xE0,0x32,0x0F,
	0x22,0xC4,0x26,0xAA,0x52,0x47,0x71,0x5D,
	0x04,0x09,0x44,0xC1,0x48,0x54,0x13,0x93,
	0xC0,0x70,0xA8,0xC6,0x0B,0xB1,0xC5,0xAE,
	0x88,0xA1,0x1C,0x3C,0x62,0x5A,0xCA,0xF1,
	0x07,0xAC,0x2E,0xAD,0xC9,0xCB,0xD6,0xFA,
	0x40,0x11,0x0C,0x4C,0x05,0x1A,0x45,0xD8,
	0x50,0x25,0x15,0x8B,0x92,0xD1,0x65,0xF4,
	0x21,0xC8,0x58,0xCC,0x64,0x36,0xE8,0xC7,
	0x31,0x6C,0x1B,0xCE,0x1D,0xE9,0xB6,0xEE,
	0x03,0x98,0x94,0x55,0xA2,0xE2,0x8D,0x4F,
	0x2C,0xA3,0x17,0xE6,0x95,0x6B,0x9E,0xBB,
	0x0D,0x4D,0x78,0xB9,0x69,0xBC,0x37,0xAF,
	0x5C,0x57,0xAB,0x9F,0xEA,0xB7,0x7D,0xDF,
	0x20,0x81,0x12,0x61,0x41,0x19,0x43,0x66,
	0x42,0x46,0x86,0x9A,0x2A,0x39,0x2D,0xD3,
	0x06,0x85,0x16,0x96,0x89,0x27,0xA9,0x76,
	0xD0,0x9C,0x56,0xF8,0x8E,0xBA,0xB3,0xFC,
	0x24,0x23,0xA4,0x4E,0x34,0xA5,0xA6,0x6D,
	0xB0,0xC3,0xD4,0x9B,0x53,0xE3,0xF2,0xDB,
	0x38,0x99,0x35,0x7A,0x87,0x97,0x6E,0x3F,
	0x59,0xB5,0x67,0x77,0xDC,0xE7,0xDD,0xFE,
	0x28,0x49,0x91,0x2B,0x0E,0xF0,0x63,0xA7,
	0x83,0x33,0xE1,0xDA,0x1E,0x9D,0x2F,0x7E,
	0x8C,0xB8,0x4B,0x1F,0x74,0xD5,0x73,0x6F,
	0xE4,0x75,0x7C,0xBD,0x5E,0xF6,0x7B,0xFD,
	0xC2,0x3A,0xB2,0x5B,0xB4,0xE5,0x3B,0xEB,
	0x6A,0x8F,0xD9,0xBE,0x3D,0xED,0xF9,0xEF,
	0x72,0xEC,0x79,0x5F,0x3E,0xDE,0xD7,0xF7,
	0xCD,0xF3,0xCF,0xFB,0xF5,0xBF,0x7F,0xFF,
},

	{
	0x00,0x40,0x80,0x88,0x10,0x50,0x06,0xC4,
	0x08,0x60,0x12,0x89,0x28,0x23,0x58,0x17,
	0x04,0x0A,0x21,0x32,0x30,0x1C,0x13,0x1D,
	0x48,0x94,0x52,0x56,0x91,0xAA,0x95,0x73,
	0x02,0x84,0x14,0xA4,0x22,0x64,0x16,0x2D,
	0x0C,0x2C,0x85,0xF0,0x49,0x4B,0x63,0xBC,
	0x03,0xC8,0x54,0x9A,0x86,0xD8,0x1B,0x79,
	0xC2,0x3A,0x6A,0x5E,0xA3,0xF4,0xAB,0xE7,
	0x20,0x24,0x41,0x34,0x09,0xA8,0x98,0xB1,
	0x44,0x25,0x45,0x3C,0x1A,0x8E,0xD1,0xF2,
	0x81,0x92,0x8A,0x78,0x83,0xC5,0x87,0x3E,
	0x15,0xB4,0xCA,0x9E,0xA6,0xE3,0xD6,0xB7,
	0x18,0x61,0x29,0xCC,0xA1,0x59,0xD4,0xE5,
	0x0D,0xA9,0x65,0x3B,0xA5,0x57,0x7C,0xFC,
	0x4A,0x66,0xE2,0xAE,0x71,0x9B,0xE6,0x7E,
	0xB8,0x2F,0xCE,0xDD,0x9D,0xF9,0xEB,0xDF,
	0x01,0x82,0x11,0x68,0x42,0xB0,0x31,0x47,
	0x05,0x8C,0x0B,0xC6,0x62,0x72,0x6C,0x8F,
	0xA0,0xC1,0x26,0x2B,0xD0,0x8D,0xD2,0x4F,
	0x70,0xE8,0x33,0xEA,0x8B,0xB9,0x37,0xBE,
	0xC0,0x38,0x43,0x55,0x0E,0x74,0x9C,0xB6,
	0xA2,0x93,0x2E,0xE9,0x5A,0x5D,0x3D,0xBD,
	0x4C,0xC3,0x4E,0xCD,0x96,0xF8,0x97,0xED,
	0x35,0xD3,0xDA,0xAF,0x7A,0x77,0xCF,0xFE,
	0x90,0x19,0x07,0xE4,0x2A,0x27,0x69,0x5B,
	0xE0,0x1E,0x99,0xB3,0xE1,0xDC,0xBA,0xF3,
	0x51,0xB2,0x0F,0xB5,0x36,0xC7,0x67,0xEE,
	0xAC,0x76,0x6B,0xD7,0xEC,0x7D,0x7B,0xF7,
	0x46,0x53,0x5C,0xCB,0x4D,0xD9,0x6D,0x5F,
	0x39,0x75,0xD5,0xFA,0xF1,0x6F,0xF5,0xFB,
	0xC9,0xA7,0xAD,0x9F,0x1F,0xBB,0xF6,0x7F,
	0x6E,0xDE,0x3F,0xEF,0xDB,0xBF,0xFD,0xFF,
},

	{
	0x00,0x01,0x04,0x24,0x08,0xA0,0x0A,0xA1,
	0x02,0x03,0x11,0x1A,0x90,0x52,0xA8,0x65,
	0x20,0x50,0x05,0x8C,0x09,0x23,0x15,0x39,
	0x28,0x1C,0xA4,0x74,0xB0,0x8D,0x69,0xF4,
	0x40,0x41,0x06,0x2A,0xC0,0x19,0x98,0xE4,
	0x12,0x85,0x13,0xA9,0x54,0xC6,0x8B,0xC7,
	0x44,0x32,0x07,0x53,0x2C,0x6C,0xB4,0x57,
	0x61,0xE2,0xD1,0x75,0x56,0xE3,0x6B,0xBB,
	0x10,0x60,0x82,0xC4,0x22,0xC1,0x51,0xA3,
	0x18,0x46,0xC2,0x1E,0x86,0x96,0xE8,0x76,
	0x21,0x64,0xA2,0x36,0x16,0x47,0xA5,0xAD,
	0x4A,0x35,0x1B,0x5E,0x4B,0xDA,0xD3,0xCF,
	0x14,0x83,0xD0,0xD8,0x31,0x33,0x27,0xB6,
	0x25,0x5C,0x9C,0xEA,0x66,0x9D,0xCE,0x7D,
	0x62,0xB2,0x55,0x9B,0xC5,0xD6,0x97,0x5F,
	0x2B,0xDC,0x6D,0xEB,0xBC,0xF5,0xBD,0xEF,
	0x80,0x81,0x42,0x89,0x30,0x8A,0x70,0xCA,
	0x48,0x68,0x43,0xD4,0x94,0x4E,0x99,0x67,
	0x88,0x4C,0x0B,0x5A,0x49,0x2E,0xD2,0x2F,
	0x0E,0x2D,0x63,0xA7,0x4D,0xD5,0xD9,0xDD,
	0x84,0x91,0x92,0x3A,0x29,0xCC,0x9A,0xB9,
	0x38,0xC9,0xB8,0x3E,0x1D,0xF2,0xEC,0xED,
	0x26,0x93,0x71,0x3D,0x87,0x8F,0xF8,0x3F,
	0xE1,0x7C,0xB3,0xD7,0x3B,0xF3,0xEE,0x7F,
	0x0C,0xC8,0x58,0x78,0x0D,0xAA,0xB1,0x5B,
	0xE0,0xAC,0x6A,0x4F,0x3C,0xAB,0xE9,0xB7,
	0x34,0x8E,0xA6,0x73,0xF0,0x7A,0xBA,0x7E,
	0xC3,0x6E,0xAE,0xDB,0x5D,0xE7,0x6F,0xFE,
	0x45,0x59,0x95,0x1F,0x0F,0xCB,0xF1,0xDE,
	0x17,0xE6,0xCD,0xAF,0x9E,0xFA,0xF9,0xDF,
	0x72,0xB5,0xE5,0x9F,0x79,0xF6,0xBE,0xFB,
	0x37,0x7B,0xFC,0xF7,0x77,0xBF,0xFD,0xFF,
},

	{
	0x00,0x10,0x80,0x88,0x40,0x21,0x30,0x19,
	0x04,0x44,0x48,0xA1,0x0C,0xB0,0x16,0x36,
	0x08,0x84,0x03,0x13,0x09,0xC2,0x46,0x27,
	0x60,0x54,0x31,0xC9,0x98,0x9C,0xAA,0xDC,
	0x20,0x12,0x41,0x61,0x14,0xE0,0x4A,0xB2,
	0x06,0x89,0xC4,0xD2,0x1C,0xD1,0x35,0x2F,
	0xC0,0x26,0x70,0x71,0x0B,0x4E,0x2E,0xEA,
	0x2C,0x65,0xF0,0xCB,0x74,0x9B,0x3B,0xF6,
	0x01,0x18,0x24,0x8A,0x81,0x38,0x2A,0x47,
	0x82,0x8C,0x58,0x1D,0x83,0xD8,0x69,0x3E,
	0x90,0x45,0x43,0x78,0x29,0x96,0x3C,0xAB,
	0xD0,0x8D,0x1E,0xC7,0x56,0x57,0x6E,0xBB,
	0x28,0x0E,0x0D,0xC3,0x86,0x17,0xB1,0xB9,
	0x68,0x9A,0x66,0x6B,0x39,0xBA,0xD3,0x6F,
	0x94,0xAC,0x95,0xEC,0x8B,0xD6,0xE9,0xDE,
	0xA9,0xE6,0xCE,0xB7,0x5D,0x9F,0xD7,0xFB,
	0x02,0x11,0x22,0x64,0x05,0x92,0x51,0x5A,
	0x0A,0x23,0x52,0x6C,0xA8,0xE2,0x59,0xCD,
	0xA0,0xC1,0x91,0xD4,0x49,0xB8,0xC6,0x5B,
	0xA2,0xCC,0x93,0x8F,0x6A,0x67,0xF4,0xF5,
	0x42,0x85,0x1A,0x4D,0xC8,0xE1,0xA5,0xF8,
	0x62,0x72,0x99,0x4F,0x55,0xF1,0x7C,0x77,
	0xA4,0x63,0x2B,0x79,0xB4,0xBC,0x3D,0xEE,
	0x53,0x9E,0xE5,0xBD,0x7A,0xE7,0x7E,0xEF,
	0x50,0x4C,0x15,0x1B,0x32,0x3A,0xE4,0xA7,
	0x34,0xA3,0xCA,0xAE,0x2D,0x76,0xD5,0x7D,
	0x07,0x4B,0xC5,0xF2,0x8E,0x97,0xB5,0xFA,
	0xE8,0xD9,0x5E,0xF3,0x75,0xEB,0xF9,0xFE,
	0x25,0x5C,0x33,0x9D,0x0F,0xAD,0x6D,0x5F,
	0x87,0x73,0xB6,0xFC,0xE3,0xDB,0xDD,0xDF,
	0xA6,0xDA,0xB3,0xED,0x37,0xBE,0xCF,0xF7,
	0x1F,0xAF,0x3F,0xBF,0x7B,0x7F,0xFD,0xFF,
},

	{
	0x00,0x01,0x04,0x82,0x08,0x05,0x81,0x4C,
	0x80,0x28,0xC0,0x0D,0x42,0xC1,0x8A,0x63,
	0x02,0x84,0x06,0x1C,0x30,0x54,0x43,0x78,
	0x24,0x62,0xA4,0x35,0x58,0x4B,0x93,0xF4,
	0x40,0x41,0xA0,0x2A,0x18,0x34,0x13,0xE1,
	0x21,0x0B,0x49,0x9A,0x38,0x96,0x74,0x1F,
	0x14,0x4A,0xA2,0x36,0x26,0x33,0x87,0x3D,
	0xA1,0x3C,0xB1,0x79,0x4E,0xF1,0x3B,0xBD,
	0x20,0x0A,0x50,0x86,0x0C,0xE0,0x8C,0xF0,
	0x48,0x0E,0x32,0xE2,0x07,0x55,0xE8,0x6B,
	0x22,0x1A,0x51,0x2E,0x15,0x39,0xC3,0xDC,
	0x29,0xE4,0x3A,0x5B,0xAC,0xA7,0x6E,0x7E,
	0x60,0x85,0x31,0x1E,0x83,0x53,0x17,0x37,
	0xC4,0xB2,0x0F,0xB6,0x59,0x5D,0xD9,0x7B,
	0x89,0x71,0x65,0xEA,0x4D,0x67,0xC7,0xD7,
	0xB8,0xD5,0xF2,0x77,0x76,0xFA,0xCF,0x7F,
	0x10,0x90,0x03,0x94,0x88,0x98,0x61,0x27,
	0x09,0x68,0xB0,0x6C,0x92,0x66,0xB4,0xE9,
	0x11,0xD0,0x16,0x2D,0x19,0xD8,0xD4,0xD3,
	0xC8,0x99,0xA9,0x8F,0x9C,0xE5,0xAD,0xBB,
	0x12,0x52,0x25,0x1B,0x2C,0x6A,0xCC,0x9B,
	0x91,0x8B,0xC6,0x3E,0xD2,0x6D,0xCD,0x5F,
	0x23,0xD1,0x1D,0x7A,0x5A,0xD6,0xAB,0xAF,
	0xA6,0xEC,0x9E,0xEB,0x75,0xDD,0x7D,0xFB,
	0x44,0x64,0x46,0xAA,0x70,0x95,0xC9,0xDA,
	0xA8,0x72,0x69,0xB9,0xA3,0x73,0x2F,0xF5,
	0x45,0x47,0xA5,0xCB,0xCA,0xBA,0xCE,0xDE,
	0x2B,0x9D,0xAE,0xDB,0x4F,0xF6,0xFC,0xFE,
	0xC2,0x8E,0xC5,0xE6,0x5C,0x5E,0x97,0xBE,
	0x56,0xF8,0xBC,0xE7,0x57,0xEE,0x3F,0xF7,
	0x8D,0xB3,0x7C,0xF9,0xB5,0x9F,0x6F,0xEF,
	0xE3,0xF3,0xED,0xFD,0xB7,0xBF,0xDF,0xFF,
},

	{
	0x00,0x40,0x01,0x88,0x04,0x41,0x48,0x58,
	0x80,0x0C,0x84,0x94,0x81,0x89,0x0B,0x5A,
	0x10,0xC0,0x50,0x8C,0x22,0xC4,0xC2,0x72,
	0x05,0x4A,0x4C,0xE4,0x70,0x55,0xE2,0x5B,
	0x02,0x14,0x82,0x16,0x18,0x29,0x49,0x71,
	0x12,0x25,0x64,0xC6,0x1C,0x69,0x53,0x9B,
	0x11,0x07,0x0D,0xCA,0xA4,0xB4,0x6C,0xB6,
	0x38,0xE1,0x6A,0xF1,0x3A,0xE9,0xEA,0x77,
	0x20,0x30,0x44,0x83,0x42,0x32,0xB0,0x95,
	0x06,0x54,0x2C,0xC9,0xA2,0xB2,0x59,0xD5,
	0x28,0x85,0xA1,0xC3,0x15,0x9A,0x36,0xD6,
	0xD0,0xA3,0x78,0x6D,0x4E,0x9E,0xBC,0xAF,
	0x21,0x13,0x92,0x33,0xE0,0xAC,0x8D,0xEC,
	0x61,0x4D,0x5C,0x37,0xCC,0xB9,0x5D,0xEB,
	0x68,0x0F,0x4B,0xE3,0x99,0xAB,0x6B,0xF3,
	0xA9,0x57,0xB3,0xFA,0xE5,0xF5,0xDE,0xFB,
	0x08,0x03,0x24,0x62,0xA0,0x0E,0xC8,0x63,
	0x09,0x46,0xC1,0xD1,0x31,0x17,0xB1,0xCE,
	0x60,0xA8,0x51,0x2E,0x98,0x27,0x1B,0xB5,
	0x1A,0xD8,0xE8,0xF4,0xF0,0xDA,0x3D,0x7D,
	0x90,0x2A,0x52,0x8E,0x45,0x2B,0xA6,0x79,
	0x23,0x9C,0xD2,0x8F,0x87,0x76,0xD3,0xBD,
	0x34,0xC5,0x56,0xF8,0xD4,0x7C,0xF2,0xDB,
	0xA5,0x4F,0xAE,0x6F,0x75,0xFC,0xBB,0xEF,
	0x0A,0x19,0x86,0xB8,0x26,0x35,0x66,0x67,
	0x43,0x1E,0x74,0xAD,0x2D,0xA7,0x6E,0xE7,
	0x8A,0x93,0x1D,0xBA,0x8B,0xE6,0x1F,0x3F,
	0x3C,0x9D,0x73,0x5F,0xC7,0xDD,0xD7,0xFE,
	0x91,0x39,0xAA,0x3B,0x47,0x97,0xDC,0xEE,
	0x65,0x7A,0xCB,0xF6,0x3E,0xCF,0xB7,0xFD,
	0x96,0x2F,0xD9,0xF9,0x5E,0xBE,0x9F,0x7F,
	0xCD,0xED,0x7E,0xBF,0x7B,0xF7,0xDF,0xFF,
},

	{
	0x00,0x10,0x20,0x14,0x04,0x82,0x44,0x91,
	0x01,0xA0,0x11,0x23,0x22,0x51,0xD0,0xCA,
	0x40,0xC0,0x84,0x38,0x06,0x98,0x19,0x8D,
	0x21,0xA2,0x62,0x17,0xA4,0x78,0x96,0x37,
	0x08,0x09,0x0C,0x8A,0x12,0x07,0x86,0xC3,
	0x05,0xA1,0x15,0x95,0x0B,0x4D,0x3C,0xB6,
	0x60,0x2A,0x0D,0xD4,0x4A,0x65,0xCC,0x76,
	0x1A,0xD2,0x47,0x5D,0xD8,0x5B,0x6E,0x7B,
	0x02,0x28,0x88,0x54,0x24,0x16,0x85,0xC9,
	0x03,0xC8,0x45,0xF0,0x58,0x2E,0xA5,0x67,
	0x0A,0x68,0x4C,0x9A,0x34,0x1B,0x87,0xD6,
	0x43,0xC5,0xC6,0xDC,0xB4,0x79,0xEA,0xF9,
	0x50,0x26,0x94,0xB8,0x32,0x6A,0x39,0x6B,
	0xC4,0x66,0xE4,0xA7,0x72,0x5E,0x8F,0x77,
	0x0E,0xE8,0x74,0xE5,0x99,0x6D,0x73,0xF3,
	0x1D,0x3D,0xCB,0x6F,0xF1,0x3F,0xDD,0xDF,
	0x80,0x90,0x30,0x64,0x18,0x92,0x49,0xB2,
	0x48,0x1C,0xA8,0x93,0xB0,0x2D,0x5A,0xBC,
	0x41,0xC2,0xE0,0xB1,0xC1,0x35,0x71,0xEC,
	0x83,0x1E,0xD1,0xB5,0x33,0x4F,0x75,0xF6,
	0x42,0x46,0x8C,0xAC,0x70,0xAA,0x3A,0x3B,
	0x29,0x8B,0x8E,0x9E,0x56,0xE3,0xE9,0xDE,
	0x2C,0x69,0x4E,0xE6,0xA3,0x97,0xAD,0xBD,
	0xA6,0xD5,0xB9,0xBE,0xF8,0x9F,0xFA,0xFB,
	0x81,0x25,0x31,0xA9,0x52,0xE1,0x55,0xB3,
	0x89,0x53,0x5C,0x7A,0x4B,0xCE,0x9B,0xB7,
	0x61,0x6C,0x27,0xAE,0x59,0xDA,0x7C,0xD7,
	0x9C,0x3E,0xD3,0xBB,0xF2,0xE7,0xF5,0xFE,
	0x13,0x36,0x0F,0xD9,0x63,0xBA,0x2F,0xEE,
	0x2B,0xCD,0x1F,0xED,0x57,0xFC,0x7D,0xEF,
	0xE2,0x9D,0xF4,0xCF,0xC7,0xDB,0xAF,0xFD,
	0xAB,0x5F,0x7E,0xBF,0xEB,0xF7,0x7F,0xFF,
},

	{
	0x00,0x08,0x02,0x88,0x01,0x44,0x0C,0x49,
	0x40,0xA0,0x30,0x0B,0x50,0xC4,0x2C,0x63,
	0x20,0x82,0xC0,0x38,0x84,0x1A,0x64,0x4E,
	0x90,0x51,0x98,0xB2,0x58,0x87,0x53,0xCD,
	0x04,0x05,0x12,0x94,0x42,0x4A,0x83,0xC9,
	0x21,0x25,0xB0,0xCC,0x8A,0xB4,0x27,0xBA,
	0x18,0x89,0x23,0x95,0x32,0x8D,0xC6,0xAE,
	0x0E,0xD2,0x5A,0x6B,0x74,0xAB,0xF8,0xF3,
	0x10,0x11,0x48,0x54,0x14,0xA1,0x26,0x17,
	0x24,0x68,0x85,0x69,0x61,0xCA,0x4B,0xA7,
	0x60,0x4C,0xC8,0x47,0xA2,0x33,0x65,0x2F,
	0x43,0x4D,0x9C,0x75,0x9A,0xB6,0xEC,0xE7,
	0x28,0xE0,0xC2,0xD4,0xA4,0x2D,0x8E,0xD5,
	0x19,0x2B,0xC3,0x5D,0xA5,0xEA,0xDA,0x6F,
	0x46,0xC5,0xE8,0x3B,0x78,0x9B,0x4F,0xD7,
	0x55,0xCE,0x8F,0xEB,0xE3,0x77,0x3F,0x7F,
	0x80,0x41,0x81,0x86,0x09,0x45,0x29,0x2E,
	0x06,0x07,0xC1,0x93,0x0D,0x3A,0xB8,0xE6,
	0x0A,0x2A,0x62,0xD8,0x16,0xA3,0xE1,0xF4,
	0x15,0x96,0x5C,0x7A,0x6C,0xC7,0x6E,0xF5,
	0x22,0x1C,0x13,0xA6,0xA8,0x66,0x6A,0x5E,
	0x34,0xF0,0x71,0xCB,0xAA,0x79,0xBC,0xCF,
	0x92,0x1E,0xD1,0xF2,0x3C,0xB3,0xB9,0xFC,
	0x8B,0x5B,0x3D,0xBD,0x7C,0xF9,0xDE,0xFB,
	0x03,0x70,0x8C,0x35,0x91,0x99,0x0F,0x67,
	0x52,0xA9,0x72,0xAD,0x59,0x76,0x57,0xF6,
	0x31,0x1D,0xE2,0x9D,0x39,0xD3,0xE9,0xB7,
	0xB1,0x97,0xDC,0x7B,0xB5,0xBE,0x5F,0xDF,
	0xD0,0x36,0xAC,0x9E,0xE4,0x1F,0x37,0xDB,
	0x1B,0x6D,0xD9,0xFA,0xE5,0x7E,0xEE,0xEF,
	0x56,0x73,0x3E,0xBB,0xF1,0xAF,0xDD,0xFD,
	0xD6,0x9F,0xED,0xBF,0x7D,0xFE,0xF7,0xFF,
},

	{
	0x00,0x10,0x80,0xA0,0x08,0x30,0x0C,0x46,
	0x02,0x50,0x21,0x61,0x22,0x15,0x54,0x66,
	0x01,0x12,0x18,0xA8,0x28,0x0B,0x83,0x99,
	0x03,0xB0,0x91,0xC9,0xE0,0xF0,0xE2,0x7A,
	0x40,0x42,0x05,0xA1,0x11,0x8C,0xC8,0x69,
	0x24,0x70,0xA4,0x9A,0x98,0x72,0xB8,0xF8,
	0x09,0x4C,0x68,0x93,0x38,0x4D,0xA6,0xC7,
	0x19,0x87,0xB4,0xF2,0x9C,0x5D,0x5B,0xED,
	0x20,0x88,0x44,0xD0,0x0A,0x31,0x62,0x1D,
	0x06,0x86,0x0D,0xC3,0x2C,0x5A,0xE1,0xBA,
	0xC0,0x89,0x2A,0x96,0x32,0xD1,0x2D,0x9D,
	0xC2,0xC5,0x6A,0xE3,0x56,0x3B,0xEA,0xDD,
	0x48,0x49,0x43,0xA5,0x51,0x35,0x4E,0xAB,
	0x29,0xB2,0xE4,0xCD,0x8D,0x6D,0x73,0xF3,
	0x8A,0x63,0xAA,0xB9,0xE8,0x7C,0x4F,0xBE,
	0xCC,0x67,0xA7,0x7E,0xE6,0xAF,0xDE,0xFE,
	0x04,0x82,0x14,0x34,0x84,0x13,0x52,0x1B,
	0x41,0x25,0x07,0xA3,0x1A,0x5C,0xAC,0x76,
	0x60,0x85,0x92,0xA9,0x58,0xB1,0xCA,0xF4,
	0xC4,0x36,0x2E,0xDC,0xC6,0xB3,0xAD,0x9F,
	0x90,0x0E,0x26,0x2B,0xA2,0x71,0x1E,0x3D,
	0x4A,0x8B,0xD2,0x9E,0x95,0x97,0xCB,0xF6,
	0x16,0x65,0x59,0xB5,0xD4,0x37,0xB6,0x77,
	0x27,0xF1,0xCE,0xF9,0x3E,0x7D,0xF5,0x7F,
	0x81,0x64,0x94,0x6C,0x23,0x55,0x74,0x6B,
	0xC1,0x17,0x53,0x9B,0x3C,0x57,0x2F,0xBB,
	0x45,0x47,0x33,0xAE,0x3A,0x75,0xD5,0x6F,
	0x78,0x5E,0xEC,0xEE,0x79,0xFC,0xB7,0xDF,
	0x1C,0x4B,0x0F,0xE9,0xD8,0x6E,0xD6,0xCF,
	0x39,0x1F,0xDA,0xBD,0xE5,0xE7,0xEB,0xF7,
	0x8E,0xD9,0x8F,0x5F,0xBC,0xDB,0xFA,0xFD,
	0xD3,0x7B,0x3F,0xFB,0xD7,0xEF,0xBF,0xFF,
},

	{
	0x00,0x20,0x08,0x0A,0x80,0x22,0x50,0xC8,
	0x10,0x60,0x24,0xC4,0x11,0x54,0xA4,0x35,
	0x04,0x41,0x14,0x0B,0x21,0x89,0xD0,0x0F,
	0x44,0x2C,0x92,0xA5,0x1A,0xC6,0x93,0xB9,
	0x40,0x84,0x09,0x25,0x28,0x19,0x43,0x6A,
	0x05,0x4A,0x86,0xE2,0x83,0x4B,0x59,0x9D,
	0x06,0xA2,0x61,0x1D,0x68,0xA9,0x1E,0x6D,
	0x32,0x3C,0xCC,0x3B,0x96,0x37,0xE9,0xF6,
	0x02,0x18,0x48,0x51,0x88,0x46,0x45,0x27,
	0x81,0x8C,0x64,0x99,0xE0,0x33,0x95,0xE5,
	0xC0,0x85,0xC2,0x65,0x13,0xB8,0x17,0xCE,
	0x91,0xE1,0x4E,0x97,0x4D,0x79,0x75,0x7E,
	0x30,0x16,0x58,0x53,0x1C,0x56,0xE8,0xB6,
	0x8A,0xAA,0xB1,0x7A,0x8D,0xCB,0xF8,0xD7,
	0x2A,0xC5,0x8B,0x67,0x78,0xD3,0xEA,0xBB,
	0xB4,0x73,0x76,0xDE,0xF4,0xEE,0xF9,0xFE,
	0x01,0x12,0x90,0x34,0x0C,0x07,0x49,0x87,
	0x42,0x94,0xA8,0xB2,0x0D,0xC3,0x71,0xB3,
	0x82,0xB0,0x4C,0xD2,0x23,0x66,0x2E,0x5B,
	0x98,0xCA,0x36,0xE3,0x6C,0xC7,0x8F,0x77,
	0x03,0x38,0xA1,0xD8,0x31,0x9A,0x69,0xBA,
	0x52,0x5C,0x3A,0x6E,0x1B,0xF1,0x9E,0xED,
	0x15,0x9C,0xE4,0xD5,0x63,0x3E,0xE6,0x3F,
	0x8E,0xF2,0x3D,0xCF,0xAE,0xEB,0x9F,0x7F,
	0xA0,0xC1,0x62,0x47,0x26,0x74,0x5A,0x1F,
	0x70,0x2D,0xC9,0xDC,0xF0,0xA7,0xDA,0xE7,
	0x29,0xD1,0x2B,0xAB,0x39,0x2F,0xB5,0xAF,
	0x55,0x4F,0xD9,0xFC,0xBC,0xF3,0xF5,0xF7,
	0x0E,0x72,0xA3,0xCD,0xA6,0x9B,0xAD,0xDB,
	0xAC,0x5E,0xEC,0x7D,0x57,0x7B,0xBD,0xEF,
	0xD4,0x7C,0x5D,0x5F,0xD6,0xFA,0xB7,0xBF,
	0x6B,0x6F,0xBE,0xFB,0xDD,0xDF,0xFD,0xFF,
},

	{
	0x00,0x01,0x10,0x88,0x08,0x42,0x82,0x46,
	0x40,0x05,0x18,0x86,0x12,0x92,0x85,0xA6,
	0x20,0xC0,0x48,0x2A,0x90,0x19,0xD0,0xD8,
	0x44,0x1A,0x34,0xC6,0x94,0x9A,0x56,0xE5,
	0x02,0x30,0x28,0x4A,0x21,0xB0,0x89,0xA3,
	0x24,0x52,0x29,0xB2,0x07,0xAC,0x8B,0xAB,
	0x06,0x64,0x8A,0xE4,0x13,0x2E,0xA9,0x3E,
	0xC2,0xC5,0x5A,0xF4,0x8D,0x6B,0xD5,0x5F,
	0x04,0x0C,0x11,0x54,0xA0,0x15,0x98,0x36,
	0x09,0x45,0x32,0x69,0xA4,0xCC,0x96,0x9E,
	0x0A,0x38,0x62,0x33,0x25,0xC3,0x1D,0x5B,
	0xA8,0x3C,0xE1,0x7A,0xE2,0xD3,0x1F,0x3F,
	0x22,0x26,0x4C,0x0F,0x0B,0x55,0x47,0xF8,
	0xA1,0x2B,0x4B,0x3B,0xB4,0xF2,0xAE,0x77,
	0x83,0x6A,0x87,0x8F,0xD2,0x6E,0xB3,0xDB,
	0x65,0xB9,0xB5,0xE7,0xF1,0x7E,0xD7,0x7F,
	0x80,0x81,0x14,0x68,0x60,0x91,0x0D,0x95,
	0x84,0x61,0x23,0x59,0xA2,0xE8,0xB1,0xE9,
	0x03,0xC8,0x31,0x9C,0x43,0x1B,0x3A,0x97,
	0x16,0x63,0x39,0x6D,0x53,0x3D,0xE6,0x9F,
	0x41,0xC1,0x49,0x17,0x51,0x5C,0x35,0x73,
	0x2C,0x1E,0xCA,0xDA,0xD1,0x79,0x5D,0xAF,
	0x70,0x99,0xA5,0x7C,0x4D,0xE3,0xAD,0xFA,
	0xAA,0x76,0xC7,0xED,0x4F,0x7D,0x7B,0xF7,
	0x50,0x58,0xC4,0x72,0x1C,0xC9,0x27,0x37,
	0xE0,0x4E,0x6C,0xCE,0x78,0xCD,0xD9,0xDD,
	0x8C,0xD4,0x93,0xBC,0xF0,0x67,0x9D,0xBE,
	0xB8,0x75,0xBA,0xF3,0x57,0xF5,0xF6,0xFD,
	0x0E,0x71,0x66,0xDC,0x2D,0x9B,0xB6,0xEB,
	0x74,0xEA,0xCB,0x6F,0x5E,0xFC,0xBD,0xEF,
	0x8E,0xD6,0x2F,0xDE,0xA7,0xF9,0xBB,0xFE,
	0xEC,0xB7,0xEE,0xDF,0xCF,0xBF,0xFB,0xFF,
},

	{
	0x00,0x08,0x04,0x03,0x80,0xC0,0x30,0xA4,
	0x10,0xA0,0x24,0xC8,0x82,0x0B,0x4C,0xE8,
	0x40,0x41,0x09,0x34,0x90,0xA2,0x4A,0x27,
	0x60,0x85,0x64,0xA5,0x83,0x1E,0x71,0x9B,
	0x01,0x12,0x06,0x49,0x14,0x23,0x52,0xD8,
	0x0C,0xB0,0x68,0x2D,0x43,0x17,0x96,0xF8,
	0x42,0x92,0x38,0xB4,0x0D,0x8E,0xC9,0x6E,
	0xA1,0x2E,0xA9,0xD6,0xAA,0xE9,0x76,0xEB,
	0x02,0x81,0x22,0x8C,0x21,0xC4,0x26,0x35,
	0x50,0x15,0x25,0x63,0xA8,0xE2,0xB8,0xE3,
	0x18,0x91,0x94,0xB2,0x13,0x6A,0x53,0xEA,
	0x32,0x9C,0x4D,0xB6,0xE4,0x57,0xF4,0xF3,
	0x84,0x31,0x1A,0x5A,0x45,0xC6,0x4B,0xC7,
	0x54,0x5C,0x66,0x79,0xB1,0x5E,0xAD,0xFA,
	0x2C,0xCC,0xD2,0x6D,0x8D,0xB9,0x75,0xAF,
	0xA6,0x3B,0xD9,0xDE,0x4F,0xBD,0xED,0xDF,
	0x20,0x28,0x0A,0xC1,0x48,0x89,0x07,0x56,
	0x11,0xE0,0xD0,0xAC,0x1C,0x9A,0xA3,0x73,
	0x44,0x16,0x62,0x72,0x51,0xCA,0xE1,0xDA,
	0x8A,0x8B,0xC5,0x5B,0x0F,0xCE,0xD3,0xBE,
	0x88,0x61,0x46,0xD1,0x29,0x3A,0x69,0x3D,
	0x70,0x4E,0x1D,0x9E,0x95,0xF1,0xDC,0xDD,
	0x86,0x1B,0x39,0x3E,0x78,0x9D,0x7A,0x9F,
	0x93,0x97,0xCD,0xFC,0xE6,0x7E,0x6F,0xFD,
	0x05,0x2A,0x98,0x74,0xC2,0x65,0x33,0xB5,
	0x58,0x87,0xD4,0xAE,0x47,0xA7,0xF2,0x5F,
	0x19,0xC3,0x99,0xD5,0x3C,0xBA,0xCB,0xBB,
	0x36,0x7C,0xAB,0xF5,0x8F,0xE7,0xF9,0xFE,
	0x0E,0x2B,0xF0,0x37,0x6C,0xE5,0xBC,0x77,
	0x55,0x5D,0x2F,0xDB,0xB3,0xEE,0xF6,0xEF,
	0x59,0xEC,0x1F,0x7D,0x67,0x3F,0xB7,0xF7,
	0x6B,0x7B,0xCF,0xBF,0xD7,0xFB,0x7F,0xFF,
},

	{
	0x00,0x01,0x08,0x44,0x10,0x90,0x18,0x23,
	0x80,0x21,0x82,0x0B,0x06,0xA1,0x1A,0xB2,
	0x02,0x81,0x50,0x52,0x42,0xA4,0x83,0x0F,
	0x12,0x98,0x70,0xB4,0x43,0x47,0xE8,0x9D,
	0x20,0x05,0xC0,0xA2,0x88,0x38,0x46,0x71,
	0x03,0x49,0x85,0xD8,0x54,0xE2,0x9C,0xCD,
	0x30,0x61,0x31,0xAC,0xC2,0x4B,0xA6,0xE6,
	0x4A,0x65,0x78,0xEC,0x36,0xE5,0xEA,0xD7,
	0x40,0x0A,0x24,0x15,0x22,0x0E,0x58,0xC6,
	0x60,0x2A,0x29,0x4D,0x07,0x8E,0x5C,0x6B,
	0x14,0x92,0x16,0x35,0xC1,0x66,0x2E,0xB9,
	0x86,0xA5,0x33,0xAE,0x53,0x3E,0x4F,0xFC,
	0x84,0xE0,0x0D,0x9A,0xC8,0x27,0xB8,0x5E,
	0xA8,0xCC,0x1E,0x79,0x99,0xB3,0x9E,0xF9,
	0xC4,0x6C,0x63,0xE3,0x2D,0xD9,0xAB,0xFA,
	0xB1,0xF4,0xD3,0xEB,0xBA,0xEE,0xDE,0xFB,
	0x04,0x11,0x09,0x34,0xA0,0x8A,0x13,0x3C,
	0x28,0x8C,0x51,0x72,0x64,0xCA,0x6A,0x75,
	0x48,0x91,0x1C,0xD4,0x25,0x96,0x93,0x1F,
	0x68,0x1B,0xE4,0xF1,0xA3,0xC7,0xDC,0xDD,
	0x41,0xD0,0x26,0x2B,0xB0,0xAA,0xF0,0xDA,
	0x45,0x59,0x87,0x6E,0x8B,0x3D,0x97,0x77,
	0x2C,0x17,0x39,0xCB,0xC9,0x76,0xAD,0xBB,
	0x8D,0xF8,0xCE,0xF5,0xB5,0xF3,0xB7,0xF7,
	0x0C,0x4C,0x62,0xD2,0x32,0x56,0x95,0x6D,
	0x19,0x69,0x5A,0x73,0x74,0x3B,0x5B,0xED,
	0x89,0xE1,0xC3,0x57,0x55,0x8F,0x67,0x9F,
	0x4E,0x2F,0xB6,0x7B,0xE9,0xDB,0x3F,0x7F,
	0x94,0xC5,0xA9,0xD5,0xD1,0x7C,0xD6,0xE7,
	0x3A,0x9B,0xA7,0xBE,0xBC,0xCF,0x7E,0xDF,
	0x1D,0x5D,0xF2,0xF6,0x7A,0x5F,0xAF,0xFE,
	0x37,0xBD,0x7D,0xEF,0x6F,0xBF,0xFD,0xFF,
},

	{
	0x00,0x20,0x80,0x42,0x04,0x03,0x05,0xD0,
	0x10,0x60,0x06,0xE0,0x81,0xA1,0x70,0xA9,
	0x40,0x12,0x14,0x68,0x84,0x0E,0x23,0x1D,
	0xA0,0x4A,0x4C,0xCC,0xA4,0xA3,0x47,0xD5,
	0x08,0x11,0x90,0x83,0x24,0x26,0x45,0xE2,
	0x18,0xA2,0x89,0x55,0x58,0xB2,0xC9,0xAE,
	0x30,0x31,0x46,0xB1,0x52,0x8B,0xE4,0x6D,
	0x13,0xB8,0x35,0x75,0xAC,0xCB,0xAB,0xEE,
	0x01,0x44,0x41,0x92,0x82,0x2A,0x25,0x78,
	0x28,0x94,0x49,0x2D,0x91,0xA5,0x1E,0x9E,
	0x0C,0xC8,0x62,0x87,0xC1,0x3A,0x4D,0xEA,
	0x34,0x72,0x4B,0x67,0x53,0x4F,0xF2,0x6F,
	0x48,0xB0,0x0D,0x39,0x0B,0x5A,0xC3,0xD6,
	0x19,0x9A,0xCA,0x3E,0x6C,0x7C,0x1F,0xDD,
	0x54,0x74,0xD2,0xDC,0x6A,0x9D,0x6E,0x7D,
	0x3C,0x9B,0xF8,0xDB,0x79,0x7B,0x3F,0xBF,
	0x02,0xC0,0x21,0x29,0x0A,0x1C,0x32,0x8D,
	0x50,0x15,0x38,0x1B,0x8C,0x93,0xAA,0xB5,
	0x09,0xA8,0xC2,0x66,0x85,0xA6,0x33,0xEC,
	0x8A,0x95,0x36,0x76,0x69,0xF1,0xF4,0x5F,
	0x22,0x1A,0x2C,0x5C,0x51,0xD4,0x65,0xDA,
	0x07,0xB4,0xD8,0xD3,0x56,0xA7,0x37,0xDE,
	0x61,0x8E,0x59,0xB9,0x0F,0xE9,0xCE,0xBB,
	0x2B,0x73,0x7A,0x7E,0x5B,0xAF,0xBD,0xFD,
	0x88,0x98,0x43,0xE1,0x64,0xC5,0x71,0x5D,
	0xC4,0x27,0x2E,0xC7,0xF0,0x8F,0xBA,0x9F,
	0x86,0xC6,0x17,0xAD,0x96,0xD9,0x3B,0xED,
	0xE8,0x3D,0x57,0x77,0x2F,0xD7,0xF9,0xDF,
	0x16,0x99,0x63,0xB6,0x9C,0xE5,0xB3,0xE7,
	0x4E,0x5E,0xE6,0xBE,0x97,0xFA,0xFC,0xFB,
	0xD1,0xE3,0x6B,0xEB,0xCD,0xB7,0xF3,0x7F,
	0xBC,0xCF,0xF6,0xEF,0xF5,0xFE,0xF7,0xFF,
},

	{
	0x00,0x10,0x40,0x41,0x02,0x60,0x84,0x51,
	0x04,0x22,0x06,0x52,0xA0,0x49,0x68,0xB2,
	0x20,0x24,0x09,0x34,0x0C,0x43,0x98,0x93,
	0x81,0x86,0x38,0x6C,0x32,0xE8,0xB1,0xAD,
	0x08,0x44,0x05,0x89,0x48,0x23,0x64,0x33,
	0x88,0xC2,0x54,0x36,0x13,0x6A,0xB8,0xD3,
	0x0A,0xA1,0x94,0xD2,0x61,0xA5,0x5A,0x4F,
	0x0E,0x27,0x66,0xB6,0x53,0xD9,0x9E,0xF3,
	0x80,0x11,0xC0,0x92,0x03,0xE0,0x16,0x95,
	0x50,0x15,0xA8,0x71,0x58,0x9A,0x74,0xDC,
	0x21,0x0B,0x2C,0xC3,0x83,0xE2,0x63,0x9B,
	0x8C,0xD1,0x2E,0xB5,0xCC,0x57,0x73,0xF5,
	0x82,0x31,0x0D,0x2B,0xA2,0x8E,0xC9,0x9D,
	0x25,0x2D,0x39,0xBA,0xB4,0x6B,0x67,0xBD,
	0x46,0x59,0xF0,0xF2,0x87,0x3B,0xD5,0x9F,
	0x1E,0x6D,0xBC,0xED,0xF8,0xBB,0xE7,0xFD,
	0x01,0x30,0x42,0x4A,0x18,0x70,0x2A,0xD4,
	0x90,0x29,0x4C,0xAC,0xA4,0xCA,0x96,0xDA,
	0x12,0x1A,0x19,0x47,0x8A,0x4B,0x55,0xF4,
	0xC4,0x65,0x17,0xD6,0xA6,0x97,0xEC,0xEE,
	0x14,0xD0,0xB0,0xE4,0x07,0x4D,0xAA,0xE6,
	0x26,0x3C,0x35,0xCB,0xE1,0x7C,0x7A,0x7E,
	0x85,0x5C,0x8B,0xF1,0xD8,0x6E,0xAB,0xCF,
	0x8D,0x5D,0x75,0xFA,0xCE,0x7D,0x77,0xFE,
	0x28,0x45,0x62,0x72,0xC1,0x4E,0x99,0x8F,
	0x91,0xA9,0x78,0xA7,0xC5,0x37,0xAE,0xAF,
	0x1C,0x1D,0x0F,0xE5,0x69,0x3E,0x1F,0xEB,
	0x1B,0x2F,0xE3,0x6F,0x5E,0xDD,0xFC,0x7F,
	0xC8,0xC6,0x9C,0x3D,0x56,0xC7,0xCD,0xDB,
	0xA3,0xEA,0xB3,0xBE,0x76,0x3F,0xB7,0xEF,
	0x3A,0xE9,0xB9,0xF6,0x5B,0xF9,0x5F,0xFB,
	0x79,0xDE,0x7B,0xF7,0xD7,0xDF,0xBF,0xFF,
},

	{
	0x00,0x08,0x40,0x88,0x80,0x28,0xA0,0x8C,
	0x10,0x14,0x05,0x0D,0xC0,0x07,0x58,0x53,
	0x20,0x11,0x0C,0x49,0x44,0x91,0x89,0x56,
	0x03,0x0B,0x98,0xB4,0x62,0x39,0xA9,0x9D,
	0x02,0x22,0x82,0x16,0x60,0x26,0x64,0xA6,
	0x48,0x15,0x19,0x8E,0x25,0xD4,0xC3,0x5D,
	0x41,0xA8,0xA2,0xAA,0x0E,0x4E,0x1B,0x79,
	0x54,0x9C,0x5C,0x3D,0x96,0xF4,0xD3,0xED,
	0x04,0x90,0x81,0x43,0x50,0xB0,0x46,0x36,
	0x21,0x23,0x45,0x66,0x34,0x78,0x4D,0xA7,
	0x12,0x4C,0xE0,0x27,0x94,0x71,0xAC,0xCB,
	0x86,0xC9,0xE1,0x6E,0xC6,0xD5,0x97,0xFA,
	0x42,0xC2,0x85,0x35,0x2C,0x9A,0xE8,0x7C,
	0xC1,0xCC,0x47,0x6D,0xD1,0x3B,0xF2,0x3F,
	0x38,0x2B,0x1E,0xAB,0x8B,0xDA,0xCD,0xEE,
	0xE2,0xE6,0xE3,0xFC,0xC7,0xF6,0x7E,0xF7,
	0x01,0x09,0x18,0x8A,0x0A,0x1C,0x52,0xE4,
	0x30,0x13,0x51,0x0F,0x61,0x8D,0x4B,0xD6,
	0x06,0x29,0xC4,0x69,0xA1,0xD2,0xA5,0x37,
	0x68,0xA3,0x3A,0x57,0xCA,0x75,0xB5,0xF9,
	0x84,0xD0,0x4A,0x2E,0x31,0xB2,0x59,0x9B,
	0xC8,0x2D,0x72,0x1F,0x5A,0xBA,0xE5,0x5F,
	0x1A,0xB1,0x65,0xF1,0x3C,0x67,0xE9,0xF3,
	0xC5,0x4F,0x8F,0x9F,0xCE,0xAF,0xD7,0xFB,
	0x24,0xA4,0x92,0xB8,0x83,0x87,0xF0,0x7A,
	0x2A,0x74,0x95,0xD9,0x1D,0xEC,0xB9,0xCF,
	0x32,0x6A,0x99,0x6B,0x55,0xB3,0x3E,0xE7,
	0x63,0x73,0x5E,0xBB,0xAE,0xDB,0x7B,0xBF,
	0x70,0x6C,0x17,0x2F,0x93,0x9E,0xBC,0xF5,
	0x33,0x5B,0xAD,0xB7,0x76,0xBD,0xDD,0xEF,
	0xD8,0xB6,0xDC,0x7D,0xEA,0xDE,0x6F,0xFD,
	0xF8,0x77,0xEB,0xFE,0xBE,0x7F,0xDF,0xFF,
},

	{
	0x00,0x10,0x04,0x0C,0x08,0x44,0x03,0xD0,
	0x01,0x60,0x90,0x4A,0x21,0x52,0x13,0xC9,
	0x20,0x42,0x11,0x62,0x14,0x51,0xC4,0x1D,
	0x28,0x94,0x25,0x3C,0x19,0x39,0xD8,0x6B,
	0x02,0x06,0x12,0x0E,0x81,0x54,0x16,0xA6,
	0x41,0xA1,0x49,0x72,0xC8,0x5C,0x5A,0x3D,
	0x88,0x15,0x64,0xB2,0x43,0x96,0x63,0xCE,
	0x89,0xC3,0xCC,0xF8,0xD2,0x4F,0xE3,0xEB,
	0x40,0x50,0xA0,0x23,0x82,0x32,0x8C,0x4D,
	0x48,0x46,0xE0,0x8E,0x4C,0x55,0xB8,0xF2,
	0xC0,0x2A,0x0B,0x8B,0x86,0x65,0x6C,0xA7,
	0x98,0xCA,0x2B,0xBC,0x1B,0x57,0xD3,0xBE,
	0x18,0x2C,0x61,0xE2,0xC2,0xD4,0x87,0xB6,
	0x31,0x47,0xB1,0x8F,0x9C,0xE6,0x9E,0xDE,
	0xA4,0xA3,0x8D,0xB5,0x2D,0x37,0x75,0xF3,
	0x53,0x9D,0x73,0xFA,0xD9,0xDB,0xAF,0xEF,
	0x80,0x05,0x24,0x29,0x84,0xB0,0x91,0x93,
	0x22,0x85,0x68,0x6A,0x07,0xB4,0x71,0x2F,
	0x09,0x58,0x0D,0xF0,0x92,0x1E,0x4E,0x79,
	0x83,0x36,0x35,0xAD,0x74,0x97,0xD6,0xFC,
	0x0A,0x38,0x1C,0x9A,0xC1,0x59,0xAC,0xBA,
	0x34,0x2E,0x56,0x76,0xA9,0xD5,0xEA,0x7E,
	0x1A,0xE1,0x27,0xAB,0x95,0x7A,0x1F,0xE7,
	0xE8,0xAE,0xE5,0x6F,0x9B,0xED,0x7B,0xDF,
	0x30,0x45,0x26,0x66,0xA2,0x99,0x33,0xF4,
	0x8A,0x78,0xC6,0x5B,0x3A,0xCD,0x5D,0x77,
	0x70,0x17,0x0F,0xE9,0x69,0x67,0xEC,0xCF,
	0x4B,0x3E,0xCB,0x9F,0xDC,0xEE,0xF5,0x7F,
	0xA8,0xAA,0xE4,0xDA,0xA5,0x6D,0x3B,0x7D,
	0xD1,0x7C,0xF1,0xF6,0xB3,0xDD,0xBB,0xFB,
	0xC5,0xB9,0xC7,0xB7,0x6E,0xD7,0xBD,0xFE,
	0x5E,0x3F,0x5F,0xBF,0xF9,0xFD,0xF7,0xFF,
},

	{
	0x00,0x20,0x08,0x14,0x80,0x41,0x0A,0x2A,
	0x04,0x22,0x18,0x86,0x05,0x16,0xE0,0x17,
	0x40,0x11,0xC0,0x23,0x30,0x07,0x98,0xA9,
	0x81,0x19,0x1A,0x6A,0x94,0x65,0x2D,0xBA,
	0x01,0x48,0x28,0x8A,0x24,0x46,0x0D,0xC3,
	0x88,0x52,0x2C,0xD4,0x4C,0x59,0x9A,0x57,
	0x60,0xA4,0x91,0xCA,0x92,0x93,0xC5,0xAB,
	0x43,0x39,0xE2,0xE5,0x63,0xCB,0xD6,0xEB,
	0x02,0xA0,0x09,0x64,0x06,0x31,0x54,0xE4,
	0x42,0xC1,0xA8,0x9C,0x4A,0x1B,0x4D,0xB5,
	0x21,0xC2,0xB0,0xAA,0xD0,0x69,0x8B,0xB3,
	0x13,0xB4,0x35,0x7A,0x2B,0x37,0x9B,0x9F,
	0x50,0x32,0x26,0x74,0x34,0x72,0x71,0xE6,
	0x1C,0x53,0x1E,0xC7,0x96,0xDC,0x1F,0x5F,
	0x25,0xC9,0x66,0xA7,0x36,0xB6,0x9E,0xDD,
	0xE1,0x2F,0xDA,0xF9,0xD5,0xB7,0xBD,0xEF,
	0x10,0x03,0x12,0x83,0x84,0x58,0x15,0x95,
	0x82,0x62,0x29,0x33,0x61,0x6C,0x78,0xCD,
	0x44,0x70,0x0E,0x99,0xC4,0xCC,0x47,0x76,
	0xA1,0x1D,0x0F,0xCE,0x5A,0xD9,0x5E,0x7B,
	0x90,0x45,0x49,0x4E,0x68,0xF0,0x27,0x3D,
	0x85,0x56,0xD8,0x6D,0xAC,0x75,0xE3,0xAF,
	0x8C,0x8D,0x8E,0x5B,0x5C,0x5D,0xE9,0x6F,
	0xD1,0x3B,0xF1,0xBB,0x67,0x77,0x7E,0xFD,
	0x0C,0xC8,0x38,0xE8,0x51,0xB2,0xA5,0xF8,
	0x0B,0x3A,0xC6,0x6B,0x55,0xAE,0x8F,0xEE,
	0x89,0x3C,0x2E,0x97,0xB8,0xAD,0x3E,0xE7,
	0xB1,0xBC,0xD3,0x3F,0x4F,0xFA,0xDE,0xBF,
	0xA2,0x4B,0xA6,0x7C,0x87,0xB9,0x73,0xFC,
	0xA3,0xF4,0x79,0xED,0x6E,0xD7,0x7D,0x7F,
	0xD2,0xEA,0x9D,0xF5,0xF2,0xF6,0xBE,0xF7,
	0xEC,0xF3,0xCF,0xDF,0xDB,0xFB,0xFE,0xFF,
},

	{
	0x00,0x01,0x40,0x12,0x08,0x41,0x03,0x2C,
	0x02,0x90,0x88,0x31,0x30,0x51,0x13,0x2E,
	0x80,0x42,0x09,0x61,0x22,0x54,0x15,0x53,
	0x50,0x68,0x1A,0xC9,0x26,0x36,0x72,0x5D,
	0x04,0x48,0x0A,0x91,0xA0,0xC1,0x4C,0x8D,
	0x06,0x32,0x83,0xCA,0x62,0x4D,0xD2,0xB3,
	0x44,0x19,0x1C,0xC6,0xC2,0xB1,0x55,0x5B,
	0x85,0x6A,0x4E,0x9D,0xF0,0x8F,0xF8,0xBE,
	0x20,0x24,0x81,0x70,0x82,0x38,0x98,0x5C,
	0xC0,0x16,0xA4,0x78,0x94,0x71,0x1B,0xDA,
	0x18,0x23,0x89,0x65,0x58,0xE8,0xA5,0xD6,
	0xC8,0x3A,0x6C,0xA7,0x66,0x3B,0xEC,0xED,
	0x14,0x52,0xD0,0x99,0x92,0x9A,0xD8,0x6B,
	0x45,0x8E,0xE1,0xF1,0xB8,0x79,0xD5,0xB7,
	0xA1,0xA3,0xB2,0xAD,0x87,0x76,0x73,0xDD,
	0xC3,0xEA,0xBC,0xDE,0x9B,0xF5,0xF3,0xF7,
	0x10,0x0C,0x05,0x8C,0x11,0x49,0xC4,0x27,
	0x21,0x0D,0xE0,0x4B,0x4A,0x0F,0xE4,0x7A,
	0x60,0x64,0x0E,0x95,0x34,0x9C,0xB4,0x7C,
	0x43,0xD1,0x74,0x9E,0x2D,0x97,0xF2,0xEE,
	0x84,0xA2,0x86,0xA6,0x8A,0xE2,0x63,0x2F,
	0x07,0x8B,0x96,0x5E,0x69,0xB5,0x75,0x7D,
	0xA8,0x3C,0x2B,0xD9,0x59,0xE5,0xF4,0xF9,
	0x5A,0xDC,0xBA,0x7E,0x6D,0xF6,0xAF,0xFD,
	0x28,0x0B,0x2A,0x93,0x46,0xC5,0x1E,0xAB,
	0x25,0x47,0x33,0x4F,0x17,0x3E,0xE6,0x6F,
	0xB0,0xD4,0xA9,0x1F,0xAC,0x3D,0xB9,0xEB,
	0x56,0x67,0xE9,0x9F,0x37,0xBD,0xD7,0xDF,
	0x29,0x35,0xCC,0xCD,0x1D,0xD3,0xE3,0xDB,
	0xAA,0x6E,0xCE,0x3F,0xAE,0x77,0x5F,0xEF,
	0x39,0xB6,0xCB,0xFA,0x57,0xBB,0xFC,0xFE,
	0xC7,0xE7,0xCF,0xBF,0x7B,0x7F,0xFB,0xFF,
},

	{
	0x00,0x08,0x01,0x14,0x10,0xA0,0x28,0x4A,
	0x02,0x21,0x18,0x46,0x48,0x83,0x68,0x66,
	0x80,0x05,0x06,0x62,0x03,0x89,0x23,0xA6,
	0x42,0x86,0xC2,0xE4,0x64,0x9A,0x69,0x5D,
	0x20,0x09,0x50,0x07,0x22,0xD0,0x1A,0xE1,
	0x60,0x32,0x25,0x4E,0x51,0xC5,0x63,0x7A,
	0x11,0x52,0xE0,0xE2,0x4C,0x35,0xC3,0x6D,
	0x91,0xB4,0x1B,0xCB,0x2B,0xDC,0x79,0xF9,
	0x40,0x90,0xC0,0xA1,0x0A,0x29,0xC4,0x72,
	0x24,0x85,0xB0,0xF0,0x8C,0xD4,0xA3,0xAE,
	0x84,0x0B,0x13,0x8B,0x26,0xC6,0xD8,0xBC,
	0x31,0x74,0xB1,0xB9,0x3C,0xCD,0xD6,0x77,
	0x88,0x70,0x45,0xA9,0x98,0x8E,0xAA,0x4F,
	0x0E,0x33,0x55,0x76,0x36,0x3E,0x9D,0x6F,
	0x15,0x5C,0x47,0xB5,0xB2,0xAD,0x6E,0xEE,
	0x9C,0xCE,0x3D,0xDE,0xE6,0x5F,0xF6,0xFE,
	0x04,0x0C,0x81,0x2C,0x44,0x58,0x2A,0x5A,
	0x82,0xA8,0xC8,0xAC,0x61,0x2E,0x39,0xDA,
	0x30,0x16,0x94,0x99,0x1C,0xD1,0x8D,0xB6,
	0x49,0x53,0x2D,0x5E,0x95,0x7C,0xD5,0xCF,
	0x12,0xA2,0x0D,0xC9,0x92,0x4D,0xCC,0x97,
	0x38,0x65,0x59,0x9E,0x1D,0xF2,0xA7,0xBB,
	0xA4,0x0F,0x87,0xF4,0x96,0xE9,0xE3,0x7D,
	0x17,0x73,0x75,0xF5,0x6B,0xFA,0xFC,0xBF,
	0x41,0x19,0x54,0x78,0x34,0xCA,0x71,0x3B,
	0x43,0xE8,0xD2,0xD9,0xB8,0xD3,0x1F,0xDD,
	0x8A,0x93,0x6C,0xE5,0x3A,0x2F,0xEA,0xB7,
	0x27,0xF8,0x37,0xED,0xF1,0xBD,0x9F,0x7F,
	0xC1,0x6A,0x4B,0xAB,0x1E,0x5B,0x8F,0xAF,
	0x56,0xC7,0x9B,0x7B,0xBA,0xF3,0xE7,0xEF,
	0xA5,0xB3,0x57,0xEB,0x67,0x3F,0xDB,0xFD,
	0xEC,0x7E,0xBE,0xFB,0xD7,0xF7,0xDF,0xFF,
},

	{
	0x00,0x01,0x08,0x81,0x04,0x88,0x11,0xC2,
	0x40,0x03,0x21,0x43,0x90,0x8C,0x19,0xD1,
	0x10,0x12,0x44,0x94,0xA0,0x98,0x49,0xA5,
	0x05,0x85,0x92,0x9A,0x45,0x3A,0x53,0x76,
	0x02,0x48,0xC0,0xA2,0x22,0x38,0x4A,0x1E,
	0x24,0x83,0x62,0x4E,0x0E,0x2D,0x47,0x57,
	0x50,0x70,0x2C,0x5A,0x4C,0x4B,0xC5,0xAD,
	0x1C,0x39,0xB8,0xA7,0xB1,0x2F,0x7A,0xDD,
	0x20,0x18,0x30,0x34,0x28,0xD0,0x51,0x59,
	0x60,0x64,0x1A,0x33,0xB0,0xC3,0x8E,0xD9,
	0x09,0x23,0xA8,0xE2,0xA1,0x35,0x2E,0x79,
	0x54,0xA9,0x93,0x9B,0x96,0xD6,0x1F,0x77,
	0x84,0x2A,0xA4,0x17,0x86,0xB2,0x36,0x9E,
	0x13,0xE1,0xCA,0xE9,0x74,0x37,0xDC,0xF3,
	0x25,0x0F,0xA6,0xF1,0xCC,0xEC,0x67,0xBB,
	0x8D,0x3D,0x3B,0x5F,0xF8,0x7D,0xEE,0xDF,
	0x80,0x82,0x14,0x31,0x41,0x0D,0x32,0xAC,
	0x0C,0x15,0x0B,0x6A,0x61,0xC6,0x27,0xD5,
	0x0A,0xC8,0x29,0x69,0x89,0x8B,0x71,0xF4,
	0x8A,0xF0,0xB4,0xCE,0x3C,0xB5,0xE3,0xFC,
	0x06,0x91,0xC4,0x2B,0xE0,0x1D,0x99,0xB9,
	0x26,0x72,0x5C,0x4F,0xD8,0xAE,0x97,0x6F,
	0x46,0xD4,0x9C,0x6D,0x65,0xAB,0x9D,0x7B,
	0x66,0x7C,0xDA,0xE7,0x5E,0x7E,0xF9,0xFE,
	0x42,0x68,0x16,0xAA,0x58,0xC9,0x1B,0x5D,
	0x52,0xE4,0x78,0xB3,0x6C,0x75,0xF2,0xFA,
	0xC1,0xA3,0x87,0xBC,0xD2,0xCB,0xEA,0x9F,
	0xE8,0xBA,0xC7,0xBE,0x8F,0xF5,0xD7,0xEF,
	0x07,0x95,0x4D,0xE6,0x63,0x3E,0x6E,0xB7,
	0x56,0xCD,0xB6,0xDB,0x5B,0xF6,0xEB,0xFD,
	0x55,0x6B,0xE5,0xDE,0xD3,0xAF,0xBD,0xFB,
	0x73,0xED,0xCF,0xF7,0x3F,0xBF,0x7F,0xFF,
},

	{
	0x00,0x20,0x10,0x0A,0x80,0x48,0x42,0x61,
	0x02,0x11,0x90,0x46,0x44,0x58,0x1A,0x63,
	0x40,0x50,0x84,0x0B,0x05,0xA8,0x92,0x4B,
	0x81,0x32,0x16,0xD8,0xA2,0x72,0x56,0xAB,
	0x04,0x28,0x14,0xC1,0x21,0x98,0x4C,0xD1,
	0x88,0x2A,0x19,0xB1,0x34,0x17,0x35,0xF4,
	0xA0,0x0E,0x91,0xD4,0x0D,0x39,0xAA,0xEA,
	0xB0,0x47,0x99,0xB3,0x71,0x9E,0xD9,0x7B,
	0x01,0x06,0xC0,0x68,0x0C,0x31,0xC4,0xF0,
	0x12,0xC8,0x85,0x3A,0x62,0x96,0xB4,0xCB,
	0x03,0x29,0x38,0x65,0x43,0x1B,0x93,0x2F,
	0x1C,0x1D,0x4E,0x5E,0x78,0x4F,0x97,0x7E,
	0x41,0x25,0x8A,0x8E,0xA1,0xA5,0xA9,0xD5,
	0x70,0x66,0x6C,0xB5,0x55,0x3D,0x6D,0xEE,
	0x83,0xC5,0x6A,0xBA,0xCA,0xAD,0x5D,0x77,
	0x74,0xF8,0x7C,0xF9,0xC7,0xBD,0x3F,0xFD,
	0x08,0x30,0x18,0x52,0x22,0x86,0x94,0x87,
	0x82,0x49,0x26,0x9A,0x13,0x2E,0xAC,0xAE,
	0x24,0x15,0x51,0x1E,0xA4,0x33,0x53,0xE5,
	0x23,0x9C,0xE2,0xCE,0x8D,0x37,0x6B,0xBB,
	0x60,0x64,0xD0,0x2D,0x2C,0xD2,0x3C,0xD3,
	0xC2,0xC3,0xC9,0x57,0xB2,0x79,0xD6,0xD7,
	0xE0,0x0F,0x59,0x8F,0x5A,0x67,0xCD,0xCF,
	0x95,0x75,0xEC,0xFC,0x5B,0xAF,0x6F,0xFB,
	0x09,0x4A,0x89,0xC6,0x54,0x4D,0x2B,0xDC,
	0x07,0xE1,0x8B,0xBC,0x69,0xF1,0x9B,0xEB,
	0x8C,0x27,0x36,0x76,0xA6,0x9D,0xE3,0xED,
	0xE8,0x1F,0x6E,0xF6,0x73,0x5F,0xF5,0xDF,
	0x45,0xCC,0x5C,0x3E,0xA3,0xE6,0xF2,0xFA,
	0xE4,0xE9,0xB9,0xE7,0x7A,0x7D,0xDD,0xF7,
	0xB8,0xDA,0x3B,0xB7,0xB6,0xDB,0xF3,0xBF,
	0xA7,0xBE,0xDE,0x7F,0x9F,0xFE,0xEF,0xFF,
},

	{
	0x00,0x10,0x02,0x12,0x08,0x22,0x11,0x0E,
	0x80,0x90,0x48,0xD0,0x30,0xE0,0x98,0xA6,
	0x40,0x42,0x14,0xC4,0x84,0x1C,0xA1,0x36,
	0x44,0x52,0x54,0x1B,0x0D,0x74,0x95,0xB3,
	0x01,0x82,0x88,0x29,0x06,0x64,0x51,0xCA,
	0x28,0x94,0x19,0xB2,0x91,0xC5,0x33,0xAE,
	0x24,0xB0,0x2A,0xB4,0x43,0x6A,0x71,0xD9,
	0x89,0x47,0x1E,0x3E,0xC9,0xD6,0xF8,0xF9,
	0x20,0x21,0x0C,0x61,0x81,0x13,0x92,0x6C,
	0x41,0xA8,0x2C,0x93,0x86,0xB8,0x0F,0xD5,
	0xA0,0x68,0x85,0x5C,0x70,0x4E,0x2D,0xA7,
	0x38,0x99,0xA9,0x2F,0xD8,0xAD,0xEA,0xBD,
	0x03,0x83,0x58,0xE1,0x8C,0x63,0x56,0x7A,
	0x8A,0x72,0xD1,0xEC,0x17,0xAB,0x37,0x5F,
	0x26,0x2B,0xE2,0x73,0xF0,0xD3,0x8F,0xDB,
	0x8D,0xB5,0x67,0x6F,0x75,0xFC,0xEE,0xEF,
	0x04,0x50,0x0A,0x07,0x60,0x46,0x34,0x4D,
	0x09,0x1A,0x4A,0xAC,0x49,0xE4,0xC3,0xB6,
	0xC0,0x62,0x23,0x4B,0x4C,0xB1,0x5A,0xCE,
	0x31,0x2E,0xAA,0xE5,0x3A,0xE3,0x6D,0xD7,
	0x18,0xA4,0xA2,0x59,0x16,0x9A,0x69,0x76,
	0xC8,0x9C,0x3C,0x7C,0x65,0x6B,0x79,0xF3,
	0x45,0x55,0x1D,0xBA,0x87,0x9D,0x97,0xED,
	0x8B,0x3B,0xF1,0x7E,0xF2,0xCF,0xDD,0xDF,
	0x05,0xC2,0x0B,0xD4,0x32,0x39,0xA3,0xC7,
	0x15,0x53,0xE8,0xE6,0xA5,0x57,0xB9,0x7D,
	0xC1,0xC6,0x27,0x5B,0x35,0x6E,0xDC,0xBE,
	0x66,0x1F,0xE9,0xF6,0xCD,0x9F,0xBB,0xF7,
	0x25,0x8E,0x78,0x4F,0x96,0x3D,0x5E,0x3F,
	0xD2,0x9B,0x9E,0xEB,0xCB,0x7B,0x77,0xFB,
	0xCC,0xF4,0xBC,0xAF,0x5D,0xFA,0xE7,0xFE,
	0xDA,0xF5,0xB7,0xFD,0xDE,0xBF,0x7F,0xFF,
},

	{
	0x00,0x08,0x20,0x88,0x01,0x12,0x09,0x91,
	0x80,0x44,0x42,0x16,0x50,0x62,0x54,0xC5,
	0x02,0x28,0x14,0x8C,0x24,0x45,0x0E,0xF0,
	0x03,0x23,0x49,0xD8,0x0B,0x93,0x9C,0xB9,
	0x04,0x0A,0x11,0x51,0x84,0x4A,0xC1,0xC6,
	0x18,0x19,0x2A,0x4B,0x2C,0x74,0x17,0xEC,
	0x30,0xD0,0x0D,0xA5,0x32,0xAA,0x1D,0x79,
	0x8A,0x35,0x36,0xF4,0xA9,0x97,0x9D,0x9F,
	0x40,0x41,0xC0,0xC4,0x06,0x58,0x13,0xB1,
	0x48,0x07,0x15,0x8E,0xA8,0xA6,0x66,0x57,
	0x0C,0xA1,0x1C,0x53,0xE0,0x65,0x5A,0x3E,
	0xA4,0x4E,0x4D,0xE9,0x6A,0x9B,0xAE,0xED,
	0xA0,0x83,0x1A,0x56,0x46,0x9A,0xC3,0x6D,
	0x38,0x99,0xCA,0x5B,0xD4,0xF1,0xEA,0x3F,
	0x43,0x2B,0x2E,0xF2,0x33,0x6B,0xDA,0xDE,
	0xC9,0x4F,0x75,0xE7,0xE3,0xBD,0xFC,0xBF,
	0x10,0x60,0x05,0x31,0x22,0x29,0x61,0xB4,
	0x90,0x25,0xC2,0xE1,0x98,0x47,0x96,0xD6,
	0x81,0x4C,0x64,0xE2,0x89,0x78,0x27,0xD3,
	0x85,0x2D,0x5C,0xD9,0x39,0xDC,0xCB,0xDD,
	0x21,0x68,0xB0,0x3A,0xA2,0x55,0x71,0xBC,
	0x94,0xB2,0x87,0xA7,0x59,0xBA,0x73,0xCF,
	0x26,0x8D,0xD2,0x9E,0xE4,0x67,0x2F,0xBE,
	0x1E,0x8F,0xAD,0x7B,0x5E,0xD7,0xB7,0xF7,
	0x82,0xC8,0x34,0x63,0x52,0x0F,0x8B,0x3B,
	0x86,0xAC,0xCC,0xB6,0x3C,0x1F,0xCD,0x6F,
	0x92,0xD1,0xB8,0x6E,0xA3,0xB5,0xF8,0xF9,
	0x6C,0x7A,0xE6,0xDB,0x76,0x7E,0xF3,0xFD,
	0x70,0xE8,0x72,0xAB,0x95,0x7C,0x37,0xFA,
	0x69,0xCE,0xD5,0xEB,0x5D,0xBB,0xEE,0xDF,
	0x1B,0x3D,0xE5,0xAF,0xB3,0x7D,0xF6,0xFE,
	0xC7,0xF5,0x77,0x7F,0x5F,0xEF,0xFB,0xFF,
},

	{
	0x00,0x10,0x08,0x05,0x04,0x0A,0x82,0x19,
	0x01,0x30,0x24,0x91,0x18,0x0D,0x68,0xB1,
	0x20,0x42,0x48,0x23,0x44,0x43,0x98,0xB2,
	0x11,0x92,0x0B,0xCA,0x46,0x55,0x6C,0x4F,
	0x80,0x88,0x22,0x26,0x09,0xA2,0x58,0x4D,
	0x81,0x8A,0x4C,0x53,0x64,0x1E,0x17,0xD6,
	0x28,0xB0,0xC8,0xE8,0xD0,0xAC,0xC9,0x79,
	0x38,0xA9,0x5C,0x57,0x33,0x3E,0xB9,0xBB,
	0x02,0x41,0xC0,0x25,0x14,0x29,0x32,0xD4,
	0x90,0x62,0xC4,0x2E,0x2C,0x96,0xA6,0xD9,
	0x0C,0x94,0x0E,0xC3,0x70,0x9A,0x3C,0xCD,
	0x83,0x87,0x2D,0x9E,0x8D,0xB6,0x6E,0x3F,
	0x50,0xE0,0x1C,0xA5,0x13,0x74,0xC6,0x37,
	0x2A,0xA3,0x2B,0xCB,0x9C,0xEC,0xF2,0x7D,
	0x54,0xF0,0x47,0xD5,0x6A,0xD3,0x5B,0xDE,
	0xAA,0x75,0xBC,0xF9,0xBA,0xB7,0x5F,0x7F,
	0x40,0x12,0x03,0xC1,0x21,0x45,0x51,0xD1,
	0xA0,0xC2,0x34,0x59,0xA4,0xE1,0x39,0xB3,
	0x60,0x1A,0x49,0x72,0x61,0x93,0x35,0xAB,
	0x16,0xD8,0xD2,0x6D,0x4E,0x67,0x73,0xFC,
	0x06,0xA1,0x31,0xB8,0x4A,0x63,0xE2,0xDC,
	0x15,0x0F,0x66,0x76,0x36,0xCE,0xDA,0xF3,
	0x52,0xB4,0x56,0xE9,0xE4,0xE3,0xA7,0x7E,
	0x8E,0xEA,0xF1,0x6F,0x7C,0xED,0xDB,0xDF,
	0x84,0x85,0x89,0xCC,0xA8,0x5A,0x1B,0x5E,
	0x8C,0x99,0xC5,0x8F,0x8B,0x2F,0x7A,0x77,
	0x07,0x78,0x1D,0x5D,0x95,0x9B,0x6B,0xCF,
	0x69,0x3D,0xAE,0x7B,0x1F,0xAF,0xF5,0xBF,
	0x86,0x65,0x3A,0xF8,0x27,0xC7,0xB5,0xF6,
	0x71,0xE5,0x97,0xE7,0xE6,0x9F,0xEB,0xFE,
	0x4B,0xAD,0xF4,0xBE,0x9D,0xEE,0xBD,0xFD,
	0x3B,0xD7,0xDD,0xEF,0xFA,0xF7,0xFB,0xFF,
},

};
#endif

