unit About;

interface

uses
  Classes, Forms, StdCtrls, Buttons, ExtCtrls, Graphics, Controls;

type
  TfmAbout = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    OKButton: TButton;
    laFravia: TLabel;
    laWKT: TLabel;
    laECD: TLabel;
    procedure laWKTClick(Sender: TObject);

  public
    constructor Create(AOwner: TComponent); override;
  end; {TfmAbout}

implementation

uses
  Windows, ShellAPI, AppData;

{$R *.DFM}

constructor TfmAbout.Create(AOwner: TComponent);
begin
  inherited;
  ProductName.Caption := rsAppName;
  Version.Caption := rsAppVersion;
  Copyright.Caption := rsAppCopyright;
end; {TfmAbout.Create}

procedure TfmAbout.laWKTClick(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', PChar((Sender as TLabel).Hint), nil, nil, SW_SHOWNORMAL);
end; {TfmAbout.laWKTClick}

end.

