#ifndef APISPY32_H
#define APISPY32_H

#include <windows.h>

#ifdef WIN95

// Increase this value if you wish to intercept more than
// 100 API functions under Windows 95/98.

#define MAX_API 100

#endif

#define MAX_API_NAME 50
#define MAX_TEXT_LEN 40
#define MAX_PARAM    20

struct tagAPIInfo;

typedef void (*tagAPIAddr)();
typedef void (*tagHandlerAddr)(tagAPIInfo *, PSTR, ...);

enum tagParamType
{
  PARAM_INT,
  PARAM_DWORD,
  PARAM_WORD,
  PARAM_BYTE,
  PARAM_PSTR,
  PARAM_PVOID,
  PARAM_PINT,
  PARAM_PDWORD,
  PARAM_PWORD,
  PARAM_PBYTE,
  PARAM_HANDLE,
  PARAM_HWND,
  PARAM_BOOL,
  PARAM_PWSTR,
  PARAM_UNKNOWN
};

struct tagParamSpec
{
  char *ParamName;
  tagParamType ParamType;
  char *ParamFormat;
  DWORD dwParamMask;
};

struct tagAPIInfo
{
  BYTE Opcodes[5];
  tagAPIAddr APIAddress;

  #ifdef WIN95

  char szAPIName[MAX_API_NAME + 1];
  HANDLE hMutex;

  #endif

  #ifdef WINNT

  DWORD dwOldProtectionFlags;
  PSTR szAPIName;
  CRITICAL_SECTION CriticalSection;

  #endif

  tagHandlerAddr APIEnterHandler;
  tagParamType ParamList[MAX_PARAM];
  BYTE ParamCount;
  tagAPIInfo *Next;
};

tagAPIInfo *HookAPIFunction(PSTR pszModuleName,
                            PSTR pszAPIName,
                            tagHandlerAddr APIEnterHandler);

void UnhookAPIFunction(tagAPIInfo *pAPIInfo);

void UnhookAllAPIFunctions();

#endif