// ----------------------------------- //
//            APISpy32 v2.1            //
//     Copyright 1999 Yariv Kaplan     //
//          WWW.INTERNALS.COM          //
// ----------------------------------- //

#include "LinkList.h"
#include "APISpy32.h"

tagAPIInfo *Head = NULL;
tagAPIInfo *Tail = NULL;

#ifdef WIN95

DWORD dwItemIndex = 0;
tagAPIInfo APIInfoArray[MAX_API];

#endif

tagAPIInfo *AddItem()
{
  tagAPIInfo *Item;

  #ifdef WIN95

  if (dwItemIndex == MAX_API)
    return NULL;

  Item = &APIInfoArray[dwItemIndex];
  dwItemIndex++;

  #endif

  #ifdef WINNT

  Item = (tagAPIInfo *)HeapAlloc(GetProcessHeap(), 0, sizeof(tagAPIInfo));

  #endif

  if (Head == NULL)
  {
    Head = Item;
    Tail = Item;
  }
  else
  {
    Tail->Next = Item;
    Tail = Tail->Next;
  }  

  Tail->Next = NULL;
  
  return Item;
}

#ifdef WINNT

void RemoveItem(tagAPIInfo *Item)
{
  tagAPIInfo *CurrentItem = Head;

  if (Head == NULL) return;

  if (Item == Head)
  {
    if (Head == Tail) Tail = NULL;
    Head = Head->Next;
    HeapFree(GetProcessHeap(), 0, Item);
    return;
  }

  while (CurrentItem->Next != Item)
    CurrentItem = CurrentItem->Next;
  
  CurrentItem->Next = Item->Next;

  if (Item == Tail) Tail = CurrentItem;

  HeapFree(GetProcessHeap(), 0, Item);
}

#endif
