// ----------------------------------- //
//            APISpy32 v2.1            //
//     Copyright 1999 Yariv Kaplan     //
//          WWW.INTERNALS.COM          //
// ----------------------------------- //

#include <windows.h>
#include "LogAPI.h"

#ifdef WINNT

#pragma comment(linker, "/section:.sdata,RWS")

#pragma data_seg(".sdata")

#endif

bool CaptureEvents = false;
DWORD dwAPISpy32ProcessId = 0;

#ifdef WINNT

#pragma data_seg()

#endif

#ifdef WINNT

bool AddLogEntry(DWORD dwProcessId, PSTR pszAPIName, DWORD dwReturnValue, PVOID pvOriginAddress)
{
  HANDLE hMailslot;
  DWORD dwBytesWritten;
  tagLogEntry LogEntry;
  BOOL Result;

  if (CaptureEvents == false || dwProcessId == dwAPISpy32ProcessId)
    return true;

  hMailslot = CreateFile("\\\\.\\mailslot\\APISpy32_Mailslot", GENERIC_WRITE,
                         FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);

  if (hMailslot == INVALID_HANDLE_VALUE)
    return false;

  LogEntry.dwProcessId = dwProcessId;
  LogEntry.dwReturnValue = dwReturnValue;
  LogEntry.pvOriginAddress = pvOriginAddress;

  strcpy(LogEntry.szAPIName, pszAPIName);

  Result = WriteFile(hMailslot, &LogEntry, sizeof(tagLogEntry), &dwBytesWritten, NULL);

  CloseHandle(hMailslot);
  
  return Result!=0;
}

#endif

#ifdef WIN95

tagLogEntry LogBuffer[MAX_LOG_ENTRIES];

DWORD dwReadLogIndex = 0, dwWriteLogIndex = 0;

bool AddLogEntry(DWORD dwProcessId, PSTR pszAPIName, DWORD dwReturnValue, PVOID pvOriginAddress)
{
  HANDLE hOverflowEvent;
  HANDLE hLogEvent;
  HANDLE hLogMutex;

  if (CaptureEvents == false || dwProcessId == dwAPISpy32ProcessId)
    return true;

  hLogMutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, "APISpy32_LogMutex");

  if (hLogMutex == NULL)
    return false;

  WaitForSingleObject(hLogMutex, INFINITE);

  LogBuffer[dwWriteLogIndex].dwProcessId = dwProcessId;
  LogBuffer[dwWriteLogIndex].dwReturnValue = dwReturnValue;
  LogBuffer[dwWriteLogIndex].pvOriginAddress = pvOriginAddress;

  if (strlen(pszAPIName) > MAX_API_LEN)
  {
    memcpy(LogBuffer[dwWriteLogIndex].szAPIName, pszAPIName, MAX_API_LEN - 3);

    LogBuffer[dwWriteLogIndex].szAPIName[MAX_API_LEN - 3] = '.';
    LogBuffer[dwWriteLogIndex].szAPIName[MAX_API_LEN - 2] = '.';
    LogBuffer[dwWriteLogIndex].szAPIName[MAX_API_LEN - 1] = '.';
    LogBuffer[dwWriteLogIndex].szAPIName[MAX_API_LEN] = '\0';
  }
  else
    strcpy(LogBuffer[dwWriteLogIndex].szAPIName, pszAPIName);

  if ((dwReadLogIndex != 0 && dwWriteLogIndex == dwReadLogIndex - 1) ||
      (dwReadLogIndex == 0 && dwWriteLogIndex == MAX_LOG_ENTRIES - 1 ))
  {
    hOverflowEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, "APISpy32_OverflowEvent");

    if (hOverflowEvent == NULL)
    {
      ReleaseMutex(hLogMutex);
      CloseHandle(hLogMutex);
      return false;
    }

    hLogEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, "APISpy32_LogEvent");

    if (hLogEvent == NULL)
    {
      CloseHandle(hOverflowEvent);
      ReleaseMutex(hLogMutex);
      CloseHandle(hLogMutex);
      return false;
    }

    SetEvent(hOverflowEvent);
    WaitForSingleObject(hLogEvent, INFINITE);
    ResetEvent(hLogEvent);
    CloseHandle(hOverflowEvent);
    CloseHandle(hLogEvent);
  }

  dwWriteLogIndex++;

  if (dwWriteLogIndex == MAX_LOG_ENTRIES)
    dwWriteLogIndex = 0;

  ReleaseMutex(hLogMutex);

  CloseHandle(hLogMutex);

  return true;
}


extern "C" __declspec(dllexport) bool GetLogParameters(DWORD *pdwNumLogEntries, DWORD *pdwReadLogIndex, tagLogEntry **ppLogBuffer)
{
  HANDLE hLogMutex;
  DWORD Result;
  
  hLogMutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, "APISpy32_LogMutex");

  if (hLogMutex == NULL)
    return false;

  Result = WaitForSingleObject(hLogMutex, INFINITE);

  if (Result == WAIT_FAILED)
  {
    CloseHandle(hLogMutex);
    return false;
  }

  *ppLogBuffer = &LogBuffer[0];
  *pdwReadLogIndex = dwReadLogIndex;

  if (dwWriteLogIndex >= dwReadLogIndex)
    *pdwNumLogEntries = dwWriteLogIndex - dwReadLogIndex;
  else
    *pdwNumLogEntries = dwWriteLogIndex + (MAX_LOG_ENTRIES - dwReadLogIndex);

  ReleaseMutex(hLogMutex);

  CloseHandle(hLogMutex);

  return true;
}


extern "C" __declspec(dllexport) void AdvanceToNextLogEntry()
{
  dwReadLogIndex++;

  if (dwReadLogIndex == MAX_LOG_ENTRIES)
    dwReadLogIndex = 0;
}

#endif


extern "C" __declspec(dllexport) void SetCaptureEventsFlag(bool bNewValue)
{
  CaptureEvents = bNewValue;
}


extern "C" __declspec(dllexport) void SetAPISpy32ProcessId(DWORD dwProcessId)
{
  dwAPISpy32ProcessId = dwProcessId;
}
