// ----------------------------------- //
//            APISpy32 v2.1            //
//     Copyright 1999 Yariv Kaplan     //
//          WWW.INTERNALS.COM          //
// ----------------------------------- //

#include <windows.h>

char *strtok(PSTR pszStr, PSTR pszDelimiters)
{
  BYTE DelimiterMap[32];
  DWORD dwIndex;
  PSTR pszTempStr;
  static PSTR pszNextToken;

  for (dwIndex = 0; dwIndex < 32; dwIndex++)
    DelimiterMap[dwIndex] = 0;

  do
  {
    DelimiterMap[*pszDelimiters >> 3] |= (1 << (*pszDelimiters & 7));
  } while (*pszDelimiters++);

  if (pszStr)
    pszTempStr = pszStr;
  else
    pszTempStr = pszNextToken;

  while ((DelimiterMap[*pszTempStr >> 3] & (1 << (*pszTempStr & 7))) && *pszTempStr)
    pszTempStr++;

  pszStr = pszTempStr;

  for (;*pszTempStr; pszTempStr++)
    if (DelimiterMap[*pszTempStr >> 3] & (1 << (*pszTempStr & 7)))
	{
    *pszTempStr++ = '\0';
	  break;
	}

  pszNextToken = pszTempStr;

  if (pszStr == pszTempStr)
    return NULL;
  else
    return pszStr;
}

char *strchr(PSTR pszStr, int iChar)
{
  PSTR pszRet;

  _asm
  {
    Cld
    Mov ESI, [pszStr]
    Mov DL, BYTE PTR [iChar]

Next:

    Lodsb
    Cmp AL, DL
    Je Found
    Or AL, AL
    Jnz Next
    Mov ESI, 1

Found:

    Dec ESI
    Mov pszRet, ESI
  }

  return pszRet;
}

char *strupr(PSTR pszStr)
{
  _asm
  {
    Mov EDX, [pszStr]

Next:

    Mov AL, [EDX]
    Or AL, AL
    Jz Done

    Cmp AL, 'a'
    Jb Skip
    Cmp AL, 'z'
    Ja Skip

    Sub AL, 'a'-'A'
    Mov [EDX], AL

Skip:

    Inc EDX
    Jmp Next
  }

Done:

  return pszStr;
}
