#ifndef APISPY32_H
#define APISPY32_H

// Registry path of APISpy32 key

#define APISPY32_REG_KEY "Software\\Internals\\APISpy32"

// The amount of time (in milliseconds) to wait for a thread
// to terminate.

#define THREAD_EXIT_TIMEOUT 5000

// The amount of time (in milliseconds) to wait before attempting to
// reinject APISpyNT.dll into the address space of all running processes.

#define DLL_INJECTION_TIMEOUT 500

#define NUM_TOOLBAR_BUTTONS 5
#define NUM_OLD_TOOLBAR_BUTTONS 8

#define TOOLBARHEIGHT 28
#define NUMCOLUMNS 4
#define TOOLBAR_FLAT 0x800
#define ID_TOOLBAR 1

#define COLUMN_WIDTH1 90
#define COLUMN_WIDTH2 350
#define COLUMN_WIDTH3 90
#define COLUMN_WIDTH4 90

#define PACKVERSION(Major, Minor) MAKELONG(Minor, Major)

struct tagSettings
{
  DWORD dwLeft;
  DWORD dwTop;
  DWORD dwWidth;
  DWORD dwHeight;
  bool WindowOnTop;
  BOOL Maximized;
  DWORD dwLVColumnWidth[NUMCOLUMNS];

}Settings;

typedef struct
{
  DWORD cbSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformID;
} DLLVERSIONINFO, *PDLLVERSIONINFO;

typedef HRESULT (CALLBACK *DLLGETVERSIONPROC)(DLLVERSIONINFO *);
typedef bool (*GETLOGPARAMETERS_PROC)(DWORD *pdwNumLogEntries, DWORD *pdwReadLogIndex, tagLogEntry **ppLogBuffer);
typedef void (*SETCAPTUREEVENTSFLAG_PROC)(bool bNewValue);
typedef void (*SETAPISPY32PROCESSID_PROC)(DWORD dwProcessId);
typedef void (*ADVANCETONEXTLOGENTRY_PROC)();

#endif
