// ----------------------------------- //
//            APISpy32 v2.1            //
//     Copyright 1999 Yariv Kaplan     //
//          WWW.INTERNALS.COM          //
// ----------------------------------- //

#include <windows.h>
#include <tlhelp32.h>
#include "apispy9x.h"

typedef HANDLE (WINAPI *CREATETOOLHELP32SNAPSHOT_PROC)(DWORD dwFlags, DWORD th32ProcessID);
typedef BOOL (WINAPI *PROCESS32FIRST_PROC)(HANDLE hSnapshot, LPPROCESSENTRY32 lppe);
typedef BOOL (WINAPI *PROCESS32NEXT_PROC)(HANDLE hSnapshot, LPPROCESSENTRY32 lppe);
typedef BOOL (WINAPI *MODULE32FIRST_PROC)(HANDLE hSnapshot, LPMODULEENTRY32 lpme);
typedef BOOL (WINAPI *MODULE32NEXT_PROC)(HANDLE hSnapshot, LPMODULEENTRY32 lpme);

CREATETOOLHELP32SNAPSHOT_PROC pCreateToolhelp32Snapshot;
PROCESS32FIRST_PROC pProcess32First;
PROCESS32NEXT_PROC pProcess32Next;
MODULE32FIRST_PROC pModule32First;
MODULE32NEXT_PROC pModule32Next;

bool InitToolhelp32()
{
  HMODULE hModule;

  hModule = GetModuleHandle("kernel32.dll");

  if (hModule == NULL)
    return false;

  pCreateToolhelp32Snapshot = (CREATETOOLHELP32SNAPSHOT_PROC)GetProcAddress(hModule, "CreateToolhelp32Snapshot");

  if (pCreateToolhelp32Snapshot == NULL)
    return false;

  pProcess32First = (PROCESS32FIRST_PROC)GetProcAddress(hModule, "Process32First");

  if (pProcess32First == NULL)
    return false;

  pProcess32Next = (PROCESS32NEXT_PROC)GetProcAddress(hModule, "Process32Next");

  if (pProcess32Next == NULL)
    return false;

  pModule32First = (MODULE32FIRST_PROC)GetProcAddress(hModule, "Module32First");

  if (pModule32First == NULL)
    return false;

  pModule32Next = (MODULE32NEXT_PROC)GetProcAddress(hModule, "Module32Next");

  if (pModule32Next == NULL)
    return false;

  return true;
}


bool GetProcessModule(DWORD dwOwnerProcessId, DWORD dwModuleId, MODULEENTRY32 *pModuleEntry32)
{
  HANDLE hSnapShot;
  MODULEENTRY32 ModuleEntry32;
  BOOL Result;
 
  hSnapShot = pCreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwOwnerProcessId);

  if (hSnapShot == (HANDLE)-1)
    return false;

  ModuleEntry32.dwSize = sizeof(MODULEENTRY32);

  Result = pModule32First(hSnapShot, &ModuleEntry32);

  if (Result != TRUE)
    return false;

  do
  {
    if (ModuleEntry32.th32ModuleID == dwModuleId)
    {
      CopyMemory(pModuleEntry32, &ModuleEntry32, sizeof(MODULEENTRY32));
      return true;
    }

  } while (pModule32Next(hSnapShot, &ModuleEntry32));

  CloseHandle(hSnapShot);

  return false;
}


bool GetProcessName9x(DWORD dwProcessId, PSTR pszProcessName)
{
  HANDLE hSnapShot;
  PROCESSENTRY32 ProcessEntry32;
  MODULEENTRY32 ModuleEntry32;
  BOOL Result;
  char *pszExtension;

  hSnapShot = pCreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);

  if (hSnapShot == (HANDLE)-1)
    return false;

  ProcessEntry32.dwSize = sizeof(PROCESSENTRY32);

  Result = pProcess32First(hSnapShot, &ProcessEntry32);

  if (Result != TRUE)
  {
    CloseHandle(hSnapShot);
    return false;
  }

  do
  {
    Result = GetProcessModule(ProcessEntry32.th32ProcessID,
                              ProcessEntry32.th32ModuleID,
                              &ModuleEntry32);

    if (Result == false)
      continue;

    if (dwProcessId == ProcessEntry32.th32ProcessID)
    {
      strcpy(pszProcessName, ModuleEntry32.szModule);

      strupr(pszProcessName);

      pszExtension = strstr(pszProcessName, ".EXE");
      
      if (pszExtension != NULL)
        *pszExtension = '\0';

      return true;
    }

  } while (pProcess32Next(hSnapShot, &ProcessEntry32));

  CloseHandle(hSnapShot);

  return false;
}

