// ----------------------------------- //
//            APISpy32 v2.1            //
//     Copyright 1999 Yariv Kaplan     //
//          WWW.INTERNALS.COM          //
// ----------------------------------- //

#include <windows.h>
#include "psapi.h"
#include "general.h"
#include "apispynt.h"

typedef BOOL (WINAPI *ENUMPROCESSES_PROC)(DWORD *lpidProcess, DWORD cb, DWORD *cbNeeded);
typedef BOOL (WINAPI *ENUMPROCESSMODULES_PROC)(HANDLE hProcess, HMODULE *lphModule, DWORD cb, LPDWORD lpcbNeeded);
typedef DWORD (WINAPI *GETMODULEBASENAME_PROC)(HANDLE hProcess, HMODULE hModule, LPTSTR lpBaseName, DWORD nSize);

ENUMPROCESSES_PROC pEnumProcesses;
ENUMPROCESSMODULES_PROC pEnumProcessModules;
GETMODULEBASENAME_PROC pGetModuleBaseName;

bool InitPSAPI()
{
  HINSTANCE hInstance;

  hInstance = LoadLibrary("psapi.dll");

  if (hInstance == NULL)
    return false;

  pEnumProcesses = (ENUMPROCESSES_PROC)GetProcAddress(hInstance, "EnumProcesses");

  if (pEnumProcesses == NULL)
  {
    FreeLibrary(hInstance);
    return false;
  }

  pEnumProcessModules = (ENUMPROCESSMODULES_PROC)GetProcAddress(hInstance, "EnumProcessModules");

  if (pEnumProcessModules == NULL)
  {
    FreeLibrary(hInstance);
    return false;
  }

  pGetModuleBaseName = (GETMODULEBASENAME_PROC)GetProcAddress(hInstance, "GetModuleBaseNameA");

  if (pGetModuleBaseName == NULL)
  {
    FreeLibrary(hInstance);
    return false;
  }

  return true;
}


bool GetProcessNameNT(DWORD dwProcessId, PSTR pszProcessName)
{
  DWORD dwProcessArray[MAX_PROCESSES];
  DWORD dwBytesNeeded;
  DWORD dwProcessCount;
  HANDLE hProcess;
  HMODULE hModule;
  BOOL Result;
  DWORD dwIndex;
  char *pszExtension;

  Result = pEnumProcesses(&dwProcessArray[0], sizeof(dwProcessArray), &dwBytesNeeded);

  if (Result == FALSE)
    return false;

  dwProcessCount = dwBytesNeeded / sizeof(DWORD);

  for (dwIndex = 0; dwIndex < dwProcessCount; dwIndex++)
  {
    if (dwProcessId == dwProcessArray[dwIndex])
    {

      hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
                             FALSE, dwProcessId);

      if (hProcess == NULL)
        return false;

      Result = pEnumProcessModules(hProcess, &hModule, sizeof(HMODULE), &dwBytesNeeded);

      if (Result == FALSE)
      {
        CloseHandle(hProcess);
        return false;
      }

      Result = pGetModuleBaseName(hProcess, hModule, pszProcessName, MAX_PATH);

      if (Result == 0)
      {
        CloseHandle(hProcess);
        return false;
      }

      strupr(pszProcessName);

      pszExtension = strstr(pszProcessName, ".EXE");
      
      if (pszExtension != NULL)
        *pszExtension = '\0';

      CloseHandle(hProcess);
    }
  }

  return true;
}


bool InjectDLL(BOOL ActionFlag)
{
  DWORD dwProcessArray[MAX_PROCESSES];
  char szDLLPath[MAX_PATH];
  DWORD dwBytesNeeded;
  DWORD dwProcessCount;
  DWORD dwIndex;
  HANDLE hProcess;
  BOOL Result;

  Result = pEnumProcesses(&dwProcessArray[0], sizeof(dwProcessArray), &dwBytesNeeded);

  if (Result == FALSE)
    return false;

  dwProcessCount = dwBytesNeeded / sizeof(DWORD);

  for (dwIndex = 0; dwIndex < dwProcessCount; dwIndex++)
  {
    hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, dwProcessArray[dwIndex]);
    
    if (hProcess == NULL)
      continue;

    GetModuleFileName(NULL, szDLLPath, sizeof(szDLLPath));

    strcpy(strrchr(szDLLPath, '\\') + 1, APISPY32DLL_NT);

    InjectLib(hProcess, szDLLPath, ActionFlag);

    CloseHandle(hProcess);
  }

  return true;
}


bool ObtainSeDebugPrivilege()
{
  BOOL Result;
  TOKEN_PRIVILEGES TokenPrivileges;
  TOKEN_PRIVILEGES PreviousTokenPrivileges;
  LUID luid;
  HANDLE hToken;
  DWORD dwPreviousTokenPrivilegesSize = sizeof(TOKEN_PRIVILEGES);

  Result = OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken);

  if (Result == FALSE)
    return false;

  Result = LookupPrivilegeValue(NULL, SE_DEBUG_NAME, &luid);

  if (Result == FALSE)
    return false;
  
  TokenPrivileges.PrivilegeCount            = 1;
  TokenPrivileges.Privileges[0].Luid        = luid;
  TokenPrivileges.Privileges[0].Attributes  = 0;

  AdjustTokenPrivileges(hToken, FALSE, &TokenPrivileges, sizeof(TOKEN_PRIVILEGES),
                        &PreviousTokenPrivileges, &dwPreviousTokenPrivilegesSize);

  if (GetLastError() != ERROR_SUCCESS)
    return false;

  PreviousTokenPrivileges.PrivilegeCount             = 1;
  PreviousTokenPrivileges.Privileges[0].Luid         = luid;
  PreviousTokenPrivileges.Privileges[0].Attributes  |= SE_PRIVILEGE_ENABLED;

  AdjustTokenPrivileges(hToken, FALSE, &PreviousTokenPrivileges,
                        dwPreviousTokenPrivilegesSize, NULL, NULL);

  if (GetLastError() != ERROR_SUCCESS)
    return false;

  CloseHandle(hToken);

  return true;
}
