package julk.net.deliver;

import java.io.*;
import julk.net.mail.SMTP;
import julk.net.mail.SMTPException;
import java.sql.*;
import julk.io.*;

public class MailListTranslator extends Translator
{
	FileOutputStream log;
	String logname;
	
	private Connection dbConnect()
	{
		try {
			DriverManager.registerDriver( new com.ms.jdbc.odbc.JdbcOdbcDriver() );
			Connection _conn = DriverManager.getConnection("jdbc:odbc:maillist",
														   "admin","");
			return _conn;
		} catch (Exception e) {
			System.out.println(e.getMessage());
			return null;
		}
	}
	
	private void sendLog(String msg)
	{
		try {
			log.write(msg.getBytes());
		} catch (Exception e) {
		}
	}
	
	private void closeLog (boolean ok)
	{
		try {
			log.close();
		} catch (IOException e) {}
		WorkResult wr = new WorkResult(logname,ok);
		setWorkResult(wr);
	}
	
	public boolean translate (String user, String service,
							  String command, WorkResult owr)
	{
		
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String server;
		String sender;
		SMTP smtp;
		try {
			logname = "log"+new java.util.Random(1000).nextGaussian();
			log = new FileOutputStream(logname);
		} catch (Exception e) {
			return false;
		}
		if (owr == null) {
			sendLog("No se ha recibido ninguna entrada\r\n");
			closeLog(false);
			return false;
		}
		try {
			conn = dbConnect();
			stmt = conn.createStatement();
		} catch (Exception e) {
			sendLog("Fallo al conectar con la base de datos de destinatarios\r\n");
			closeLog(false);
			return false;
		}
		try {
			rs = stmt.executeQuery("SELECT email " +
											 "FROM maillist");
		} catch (Exception e) {
			sendLog("Fallo al recuperar la informacin de destinatarios\r\n");
			closeLog(false);
			return false;
		}
		try {
			int pos = command.indexOf(" ");
			server = command.substring(0,pos);
			sender = command.substring(pos+1);
		} catch (Exception e ) {
			sendLog("Fallo de interpretacin del comando\r\n");
			closeLog(false);
			return false;
		}
		try {
			smtp = new SMTP(server,25);
		} catch (Exception e) {
			sendLog("Fallo al conectar con el servidor de correo " + server + "\r\n");
			closeLog(false);
			return false;
		}
		try {
			smtp.helo("mailer");
		} catch (Exception e) {
			sendLog("Dominio no aceptado en HELO\r\n");
			closeLog(false);
			return false;
		}
		try {
			smtp.mail_from(sender);
		} catch (Exception e) {
			sendLog("Emisor "+sender+"no aceptado\r\n");
			closeLog(false);
			return false;
		}
		try {
			while (rs.next()) {
				String recipient = rs.getString(1);
				try {
					smtp.rcpt_to(recipient);
				} catch (SMTPException smtpe) {
					try {
						sendLog("No se pudo enviar mensaje a " + recipient + "\r\n");
					} catch (Exception e) {
					}
				}
			}
		} catch (SQLException e) {
			sendLog("Fallo al recuperar datos de destinatarios\r\n");
			closeLog(false);
			return false;
		}
		try {
			if (rs != null) rs.close();
			if (stmt != null) stmt.close();
			if (conn != null) conn.close();
		} catch (Exception e) {
		}
		try {
			smtp.dataFile(owr.getName());
		} catch (Exception e) {
			sendLog("Fallo al enviar el mensaje\r\n");
			closeLog(false);
			return false;
		}
		try {
			smtp.quit();
		} catch (Exception e) {
		}
		sendLog("Mensaje enviado con xito\r\n");
		closeLog(true);
		return true;
	}
}
