package julk.net.deliver;

import julk.net.scheduler.SchedulerProgram;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Date;

public class QueueRecovery extends SchedulerProgram
{
	private Deliverer DELIVERER;
	private Hashtable queue;
	
	public QueueRecovery ()
	{
	}
	
	public void Init ()
	{
		System.out.println("Iniciando el sistema de recuperacin automtica de colas remotas...");
	}
	
	private boolean setDeliverer()
	{
		if (DELIVERER == null) {
			DELIVERER = (Deliverer) getObject("Deliverer");
			if (DELIVERER == null)
				return false;
			queue = DELIVERER.getQueueList();
			return true;
		} else {
			return true;
		}
	}
	
	protected final void launch ()
	{
		if (!setDeliverer()) {
			setReady(false);
			return;
		}
		
		Enumeration e = queue.elements();
		Queue q;
		boolean again = false;
		
		while (e.hasMoreElements()) {
			q = (Queue) e.nextElement();
			if (!q.isOnline()) {
				if (!q.connect())
					again = true;
			}
		}
		
		if (!again) {
			DELIVERER.getScheduler().subProgram(key);
			System.out.println("No hay ms colas fuera de lnea, retirado programa de recuperacin");
			DELIVERER.getRegistry().unRegister("QueueRecovery");
		}
	}
}
