package julk.net.deliver;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;

public class WorkResult
{
	private String name;
	private String attach;
	
	public WorkResult(String name)
	{
		this.name = name;
		attach = "S";
	}
	
	public WorkResult(String _name, boolean _attached)
	{
		this(_name);
		attach = (_attached ? "S" : "N");
	}
	
	private String getResponse (InputStream in)
	{
		String response = "";
		int c;
		try {
			while (in.available() == 0)
				Thread.sleep(100);
			while ((c = in.read()) != -1) {
				if (c == 13) {
					c = in.read();
					break;
				}
				response += (char) c;
			}
		} catch (Exception e) {}
		return response;
	}
		
	private void sendRequest (String cmd, OutputStream out)
	{
		if (cmd.length() == 0)
			return;
		try {
			out.write ((cmd + "\r\n").getBytes());
		} catch (Exception e) {
		}
	}
	
	public void receive(InputStream in,long count)
		throws Exception
	{
		name = getResponse(in);
		if (name.length() == 0)
			throw new Exception("No llega bien el nombre");
		int pos = name.lastIndexOf("/");
		if (pos != -1) name = name.substring(pos+1);
		pos = name.lastIndexOf("\\");
		if (pos != -1) name = name.substring(pos+1);
		attach = getResponse(in);
		if (attach.length() == 0)
			throw new Exception("No llega bien la propiedad attach");
		FileOutputStream fout = new FileOutputStream(name);
		dump(in,fout,count);
		fout.close();
	}
	
	public void receive(InputStream in)
		throws Exception
	{
		name = getResponse(in);
		if (name.length() == 0)
			throw new Exception("No llega bien el nombre");
		int pos = name.lastIndexOf("/");
		if (pos != -1) name = name.substring(pos+1);
		pos = name.lastIndexOf("\\");
		if (pos != -1) name = name.substring(pos+1);
		attach = getResponse(in);
		if (attach.length() == 0)
			throw new Exception("No llega bien la propiedad attach");
		FileOutputStream fout = new FileOutputStream(name);
		dumpFile(in,fout);
		fout.close();
	}

	public void send(OutputStream out)
		throws Exception
	{
		FileInputStream in = new FileInputStream(name);
		String nombre = new String(name);
		int pos = nombre.lastIndexOf("\\");
		if (pos != -1) nombre = nombre.substring(pos+1);
		pos = nombre.lastIndexOf("/");
		if (pos != -1) nombre = nombre.substring(pos+1);
		
		sendRequest(nombre,out);
		sendRequest(attach,out);
		dumpFile(in,out);
		in.close();
	}
	
	private void dump(InputStream in, OutputStream out,long count)
		throws IOException
	{
		int c;
		BufferedInputStream bin;
		BufferedOutputStream bout;
		
		bin = new BufferedInputStream(in,4096);
		bout = new BufferedOutputStream(out,4096);
		for (int i = 0; i < count && (c = bin.read()) != -1; i++)		
			bout.write(c);
		bout.flush();
	}
	
	private void dumpFile(InputStream in, OutputStream out)
		throws Exception
	{
		int c;
		BufferedInputStream bin;
		BufferedOutputStream bout;
		
		bin = new BufferedInputStream(in,4096);
		bout = new BufferedOutputStream(out,4096);
		int i;
		for (i = 0;(c = bin.read()) != -1; i++)		
			bout.write(c);
		bout.flush();
	}
	
	public long size()
	{
		/*try {
			FileInputStream fin = new FileInputStream(name);
			int c, l = 0;
			while ((c = fin.read()) != -1)
				l++;
			fin.close();
			return l;
		} catch (Exception e) {
			return 0;
		}*/
		File f = new File(name);
		long l = f.length();
		return l;
	}

	public String getName()
	{
		return name;
	}
	
	public boolean isAttached()
	{
		return (attach.equalsIgnoreCase("S") ? true : false);
	}
}
