package julk.net.mail.bots;

import julk.net.mail.*;
import julk.net.deliver.RemoteWorkQueue;
import julk.net.deliver.WorkItem;
import julk.net.deliver.WorkResult;
import java.io.FileOutputStream;
import julk.net.scheduler.*;
import java.util.Properties;

public class Broken implements Runnable
{
	private Thread t;
	private String pop3Server;
	private String user;
	private String pass;
	private int pop3Port;
	private RemoteWorkQueue rwq;
	private WorkItem wi;
	private Properties ini;
	private boolean ready;
	  
	public Broken(String pop3Server, String user, String pass, String deliverer)
		throws Exception
	{
		init (pop3Server,user,pass,deliverer);
	}
	
	public Broken ()
	{
		ready = false;
	}
	
	public void init (String pop3Server, String user,
					  String pass, String deliverer)
		throws Exception
	{
		this.pop3Server = pop3Server;
		this.pop3Port = 110;
		this.user = user;
		this.pass = pass;
		rwq = new RemoteWorkQueue(deliverer,"several");
		t = new Thread(this);
		ready = true;
	}
	
	public void start()
	{
		if (ready) {
			t.start();		
		}
	}
	
	public void stop()
	{
		if (ready)
			t.stop();
	}
	
	public void suspend()
	{
		if (ready)
			t.suspend();
	}
	
	public void resume()
	{
		if (ready)
			t.resume();
	}
	
	public void join()
		throws InterruptedException
	{
		if (ready)
			t.join();
	}
	
	private POP3 conectarPOP3()
	{
		POP3 pop3;
		
		try {
			pop3 = new POP3(pop3Server, pop3Port);
			pop3.user(user);
			pop3.pass(pass);
			POP3.Stat stat = pop3.stat();
			if (stat.messages() != 0)
				return pop3;
			pop3.quit();
		} catch (POP3Exception pop3e) {}
		pop3 = null;
		return null;
	}
	
	private String getSender(String from)
	{
		String value;
		int pos;
		
		pos = from.indexOf(':');
		
		if (pos == -1)
			return null;
		
		value = from.substring(pos+1);
		
		pos = value.indexOf('<');
		
		if (pos == -1)
			return value;
		
		int pos_f = value.indexOf('>');
		
		value = value.substring(pos+1,pos_f);
		
		return value;
	}
	
	public void run()
	{
		try {
			POP3 pop3;
			String cmd,service;
			int pos;
			while (true) {
				while ((pop3 = conectarPOP3()) == null)
					Thread.sleep(300000);
				POP3.List _list;
				_list = pop3.list();
				String from;
				int start;
				for (int n = 1; n <= _list.size(); n++) {
					// Comenzar recogiendo el mensaje
					POP3.Message msg = pop3.retr(n);
					// Obtener emisor del mensaje
					from = "";
					start = 0;
					while (!msg.lineAt(start).toLowerCase().startsWith("from:")
						   && start < msg.linesCount()-1)
						start++;
					if (start < msg.linesCount()-1) {
						from = getSender(msg.lineAt(start));
						start++;
					} else {
						continue;
					}
					// Leer y extrar comandos
					for (int l = 0; l < msg.linesCount(); l++) {
						// Identificar el protocolo y enviarlo
						//     al broker concreto para el protocolo.
						//if (msg.lineAt(l).startsWith("#Broken#")) {
						//	cmd = msg.lineAt(l).substring(8);
							cmd = msg.lineAt(l);
							pos = cmd.indexOf("#");
							if (pos == -1)
								continue;
							service = cmd.substring(0,pos);
							pos = cmd.toLowerCase().indexOf("mailer#");
							if (pos == -1)
								cmd += "#mailer#do";
							wi = new WorkItem(from,service,cmd);
							if (rwq.add(wi)) 
								System.out.println("Trabajo sometido: "+cmd);
							else {
								System.out.println("Trabajo no aceptado: "+cmd);
								FileOutputStream fout = new FileOutputStream ("error.mme");
								fout.write("Subject: Robomail error\r\n\r\n".getBytes());
								fout.write("Su peticin no ha sido aceptada.\r\n".getBytes());
								fout.write("Verifique la sintaxis del comando o pngase en contacto con e personal responsable del servicio.\r\n".getBytes());
								fout.write(cmd.getBytes());								
								fout.close();
								WorkResult wr = new WorkResult("error.mme",false);
								wi = new WorkItem (from,"mailer","mailer#do",wr);
								rwq.add(wi);
							}
						//}
					}
				}
				for (int n = 1; n <= _list.size(); n++)
					pop3.dele(n);
				pop3.quit();
				Thread.sleep(300000);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void config ( Properties cfg )
	{
		ini = cfg;
	}
	
	public Properties config ()
	{
		return ini;
	}
	
	public void launch ()
	{
		String server, user, pass;

		if (ini != null) {
			server = ini.getProperty("SERVER","pop3.terra.es");
			user = ini.getProperty("USER","robomail.terra.es");
			pass = ini.getProperty("PASS","botmail");
		} else {
			server = "pop3.terra.es";
			user = "robomail.terra.es";
			pass = "botmail";
		}
		
		try {
			init(server,user,pass,"127.0.0.1");
			start();
			join();
		} catch (Exception e) {
		}
	}
	
	public static void main (String[] args)
		throws Exception
	{
		String host, server, user, pass;
		try {
			host = args[0];
		} catch (ArrayIndexOutOfBoundsException aioobe) {
			host = "127.0.0.1";
		}
		try {
			server = args[1];
		} catch (ArrayIndexOutOfBoundsException aioobe) {
			server = "pop3.terra.es";
		}
		try {
			user = args[2];
		} catch (ArrayIndexOutOfBoundsException aioobe) {
			user = "robomail.terra.es";
		}
		try {
			pass = args[3];
		} catch (ArrayIndexOutOfBoundsException aioobe) {
			pass = "botmail";
		}
		Broken broken = new Broken(server,user,pass,host);
		broken.start();
		broken.join();
	}
}
