

#include <Windows.H>

#include "ProcMem.H"
#include "InjLib.h"

typedef void ( *PROCSETACCOUNT)(char* Account);


extern char Account[255];
//////////////////////////////////////////////////////////////


#define ORD_LoadLibraryA "LoadLibraryA" 
//((LPCSTR) MAKEINTRESOURCE(0x190))
#define ORD_LoadLibraryW "LoadLibraryW"
//	((LPCSTR) MAKEINTRESOURCE(0x193))
#define ORD_FreeLibrary  "FreeLibrary"

#define ORD_GetModuleHandleA "GetModuleHandleA"
//		((LPCSTR) MAKEINTRESOURCE(0x98))
#define ORD_GetModuleHandleW "GetModuleHandleW"

#define ORD_GetProcAddress "GetProcAddress"

typedef HINSTANCE (WINAPI *PROCLOADLIBRARY)(LPBYTE);
typedef BOOL (WINAPI *PROCFREELIBRARY)(HINSTANCE);
typedef HMODULE (WINAPI* PROCGETMODULEHANDLE)(LPBYTE);

typedef PVOID (WINAPI* PROCGETPROCADDRESS)(HINSTANCE,LPBYTE);


typedef struct {
	PROCLOADLIBRARY fnLoadLibrary;
	PROCFREELIBRARY fnFreeLibrary;
	PROCGETPROCADDRESS fnGetProcAddress;
	BYTE pbLibFile[MAX_PATH * sizeof(WCHAR)];
	char Account[255];
	char FuncName[32];
} INJLIBINFO, *PINJLIBINFO;

typedef struct {
	PROCGETMODULEHANDLE fnGetModuleHandle;
	PROCFREELIBRARY fnFreeLibrary;
	BYTE pbLibFile[MAX_PATH * sizeof(WCHAR)];
} UNINJLIBINFO, *PUNINJLIBINFO;

//////////////////////////////////////////////////////////////


#pragma check_stack (off)

static DWORD WINAPI ThreadFuncAttach(PINJLIBINFO pInjLibInfo) {
	HINSTANCE hinstLib;
	PROCSETACCOUNT fnSetAccount;

	hinstLib = pInjLibInfo->fnLoadLibrary(pInjLibInfo->pbLibFile);
	fnSetAccount = (PROCSETACCOUNT)pInjLibInfo->fnGetProcAddress(hinstLib,(PUCHAR)pInjLibInfo->FuncName);



	if(fnSetAccount) fnSetAccount(pInjLibInfo->Account);

	return((DWORD) hinstLib);
}


//////////////////////////////////////////////////////////////

static void AfterThreadFuncAttach(void) {
}


//////////////////////////////////////////////////////////////
static DWORD WINAPI ThreadFuncDetach(PUNINJLIBINFO pUnInjLibInfo) {
	HMODULE hModuleLib;
	BOOL result=0;

	hModuleLib = pUnInjLibInfo->fnGetModuleHandle(pUnInjLibInfo->pbLibFile);

	

	if (hModuleLib != NULL)  {
		result = 
		pUnInjLibInfo->fnFreeLibrary(hModuleLib);
				
	}

	return result;
}
/////////////////////////////////////////////////////////////////////
static void AfterThreadFuncDetach(void) {
}
#pragma check_stack 
///////////////////////////////////////////////////////

static  HINSTANCE InjectLibWorA (HANDLE hProcess,
	const BYTE * const pbLibFile, BOOL fUnicode) {

	HINSTANCE hinstKrnl = GetModuleHandle(__TEXT("Kernel32"));

	INJLIBINFO InjLibInfo = {
		(PROCLOADLIBRARY) GetProcAddress(hinstKrnl,
			(fUnicode ? ORD_LoadLibraryW : ORD_LoadLibraryA)),

		(PROCFREELIBRARY) GetProcAddress(hinstKrnl, ORD_FreeLibrary),
		(PROCGETPROCADDRESS) GetProcAddress(hinstKrnl, ORD_GetProcAddress),
		0,	// The pbLibFile member is initialized later.
		0,
		0
	};


	PDWORD pdwCodeRemote = NULL;

	const int cbCodeSize = ((LPBYTE) AfterThreadFuncAttach - (LPBYTE) ThreadFuncAttach);

	PINJLIBINFO pInjLibInfoRemote = NULL;

	DWORD dwNumBytesXferred = 0;

	DWORD dwThreadId = 0;
	const DWORD cbMemSize = cbCodeSize + sizeof(InjLibInfo) + 3;
	HANDLE hThread = NULL;
	HINSTANCE hinstDLLRemote = NULL;

	BOOL fOk = FALSE;
	DWORD dwOldProtect;

	__try {
		strcpy(InjLibInfo.Account,Account);
		strcpy(InjLibInfo.FuncName,"SetAccount");

		if (fUnicode)
			wcscpy((LPWSTR) InjLibInfo.pbLibFile, (LPCWSTR) pbLibFile);
		else
			strcpy((LPSTR) InjLibInfo.pbLibFile, (LPCSTR) pbLibFile);

		pdwCodeRemote = (PDWORD) AllocProcessMemory(hProcess, 
			cbMemSize);

		if (pdwCodeRemote == NULL)
			__leave;

		fOk = VirtualProtectEx(hProcess, pdwCodeRemote, cbMemSize,
				PAGE_EXECUTE_READWRITE, &dwOldProtect);
		if (!fOk)
			__leave;

		fOk = WriteProcessMemory(hProcess, pdwCodeRemote,
			(LPVOID) ThreadFuncAttach, cbCodeSize, &dwNumBytesXferred);
		if (!fOk)
			__leave;

		pInjLibInfoRemote = (PINJLIBINFO) 
			(pdwCodeRemote + ((cbCodeSize + 4) & ~3));

		fOk = WriteProcessMemory(hProcess, pInjLibInfoRemote,
			&InjLibInfo, sizeof(InjLibInfo), &dwNumBytesXferred);
		if (!fOk)
			__leave;


		hThread = CreateRemoteThread(hProcess, NULL, 0, 
			(LPTHREAD_START_ROUTINE) pdwCodeRemote,
			pInjLibInfoRemote, 0, &dwThreadId);
		if (hThread == NULL)
			__leave;

		ResumeThread(hThread);

		WaitForSingleObject(hThread, INFINITE);
	}	// __try
	__finally {
		if (hThread != NULL) {
			GetExitCodeThread(hThread, (PDWORD) &hinstDLLRemote);
			CloseHandle(hThread);
		}

		FreeProcessMemory(hProcess, pdwCodeRemote);
	}	//__finally

	return hinstDLLRemote ;
}

static BOOL UnInjectLibWorA (HANDLE hProcess,
	const BYTE * const pbLibFile, BOOL fUnicode) {

	HINSTANCE hinstKrnl = GetModuleHandle(__TEXT("Kernel32"));

	UNINJLIBINFO UnInjLibInfo = {
		(PROCGETMODULEHANDLE) GetProcAddress(hinstKrnl,
			(fUnicode ? ORD_GetModuleHandleW : ORD_GetModuleHandleA)),
		
		(PROCFREELIBRARY) GetProcAddress(hinstKrnl, ORD_FreeLibrary),
		0	// The pbLibFile member is initialized later.
	};

	PDWORD pdwCodeRemote = NULL;

	const int cbCodeSize = ((LPBYTE) AfterThreadFuncDetach - (LPBYTE) ThreadFuncDetach);

	PUNINJLIBINFO pUnInjLibInfoRemote = NULL;

	DWORD dwNumBytesXferred = 0;

	DWORD dwThreadId = 0;
	const DWORD cbMemSize = cbCodeSize + sizeof(UnInjLibInfo) + 3;
	HANDLE hThread = NULL;
	BOOL FreeLibResult=NULL;

	BOOL fOk = FALSE;
	DWORD dwOldProtect;

	__try {
		
		if (fUnicode)
			wcscpy((LPWSTR) UnInjLibInfo.pbLibFile, (LPCWSTR) pbLibFile);
		else
			strcpy((LPSTR) UnInjLibInfo.pbLibFile, (LPCSTR) pbLibFile);


		pdwCodeRemote = (PDWORD) AllocProcessMemory(hProcess, 
			cbMemSize);

		if (pdwCodeRemote == NULL)
			__leave;

		fOk = VirtualProtectEx(hProcess, pdwCodeRemote, cbMemSize,
				PAGE_EXECUTE_READWRITE, &dwOldProtect);
		if (!fOk)
			__leave;

		fOk = WriteProcessMemory(hProcess, pdwCodeRemote,
			(LPVOID) ThreadFuncDetach, cbCodeSize, &dwNumBytesXferred);
		if (!fOk)
			__leave;


		pUnInjLibInfoRemote = (PUNINJLIBINFO) 
			(pdwCodeRemote + ((cbCodeSize + 4) & ~3));

		fOk = WriteProcessMemory(hProcess, pUnInjLibInfoRemote,
			&UnInjLibInfo, sizeof(UnInjLibInfo), &dwNumBytesXferred);
		if (!fOk)
			__leave;


		hThread = CreateRemoteThread(hProcess, NULL, 0, 
			(LPTHREAD_START_ROUTINE) pdwCodeRemote,
			pUnInjLibInfoRemote, 0, &dwThreadId);
		if (hThread == NULL)
			__leave;

		ResumeThread(hThread);

		WaitForSingleObject(hThread, INFINITE);
	}	// __try
	__finally {
		if (hThread != NULL) {
			GetExitCodeThread(hThread, (PDWORD) &FreeLibResult);
			CloseHandle(hThread);
		}

		FreeProcessMemory(hProcess, pdwCodeRemote);
	}	//__finally

	return FreeLibResult;
}

//////////////////////////////////////////////////////////////


HINSTANCE InjectLibA (HANDLE hProcess, LPCSTR lpszLibFile) {

	return(InjectLibWorA(hProcess, (LPBYTE) lpszLibFile, FALSE));
}


//////////////////////////////////////////////////////////////


HINSTANCE InjectLibW (HANDLE hProcess, LPCWSTR lpszLibFile) {

	return(InjectLibWorA(hProcess, (LPBYTE) lpszLibFile, TRUE));
}
//////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////


BOOL UnInjectLibA (HANDLE hProcess, LPCSTR lpszLibFile) {

	return(UnInjectLibWorA(hProcess, (LPBYTE) lpszLibFile, FALSE));
}

//////////////////////////////////////////////////////////////


BOOL UnInjectLibW (HANDLE hProcess, LPCWSTR lpszLibFile) {

	return(UnInjectLibWorA(hProcess, (LPBYTE) lpszLibFile, TRUE));
}
//////////////////////////////////////////////////////////////


