#include <stdio.h>
#define MAX_BUF 4096 // bigger = faster!
#define UINT unsigned int

// GETINF.EXE ( | MORE ) ( > STRING.TXT ) ( > PRN ) ( WHATEVER )

// Here is a simple structure to extract the data. 
typedef struct {
        char cZero1;
        char cZero2;
        char cSrcLen;
        char cZero3;
        char cDstLen;
        char cZero4;
        char szText[512];
} uData;

typedef uData *pHeader; // a pointer to the structure

char *pzCheckCur(char *pzPos); // check current structure
UINT iParseBuf(char *szBuffer, UINT iTop); // parses the current buffer
void ProcessFile(FILE *fFile); // processes entire file
int  iIsString(char *szString); // is it a text string? 

main (int argc, char **argv)
{
        FILE *fFile;

        if (argc < 2) abort(); // ugly hack
        if (!(fFile = fopen(argv[1],"rb"))) abort(); // who needs a message?
        ProcessFile(fFile);
        return 1;
}

int iIsString(char *szString)
{
    char *pzS;
    pzS = szString;
    while (*pzS != '\0')
    {
       if ((int)*pzS < 0x20) return 0;
       if ((int)*pzS++ > 0x7f) return 0;
    }
    return 1;
}

// basically, keep loading MAX_BUF sized chunks until EOF 
void ProcessFile(FILE *fFile)
{
        char szBuffer[MAX_BUF];
        UINT  iChar, iOffset;

        iOffset = 0;
        while ((iChar = fgetc(fFile)) != EOF)
        {
                szBuffer[iOffset] = (char)iChar;
                if (++iOffset == (MAX_BUF-1)) {
                   iOffset = iParseBuf(szBuffer, iOffset);
                }
        }
        if (iOffset > 0) iOffset = iParseBuf(szBuffer, iOffset);
        return;
}

// process the buffer. if we get close enough to the end that an entire
// structure won't fit, shift it to the beginning and tag more junk from the
// file onto the back
UINT iParseBuf(char *szBuffer, UINT iTop)
{
        char *pzBuffer, *pzCopy;
        UINT iOffset, iCur;

        pzBuffer = szBuffer;
        iCur = 0;
        while (iCur < iTop)
        {
                pzBuffer = pzCheckCur(pzBuffer);
                iCur = (UINT)(pzBuffer - szBuffer);
                if ((iTop - iCur) < sizeof(uData))
                {
                   iOffset = iTop - iCur;
                   pzCopy = szBuffer;
                   while (iCur++ < iTop)
                      *pzCopy++ = *pzBuffer++;
                   return iOffset;
                }
        }
        return 0;
}



char *pzCheckCur(char *pzPos)
{
        pHeader pStruct;
        char *pzSrc, *pzVal, *pzText, *pzEnd; 
        char szSrc[256], szVal[256];
        char cLocSrc, cLocDst;
        UINT iOffset, iIter, iSrc, iDst;
        short *psVal;
        int *piVal;

      // point the structure to the current memory position
        pStruct = (pHeader)pzPos;
        pzSrc = szSrc;
        pzVal = szVal;

      // if these aren't zero, we don't have a valid structure
        if (pStruct->cZero1 | pStruct->cZero2 | pStruct->cZero3 |
            pStruct->cZero4) return ++pzPos;

      // move to a local so the casting doesn't overflow
        cLocSrc = pStruct->cSrcLen;
        cLocDst = pStruct->cDstLen;

      // cast to unsigned int
        iSrc = (UINT)cLocSrc;
        iDst = (UINT)cLocDst;

      // leave if out of range
        if (iSrc <= 1 || iDst <= 1) return ++pzPos;
        if (iSrc > 254 || iDst > 254) return ++pzPos;

      // a valid structure has 0x01 - 0x04
        iOffset = iSrc + iDst;
        pzEnd = pStruct->szText + iOffset;
        if (*(char *)pzEnd == (char)0x0) return ++pzPos;
        if (*(char *)pzEnd > (char)0x04) return ++pzPos;

      // build text strings from the structure
        iIter = 0;
        pzText = pStruct->szText;
        while (iIter++ < (UINT)cLocSrc)
                *pzSrc++ = *pzText++;
        *pzSrc = '\0';
        while (iIter++ <= iOffset)
                *pzVal++ = *pzText++;
        *pzVal = '\0';

       // print it, then return the end of the structure
        if (iIsString(szVal))
           printf("%s = %s\n",szSrc,szVal);
        else {
           if (iSrc == 4) {
               psVal = (short *)szVal;
               printf("%s = %d\n",szSrc,*psVal);
           }
           else if (iSrc == 8) {
               piVal = (int *)szVal;
               printf("%s = %d\n",szSrc,*piVal);
           }
           else printf("%s = ?\n",szSrc);
        }
        return (char *)pzEnd;
}






