; for v3.22 and v3.23

; some symbols to make the code more readable

%define WINICE_VERSION 0x322

%if WINICE_VERSION = 0x322
WINICE_BASE	EQU 0		; needs to be fixed in reloc table
WINICE_DELTA	EQU 5		; special Winice code/data segment base

PAGEIN_R0	EQU 0xD1512	;'PMR0'

PAGEIN_PM	EQU 0xD1501	;'PMCB'
PMCB_SEG	EQU 0x7D80A	;'PMCS'
PMCB_OFF	EQU 0x7D805	;'PMCO'

PAGEIN_V86	EQU 0xD14C8	;'VMCB'
V86CB_SEG	EQU 0x7D7CD	;'VMCS'
V86CB_OFF	EQU 0x7D7C8	;'VMCO'

pSaveRegs	EQU 0x861F3
pRestoreRegs	EQU 0x8628A
pSkipWord	EQU 0x12F53
pSkipWhiteSpace	EQU 0x0B83C
pExp2Int	EQU 0x0C01D

wWINICE_CODE	EQU 0x00009
oINT3		EQU 0x861EC

dClient_EAX	EQU 0x0FFD1
dClient_EBX	EQU 0x0FFD5
dClient_ECX	EQU 0x0FFD9
dClient_EDX	EQU 0x0FFDD
dClient_ESI	EQU 0x0FFE1
dClient_EDI	EQU 0x0FFE5
dClient_EBP	EQU 0x0FFE9
dClient_ESP	EQU 0x0FFED
dClient_EIP	EQU 0x0FFF1
dClient_EFLAGS	EQU 0x0FFF5
dClient_CS	EQU 0x0FFF9
dClient_DS	EQU 0x0FFFD
dClient_SS	EQU 0x10001
dClient_ES	EQU 0x10005
dClient_FS	EQU 0x10009
dClient_GS	EQU 0x1000D

fExecMoreCmds	EQU 0x06731
fDoingPAGEIN	EQU 0x86633
oPAGEIN_INT3	EQU 0x8667F
%endif

%if WINICE_VERSION = 0x323
WINICE_BASE	EQU 0		; needs to be fixed in reloc table
WINICE_DELTA	EQU 5		; special Winice code/data segment base

PAGEIN_R0	EQU 0xD6522	; 'PMR0'

PAGEIN_PM	EQU 0xD6511	; 'PMCB'
PMCB_SEG	EQU 0x7E5F1	; 'PMCS'
PMCB_OFF	EQU 0x7E5EC	; 'PMCO'

PAGEIN_V86	EQU 0xD64D8	; 'VMCB'
V86CB_SEG	EQU 0x7E5B4	; 'VMCS'
V86CB_OFF	EQU 0x7E5AF	; 'VMCO'

pSaveRegs	EQU 0x895CB
pRestoreRegs	EQU 0x89662
pSkipWord	EQU 0x1322E
pSkipWhiteSpace	EQU 0x0B96C
pExp2Int	EQU 0x0C14D

wWINICE_CODE	EQU 0x00009
oINT3		EQU 0x895C4

dClient_EAX	EQU 0x10205
dClient_EBX	EQU 0x10209
dClient_ECX	EQU 0x1020D
dClient_EDX	EQU 0x10211
dClient_ESI	EQU 0x10215
dClient_EDI	EQU 0x10219
dClient_EBP	EQU 0x1021D
dClient_ESP	EQU 0x10221
dClient_EIP	EQU 0x10225
dClient_EFLAGS	EQU 0x10229
dClient_CS	EQU 0x1022D
dClient_DS	EQU 0x10231
dClient_SS	EQU 0x10235
dClient_ES	EQU 0x10239
dClient_FS	EQU 0x1023D
dClient_GS	EQU 0x10241

fExecMoreCmds	EQU 0x067E5
fDoingPAGEIN	EQU 0x89A0B
oPAGEIN_INT3	EQU 0x89A57
%endif


; common stuff

R0_OPENCREATFILE	EQU 0xD500
R0_WRITEFILE		EQU 0xD601
R0_CLOSEFILE		EQU 0xD700

; Client Register Structure as passed to V86/PM CallBacks
struc CRS
Client_EDI	resd 1		; 0
Client_ESI	resd 1		; 4
Client_EBP	resd 1		; 8
Client_res0	resd 1		; C
Client_EBX	resd 1		; 10
Client_EDX	resd 1		; 14
Client_ECX	resd 1		; 18
Client_EAX	resd 1		; 1C
Client_Error	resd 1		; 20
Client_EIP	resd 1		; 24
Client_CS	resw 1		; 28
Client_res1	resw 1		; 2C
Client_EFlags	resd 1		; 30
Client_ESP	resd 1		; 34
Client_SS	resw 1		; 38
Client_res2	resw 1
Client_ES	resw 1		; 3C
Client_res3	resw 1
Client_DS	resw 1		; 40		
Client_res4	resw 1
Client_FS	resw 1		; 44
Client_res5	resw 1
Client_GS	resw 1		; 48
Client_res6	resw 1
Client_Alt_EIP	resd 1		; 4C
Client_Alt_CS	resw 1		; 50
Client_res7	resw 1
Client_Alt_EFlags	resd 1
Client_Alt_ESP	resd 1
Client_Alt_SS	resw 1
Client_res8	resw 1
Client_Alt_ES	resw 1
Client_res9	resw 1
Client_Alt_DS	resw 1
Client_res10	resw 1
Client_Alt_FS	resw 1
Client_res11	resw 1
Client_Alt_GS	resw 1
Client_res12	resw 1
endstruc
