%include "icedump.inc"

; ------------------------------------------------------------------------------
; this piece of code executes while Winice is being initialized (DEVICE_INIT).
; it allocates callbacks used for ring transitions.
; ------------------------------------------------------------------------------

; ------------------------------------------------------------------------------
; the basic idea behind the original PAGEIN is that Winice lets the client
; resume execution at a CS:EIP other than the current one (of course, the
; current state of the client registers will be saved and restored later).

; at the new CS:EIP we can find nothing else but a simple "MOV AL,[EBX]" which
; will trigger a page fault that will be handled by the VMM (bring in the page).
; of course, the client's EBX has previously been set to the address specified
; in the PAGEIN command. next a special INT3 ('cos its address is saved in an
; internal Winice variable and subsequently examined in Winice's INT3 handler)
; is executed which will be cought by Winice and control will be returned to the
; debugger. btw, the address of the page faulting instruction is also saved
; so that Winice's page fault handler wouldn't intervene when it occurs.

; the importance of this entire mechanism is that basically we have the means
; of executing arbitrary instructions in the client's context from within
; Winice. this is very similar to the nested execution concept in the VxD world,
; but this time we have a system debugger controlling the entire system, so we
; cannot rely on the VMM services.

; anyway, this is how i came up with the idea of my Winice dumper. of course,
; there were a few things left to be fixed before it would work as expected.

; first of all, i needed to find ways to support all execution modes in Win9x.
; the original PAGEIN supported 32 bit modes only (both ring-3 and ring-0).
; "support" in this context means that before resuming execution of the client
; the debugger has to set up the client's registers. here's a detailed list of
; my solution for supporting each possible execution mode:

; V86
; during Winice initialization i allocate a V86 CallBack and in the PAGEIN
; parser i modify the client's CS:IP to this V86CB. this will transfer control
; to the ring-0 code whose address i specified when i allocated the V86CB.
; not too suprisingly, the ring-0 code does then the actual memory dump. there
; is actually a little more to this as in this special case, i have to find an
; INT3 where the V86CB can return to (it has to be in the first 1 meg of the
; linear address space). see the dumper code for details.

; ring-3 PM
; during Winice initialization i allocate a PM CallBack and in the PAGEIN
; parser i modify the client CS:(E)IP to this PMCB. so, this is very much like
; the V86 case, except here i don't need to hunt for an INT3 'cos i have one
; inside Winice itself.

; note one fine point in the choice of using CallBacks for ring transitions:
; we won't mess up the client's address space (most notably its stack). the
; original PAGEIN placed that MOV mentioned earlier onto the client's stack
; to support ring-3 mode (ring-0 support works like mine). this is not only
; ugly (besides the obvious traces on the client's stack, it will even fail
; if the stack happens to be paged out ;-) but rather unnecessary as well.

; ring-0 PM
; support for this one is rather straightforward, i just need to modify the
; client EIP to the address of the ring-0 dumper routine. well, as you can see
; it in the dumper code, i have to emulate the client register structure (so
; that the same code could be used for dumping) on the stack before i can
; actually execute the dumper itself.
; ------------------------------------------------------------------------------


; ------------------------------------------------------------------------------
; callback addresses are stored directly into the PAGEIN parser code which in
; turn will load them into the client CS:(E)IP registers
; ------------------------------------------------------------------------------

	BITS 32

%if WINICE_VERSION = 0x322
	ORG 0x7D72D
%elif WINICE_VERSION = 0x323
	ORG 0x7E514
%else
	ORG NotSupportedVersion
%endif

init
	mov	edx,WINICE_BASE		; reloc: offset 0
	lea	esi,[edx+PAGEIN_PM]	; offset of entryPMCB
	db 0xCD,0x20,0x0C,0x00,0x01,0x00; VMMcall Allocate_PM_Call_Back
	jnb	.gotPMCB

	xor	eax,eax			; oops...

.gotPMCB
	movzx	ebx,ax
	mov	[edx+PMCB_OFF],ebx
	shr	eax,16
	mov	[edx+PMCB_SEG],eax

	lea	esi,[edx+PAGEIN_V86]	; offset of entryV86CB
	db 0xCD,0x20,0x0B,0x00,0x01,0x00; VMMcall Allocate_V86_Call_Back
	jnb	.gotV86CB

	xor	eax,eax			; oops...

.gotV86CB
	movzx	ebx,ax
	mov	[edx+V86CB_OFF],ebx
	shr	eax,16
	mov	[edx+V86CB_SEG],eax
	retn
