// TryParms.cpp : implementation file
//

#include "stdafx.h"
#include "uncontraband.h"
#include "TryParms.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAXOFFS		11
#define MAXBLOCK	12
#define MAXRESULTS	1024

struct autosearch {
	int			offsindex;
	int			blocksize;
	int			key;
};

struct BmHdr {
  BITMAPFILEHEADER h1;
  BITMAPINFOHEADER h2;
}						header;

unsigned long			scanlinesize;
int						wastedperline;
unsigned long			maxfiledata;
int						offscnt;
unsigned long			filelength [MAXOFFS];
int						lengthoffs [MAXOFFS];
int						offsindex = -1;
int						blckindex = 0;

int						nresults;
autosearch				results [1024];

/////////////////////////////////////////////////////////////////////////////
// CTryParms dialog


CTryParms::CTryParms(FILE *inp, FILE *out, int automode, unsigned long srclen, int srcstring, char *string, int exact, CWnd* pParent /*=NULL*/)
	: CDialog(CTryParms::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTryParms)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_inp = inp;
	m_out = out;
	m_automode = automode;
	m_srclen = srclen;
	m_srcstring = srcstring;
	m_string = string;
	m_exact = exact;
}


void CTryParms::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTryParms)
	DDX_Control(pDX, IDC_RESULTS, m_results);
	DDX_Control(pDX, IDC_VALIDKEYS, m_validkeys);
	DDX_Control(pDX, IDOK, m_ok);
	DDX_Control(pDX, IDC_OFFS, m_offs);
	DDX_Control(pDX, IDC_KEYS, m_keys);
	DDX_Control(pDX, IDC_BLOCKSIZE, m_block);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTryParms, CDialog)
	//{{AFX_MSG_MAP(CTryParms)
	ON_CBN_SELCHANGE(IDC_BLOCKSIZE, OnSelchangeBlocksize)
	ON_CBN_SELCHANGE(IDC_OFFS, OnSelchangeOffs)
	ON_LBN_SELCHANGE(IDC_KEYS, OnSelchangeKeys)
	ON_CBN_SELCHANGE(IDC_RESULTS, OnSelchangeResults)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTryParms message handlers

void CTryParms::OnSelchangeBlocksize() 
{
	// TODO: Add your control notification handler code here
	blckindex = m_block.GetCurSel ();
	TryDecode ();
}

void CTryParms::OnSelchangeOffs() 
{
	// TODO: Add your control notification handler code here
	
	int sel = m_offs.GetCurSel ();
	if (sel >= 0 && !filelength [sel]) {
		m_offs.SetCurSel (offsindex);
	} else {
		offsindex = sel;
	}
	TryDecode ();
}

void CTryParms::ShowKeys () {
	int		k = m_keys.GetCurSel ();
	int		n;

	m_validkeys.ResetContent ();
	if (offsindex < 0) return;
	for (n = k; n < 10000; n += 0x100) {
		int		a, b, c, d;
		char	buf [100];

		d = n;
		d -= 1001 * (a = d / 1001);
		d -=  100 * (b = d / 100);
	    if (b % 4 != blckindex) continue;
		if ((a + b) % 11 != lengthoffs [offsindex]) continue;
		d -=   10 * (c = d / 10);
		sprintf (buf, "%d %d %d %d", a, b, c, d);
		m_validkeys.AddString (buf);
	}
	m_validkeys.SetCurSel (0);
}

void CTryParms::OnSelchangeKeys() 
{
	// TODO: Add your control notification handler code here

	m_ok.EnableWindow (TRUE);
	ShowKeys ();
}

BOOL CTryParms::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// TODO: Add extra initialization here
	
	m_ok.EnableWindow (FALSE);
	offsindex = -1;
	blckindex = 0;
	fseek (m_inp, 0, SEEK_SET);
	if (fread (&header, 1, sizeof (header), m_inp) != sizeof (header)) {
		char msg [50];
		wsprintf (msg, "Error reading %d bytes\nError: %s", sizeof (header), strerror (errno));
		MessageBox (msg);
		EndDialog (0);
		return FALSE;
	}
	else if (strncmp ((char *) &header, "BM", 2)) {
		MessageBox ("Not a bitmap file");
		EndDialog (0);
		return FALSE;
	}
	else if (header.h2.biBitCount != 24) {
		MessageBox ("Not a 24 bit bitmap file");
		EndDialog (0);
		return FALSE;
	}
	else if (header.h2.biCompression != BI_RGB) {
		MessageBox ("Cannot work on a compressed file");
		EndDialog (0);
		return FALSE;
	}
	// SetCursor (IDC_WAIT);
	scanlinesize  = header.h2.biWidth * 3;
	wastedperline = 0;
	if (scanlinesize % 4) {
		wastedperline = 4 - (scanlinesize % 4);
	}
	maxfiledata  = (header.h1.bfSize - 32 - 10 - header.h1.bfOffBits - header.h2.biHeight * wastedperline) / 8;
	char	buf [42];
	fseek (m_inp, header.h1.bfOffBits, SEEK_SET);
	fread (&buf, sizeof (buf), 1, m_inp);
	offscnt = 0;
	for (int offs = 0; offs < MAXOFFS; offs++) {
		unsigned long len = 0;
		for (int i = 31; i >= 0; i--) {
			len <<= 1;
			len |= (buf [offs + i] & 1);
		}
		if (len > maxfiledata) continue;
		filelength [offscnt] = len;
		lengthoffs [offscnt] = offs;
		if (offsindex < 0 || len < filelength [offsindex]) offsindex = offscnt;
		offscnt++;
		char line [50];
		wsprintf (line, "%02d - %d bytes%s", offs, len, len ? "" : " (not compatible)");
		m_offs.AddString (line);
	}
	m_block.AddString ("8 bits");
	m_block.AddString ("9 bits");
	m_block.AddString ("10 bits");
	m_block.AddString ("11 bits");
	m_offs.SetCurSel (offsindex);
	m_block.SetCurSel (blckindex);
	if (m_automode) {
		AutoSearch ();
	} else {
		m_results.EnableWindow (0);
		if (offsindex >=0) TryDecode ();
	}
	// SetCursor (IDC_ARROW);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CTryParms::ReadData (int ofs_index, int blocksize, char **data, unsigned long *size) {
	char			*buf;
	unsigned long	len;
	unsigned long	dlen;
	char			wasted [4];
	unsigned long	readdata;
	unsigned long	readlen, bytesread;

	len = filelength [ofs_index];
	if (!len) return 0;
	dlen = len * blocksize + 32 + lengthoffs [ofs_index];
	if (!(*data = (char *) malloc (len))) return 0;
	if (!(buf  = (char *) malloc (dlen))) { free (*data); return 0; }
	fseek (m_inp, header.h1.bfOffBits, SEEK_SET);
	for (readdata = 0; readdata < dlen; readdata += readlen) {
		readlen = dlen - readdata;
		if (readlen > scanlinesize) readlen = scanlinesize;
		bytesread = fread (&buf [readdata], 1, readlen, m_inp);
		if (bytesread < readlen) {
			free (*data);
			free (buf);
			return 0;
		}
		fread (wasted, 1, wastedperline, m_inp);
	}
	long ipos, opos;
	ipos = 32 + lengthoffs [ofs_index];
	opos = 0;
	*size = 0;
	memset (*data, 0, len);
	while (*size < len) {
		for (int i = 7; i >= 0; i--) {
			(*data) [opos] = ((*data) [opos] << 1) | (buf [ipos + i] & 1); 
		}
		opos++;
		ipos += blocksize;
		++*size;
	}
	free (buf);
	return 1;
}

void CTryParms::Decode (char *data, unsigned long size, int key) {
	if (!data) return;
	for (unsigned long i = 0; i < size; i++) data [i] ^= key;
}


void CTryParms::TryDecode () {
	char			*data;
	unsigned long	size;
	char			buf [100];
	unsigned		len = sizeof (buf) - 1;
	char			line [256];

	if (!ReadData (offsindex, blckindex + 8, &data, &size)) return;
	if (size < len) len = size;
	m_keys.ResetContent ();
	m_validkeys.ResetContent ();
	for (int key = 0; key < 0x100; key++) {
		for (unsigned i = 0; i < len; i++) {
			buf [i] = data [i] ^ key;
		}
		buf [i] = 0;
		sprintf (line, "%02X: %s", key, buf);
		m_keys.AddString (line);
	}
	free (data);
}

void CTryParms::OnOK() 
{
	// TODO: Add extra validation here

	char			*data;
	unsigned long	size;
	int				key;

	key = m_keys.GetCurSel ();
	if (!ReadData (offsindex, blckindex + 8, &data, &size)) {
		MessageBox ("Error reading data");
		return;
	}
	Decode (data, size, key);
	fseek (m_out, 0, SEEK_SET);
	fwrite (data, 1, size, m_out);
	free (data);
	CDialog::OnOK();
}

void CTryParms::AutoSearch () {
	char				*data;
	unsigned long		 size;
	char				 buf [128];
	char				*scanbuf;
	int					 thislooksgood;
	unsigned			 srclen;
	char				*srcfor;
	char				*validset = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz,.;:-_<>[]{}+*/!$%&()=?^|<>\n\r\t \'\"\\";
	unsigned			 curlen;

	nresults = 0;
	m_results.ResetContent ();
	srcfor = strdup (m_string);
	if (!m_exact) strupr (srcfor);
	for (int i = 0; i < offscnt; i++) {
		srclen = m_srclen > filelength [i] ? filelength [i] : m_srclen;
		if (!(scanbuf = (char *) malloc (srclen + 1))) return;
		memset (scanbuf, 0, srclen + 1);
		for (int j = 0; j < 4; j++) {
			if (!ReadData (i, j + 8, &data, &size)) continue;
			for (int k = 0; k < 256; k++) {
  				memcpy (scanbuf, data, srclen);
				Decode (scanbuf, srclen, k);
				if ((curlen = strlen (scanbuf)) < srclen) continue;
				if (m_srcstring) {
					if (!m_exact) strupr (scanbuf);
					thislooksgood = (strstr (scanbuf, srcfor) != NULL);
				} else {
					thislooksgood = (strspn (scanbuf, validset) == curlen);
				}
				if (thislooksgood) {
					results [nresults].offsindex = i;
					results [nresults].blocksize = j;
					results [nresults].key       = k;
					nresults++;
					sprintf (buf, "Offset=%d Blocksize=%d Key=%02X", lengthoffs [i], j + 8, k);
					m_results.AddString (buf);
				}
			}
			free (data);
		}
		free (scanbuf);
	}
	free (srcfor);
	m_results.SetCurSel (0);
	OnSelchangeResults ();
}


void CTryParms::OnSelchangeResults() 
{
	// TODO: Add your control notification handler code here

	int i = m_results.GetCurSel ();
	offsindex = results [i].offsindex;
	blckindex = results [i].blocksize;
	m_offs.SetCurSel (offsindex);
	m_block.SetCurSel (blckindex);
	TryDecode ();
	m_keys.SetCurSel (results [i].key);
	OnSelchangeKeys ();
}
