// uncontrabandDlg.cpp : implementation file
//

#include "stdafx.h"
#include "uncontraband.h"
#include "uncontrabandDlg.h"
#include "TryParms.h"
#include "Options.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


char bmpfile [512];
char outfile [512];

/////////////////////////////////////////////////////////////////////////////
// CUncontrabandDlg dialog

CUncontrabandDlg::CUncontrabandDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUncontrabandDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUncontrabandDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_automode   = 1;
	m_srclen     = 100;
	m_srcstring  = 0;
	m_exactcase  = 0;
	m_string [0] = 0;

}

void CUncontrabandDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUncontrabandDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUncontrabandDlg, CDialog)
	//{{AFX_MSG_MAP(CUncontrabandDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SELBMP, OnSelbmp)
	ON_BN_CLICKED(IDC_SELOUT, OnSelout)
	ON_BN_CLICKED(IDC_TRY, OnTry)
	ON_BN_CLICKED(IDC_OPTIONS, OnOptions)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUncontrabandDlg message handlers

BOOL CUncontrabandDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUncontrabandDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUncontrabandDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUncontrabandDlg::OnSelbmp() 
{
	// TODO: Add your control notification handler code here
  CFileDialog dlg (TRUE, ".BMP", "",  OFN_HIDEREADONLY, "Bitmap files|*.bmp");
  if (dlg.DoModal ()) {
    strcpy (bmpfile, dlg.m_ofn.lpstrFile);
	SetDlgItemText (IDC_BMP, bmpfile);
  }
}

void CUncontrabandDlg::OnSelout() 
{
	// TODO: Add your control notification handler code here
  CFileDialog dlg (FALSE, ".TXT", "",  OFN_OVERWRITEPROMPT, "Text files|*.txt|All files|*.*");
  if (dlg.DoModal ()) {
    strcpy (outfile, dlg.m_ofn.lpstrFile);
	SetDlgItemText (IDC_OUT, outfile);
  }
	
}

void CUncontrabandDlg::OnTry() 
{
	// TODO: Add your control notification handler code here

	FILE	*fb, *fo;
	int		status;

	GetDlgItemText (IDC_BMP, bmpfile, sizeof (bmpfile));
	GetDlgItemText (IDC_OUT, outfile, sizeof (outfile));
	if (!*bmpfile || !*outfile) {
		MessageBox ("Missing file name");
		return;
	}
	fb = fopen (bmpfile, "rb");
	fo = fopen (outfile, "wb");
	if (!fb || !fo) {
		MessageBox ("Error opening i/o file(s)", "Error", MB_ICONSTOP);
	} else {
    	CTryParms	Try (fb, fo, m_automode, m_srclen, m_srcstring, m_string, m_exactcase, this);
		status = Try.DoModal ();
	}
	fclose (fb);
	fclose (fo);
}



void CUncontrabandDlg::OnOptions() 
{
	// TODO: Add your control notification handler code here

	COptions			OptDlg (&m_automode, &m_srclen, &m_srcstring, m_string, &m_exactcase, this);

	OptDlg.DoModal ();
}
