/* fives.c */
/* Takes text from standard input and writes to standard output.
   Output is written in capital letters in groups of five,
   ten groups to a line.
   Non-alphabetic characters from standard input are discarded.
   Exception: an asterisk is treated like a letter. This can be
   used to indicate damaged or missing letters. */


#include <stdio.h>
#include <ctype.h>

void
main ()
{
  int k, m = 0, n = 0;
  while ((k = getchar ()) != EOF)
    {
      k = toupper (toascii (k));
      if (isalpha (k) || (k == '*'))
        {
          if (n == 5)
            {
              n = 0, m++;
              putchar (' ');
            }
          if (m == 10)
            {
              putchar ('\n');
              m = 0;
            }
          putchar (k);
          n++;
        }
    }
  putchar ('\n');
}
