/* vigdec.c */
/* Decodes Vigenere preserving case, punctuation, non-
   alphabetics. Output to stdout. By J.W. Stumpel. Asterisks
   are considered to be "damaged letters" and advance the count. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define KEYMAX 50               /* max keylength */

char *usage =
"\nVigenere decoding program"
"\nUsage: vigenc [keyword] [ciphertext]"
"\nor vigenc [keyword] < ciphertext"
"\n[keyword] is case-insensitive\n";

void
tonumber (char *s)
{
  char k;
  while ((k = *s) != 0)
    {
      if (k > 'Z')
        k -= 'a';
      else
        k -= 'A';
      *s++ = k;
    }
}

char key[KEYMAX + 1];

int
main (int argc, char *argv[])
{
  int i, k, keylength;

  FILE *myinput = stdin;

  if (argc < 2)
    {
      fprintf (stderr, usage);
      return 1;
    }

  if (argc >= 2)
    {
      int OK = 1;
      keylength = strlen (argv[1]);
      if (keylength >= KEYMAX)
        {
          fprintf (stderr, "\nKey too long! Max %d chars\n", KEYMAX);
          return 2;
        }
      strcpy (key, argv[1]);
      for (i = 0; i < keylength; i++)
        if (!isalpha (key[i]))
          {
            OK = 0;
            break;
          }
      if (!OK)
        {
          fprintf (stderr, "\nKey must be alphabetical!\n");
          return 3;
        }
      tonumber (key);
    }

  if (argc >= 3)
    {
      myinput = fopen (argv[2], "r");
      if (!myinput)
        {
          fprintf (stderr, "\nFile not found!\n");
          return 4;
        }
    }

  i = 0;
  while ((k = fgetc (myinput)) != EOF)
    {
      if (isalpha (k))
        {
          if (k <= 'Z')
            {
              k -= key[i];
              if (k < 'A')
                k += 26;
            }
          else
            {
              k -= key[i];
              if (k < 'a')
                k += 26;
            }
          if (++i >= keylength)
            i = 0;
        }
      else if (k == '*')
        {
          if (++i >= keylength)
            i = 0;
        }
      putchar (k);
    }

  return 0;
}
