#include "windows.h"
#include "resource.h"
#include "bn.h"

#define MAX_NAME_LEN 0x64

char szCode[MAX_NAME_LEN]={0};
char szUser[MAX_NAME_LEN]={0};

unsigned long RSAhex;
unsigned char XORTable[4], toEncode[0x20], toDecode[0x20], ADDTable[]={10,9,10,6,6,9,9,10,9,9,0,0};

HANDLE hInst;

void	   EntryPoint();
void	   CenterDialog(HWND hwndDlg);
BOOL	   CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL	   CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
extern "C" void des_encode(void);

/* BEGIN OF PROTECTECTION ALGORITHM */

int INV(int byte)
{
	int k, i;

	i=byte&1;
	for (k=0; k<7; k++)
	{
		i<<=1;
		byte>>=1;
		i+=byte&1;
	}
	return i;
}

void Calculate()
{
	int k, i, x;
	unsigned short crc;
	BIGNUM *N=BN_new();
	BIGNUM *D=BN_new();
	BIGNUM *E=BN_new();
	BIGNUM *R=BN_new();
	BIGNUM *A=BN_new();
	BN_CTX *CTX=BN_CTX_new();

	/* verify if the usercode is correct and parse it */

	lstrcpy(szCode, szUser);
	if ((szCode[4]!=0x20)||(szCode[9]!=0x20)||(szCode[14]!=0x20)||(szCode[19]!=0x20)||(lstrlen(szCode)!=22))
	{
		lstrcpy(szCode, "Entered usercode is not in the correct format...");
		BN_CTX_free(CTX); BN_free(N); BN_free(D); BN_free(R); BN_free(A);
		return;
	}
	lstrcpyn(szUser, szCode, 5);
	lstrcpyn(szUser+4, szCode+5, 5);
	lstrcpyn(szUser+8, szCode+10, 5);
	lstrcpyn(szUser+12, szCode+15, 5);
	lstrcpy(szUser+16, szCode+20);
	for (k=0; k<9; k++)
	{
		lstrcpyn(szCode, szUser+(k*2), 3);
		i=strtoul(szCode, NULL, 0x10);
		toDecode[k]=i&0xFF;
	}

	/* des stuff, added in v4.0 beta    */

	static unsigned char DESpw1[8] = { 0xC7, 0x21, 0xF5, 0xE7, 0x67, 0x4C, 0xE9, 0xBD, };
	static unsigned char DESpw2[8] = { 0x7A, 0x16, 0x0C, 0x91, 0x7A, 0x06, 0x41, 0xF4, };
	static unsigned char DESpw3[8] = { 0x22, 0x04, 0x03, 0x8F, 0xE9, 0x5C, 0x35, 0xC9, };

	__asm
	{
		pushad
		mov  ebx, 3
	loop1:
		push 0
		push 17h
		lea  eax, toDecode+1
		lea  ecx, DESpw1
		xor  edx, edx
		call des_encode
		dec  ebx
		jne  loop1
	
		mov  ebx, 3
	loop2:
		push 0
		push 17h
		lea  eax, toDecode
		lea  ecx, DESpw3
		xor  edx, edx
		call des_encode
		dec  ebx
		jne  loop2
	
		mov  ebx, 3
	loop3:
		push 0
		push 17h
		lea  eax, toDecode+1
		lea  ecx, DESpw2
		xor  edx, edx
		call des_encode
		dec  ebx
		jne  loop3
	
		mov  ebx, 3
	loop4:
		push 0
		push 17h
		lea  eax, toDecode
		lea  ecx, DESpw1
		xor  edx, edx
		call des_encode
		dec  ebx
		jne  loop4
		popad
	}
	
	/* initialize bignum vars for rsa30
	   N = 123107
	   p = 307
	   q = 401
	   e = 229
	   d = 1069							*/

	BN_dec2bn(&N, "123107");
	BN_dec2bn(&D, "1069");
	BN_dec2bn(&E, "229");

	/* perform initial usercode decryption */

	__asm mov dword ptr [XORTable], 0xA3F667E4

	for (k=0; k<9; k++)
	{
		toDecode[k]^=XORTable[0];
		toDecode[k]^=XORTable[1];
		toDecode[k]^=XORTable[2];
		toDecode[k]^=XORTable[3];

		XORTable[3]^=XORTable[2];
		XORTable[2]^=XORTable[1];
		XORTable[1]^=XORTable[0];
		XORTable[0]^=toDecode[k];
	}

	/* perform rsa30 decryption on usercode */
	for (k=1, x=1; k<9; k+=2)
	{
		memcpy((unsigned char*)&RSAhex, (unsigned char*)(toDecode+k), 2);

		if (toDecode[0] & x)
		{
			RSAhex<<=8;
			RSAhex+=1;
			BN_bin2bn((unsigned char*)&RSAhex, 3, A);
		}
		else
			BN_bin2bn((unsigned char*)&RSAhex, 2, A);

		BN_mod_exp(R, A, D, N, CTX);
		RSAhex=0;
		i=BN_bn2bin(R, (unsigned char*)&RSAhex);

		if (i<2)
			RSAhex<<=8;

		memcpy((unsigned char*)(toDecode+k), (unsigned char*)&RSAhex, 2);
		x<<=1;
	}
	ZeroMemory(szCode, MAX_NAME_LEN);
	ZeroMemory(toEncode, 0x20);

	/* fill the array to be encoded with the needed values */
	//toEncode[1]=toDecode[1]^0x80;
	toEncode[1]=toDecode[1]&0x7F;
	toEncode[2]=(rand()%0x63)+1;
	
	toEncode[5]=0x02;
	toEncode[6]=0x00;
	toEncode[7]=0x00;
	toEncode[8]=0x80;
	toEncode[9]=0;
	toEncode[10]=0x80;

	toEncode[3]=toDecode[5];
	toEncode[4]=toDecode[6];
	for (k=0; k<12; k++)
		toEncode[3]+=ADDTable[k];
	for (k=0; k<12; k++)
		toEncode[4]+=ADDTable[k];
	
	/* generate and store checksum of array values */

	for (k=1, crc=0xFFFF; k<11; k++)
	{
		crc^=INV(toEncode[k])<<8;
		for (i=0; i<8; i++)
		{
			if (crc & 0x8000)
			{
				crc<<=1;
				crc^=0x8005;
			}
			else
				crc<<=1;
		}
	}
	toEncode[12]=INV(crc&0xFF);
	toEncode[11]=INV((crc&0xFF00)>>8);

	/* perform rsa30 encryption */

	for (k=11; k>=1; k-=2)
	{
		toEncode[0]<<=1;
		BN_bin2bn((unsigned char*)(toEncode+k), 2, A);

		RSAhex=0;
		i=BN_bn2bin(A, (unsigned char*)&RSAhex);

		if (RSAhex!=0)
		{
		BN_mod_exp(R, A, D, N, CTX);
		RSAhex=0;
		i=BN_bn2bin(R, (unsigned char*)&RSAhex);
		} else { RSAhex=0; i=2; };

		if (i<2)
			RSAhex<<=8;
		if (i>2)
		{
			RSAhex>>=8;
			toEncode[0]|=1;
		}
		memcpy((unsigned char*)(toEncode+k), (unsigned char*)&RSAhex, 2);		
	}	
	toEncode[0]&=0x7F;

	/* perform final encryption */

	__asm mov dword ptr [XORTable], 0xA3F667E4	

	for (k=0; k<13; k++)
	{
		i=toEncode[k];

		toEncode[k]^=XORTable[3];
		toEncode[k]^=XORTable[2];
		toEncode[k]^=XORTable[1];
		toEncode[k]^=XORTable[0];

		XORTable[3]^=XORTable[2];
		XORTable[2]^=XORTable[1];
		XORTable[1]^=XORTable[0];
		XORTable[0]^=i;
	}

	/* convert binary to hex string */

	szCode[0]=0;
	for (k=0; k<13; k++)
	{
		if ( ((k%2)==0) && (k!=0) ) lstrcat(szCode, " ");
		wsprintf(szCode+lstrlen(szCode), "%02X", toEncode[k]);
	}

	/* free the bignum variables */

	BN_CTX_free(CTX); BN_free(N); BN_free(D); BN_free(R); BN_free(A);
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length;

	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			srand(GetTickCount());
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_USERNO, WM_SETTEXT, NULL, (LPARAM)"000000000000");
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Enter your usercode in the editbox above...");
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:		
					Length = SendDlgItemMessage(hwndDlg, IDC_UCODE, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szUser);
					if (Length)
					{
						Calculate();
						SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						wsprintf(szCode, "%04d%04d%04d", rand()%10000, rand()%10000, rand()%10000);
						SendDlgItemMessage(hwndDlg, IDC_USERNO, WM_SETTEXT, NULL, (LPARAM)szCode);
					}
					else
					{
						SendDlgItemMessage(hwndDlg, IDC_USERNO, WM_SETTEXT, NULL, (LPARAM)"000000000000");
						SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Enter your usercode in the editbox above...");
						break;
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};