#include "windows.h"
#include "resource.h"
#include "blowfish.h"
#include "time.h"

#define MAX_NAME_LEN 0x64

long numLics;
char szName[MAX_NAME_LEN]={0};
char szCode[MAX_NAME_LEN]={0};

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

void Calculate(DWORD Length)
{
	int k;
	time_t actualtime;
	BF_KEY blowfish;
	unsigned long namesum, tmp;
	
	for (k=0, namesum=0x66; k<lstrlen(szName); k++)
	{
		tmp=namesum;
		__asm sar tmp, 25
		namesum<<=7;
		tmp|=namesum;
		namesum=tmp+szName[k];
	}

	time(&actualtime);
	if (actualtime<0x368C1000)
	{
		lstrcpy(szCode, "Your system clock may not be set to before Jan 01 1999.");
		return;
	}
	actualtime-=0x368C1000;
	actualtime=actualtime / 0x3C / 0x3C / 8 / 3;

	wsprintf(szCode, "%dFtpVC -- FTP-based Version Control System", namesum);
	wsprintf(szName, "f%03d%04d", numLics, actualtime);
	
	BF_set_key(&blowfish, lstrlen(szCode), (unsigned char*)szCode);
	BF_encrypt((unsigned long*)szName, &blowfish);

	for (k=0; k<8; k++)
		wsprintf(szCode + (k*2), "%02X", szName[k] & 0xFF);
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_LICS, EM_SETLIMITTEXT, 3, NULL);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_LICS, WM_SETTEXT, NULL, (LPARAM)"500");
			SendDlgItemMessageA(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Enter your information in the editboxes above...");
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_NAME:
				case IDC_LICS:
					if (HIWORD(wParam) == EN_UPDATE)
					{
						numLics = GetDlgItemInt(hwndDlg, IDC_LICS, NULL, NULL);
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN, (LPARAM)szName);
						if ((Length) && (numLics))
						{
							Calculate(Length);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Enter your information in the editboxes above...");
							break;
						}
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};