#include "windows.h"
#include "resource.h"

#define MAX_NAME_LEN 0x64

char szBack[MAX_NAME_LEN];
char szTemp[0x30];
char szCode[MAX_NAME_LEN];
char szName[MAX_NAME_LEN];
unsigned long dwordone, dwordtwo;

unsigned long chartable[]={
0x0100, 0x0300, 0x0500,
0x0700, 0x0900, 0x0B00,
0x0D00, 0x0F00, 0x1100,
0x1300, 0x1500, 0x1700,
0x1900, 0x1B00, 0x1D00,
0x1F00, 0x2100, 0x2300,
0x2500, 0x2700, 0x2900,
0x2B00, 0x2D00, 0x2F00,
0x3100, 0x3300, 0x0000,
};

const char Append[]="TILERISAREALLYGREATAPPLICATION";


HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

long BaseTransform(long num)
{
	if (num<=7)  return num+0x32;
	if (num<=15) return num+0x39;
	if (num<=20) return num+0x3A;
	if (num<=31) return num+0x3B;
	return num;
}

void Generate(long Length, long varvalue2)
{
	static unsigned long i, k, truelen, checksum, tmptwo, tmptwob, aux;

	strupr(szName);
	lstrcpy(szCode, szName);

	for (truelen=i=0; i<Length; i++)
		if ( (szCode[i]>=0x41) && (szCode[i]<=0x5A) )
			szName[truelen++]=szCode[i];
	szName[truelen]=0;

	if (truelen>7)
	{
		lstrcpyn(szCode, szName, 3);
		lstrcpyn(szCode+2, szName+3, 3);
		lstrcat(szCode, szName+6);
	} else lstrcpy(szCode, szName);

	lstrcat(szCode, Append);
	szCode[0x1E]=0;

	for (checksum=i=0; i<0x1E; i++)
	{
		checksum+=szCode[i];
		k=checksum;
	}

	k+=0xFFFFF863;
	checksum=k&0xFFFF;

	tmptwo=varvalue2&0x1F;
	tmptwob=varvalue2;

	i=k=1;
	tmptwo+=2;

	dwordone=(i*checksum)&0xFFF;
	tmptwo+=dwordone;

	dwordone<<=10;	
	dwordone|=0x244;
	dwordone|=tmptwob<<0x17;

	dwordtwo=szCode[0]-0x41;	
	tmptwo+=dwordtwo;

	dwordtwo=chartable[dwordtwo];

	tmptwo+=dwordtwo&0xFF;
	tmptwo+=dwordone&0x1F;
	dwordtwo|=tmptwo<<14;

	ltoa(dwordone, szTemp, 2);
	wsprintf(szName, "%030s", szTemp);
	for (tmptwo=i=0; (i*5)<lstrlen(szName); i++)
	{
		lstrcpyn(szTemp, szName+lstrlen(szName)-((i+1)*5), 6);
		for (k=0; k<32; k++)
		{
			ltoa(k, szTemp+32, 2);
			wsprintf(szTemp+16, "%05s", szTemp+32);
			if (lstrcmp(szTemp, szTemp+16)==0) break;
		}
		if (tmptwo==3) szCode[tmptwo++]=0x2D;
		szCode[tmptwo++]=BaseTransform(k)&0xFF;
	}

	ltoa(dwordtwo, szTemp, 2);
	wsprintf(szName, "%025s", szTemp);
	for (i=0; (i*5)<lstrlen(szName); i++)
	{
		lstrcpyn(szTemp, szName+lstrlen(szName)-((i+1)*5), 6);
		for (k=0; k<32; k++)
		{
			ltoa(k, szTemp+32, 2);
			wsprintf(szTemp+16, "%05s", szTemp+32);
			if (lstrcmp(szTemp, szTemp+16)==0) break;
		}
		if (tmptwo==9) szCode[tmptwo++]=0x2D;
		szCode[tmptwo++]=BaseTransform(k)&0xFF;
	}
	szCode[tmptwo++]=0;
	szCode[tmptwo++]=0;
}

void Calculate(unsigned long Length)
{
	static unsigned long varloop;

	lstrcpy(szBack, szName);
	for (varloop=0x7F; varloop>0; varloop--)
	{
		dwordone=dwordtwo=0;	
		Generate(Length, varloop);

		__asm
		{
			pushad
			mov eax, [dwordone]
			mov ebx, eax
			and eax, 200h
			cmp eax, 200h
			jne badcode
			test ebx, 10400000h
			jne badcode
			mov eax, ebx
			and eax, 1Fh
			cmp al, 18h
			ja badcode
			mov eax, ebx
			and eax, 1E0h
			cmp eax, 20h
			jb badcode
			cmp eax, 180h
			ja badcode
			and ebx, 0F800000h
			cmp ebx, 800000h
			jb badcode
			cmp ebx, 0F800000h
			ja badcode
			mov eax, [dwordtwo]
			and eax, 100h
			cmp eax, 100h
			jne badcode
			popad
		}
		return;

		badcode:
		__asm popad
		ZeroMemory(szTemp, MAX_NAME_LEN*2+0x30);
		lstrcpy(szName, szBack);
	}
	lstrcpy(szCode, "No valid code found for the the current name...");
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			srand(GetTickCount());
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");			
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_NAME:
					if (HIWORD(wParam) == EN_UPDATE)
					{
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szName);
						if (Length)
						{
							Calculate(Length);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");
							break;
						}						
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};