#include "windows.h"
#include "resource.h"

#define MAX_NAME_LEN 0x64

char szName[MAX_NAME_LEN];
char szCode[MAX_NAME_LEN];
char temp  [MAX_NAME_LEN];
char szBin [MAX_NAME_LEN*2];
unsigned char toEncode[20];

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

void Calculate()
{
	int           i, k, k1, bit2check, bitshl, out_p, in_p, checksum;
	static char   table[]="ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
	unsigned char c, seed;

	toEncode[0]=rand()&0xFF;
	toEncode[1]=toEncode[0]^0x44;
	toEncode[2]=0x48;
	toEncode[3]=0x41;
	toEncode[4]=0x52;
	toEncode[5]=0x4D;

	for (i=8; i>0; i--)
	{		

		for (k=5; k>=0; k--)
		{
			if (k!=0)
				seed=toEncode[k-1];
			else
				if (i==1)
					seed=0x50;
				else
					seed=toEncode[5];

			c=toEncode[k];
			
			for (k1=0; k1<i; k1++)
			{
				if (c & 1)
				{
					c>>=1;
					c|=0x80;
				}
				else
					c>>=1;
			}
	
			c^=seed;

			toEncode[k]=c;
		}
	}

	memset(szCode, 0, MAX_NAME_LEN);

	for (k=checksum=0; k<6; k++)
		if (checksum & 0x8000)
		{
			checksum<<=1;
			checksum+=(char)toEncode[k];
			checksum++;
		}
		else
		{
			checksum<<=1;
			checksum+=(char)toEncode[k];
		}
	toEncode[7]=(unsigned char)(checksum);
	toEncode[6]=(unsigned char)(checksum >> 8);	

	for (bitshl=4, bit2check=0x80, out_p=in_p=0; in_p < 8; bitshl--, bit2check>>=1)
	{
		if (toEncode[in_p] & bit2check)
			szCode[out_p] |= (1 << bitshl);

		if (bitshl==0)
		{
			bitshl=5;
			out_p++;
		}

		if (bit2check==1)
		{
			bit2check=0x100;
			in_p++;
		}
	}

	for (k=0; k<(out_p+1); k++)
	{
		i=szCode[k] + (k * 3);

		if (i > 0x1F)
		{
			while (i>0x1F) i-=0x20;
			szName[k+1]=table[i];
		}
		else
			szName[k+1]=table[i];
	}
	szName[0]=0x50;
	szName[k+1]=0;
	strcpy(szCode, szName);	
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			Calculate();
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
			SetFocus(GetDlgItem(hwndDlg, IDC_EXIT));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					Calculate();
					SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};