#include "windows.h"
#include "resource.h"
#include "sha.h"
#include "blowfish.h"

#define MAX_NAME_LEN 0x64

char szName[MAX_NAME_LEN]={0};
char szCode[MAX_NAME_LEN]={0};
unsigned long ulCode[2];

HANDLE hInst;

void EntryPoint();
void CenterDialog(HWND hwndDlg);
BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

/* BEGIN OF PROTECTECTION ALGORITHM */

char BaseTransform(long num)
{
	char chartable[40]="012345679ABCDEFGHJKLMNPQRSTUVWXY*";

	if (num>lstrlen(chartable)) return num;
		else return chartable[num];		
}

void Calculate(DWORD Length)
{
	BF_KEY blowfish;
	long k, k1, i;
	unsigned char shamd[0x80];
	char temp[0x80];

	ulCode[0]=0;
	ulCode[1]=0;
	SHA1((unsigned char*)szName, 0x50, (unsigned char*)&shamd);

	__asm
	{				
		push edi
		push esi
		push ecx
		lea esi, shamd
		lea edi, ulCode+2
		mov word ptr [edi-2], 5243h
		mov dword ptr [edi+2], 6BA8C300h
		mov ecx, 3
		repz movsb
		pop ecx
		pop esi
		pop edi
	}
	ulCode[0]^=0x5A5A5A5A;
	ulCode[1]^=0x5A5A5A5A;

	ZeroMemory(shamd, 0x20);
	SHA1((unsigned char*)"GrBZuStrp", 9, (unsigned char*)&shamd);
	BF_set_key(&blowfish, 0x20, (unsigned char*)shamd);
	BF_encrypt((unsigned long*)ulCode, &blowfish);

	ZeroMemory(szName, MAX_NAME_LEN);
	ltoa(ulCode[1], (char*)szCode, 2);
	lstrcpy(szName, szCode);
	ltoa(ulCode[0], (char*)szCode, 2);
	wsprintf(szName+lstrlen(szName), "%032s", szCode);

	wsprintf(szCode, "%065s", szName);
	lstrcpy(szName, szCode);

	for (k=i=0; i<lstrlen(szName); i+=5)
	{
		lstrcpyn(temp, szName+i, 6);
		for (k1=0x20; k1>=0; k1--)
		{
			ltoa(k1, temp+32, 2);
			wsprintf(temp+16, "%05s", temp+32);
			if (lstrcmp(temp, temp+16)==0) break;
		}
		szCode[k++]=BaseTransform(k1);
	}
	szCode[k++]=0;
	strrev(szCode);
}

/* END OF PROTECTECTION ALGORITHM */

void main()
{
	hInst = GetModuleHandle(NULL);
	ExitProcess(DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_MAINDLG), 0, (DLGPROC)MainHandler, IDD_MAINDLG));
}

void CenterDialog(HWND hwndDlg)
{
	RECT Dlg, Desktop;
	DWORD Height, Width, DeskX, DeskY;
	GetWindowRect(hwndDlg, &Dlg);
	GetWindowRect(GetDesktopWindow(), &Desktop);
	Width = Dlg.right - Dlg.left;
	Height = Dlg.bottom - Dlg.top;
	DeskX = (Desktop.right - Width) >> 1;
	DeskY = (Desktop.bottom - Height) >> 1;	
	MoveWindow(hwndDlg, DeskX, DeskY, Width, Height, NULL);
}

BOOL CALLBACK MainHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int Length;
	switch(uMsg)
	{
		case WM_CTLCOLOREDIT:
			if ((DWORD)lParam == (DWORD)GetDlgItem(hwndDlg, IDC_SERIAL))
			{
				SetBkColor((HDC)wParam, 0xC0C0C0);
				SetTextColor((HDC)wParam, NULL);
				CreateSolidBrush(0xC0C0C0);
			}
			break;
		case WM_INITDIALOG:
			SendMessage(hwndDlg, WM_SETICON, TRUE, (LPARAM)LoadIcon((HINSTANCE)hInst, MAKEINTRESOURCE(IDI_MAINICON)));
			CenterDialog(hwndDlg);
			SendDlgItemMessageA(hwndDlg, IDC_NAME, EM_SETLIMITTEXT, MAX_NAME_LEN, NULL);
			SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");			
			SetFocus(GetDlgItem(hwndDlg, IDC_NAME));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_EXIT:
					EndDialog(hwndDlg, NULL);
					break;
				case IDC_NAME:
					if (HIWORD(wParam) == EN_UPDATE)
					{
						ZeroMemory(szName, MAX_NAME_LEN);	
						Length = SendDlgItemMessage(hwndDlg, IDC_NAME, WM_GETTEXT, MAX_NAME_LEN+1, (LPARAM)szName);
						if (Length)
						{
							Calculate(Length);
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)szCode);
						}
						else
						{
							SendDlgItemMessage(hwndDlg, IDC_SERIAL, WM_SETTEXT, NULL, (LPARAM)"Please enter your name in the editbox above...");
							break;
						}
					}
					break;
				case IDC_ABOUT:
					DialogBoxParam((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_ABOUTDLG), hwndDlg, (DLGPROC)AboutHandler, IDD_ABOUTDLG);
				default:
					DefWindowProc(hwndDlg, uMsg, wParam, lParam);
			}
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
}

BOOL CALLBACK AboutHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			CenterDialog(hwndDlg);
			break;
		case WM_COMMAND:
			if (wParam == IDC_CLOSE) EndDialog(hwndDlg, NULL);
			break;
		default:
			DefWindowProc(hwndDlg, uMsg, wParam, lParam);
	};
	return(FALSE);
};