/****************** QuitaNag 1.00 *********************/

/************** Mr. Blue / [WkT!2000] *****************/


#include <windows.h>
#include <winreg.h>
#include <winuser.h>

typedef struct objetivo{
   char *clase;
   int x;
   int y;
   DWORD color;
}objetivo;

HWND ventana,boton;
BOOL eventana,eboton;

/****************** BuscaVentana ***********************/
// Esta funcin se encarga de distinguir si la ventana que se le
// pasa como primer parmetro es la que buscamos. Para ello, examina 
// si en el ttulo de la ventana aparece la cadena que se le pasa 
// como segundo parmetro.


BOOL CALLBACK BuscaVentana(HWND nuevohwnd, LPARAM lparam)
{
char texto[256];

if (nuevohwnd==NULL) return (TRUE);

GetWindowText(nuevohwnd,texto,sizeof(texto)); // Obtengo el ttulo de la ventana.
if (strstr(texto,(char *)lparam))	      // Si la cadena aparece en el ttulo
	{
		ventana=nuevohwnd;	      // Guardo el handle de la ventana.	
		eventana=TRUE;		      // Indico que se encontr la ventana	
		return(FALSE);		      // Paro la enumeracin actual	
	}
else return(TRUE);	// Si no es la ventana que busco continuo la enumeracin
}


/************** BuscaBoton ********************/
// Esta funcin se encarga de distinguir si el control actual es el que buscamos.
// Los parmetros del control a buscar se pasa a la funcin como una variable
// de tipo 'objetivo'.


BOOL CALLBACK BuscaBoton(HWND nuevohwnd, LPARAM lparam)
{
char clase[200];
HDC hdevicecontext;
COLORREF colores;
objetivo *miboton;

miboton = (objetivo *) lparam;	

GetClassName(nuevohwnd,clase,sizeof(clase)); //Capturo clase del control

if (!strcmp(clase,miboton->clase)) 	     // Verifica si es la clase correcta
{            				     // Si la es....
	SetForegroundWindow(nuevohwnd);      // Trae a primer plano el control
	EnableWindow(nuevohwnd, TRUE);       // Lo habilita
	hdevicecontext=GetDC(nuevohwnd);     // Captura DC del control
	// Captura pixel
	colores=GetPixel(hdevicecontext,miboton->x,miboton->y); 
	if (colores==miboton->color)         // Verifica si es del color correcto
	{				        // Si lo es...
		boton=nuevohwnd;		// Guarda su handle
		eboton=TRUE;			// Indica que se encontr	
		return(FALSE);			// Finaliza enumeracin
	}
}
return(TRUE);		// Si no es el control buscado, continua enumeracin
}



/********************** WinMain **************************/

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

char *titulo, *linea, *ejecut, *final;
objetivo elboton;
STARTUPINFO infoinicio;
PROCESS_INFORMATION infoproceso;
static char *copyright="QuitaNag 1.00  @ Mr. Blue / [WkT!] 2000";
unsigned tiempo, temporal, retorno;

	linea=LocalAlloc(LPTR, 255);
	titulo=LocalAlloc(LPTR, 40);
	ejecut=LocalAlloc(LPTR, 40);
	elboton.clase=LocalAlloc(LPTR,40);
	// Captura directorio desde el que se ejecuta QuitaNag
	lstrcpy(linea, GetCommandLine()+1);
	final=strrchr(linea,92)+1;
	*final=(char)0;
	// Construye el path al .INI
	lstrcat(linea, "quitanag.ini");
	// Lectura datos del .INI: titulo ventana-nag, fichero ejecutable, 
	// clase del botn a pulsar, milisegundos de espera a que aparezca el botn,
	// coordenadas del pixel y su color correcto.
	if ((!GetPrivateProfileString("Nag","titulo","",titulo,40,linea))||
       (!GetPrivateProfileString("Nag","fichero","",ejecut,40,linea))||
	   (!GetPrivateProfileString("Nag","clase","",elboton.clase,40,linea))||
	   ((tiempo = GetPrivateProfileInt("Nag","Milisec",0,linea))==0)||
       ((elboton.color = GetPrivateProfileInt("Nag","colorRGB",-1,linea))<0)||
	   ((elboton.x = GetPrivateProfileInt("Nag","coordx",-1,linea))<0)||
	   ((elboton.y = GetPrivateProfileInt("Nag","coordy",-1,linea))<0))
	{
		// Si no se encentra algn dato se muestra error.
		MessageBox(NULL,"No se encuentra fichero .INI o es incorrecto :-(",
			       (const char *)copyright,MB_ICONERROR);
		return(1);
	}

    *final=(char)0; 
        // Construye path del ejecutable.
	lstrcat(linea,ejecut);
	eventana=FALSE;
	eboton=FALSE;
	// Arranca el proceso 'vctima'
	GetStartupInfo(&infoinicio);
	if ( CreateProcess(linea,lpCmdLine,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,
    	               NULL,&infoinicio,&infoproceso) == 0 ) 
	{
		MessageBox(NULL,"No se encuentra el ejecutable :-(",
			       (const char *)copyright,MB_ICONERROR);
		return(1);
	}
	WaitForInputIdle(infoproceso.hProcess,INFINITE);
	temporal = GetTickCount();
	// Busca la ventana hasta encontrarla o hasta que se agote el tiempo.
	while ((!eventana)&&(temporal+tiempo>GetTickCount())) 
		EnumThreadWindows(infoproceso.dwThreadId,&BuscaVentana,titulo); 
	if (eventana)
	{
		// Busca el botn hasta encontrarlo o que se agote el tiempo.
		while ((!eboton)&&(temporal+tiempo>GetTickCount()))
			EnumChildWindows(ventana,&BuscaBoton,&elboton);
		if (eboton) // Si se encontr, se "pulsa"
		{
		    PostMessage(boton,BM_CLICK,0,0);
			retorno = 0;
		}
		else 
		{
			MessageBox(NULL,"No encuentro el botn :-(",
				   (const char *)copyright,MB_ICONERROR);
			retorno = 1;
		}
	}
	else
	{
		MessageBox(NULL,"No encuentro la ventana :-(",
			   (const char *)copyright,MB_ICONERROR);
		retorno = 1;
	}

    CloseHandle (infoproceso.hProcess);
	CloseHandle (infoproceso.hThread);
	LocalFree(elboton.clase);
	LocalFree(ejecut);
	LocalFree(titulo);
	LocalFree(linea);
	return(retorno);
}



