sn_Generate	    PROTO	:LPSTR,:DWORD,:LPSTR
clean_string	    PROTO       :LPSTR
;------------------------------------------------------------------------- 

.data

szAbout_Title       	db  'TeaM Seek n Destroy',0

min_name_len    	equ 1 	;lowest name len
max_name_len    	equ 30  ;max name len
_err_name_len_less   	db  'Please enter a name < %d chars!',0
_err_name_len_more   	db  'Please enter a name > %d chars!',0
_err_buffer		db  0
szAppName       	db  'Program Name 1.0',0
szBOX_1_TITLE		db  'Name:',0
szBOX_2_TITLE		db  'Serial:',0

szName	        	DB 20H DUP(0)
szSerial		dd 20h dup(0)
szLon			dd 0
strCHARS		db 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',0
szLonBuff		dd 0
newname			db 20h dup(0)
strresult		db 100h dup(0)
sznumber1		db 100h dup(0)

.code
sn_Generate PROC    usrname:LPSTR, name_len:DWORD, serial:LPSTR
		invoke	clean_string,addr sznumber1
		invoke	clean_string,addr newname
		invoke	clean_string,addr strresult
		
		invoke	lstrcpy,addr newname,usrname

	DO_IT:
	;//* START OF BASE_64_ENCODE *//
		mov 	[szLon],20
		mov	ecx,[szLon]	;ecx = name length
		lea	eax,offset newname ;1st part encoded
	;//* BASE 64 BEGIN *//
		call	BASE64_ENCODE
	;//* BASE 64 END *//
	;//* mov strresult to the output
		invoke	lstrcpy,addr sznumber1,addr strresult
		push	offset sznumber1	
	DONE: 
		ret
       
sn_Generate endp
clean_string PROC    the_string:LPSTR
		mov	eax,[the_string]
		push	eax
		call	lstrlen
		mov	ecx,eax
 		xor	al, al
		mov	edi, [the_string]
		rep stosb
		ret
clean_string endp
BASE64_ENCODE	proc	near
		push	ebx
		push	esi
		push	edi
		push	ecx
		mov	[szLonBuff], ecx ;mov	szLonBuff name len
		mov	esi, eax	 ;mov esi string to encode
		xor	ebx, ebx               
		xor	edi, edi
		mov	eax, [szLonBuff]
		mov	ecx, 3          ; nQuants = nLen % 3
		cdq			;
		idiv	ecx		;
		test	eax, eax	;if nQuants > 0 then
		jle	@CHECK		
					
	@LOOP:					;we read 3 bytes at a time!
						;edi = length
						;esi = name
						;ebx = i(counter)
		xor	edx, edx
		mov	dl, [esi+ebx] 		;edx = name[i]
		shr	edx, 2			;edx >>= 2
		mov	dl, ds:strCHARS[edx]	;edx = chars[edx]
		mov	strresult[edi], dl	;abOutput[0] = edx
		mov	dl, [esi+ebx]		;edx = name[i]
		and	dl, 3			;edx &&= 3
		and	edx, 0FFh		;edx &&= 255
		shl	edx, 4			;edx <<= 4
		xor	ecx, ecx		;ecx = 0
		mov	cl, [esi+ebx+1]		;ecx = name[i+1]
		shr	ecx, 4			;ecx >>= 4
		add	edx, ecx		;edx +=ecx
		mov	dl, ds:strCHARS[edx]	;edx = chars[edx]
		push	edx			;
		pop	edx			;
		mov	strresult[edi+1], dl	;abOutput[1]=edx
		mov	dl, [esi+ebx+1]		;edx = name[i+1]
		and	dl, 0Fh			;edx &&= 15
		and	edx, 0FFh		;edx &&= 255
		shl	edx, 2			;edx <<=2
		xor	ecx, ecx		;ecx = 0
		mov	cl, [esi+ebx+2]		;ecx = name[i+2]
		shr	ecx, 6			;ecx >>= 6
		add	edx, ecx		;edx +=ecx
		mov	dl, ds:strCHARS[edx]	;edx = chars[edx]
		push	edx			;
		pop	edx			;
		mov	strresult[edi+2], dl	;abOutput[2]=edx
		mov	dl, [esi+ebx+2]		;edx= name[i+2]
		and	dl, 3Fh			;edx&&=63
		and	edx, 0FFh		;edx&&=255
		mov	dl, ds:strCHARS[edx]	;edx=chars[edx]
		mov	strresult[edi+3], dl	;abOutput[3]=edx
		add	edi, 4			;next 4 bytes(abOutput)
		add	ebx, 3			;next 3 chars of name
		dec	eax			;nQuants -= 1
		jnz	@LOOP

@CHECK:		;else	this part denotates if we use 2 "=" or 1		
		mov	eax, [szLonBuff]	; nQuants = nLen mod 3
		mov	ecx, 3			
		cdq
		idiv	ecx
		test	edx,edx			;Case(0)
		jz	@DONE			;if nQuants = 0     
		cmp	edx,1			;Case(1)
		je	@TWO_EQUALS		;if nQuants = 1
		cmp	edx,2			;Case(2)
		jz	@ONE_EQUAL		;if nQuants = 2

@TWO_EQUALS:	;we need 2 "="'s so eg; serial UHVOa0R1RG==	
						;edi = length
						;esi = name
						;ebx = i(counter)
		xor	eax, eax		;eax= 0
		mov	al, [esi+ebx]		;eax=name[i]
		shr	eax, 2			;eax>>= 2
		mov	al, ds:strCHARS[eax]	;eax=chars[eax]
		mov	strresult[edi], al	;abOutput[len]= eax
		mov	al, [esi+ebx]		;eax=name[i]
		and	al, 3			;eax&&= 3
		and	eax, 0FFh		;eax&&= 255
		shl	eax, 4			;eax<<= 4
		mov	al, ds:strCHARS[eax]	;eax= chars[eax]
		mov	strresult[edi+1], al	;abOutput[len+1]= eax
		mov	byte ptr [strresult+edi+2], 3Dh ;abOutput[len+2]= "="
		mov	byte ptr [strresult+edi+3], 3Dh ;abOutput[len+3]= "="
		jmp	short @DONE

@ONE_EQUAL:	;we need 1 "="'s so eg; serial UHVOa0R1RGU=
						;edi = length
						;esi = name
						;ebx = i(counter)
		xor	eax, eax		;eax = 0
		mov	al, [esi+ebx]		;eax = name[i]
		shr	eax, 2			;eax>>= 2
		mov	al, ds:strCHARS[eax]	;eax = chars[eax]
		mov	strresult[edi], al	;abOutput[len]= eax
		mov	al, [esi+ebx]		;eax = name[i]
		and	al, 3			;eax&&= 3
		and	eax, 0FFh		;eax&&= 255
		shl	eax, 4			;eax<<= 4
		xor	edx, edx		;edx= 0
		mov	dl, [esi+ebx+1]		;edx= name[i+1]
		shr	edx, 4			;edx>>= 4
		add	eax, edx		;eax+= edx
		mov	al, ds:strCHARS[eax]	;eax= chars[eax]
		mov	strresult[edi+1], al	;abOutput[len+1]= eax
		mov	al, [esi+ebx+1]		;eax= name[i+1]
		and	al, 0Fh			;eax&&= 15
		and	eax, 0FFh		;eax&&= 255
		shl	eax, 2			;eax<<= 2
		mov	al, ds:strCHARS[eax]	;eax= chars[eax]
		mov	strresult[edi+2], al	;abOutput[len+1]= eax
		mov	byte ptr [strresult+edi+3], 3Dh;abOutput[len+3]= "="
@DONE:		
		;encoded str is held in strresult!	
		pop	edx
		pop	edi
		pop	esi
		pop	ebx
		ret
BASE64_ENCODE	endp
;Public Function EncodeStr64(sInput As String) As String
;    Dim abOutput() As Byte
;    Dim sLast As String
;    Dim b(3) As Byte
;    Dim j As Integer
;    Dim i As Long, nLen As Long, nQuants As Long
;    Dim iIndex As Long
;    Dim B0 As Byte, B1 As Byte, B2 As Byte, B3 As Byte
;    EncodeStr64 = ""
;    nLen = Len(sInput)
;    
;    nQuants = nLen \ 3
;    
;    iIndex = 0
;    
;    
;    If (nQuants > 0) Then
;        ReDim abOutput(nQuants * 4 - 1)
;        ' Now start reading in 3 bytes at a time
;        For i = 0 To nQuants - 1 'len / 3 -1
;            For j = 0 To 2
;               b(j) = Asc(Mid(sInput, (i * 3) + j + 1, 1))
;            Next
;           
;    	     B0 = SHR2(b(0)) And &H3F
;    	     B1 = SHL4(b(0) And &H3) Or (SHR4(b(1)) And &HF)
;    	     B2 = SHL2(b(1) And &HF) Or (SHR6(b(2)) And &H3)
;    	     B3 = b(2) And &H3F
;    
;   	     b(0) = aEncTab(B0)
;    	     b(1) = aEncTab(B1)
;    	     b(2) = aEncTab(B2)
;   	     b(3) = aEncTab(B3)
;            abOutput(iIndex) = b(0)
;            abOutput(iIndex + 1) = b(1)
;            abOutput(iIndex + 2) = b(2)
;            abOutput(iIndex + 3) = b(3)
;            iIndex = iIndex + 4
;        Next
;        EncodeStr64 = StrConv(abOutput, vbUnicode)
;    End If
;    
;    ' Cope with odd bytes
;    ' (no real performance hit by using strings here)
;    Select Case nLen Mod 3
;    Case 0
;        sLast = ""
;    Case 1
;        b(0) = Asc(Mid(sInput, nLen, 1))
;        b(1) = 0
;        b(2) = 0
;    	     B0 = SHR2(b(0)) And &H3F
;    	     B1 = SHL4(b(0) And &H3) Or (SHR4(b(1)) And &HF)
;    	     B2 = SHL2(b(1) And &HF) Or (SHR6(b(2)) And &H3)
;    	     B3 = b(2) And &H3F
;    
;   	     b(0) = aEncTab(B0)
;    	     b(1) = aEncTab(B1)
;    	     b(2) = aEncTab(B2)
;   	     b(3) = aEncTab(B3)

;        sLast = StrConv(b(), vbUnicode)
;        ' Replace last 2 with =
;        sLast = Left(sLast, 2) & "=="
;    Case 2
;        b(0) = Asc(Mid(sInput, nLen - 1, 1))
;        b(1) = Asc(Mid(sInput, nLen, 1))
;        b(2) = 0
;    	     B0 = SHR2(b(0)) And &H3F
;    	     B1 = SHL4(b(0) And &H3) Or (SHR4(b(1)) And &HF)
;    	     B2 = SHL2(b(1) And &HF) Or (SHR6(b(2)) And &H3)
;    	     B3 = b(2) And &H3F
;    
;   	     b(0) = aEncTab(B0)
;    	     b(1) = aEncTab(B1)
;    	     b(2) = aEncTab(B2)
;   	     b(3) = aEncTab(B3)

;        sLast = StrConv(b(), vbUnicode)
;        ' Replace last with =
;        sLast = Left(sLast, 3) & "="
;    End Select
;    
;    EncodeStr64 = EncodeStr64 & sLast
;End Function
