#include<stdio.h>
#include<ctype.h>
#include<string.h>
#include<stdlib.h>
#include "vktools.h"

/*****************************************************************************/
/*	
 *	Module:	vklib.c
 *
 *	Description:	Code to generate vendor keys and manage encryption seeds.
 *			
 *
 *	Last changed:  3-OCT-1999
 *	N. Blender
 *
 */

unsigned long versionno;
unsigned long var1;
unsigned long var2;

int nbl_keygen(int inver, char *myvname, char *outdata)
{
	VENDORCODE tstvendor;
	unsigned long vkey5;
	unsigned long ovals[5];
	int versionno;
	int i;
	char tmpstr[1024];

	switch(inver)
	{
	case 4:
		versionno = 4;
		var1 = 0xcf53fa74;
		var2 = 0xa8f38730;
		break;
	case 5:
		versionno = 5;
		var1 = 0x58A340F2;
		var2 = 0xa8f38730;
		break;
	case 6:
		versionno = 6;
		var1 = 0x1504C935;
		var2 = 0xa8f38730;
		break;
	case 7:
		versionno = 7;
		var1 = 0x788f71d2;
		var2 = 0x7648b98e;
		break;
	case 8:
		versionno = 8;
		var1 = 0x3CDE3EBF;
		var2 = 0x6F7330B8;
		break;
	case 9:
		versionno = 9;
		var1 = 0x72346B53;
		var2 = 0x6F7330B8;
		break;
	default:
		strcpy(outdata, "Invalid version number.");
		return(-1);
	}
	if (strlen(myvname) < 1 || strlen(myvname) > 32)
	{
		strcpy(outdata, "Vendor Name must be\r\nbetween 1 and 32 chars.");
		return(-1);
	}
	if (strchr(myvname, ' ') || strchr(myvname, '\t'))
	{
		strcpy(outdata, "Vendor Name must not\r\ncontain spaces.");
		return(-1);
	}
	*outdata = 0;
	sprintf (tmpstr, "/* Version %d keys */\r\n", versionno);
	strcat(outdata, tmpstr);

	nbl_makekey(myvname, &tstvendor, &vkey5); 
	for (i = 0; i < 4; i++) 
	{
		sprintf (tmpstr, "#define VENDOR_KEY%d 0x%08x\r\n", i+1, tstvendor.keys[i]);
		strcat(outdata, tmpstr);
	} 
	sprintf (tmpstr, "#define VENDOR_KEY5 0x%08x\r\n", vkey5);
	strcat(outdata,tmpstr);
	if (inver == 7  || inver == 8 || inver == 9)
	{
		if (inver == 7)
		{
			nbl7_crogen(myvname, ovals);
		}
		else
		if (inver == 8)
		{
			nbl8_crogen(myvname, ovals);
		}
		else
		{
			nbl9_crogen(myvname, ovals);
		}

		sprintf (tmpstr, "#define CRO_KEY1 0x%08x\r\n", ovals[1]);
		strcat(outdata,tmpstr);
		sprintf (tmpstr, "#define CRO_KEY2 0x%08x\r\n", ovals[2]);
		strcat(outdata,tmpstr);
	}
	sprintf (tmpstr, "\r\n#define VENDOR_NAME \"%s\"\r\n", myvname);
	strcat(outdata,tmpstr);

	return(0);
}
/*-------------------------------------------------------------*
 *
 * nbl_gen 
 * CRO generator routine.
 *-------------------------------------------------------------*/
unsigned long nbl_gen(char *instr, unsigned long *numarr, unsigned long *okeys)
{
	int i;
	unsigned long cksum1;
	unsigned long res1;
	unsigned long res3;
	unsigned long res5;
	unsigned long res7;
	unsigned long cksum2;
	unsigned long key0;
	unsigned long res2;
	unsigned long cksum3;
	unsigned long key1;
	unsigned long res4;
	unsigned long cksum4;
	unsigned long key2;
	unsigned long res6;
	unsigned long cksum5;
	unsigned long key3;
	unsigned long decvals[4];

	for (i = 0; i < 4; i++) {
		okeys[i] = 0;
	}
	z_init(instr, &cksum1);
	decvals[0] = cksum1;
	decvals[1] = numarr[0];
	decvals[2] = numarr[1];
	decvals[3] = 0;


	res1 = decvals[0];
	res3 = decvals[1];
	res5 = decvals[2];
	res7 = decvals[3];


	cksum2 = res1 ^ cksum1;
	key0 = rl_icf(cksum2);
	res2 = res1 ^ key0;
	cksum3 = res2 ^ res3;
	key1 = rl_icf(cksum3);
	res4 = res3 ^ key1;
	cksum4 = res5 ^ res4;
	key2 = rl_icf(cksum4);
	res6 = res5 ^ key2;
	cksum5 = res7 ^ res6;
	key3 = rl_icf(cksum5);

	okeys[0] = decvals[0];
	okeys[1] = decvals[1];
	okeys[2] = decvals[2];
	okeys[3] = cksum5;
	return(0);
}
/*-------------------------------------------------------------*
 *
 * nbl_rev 
 * essentially, inverse of nbl_key.
 *-------------------------------------------------------------*/
unsigned long nbl_rev(char *instr,unsigned long *decvals, unsigned long *okeys)
{
	int i;
	unsigned long cksum1;
	unsigned long res1;
	unsigned long res3;
	unsigned long res5;
	unsigned long res7;
	unsigned long cksum2;
	unsigned long key0;
	unsigned long res2;
	unsigned long cksum3;
	unsigned long key1;
	unsigned long res4;
	unsigned long cksum4;
	unsigned long key2;
	unsigned long res6;
	unsigned long cksum5;
	unsigned long key3;
	VENDORCODE tmpvendor;

	for (i = 0; i < 5; i++) {
		okeys[i] = 0;
	}
	z_init(instr, &cksum1);

	res1 = decvals[0];
	res3 = decvals[1];
	res5 = decvals[2];
	res7 = decvals[3];

	cksum2 = res1 ^ cksum1;
	key0 = rl_icf(cksum2);
	res2 = res1 ^ key0;
	cksum3 = res2 ^ res3;
	key1 = rl_icf(cksum3);
	res4 = res3 ^ key1;
	cksum4 = res5 ^ res4;
	key2 = rl_icf(cksum4);
	res6 = res5 ^ key2;
	cksum5 = res7 ^ res6;
	key3 = rl_icf(cksum5);

	okeys[0] = key0;
	okeys[1] = key1;
	okeys[2] = key2;
	okeys[3] = key3;
	tmpvendor.type = 0x0004; /* vendorcode 4 type of structure */
	tmpvendor.data[0] = 0; /* UNUSED */
	tmpvendor.data[1] = 0; /* UNUSED */
	tmpvendor.keys[0] = okeys[0];
	tmpvendor.keys[1] = okeys[1];
	tmpvendor.keys[2] = okeys[2];
	tmpvendor.keys[3] = okeys[3];
	tmpvendor.flexlm_version = 6;
	tmpvendor.flexlm_revision = 1;
	return(0);
}

/*---------------------------------------------------*
 *
 * nbl_crogen: generate a set of CRO keys for
 * FLEXlm 7.2
 *---------------------------------------------------*/
int nbl7_crogen(char *vendname, unsigned long *ovals)
{
	int i;
	unsigned long ivals[4];
	unsigned long ctlarr[2];

	for (i = 0; i < 4; i++)
	{
		ivals[i]= 0;
	}
	ctlarr[0] = 0xffffffff;
	ctlarr[1] = 0xffffffff;

	nbl_gen(vendname, ctlarr, ivals);
	nbl_rev(vendname, ivals, ovals);
	return(0);
}
/*---------------------------------------------------*
 *
 * nbl_crogen: generate a set of CRO keys for
 * FLEXlm 8.1
 *---------------------------------------------------*/
int nbl8_crogen(char *vendname, unsigned long *ovals)
{
	int i;
	unsigned long ivals[4];
	unsigned long ctlarr[2];

	for (i = 0; i < 4; i++)
	{
		ivals[i]= 0;
	}
	ctlarr[0] = 0x3fffffff;
	ctlarr[1] = 0x3fffffff;

	nbl_gen(vendname, ctlarr, ivals);
	nbl_rev(vendname, ivals, ovals);
	return(0);
}
/*---------------------------------------------------*
 *
 * nbl_crogen: generate a set of CRO keys for
 * FLEXlm 9.0
 *---------------------------------------------------*/
int nbl9_crogen(char *vendname, unsigned long *ovals)
{
	int i;
	unsigned long ivals[4];
	unsigned long ctlarr[2];

	for (i = 0; i < 4; i++)
	{
		ivals[i]= 0;
	}
	ctlarr[0] = 0xffffffff;
	ctlarr[1] = 0xffffffff;

	nbl_gen(vendname, ctlarr, ivals);
	nbl_rev(vendname, ivals, ovals);
	return(0);
}

/*****************************************************************************/
/*	
 *
 * nbl_br:
 * reverse bit order
 * X == nbl_br(nbl_br(X))
 * inval(input) value to be processed
 * returns reversed value.
 */
unsigned long nbl_br(unsigned long inval)
 {
	unsigned long outval = 0;
	int i;

	
	for (i = 0; i < 8; i++)
	{
		outval = outval << 1;
		outval = outval | (inval & 0x00000001);
		inval = inval >> 1;
	}
	return(outval);
}

/*****************************************************************************/
/*	
 *
 * nbl_hbs:
 * swap nybbles around
 * X == nbl_hbs(nbl_hbs(X))
 * inval(input) value to be processed
 * returns nybble swapped value.
 */
unsigned long nbl_hbs(unsigned long inval)
 {
	unsigned long outval;
	int tmpval;
	int tmpval1;

	tmpval = inval & 0x000000f0;
	tmpval = tmpval >> 4;
	tmpval1 = inval & 0x0000000f;
	tmpval1 = tmpval1 <<4;
	outval = tmpval1 | tmpval;
	return(outval);
}


/*****************************************************************************/
/*	
 *
 * z_init; generate checksum from key string 
 * instr(input) string to be processed
 * outval(output) checksum value
 * returns 0 always.
 */
int z_init(char *instr, unsigned long *outval)
{
	int i = 0;
	unsigned long cksum;
	unsigned long addval;
	unsigned long offset;

	char *p;
	/* cryptoseed */
	cksum = var1;

	/* successively XOR bytes of seed with bytes of input string */
	for (p = instr; *p != '\0'; *p++)
	{
		offset = i%4;
		addval = (unsigned long) (*p & 0x000000ff);
		addval = addval << (offset*8);
		cksum = cksum ^ addval;
		i++;
	}
	*outval = cksum;
	return(0);
}

/*****************************************************************************/
/*	
 *
 * nb_nzsum: generate other checksum from key string 
 *           this is a zero seeded version of z_init.
 * instr(input) string to be processed
 * outval(output) checksum value
 * returns 0 always.
 */
int nb_nzsum(char *instr, unsigned long *outval)
{
	int i = 0;
	unsigned long cksum;
	unsigned long addval;
	unsigned long offset;

	char *p;
	/* cryptoseed */
	cksum = 0x0;

	/* successively XOR bytes of seed with bytes of input string */
	for (p = instr; *p != '\0'; *p++)
	{
		offset = i%4;
		addval = (unsigned long) (*p & 0x000000ff);
		addval = addval << (offset*8);
		cksum = cksum ^ addval;
		i++;
	}
	*outval = cksum;
	return(0);
}

/*****************************************************************************/
/*	
 *
 * nb_makekey 
 * Make a valid vendorcode struct given a name.
 * this uses hardcoded values that should not be changed unless
 * you run fix_checksum against the structure.
 *
 * the actual vendorcode does NOT affect the keys generated, only
 * the values of the encryption seeds do that.
 *
 * instr(input) vendor name to be encoded.
 * vs(output) outut vendorcode structure.
 * returns 0.
 */
unsigned long nbl_makekey(char *instr, VENDORCODE *vs, unsigned long *vkey5)
{
	int i;
	unsigned long incval;
	unsigned long incval1;
	unsigned long cksum1;
	unsigned long res1;
	unsigned long res3;
	unsigned long res5;
	unsigned long res7;
	unsigned long cksum2;
	unsigned long key0;
	unsigned long res2;
	unsigned long cksum3;
	unsigned long key1;
	unsigned long res4;
	unsigned long cksum4;
	unsigned long key2;
	unsigned long res6;
	unsigned long cksum5;
	unsigned long key3;
	unsigned long tmpnum2;
	unsigned long tmpnum3;
	unsigned long tmpval1;
	unsigned int okeys[5];

	for (i = 0; i < 5; i++)
	{
		okeys[i] = 0;
	}
	z_init(instr, &cksum1);

	res1 = 0xbffffffe;
	res3 = 0xffffffe2;
	res5 = 0xffffffff;
	res7 = 0x03eea001;

	cksum2 = res1 ^ cksum1;
	key0 = rl_icf(cksum2);
	res2 = res1 ^ key0;
	cksum3 = res2 ^ res3;
	key1 = rl_icf(cksum3);
	res4 = res3 ^ key1;
	cksum4 = res5 ^ res4;
	key2 = rl_icf(cksum4);
	res6 = res5 ^ key2;
	cksum5 = res7 ^ res6;
	key3 = rl_icf(cksum5);

	okeys[0] = key0;
	okeys[1] = key1;
	okeys[2] = key2;
	okeys[3] = key3;
	vs->data[0] = 0; /* UNUSED */
	vs->data[1] = 0; /* UNUSED */
	vs->keys[0] = okeys[0];
	vs->keys[1] = okeys[1];
	vs->keys[2] = okeys[2];
	vs->keys[3] = okeys[3];
	incval = 0;
	nb_nzsum(instr, &incval);
	incval1 = 0;
	/* swap byte order */
	for (i = 0; i < 4; i++)
	{
		incval1 = incval1 << 8;
		tmpval1 = (incval >> (i * 8)) & 0x000000ff;
		incval1 |= tmpval1;
	}

	tmpnum2 = var2 ^ incval1;
	tmpnum3 = tmpnum2 ^ 0xffffffe2;
	*vkey5 = tmpnum3 ^ 0xffffffff;
	return(0);
}
/*****************************************************************************/
/*	
 *
 * rl_icf: Generate key values.
 *         this algorithm is used to generate the vendorcode
 *         structure keys from the decoded keyvalues.
 *
 * inval(input) value to be encrypted
 * returns encrypted value.
 */
unsigned long rl_icf(unsigned long inval)
{
	 unsigned long htmp2;
	 unsigned long result0;
	 unsigned long result1;
	 unsigned long outtmp1;
	 unsigned long tmp1;
	 unsigned long outtmp2;
	 unsigned long tmp2;
	 unsigned long htmp3;
	 unsigned long tmp3;
	 unsigned long result2;
	 unsigned long mhtmp0;
	 unsigned long htmp0;
	 unsigned long tmp0;
	 unsigned long outval;

	 htmp2 = inval >> 24;
	 result0 = inval >> 16;
	 result0 &= 0x000000ff;
	 result1 = inval >> 8;
	 result1 &= 0x000000ff;
	 outtmp1 = result1 ^ htmp2;
	 tmp1 = nbl_br(outtmp1);
	 outtmp2 = nbl_hbs(htmp2);
	 tmp2 = nbl_br(outtmp2);
	 htmp3 = result0 ^ htmp2;
	 tmp3 = nbl_hbs(htmp3);
	 result2 = inval & 0x000000ff;
	 mhtmp0 = result2 ^ result1;
	 htmp0 = nbl_br(mhtmp0);
	 tmp0 = nbl_hbs(htmp0);
	 outval = tmp0;
	 outval |= tmp1 << 8;
	 outval |= tmp2 << 16;
	 outval |= tmp3 << 24;
	 return(outval);
 }
/*-------------------------------------------------------------*
 *
 * nbl_c: 
 * count "true" bits inside structure.
 *-------------------------------------------------------------*/
unsigned long nbl_c(unsigned long *inval)
{
	unsigned long curval;
	int val1;
	unsigned long *val3;
	unsigned long sumval;
	unsigned long i;
	unsigned long r0 = 0;
	val3 = inval;
	sumval = r0;
	for (val1 = 3; val1 >= 0; val1--) {
		curval = *val3;
		for (i = 93; i >= 31; i-=2) {
			if (curval & 0x00000001) { 
				sumval += 1;
			}
			curval = curval >> 1;
		}
		val3++;
	}
	return(sumval);
}
