/* change system id on IRIX 6.5 (IP27) -- origin200

   since the system ID on different types of SGI hardware is obtained in
   different ways, YMMV. This may even crash your machine.

   compile by   --  cc -o csid csid-ip27-irix65.c -lelf
 
   run this with no parameters first and make sure it reports the
   correct system id
 
   if all is well, you can run it with the system id you want

  e.g.
    marmot:/home/mch/tmp> cc -o csid csid-ip27-irix65.c -lelf 
    marmot:/home/mch/tmp> su
    Password:
    marmot# /sbin/sysinfo
    System ID:
    12  34  56  78  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    marmot# ./csid
    hexadecimal system id seems to be 12345678
    marmot# ./csid 69c0ffee
    marmot# /sbin/sysinfo
    System ID:
    69  c0  ff  ee  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  00  
    marmot#

 */


#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <nlist.h>
struct nlist64 nl[2];

/* this magic value and the following routine comes from disassemble,
 *
 * Note: the following is written out from my memory(the machine is not
 *   available presently),so some numbers/names may differ a bit
 * The process:
 *   1. dis /unix > unix.s
 *   2. trace lmhostid or sysinfo to find out which syscall is used
 *      they are syssgi(0xbf,..) GET_NUM_MODULES and 
 *            syssgi(0xc0,..) GET_MODULE_INFO
 *      anyway, they finally call syssgi_gethostid
 *   3. syssgi_gethostid calls get_kmod_info
 *   4. analysis get_kmod_info,you can find it load a number
 *      from modules[0]->offset_768,then decode the number
 *      using decode_int_serial to get final hostid
 */

#define SN00_SERIAL_FUDGE 0xffc4e50bf62aec3eULL

void
decode_int_serial(unsigned long long src, unsigned long long *dest)
{
    unsigned long long val;
    int i;
                                                                                
   /* luckily enough that it is a reversable encoding :)*/
    for (i = 0; i < sizeof(long long); i++) {
        ((char*)&val)[sizeof(long long)/2 +
                     ((i%2) ? ((i/2 * -1) - 1) : (i/2))] =
            ((char*)&src)[i];
    }
                                                                                
    *dest = val + SN00_SERIAL_FUDGE;
}

void
encode_int_serial(unsigned long long src, unsigned long long *dest)
{
    unsigned long long val;
    int i;

    val = src - SN00_SERIAL_FUDGE;
                                                                                
   /* luckily enough that it is a reversable encoding :)*/
    for (i = 0; i < sizeof(long long); i++) {
        ((char*)dest)[i] = ((char*)&val)[sizeof(long long)/2 +
                     ((i%2) ? ((i/2 * -1) - 1) : (i/2))] ;
    }
                                                                                
}

 
main(argc,argv)
int argc;
char *argv[];
{
    int kmem;
    int just_read = 0;
    unsigned int new_id, cur_id;
    off_t where;
    unsigned long long data,data_out;

    if ((kmem = open("/dev/kmem", O_RDWR)) < 0) {
        fprintf(stderr, "cannot open /dev/kmem\n");
        exit(1);
    }
    just_read = (argc <= 1);
    if (argc > 1) 
         new_id = strtoul(argv[1], NULL, 16);

    nl[0].n_name="modules";
    nl[1].n_name = NULL;
    if (nlist64("/unix", nl) < 0) {
        fprintf(stderr, "cannot read namelist out of /unix\n");
        exit(1);
    }


    if ((where = nl[0].n_value) == 0) {
        fprintf(stderr, "unknown kernel variable enet_collision\n");
        exit(1);
    }
     
    if (lseek(kmem, where, SEEK_SET) == (-1)) {
        fprintf(stderr, "lseek on /dev/kmem failed\n");
        exit(1);
    }

    /* *modules is the address of orignal id value */
    printf("modules structure located at %16llx\n",where);
    if (read(kmem, &where, 8) < 8) {
	    fprintf(stderr, "read failed\n");
	    exit(1);
    }

    /* 768 comes from disassemble... */
    printf("*modules is %16llx\n",where+768);
    if (lseek(kmem, where + 768, SEEK_SET) == (-1)) {
	    fprintf(stderr, "lseek on /dev/kmem failed\n");
	    exit(1);
    }
    if (read(kmem, &data, 8) < 8) {
	    fprintf(stderr, "read failed\n");
	    exit(1);
    }

    /* they are trying to hide it:) */
    decode_int_serial(data,&data_out);
    cur_id = *((int*)&data_out + 1);
    printf("hexadecimal system id seems to be %08x\n", cur_id);

    if (!just_read) {
        if (lseek(kmem, where + 768, SEEK_SET) == (-1)) {
	    fprintf(stderr, "lseek on /dev/kmem failed\n");
	    exit(1);
        }
	//data_out = 0x800690d3849ULL;
        *((int*)&data_out + 1) = new_id;
        encode_int_serial(data_out,&data);
        if (write (kmem, &data, 8) < 8) {
            fprintf(stderr, "write to /dev/kmem failed\n");
            exit(1);
        }
	printf("new id set to %x\n",new_id);
    }
    close(kmem);
    exit(0);
}


