/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.LineMarginPainter;
import com.jidesoft.utils.SortedList;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLineMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseListener,
MouseMotionListener {
    protected List<LineMarginPainter> _lineMarginPainters;
    private int b = -1;
    private int c = -1;

    public AbstractLineMargin(CodeEditor codeEditor) {
        super(codeEditor);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void paintMargin(Graphics var1_1) {
        block4: {
            var13_2 = AbstractMargin.a;
            var2_3 = (Graphics2D)var1_1.create();
            var3_4 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
            var5_6 = var4_5 = this.getCodeEditor().getFirstLine();
            var6_7 = var4_5 + this.getHeight() / var3_4;
            var6_7 = Math.min(var6_7, this.getCodeEditor().getLineCount() - 1);
            var7_8 = this.getPreferredSize().width;
            v0 = this._editor.isEnabled();
            if (var13_2 != 0) ** GOTO lbl14
            if (v0 == 0) {
                var2_3.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            try {
                v0 = 0;
lbl14:
                // 2 sources

                var8_9 = v0;
                var9_11 = new Rectangle(0, var8_9, var7_8, var3_4);
                var10_12 = this.getLineMarginPainters();
                for (var11_13 = var5_6; var11_13 <= var6_7; ++var11_13) {
                    var12_14 = this.a(var10_12, var2_3, var9_11, var11_13);
                    this.paintLineMargin(var2_3, var9_11, var11_13);
                    this.a(var10_12, var12_14, var2_3, var9_11, var11_13);
                    var9_11.y += var3_4;
                    if (var13_2 != 0) break block4;
                    if (var13_2 == 0) continue;
                    break;
                }
            }
            catch (Exception var8_10) {
                System.err.println("Error repainting line range {" + var5_6 + "," + var6_7 + "}:");
                var8_10.printStackTrace();
            }
            var2_3.dispose();
        }
    }

    private int a(List<LineMarginPainter> list, Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        block4: {
            int n3;
            int n4 = AbstractMargin.a;
            if (list != null) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    LineMarginPainter lineMarginPainter;
                    LineMarginPainter lineMarginPainter2 = lineMarginPainter = list.get(n3);
                    if (n4 == 0) {
                        n2 = lineMarginPainter2.getLayer();
                        if (n4 != 0) break block4;
                        if (n2 >= 1000) break;
                        lineMarginPainter2 = lineMarginPainter;
                    }
                    lineMarginPainter2.paintLineMargin(graphics, this.getCodeEditor(), rectangle, n);
                    if (n4 == 0) continue;
                }
            }
            n2 = n3;
        }
        return n2;
    }

    private void a(List<LineMarginPainter> list, int n, Graphics graphics, Rectangle rectangle, int n2) {
        int n3 = AbstractMargin.a;
        if (list != null) {
            for (int i = n; i < list.size(); ++i) {
                LineMarginPainter lineMarginPainter = list.get(i);
                lineMarginPainter.paintLineMargin(graphics, this.getCodeEditor(), rectangle, n2);
                if (n3 == 0) continue;
            }
        }
    }

    public void addLineMarginPainter(LineMarginPainter lineMarginPainter) {
        List<LineMarginPainter> list = this._lineMarginPainters;
        if (AbstractMargin.a == 0) {
            if (list == null) {
                this._lineMarginPainters = new SortedList<LineMarginPainter>(new ArrayList(), new Comparator<LineMarginPainter>(){

                    @Override
                    public int compare(LineMarginPainter lineMarginPainter, LineMarginPainter lineMarginPainter2) {
                        int n;
                        block6: {
                            int n2;
                            block5: {
                                int n3 = AbstractMargin.a;
                                int n4 = lineMarginPainter.getLayer();
                                int n5 = lineMarginPainter2.getLayer();
                                n = n4;
                                n2 = n5;
                                if (n3 != 0) break block5;
                                if (n < n2) {
                                    return -1;
                                }
                                n = n4;
                                if (n3 != 0) break block6;
                                n2 = n5;
                            }
                            if (n > n2) {
                                return 1;
                            }
                            n = 0;
                        }
                        return n;
                    }
                });
            }
            list = this._lineMarginPainters;
        }
        list.add(lineMarginPainter);
    }

    public void removeLineMarginPainter(LineMarginPainter lineMarginPainter) {
        List<LineMarginPainter> list = this._lineMarginPainters;
        if (AbstractMargin.a == 0) {
            if (list == null) {
                return;
            }
            list = this._lineMarginPainters;
        }
        list.remove(lineMarginPainter);
    }

    protected List<LineMarginPainter> getLineMarginPainters() {
        return this._lineMarginPainters;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        String string = this.getToolTipText(mouseEvent);
        if (string == null) {
            return null;
        }
        int n = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        int n2 = mouseEvent.getPoint().y / n;
        return new Point(this.getPreferredSize().width + 6, n2 * n + n / 2);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        int n2 = this.getCodeEditor().getFirstLine();
        int n3 = mouseEvent.getPoint().y / n;
        return this.getToolTipText(n3 + n2);
    }

    public abstract void paintLineMargin(Graphics var1, Rectangle var2, int var3);

    public abstract String getToolTipText(int var1);

    @Override
    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    @Override
    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    @Override
    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        block10: {
            int n;
            int n2;
            block13: {
                int n3;
                block12: {
                    block11: {
                        block8: {
                            block9: {
                                int n4;
                                int n5;
                                block6: {
                                    block7: {
                                        block5: {
                                            block4: {
                                                n3 = AbstractMargin.a;
                                                int n6 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
                                                int n7 = this.getCodeEditor().getFirstLine();
                                                int n8 = mouseEvent.getPoint().y / n6;
                                                n5 = n2 = n8 + n7;
                                                if (n3 != 0) break block4;
                                                if (n5 < 0) break block5;
                                                n5 = n8;
                                            }
                                            n4 = this.getCodeEditor().getVisibleLines();
                                            if (n3 != 0) break block6;
                                            if (n5 < n4) break block7;
                                        }
                                        return;
                                    }
                                    n5 = mouseEvent.getModifiers();
                                    n4 = 2;
                                }
                                n = n5 & n4;
                                if (n3 != 0) break block8;
                                if (n == 0) break block9;
                                n = mouseEvent.getModifiers() & 1;
                                if (n3 != 0) break block8;
                                if (n != 0) break block9;
                                this.c = n2;
                                if (n3 == 0) break block10;
                            }
                            n = this.c;
                        }
                        if (n3 != 0) break block11;
                        if (n < 0) break block10;
                        n = mouseEvent.getModifiers() & 2;
                    }
                    if (n3 != 0) break block12;
                    if (n != 0) break block10;
                    n = mouseEvent.getModifiers() & 1;
                }
                if (n3 != 0) break block13;
                if (n == 0) break block10;
                n = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n2, this.c), 0)));
            }
            int n9 = n;
            int n10 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n2, this.c) + 1));
            this.getCodeEditor().select(n9, n10);
        }
    }

    protected void selectLine(int n) {
        int n2 = this._editor.getLineStartOffset(this._editor.viewToModelLine(n));
        int n3 = this._editor.getLineStartOffset(this._editor.viewToModelLine(n + 1));
        this.getCodeEditor().select(n2, n3);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        int n2 = this.getCodeEditor().getFirstLine();
        int n3 = mouseEvent.getPoint().y / n;
        this.b = n3 + n2;
        this.selectLine(this.b);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.b = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        block9: {
            block8: {
                int n3;
                block6: {
                    int n4;
                    block7: {
                        n3 = AbstractMargin.a;
                        int n5 = this.b;
                        if (n3 == 0) {
                            if (n5 < 0) {
                                return;
                            }
                            this.c = -1;
                            n5 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
                        }
                        int n6 = n5;
                        int n7 = this.getCodeEditor().getFirstLine();
                        n4 = mouseEvent.getPoint().y / n6;
                        n2 = n4 + n7;
                        n = n4;
                        if (n3 != 0) break block6;
                        if (n > 0) break block7;
                        this.getCodeEditor().setFirstLine(n7 + n4 - 1);
                        if (n3 == 0) break block8;
                    }
                    n = n4;
                }
                if (n3 != 0) break block9;
                if (n > this.getCodeEditor().getVisibleLines() - 1) {
                    this.getCodeEditor().setFirstLine(n2 - this.getCodeEditor().getVisibleLines() + 1);
                }
            }
            n = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n2, this.b), 0)));
        }
        int n8 = n;
        int n9 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n2, this.b)));
        this.getCodeEditor().select(n8, n9);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

