/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan b;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this(null);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    public void paintMargin(Graphics graphics) {
        FoldingSpan[] foldingSpanArray;
        int n = AbstractMargin.a;
        int n2 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
            this.paintFolding(graphics, foldingSpan, n2);
            if (n == 0) continue;
        }
    }

    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        CodeFoldingPainter codeFoldingPainter = this._codeFoldingPainter;
        if (AbstractMargin.a == 0) {
            if (codeFoldingPainter == null) {
                this._codeFoldingPainter = new DefaultCodeFoldingPainter();
            }
            codeFoldingPainter = this._codeFoldingPainter;
        }
        return codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected void paintFolding(Graphics graphics, FoldingSpan foldingSpan, int n) {
        block9: {
            int n2;
            int n3;
            int n4;
            int n5;
            block4: {
                block5: {
                    int n6;
                    block8: {
                        int n7;
                        int n8;
                        block6: {
                            block7: {
                                n6 = AbstractMargin.a;
                                n5 = this.getCodeEditor().getFirstLine();
                                n4 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                n3 = this.b == foldingSpan ? 2 : 0;
                                n2 = foldingSpan.isExpanded();
                                if (n6 != 0) break block4;
                                if (n2 == 0) break block5;
                                int n9 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                n8 = n4;
                                n7 = n9;
                                if (n6 != 0) break block6;
                                if (n8 == n7) break block7;
                                n4 = this.getCodeEditor().modelToViewLine(n4) + 1;
                                n9 = this.getCodeEditor().modelToViewLine(n9) + 1;
                                int n10 = this.getCodeFoldingPainter().paintFoldingStart(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                                int n11 = this.getCodeFoldingPainter().paintFoldingEnd(this, graphics, foldingSpan, new Rectangle(0, (n9 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                                this.getCodeFoldingPainter().paintFoldingLine(this, graphics, foldingSpan, new Rectangle(0, n10, this.getWidth(), n11 - n10), n3);
                                if (n6 == 0) break block8;
                            }
                            n8 = this.getCodeEditor().modelToViewLine(n4);
                            n7 = 1;
                        }
                        n4 = n8 + n7;
                        this.getCodeFoldingPainter().paintExpandedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
                    }
                    if (n6 == 0) break block9;
                }
                n2 = this.getCodeEditor().modelToViewLine(n4) + 1;
            }
            n4 = n2;
            this.getCodeFoldingPainter().paintCollapsedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n5 - 1) * n + 1, this.getWidth(), n), n3);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block3: {
            HitInfo hitInfo;
            block10: {
                int n;
                block9: {
                    int n2;
                    block8: {
                        block4: {
                            block5: {
                                block7: {
                                    block6: {
                                        HitInfo hitInfo2;
                                        block2: {
                                            n2 = AbstractMargin.a;
                                            hitInfo2 = hitInfo = this.getSpanInfo(mouseEvent.getPoint());
                                            if (n2 != 0) break block2;
                                            if (hitInfo2 == null) break block3;
                                            hitInfo2 = hitInfo;
                                        }
                                        n = hitInfo2.a.isExpanded();
                                        if (n2 != 0) break block4;
                                        if (n == 0) break block5;
                                        n = hitInfo.b;
                                        if (n2 != 0) break block6;
                                        if (n == 0) break block7;
                                        n = hitInfo.b;
                                    }
                                    if (n2 != 0) break block4;
                                    if (n != 1) break block5;
                                }
                                this.getCodeEditor().getFoldingModel().collapseFoldingSpan(hitInfo.a);
                                if (n2 == 0) break block3;
                            }
                            n = hitInfo.a.isExpanded() ? 1 : 0;
                        }
                        if (n2 != 0) break block8;
                        if (n != 0) break block3;
                        n = hitInfo.b;
                    }
                    if (n2 != 0) break block9;
                    if (n == 0) break block10;
                    n = hitInfo.b;
                }
                if (n != 1) break block3;
            }
            this.getCodeEditor().getFoldingModel().expandFoldingSpan(hitInfo.a);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        block3: {
            CodeFoldingMargin codeFoldingMargin;
            block2: {
                codeFoldingMargin = this;
                if (AbstractMargin.a != 0) break block2;
                if (codeFoldingMargin.b == null) break block3;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block5: {
            CodeFoldingMargin codeFoldingMargin;
            block6: {
                HitInfo hitInfo;
                int n;
                block2: {
                    HitInfo hitInfo2;
                    block3: {
                        CodeFoldingMargin codeFoldingMargin2;
                        block4: {
                            n = AbstractMargin.a;
                            hitInfo = hitInfo2 = this.getSpanInfo(mouseEvent.getPoint());
                            if (n != 0) break block2;
                            if (hitInfo == null) break block3;
                            codeFoldingMargin2 = this;
                            if (n != 0) break block4;
                            if (codeFoldingMargin2.b == hitInfo2.a) break block3;
                            this.b = hitInfo2.a;
                            codeFoldingMargin2 = this;
                        }
                        codeFoldingMargin2.repaint();
                        if (n == 0) break block5;
                    }
                    hitInfo = hitInfo2;
                }
                if (hitInfo != null) break block5;
                codeFoldingMargin = this;
                if (n != 0) break block6;
                if (codeFoldingMargin.b == null) break block5;
                this.b = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        int n = AbstractMargin.a;
        int n2 = this.getCodeEditor().getFirstLine();
        int n3 = this.getCodeEditor().getPainter().getFontMetrics().getHeight();
        int n4 = point.y;
        int n5 = n4 / n3;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n6 = n2 + n5;
        FoldingSpan[] foldingSpanArray2 = foldingSpanArray;
        int n7 = foldingSpanArray2.length;
        int n8 = 0;
        while (n8 < n7) {
            FoldingSpan foldingSpan = foldingSpanArray2[n8];
            int n9 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
            int n10 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            int n11 = this.getCodeEditor().modelToViewLine(n9);
            int n12 = this.getCodeEditor().modelToViewLine(n10);
            if (n == 0) {
                if (n6 >= n11 && n6 <= n12) {
                    HitInfo hitInfo = new HitInfo();
                    hitInfo.a = foldingSpan;
                    int n13 = n6;
                    int n14 = n11;
                    if (n == 0) {
                        if (n13 == n14) {
                            hitInfo.b = 0;
                            return hitInfo;
                        }
                        n13 = n6;
                        n14 = n12;
                    }
                    if (n13 == n14) {
                        hitInfo.b = 0;
                        return hitInfo;
                    }
                }
                ++n8;
            }
            if (n == 0) continue;
        }
        return null;
    }

    protected static class HitInfo {
        FoldingSpan a;
        int b;

        protected HitInfo() {
        }
    }
}

