/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.Span;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.icons.IconsFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.Icon;

public class DefaultCodeFoldingPainter
implements CodeFoldingPainter {
    private static final Icon a = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom.png");
    private static final Icon b = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top.png");
    private static final Icon c = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed.png");
    private static final Icon d = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened.png");
    private static final Icon e = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom_r.png");
    private static final Icon f = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top_r.png");
    private static final Icon g = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed_r.png");
    private static final Icon h = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened_r.png");
    private static final BasicStroke i = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    public int paintFoldingStart(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? f : b;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 + icon.getIconHeight() / 2;
    }

    public int paintFoldingEnd(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? e : a;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2;
    }

    public void paintCollapsedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? g : c;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    public void paintExpandedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? h : d;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    public void paintFoldingLine(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        block3: {
            int n2;
            int n3;
            block2: {
                n3 = n;
                n2 = 2;
                if (AbstractMargin.a != 0) break block2;
                if (n3 != n2) break block3;
                graphics.setColor(Color.BLACK);
                n3 = rectangle.x;
                n2 = rectangle.width / 2;
            }
            int n4 = n3 + n2;
            graphics.drawLine(n4, rectangle.y, n4, rectangle.y + rectangle.height);
        }
    }

    public void paintBackground(Component component, Graphics graphics, Rectangle rectangle) {
        Stroke stroke;
        Color color;
        int n;
        int n2;
        block4: {
            Graphics graphics2;
            block2: {
                block3: {
                    int n3 = AbstractMargin.a;
                    n2 = rectangle.x + rectangle.width / 2;
                    n = rectangle.height;
                    color = graphics.getColor();
                    stroke = ((Graphics2D)graphics).getStroke();
                    graphics.setColor(component.getBackground());
                    graphics2 = graphics;
                    if (n3 != 0) break block2;
                    graphics2.fillRect(rectangle.x, rectangle.y, n2, n);
                    if (!(component instanceof AbstractMargin)) break block3;
                    CodeEditor codeEditor = ((AbstractMargin)component).getCodeEditor();
                    graphics.setColor(codeEditor.getPainter().getBackground());
                    if (n3 == 0) break block4;
                    CodeEditor.O = !CodeEditor.O;
                }
                graphics2 = graphics;
            }
            graphics2.setColor(Color.WHITE);
        }
        graphics.fillRect(rectangle.x + n2 + 1, rectangle.y, n2, n);
        graphics.setColor(Color.GRAY);
        ((Graphics2D)graphics).setStroke(i);
        graphics.drawLine(n2, 0, n2, n);
        graphics.setColor(color);
        ((Graphics2D)graphics).setStroke(stroke);
    }

    public int getPreferredWidth() {
        return a.getIconWidth() + 4;
    }
}

