/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.margin.AbstractLineMargin;
import com.jidesoft.editor.margin.AbstractMargin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LineOffsetMargin
extends AbstractLineMargin
implements DocumentListener {
    public LineOffsetMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.getCodeEditor().getDocument().addDocumentListener(this);
    }

    public void paintLineMargin(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = AbstractMargin.a;
        int n3 = this.getCodeEditor().getLineStartOffset(n);
        int n4 = this.getCodeEditor().getLineEndOffset(n);
        String string = n3 + " - " + n4;
        graphics.setColor(new Color(128, 128, 0));
        graphics.drawString(string, rectangle.x + rectangle.width - this.getCodeEditor().getPainter().getFontMetrics().stringWidth(string) - 3, rectangle.y + this.getCodeEditor().getPainter().getFontMetrics().getAscent());
        if (CodeEditor.O) {
            AbstractMargin.a = ++n2;
        }
    }

    public int getPreferredWidth() {
        int n = this.getCodeEditor().getDocument().getLength();
        String string = n + " - " + n;
        return this.getCodeEditor().getPainter().getFontMetrics().stringWidth(string) + 6;
    }

    public String getToolTipText(int n) {
        return "" + (n + 1);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.repaint();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.repaint();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.repaint();
    }
}

