/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyContext;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.embed.variable.VariableInterceptor;

public class Utils {
    static int getLineNumber(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.LINENUMBER.toString(), 100);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    static Object getReceiver(ScriptContext context) {
        return context.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    static String getFilename(ScriptContext context) {
        Object filename2 = context.getAttribute("javax.script.filename");
        return filename2 != null ? (String)filename2 : "<script>";
    }

    static boolean isTerminationOn(ScriptContext context) {
        boolean termination = false;
        Object obj = context.getAttribute(AttributeName.TERMINATION.toString());
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            termination = true;
        }
        return termination;
    }

    static void preEval(ScriptingContainer container, JRubyContext jrubyContext) {
        Object value2;
        Object receiver2 = Utils.getReceiverObject(jrubyContext);
        Bindings bindings = jrubyContext.getEngineScopeBindings();
        Set keys2 = bindings.keySet();
        for (String key2 : keys2) {
            value2 = bindings.get(key2);
            Utils.put(container, receiver2, key2, value2);
        }
        bindings = jrubyContext.getGlobalScopeBindings();
        if (bindings == null) {
            return;
        }
        keys2 = bindings.keySet();
        for (String key2 : keys2) {
            if (container.getVarMap().containsKey(key2)) continue;
            value2 = bindings.get(key2);
            Utils.put(container, receiver2, key2, value2);
        }
    }

    private static Object getReceiverObject(JRubyContext jrubyContext) {
        if (jrubyContext == null) {
            return null;
        }
        return jrubyContext.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    static void postEval(ScriptingContainer container, JRubyContext jrubyContext) {
        Bindings globalMap;
        if (jrubyContext == null) {
            return;
        }
        Object receiver2 = Utils.getReceiverObject(jrubyContext);
        Bindings engineMap = jrubyContext.getEngineScopeBindings();
        int size2 = engineMap.keySet().size();
        String[] names2 = engineMap.keySet().toArray(new String[size2]);
        for (int i2 = 0; i2 < names2.length; ++i2) {
            if (!Utils.shouldLVarBeDeleted(container, names2[i2])) continue;
            engineMap.remove(names2[i2]);
        }
        Set keys2 = container.getVarMap().keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key2 : keys2) {
                Object value2 = container.getVarMap().get(key2);
                engineMap.put(Utils.adjustKey(key2), value2);
            }
        }
        if ((globalMap = jrubyContext.getGlobalScopeBindings()) == null) {
            return;
        }
        keys2 = globalMap.keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key3 : keys2) {
                if (engineMap.containsKey(key3)) continue;
                Object value3 = container.getVarMap().get(receiver2, key3);
                globalMap.put(key3, value3);
            }
        }
    }

    private static Object put(ScriptingContainer container, Object receiver2, String key2, Object value2) {
        Object oldValue = null;
        String adjustedKey = Utils.adjustKey(key2);
        oldValue = Utils.isRubyVariable(container, adjustedKey) ? container.put(receiver2, adjustedKey, value2) : container.setAttribute(adjustedKey, value2);
        return oldValue;
    }

    static boolean isRubyVariable(ScriptingContainer container, String name2) {
        return VariableInterceptor.isKindOfRubyVariable(container.getProvider().getLocalVariableBehavior(), name2);
    }

    private static String adjustKey(String key2) {
        if (key2.equals("javax.script.argv")) {
            return "ARGV";
        }
        if ("ARGV".equals(key2)) {
            return "javax.script.argv";
        }
        return key2;
    }

    private static boolean shouldLVarBeDeleted(ScriptingContainer container, String key2) {
        LocalVariableBehavior behavior = container.getProvider().getLocalVariableBehavior();
        if (behavior != LocalVariableBehavior.TRANSIENT) {
            return false;
        }
        return TransientLocalVariable.isValidName(key2);
    }
}

