/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconsFactory {
    static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> disableIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> enhancedIcons = new HashMap<String, ImageIcon>();
    public static ImageIcon EMPTY_ICON = new ImageIcon(){
        private static final long serialVersionUID = 5081581607741629368L;

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    };
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon getImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        Icon icon = icons.get(string2);
        if (icon != null) {
            return (ImageIcon)icon;
        }
        ImageIcon imageIcon = IconsFactory.createImageIcon(clazz, string);
        icons.put(string2, imageIcon);
        return imageIcon;
    }

    public static ImageIcon findImageIcon(Class<?> clazz, String string) throws IOException {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = icons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createImageIconWithException(clazz, string);
        icons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getDisabledImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = disableIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createGrayImage(IconsFactory.getImageIcon(clazz, string));
        disableIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = enhancedIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string));
        enhancedIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string, int n) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = enhancedIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string), n);
        enhancedIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon createGrayImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    private static ImageIcon createGrayImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
    }

    public static ImageIcon createGrayImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        if (n == 0 || n2 == 0) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image));
    }

    public static ImageIcon createBrighterImage(Image image, int n) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image, n));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon, int n) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage, n));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage()));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon, int n) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage(), n));
    }

    public static ImageIcon createNegativeImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(MaskFilter.createNegativeImage(image));
    }

    public static ImageIcon createMaskImage(Component component, Icon icon, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(bufferedImage, color, color2));
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d) {
        int n;
        int n2;
        double d2 = d % 360.0;
        if (d != 0.0 && d2 == 0.0) {
            d2 = 360.0;
        }
        double d3 = d2 % 90.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 90.0;
        }
        double d4 = Math.toRadians(d3);
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        if (d2 >= 0.0 && d2 <= 90.0 || d2 > 180.0 && d2 <= 270.0) {
            n2 = (int)Math.round((double)n3 * Math.sin(1.5707963267948966 - d4) + (double)n4 * Math.sin(d4));
            n = (int)Math.round((double)n3 * Math.sin(d4) + (double)n4 * Math.sin(1.5707963267948966 - d4));
        } else {
            n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d4) + (double)n3 * Math.sin(d4));
            n = (int)((double)n4 * Math.sin(d4) + (double)n3 * Math.sin(1.5707963267948966 - d4));
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        int n7 = n3 % 2 != 0 && d2 >= 90.0 && d2 <= 180.0 ? 1 : 0;
        int n8 = n3 % 2 != 0 && d2 >= 180.0 && d2 < 360.0 ? 1 : 0;
        graphics2D.translate(n2 / 2 + n7, n / 2 + n8);
        graphics2D.rotate(Math.toRadians(d2));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n5, -n6);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createNegativeImage(Component component, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(bufferedImage));
    }

    private static ImageIcon createImageIcon(Class<?> clazz, String string) {
        try {
            return IconsFactory.createImageIconWithException(clazz, string);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return null;
        }
    }

    private static ImageIcon createImageIconWithException(Class<?> clazz, String string) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        Image image = "true".equals(SecurityUtils.getProperty("jide.useImageIO", "true")) ? ImageIO.read(inputStream) : IconsFactory.readImageIcon(clazz, string, inputStream);
        inputStream.close();
        return new ImageIcon(image);
    }

    private static Image readImageIcon(Class clazz, String string, InputStream inputStream) throws IOException {
        int n;
        byte[][] byArrayArray = new byte[1][];
        Object object = new BufferedInputStream(inputStream);
        Object object2 = new ByteArrayOutputStream(1024);
        byArrayArray[0] = new byte[1024];
        while ((n = ((FilterInputStream)object).read(byArrayArray[0])) > 0) {
            ((ByteArrayOutputStream)object2).write(byArrayArray[0], 0, n);
        }
        ((BufferedInputStream)object).close();
        ((OutputStream)object2).flush();
        byArrayArray[0] = ((ByteArrayOutputStream)object2).toByteArray();
        if (byArrayArray[0] == null || byArrayArray[0].length == 0) {
            object = clazz.getPackage();
            object2 = "";
            if (object != null) {
                object2 = ((Package)object).getName().replace('.', '/');
            }
            if (byArrayArray[0] == null) {
                throw new IOException("Warning: Resource " + (String)object2 + "/" + string + " not found.");
            }
            if (byArrayArray[0].length == 0) {
                throw new IOException("Warning: Resource " + (String)object2 + "/" + string + " is zero-length");
            }
        }
        return Toolkit.getDefaultToolkit().createImage(byArrayArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateHTML(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = IconsFactory.getClassName(string);
        File file = new File(string + ".html");
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + string + "</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + string2 + ".java</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + string2 + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual " + "full constant name as in the table below" + "</font></b></p>");
                IconsFactory.generate(clazz, fileWriter, string2);
                fileWriter.write("\n</body>\n</html>");
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            finally {
                fileWriter.close();
            }
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + string2 + ".java");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static String getClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static void generate(Class<?> clazz, FileWriter fileWriter, String string) throws IOException {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i = classArray.length - 1; i >= 0; --i) {
            Field[] fieldArray = classArray[i];
            IconsFactory.generate(fieldArray, fileWriter, IconsFactory.getClassName(fieldArray.getName()));
        }
        Field[] fieldArray = clazz.getFields();
        fileWriter.write("<p><font face=\"Verdana\"><b>" + string + "</b></font></p>");
        fileWriter.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        fileWriter.write("<tr>\n");
        fileWriter.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        fileWriter.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        fileWriter.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        fileWriter.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        fileWriter.write("</tr>\n");
        for (Field field : fieldArray) {
            try {
                String string2 = field.getName();
                Object object = field.get(clazz);
                fileWriter.write("<tr>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string2 + "</font></td>\n");
                fileWriter.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + object + "\"></font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + object + "</font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string + "." + string2 + "</font></td>\n");
                fileWriter.write("</tr>\n");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        fileWriter.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n, int n2, int n3, int n4) {
        return IconsFactory.getIcon(component, imageIcon, n, n2, n3, n4, n3, n4);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n, int n2, int n3, int n4, int n5, int n6) {
        return IconsFactory.getIcon(component, imageIcon, n, n2, n3, n4, 2, n5, n6);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n, int n2, int n3, int n4, int n5) {
        return IconsFactory.getIcon(component, imageIcon, n, n2, n3, n4, n5, n3, n4);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (imageIcon == null || n < 0 || n + n3 > imageIcon.getIconWidth() || n2 < 0 || n2 + n4 > imageIcon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, n5);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n6, n7, n, n2, n + n3, n2 + n4, component);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n) {
        return IconsFactory.getOverlayIcon(component, imageIcon, imageIcon2, n, new Insets(0, 0, 0, 0));
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n, Insets insets) {
        int n2 = -1;
        int n3 = -1;
        int n4 = imageIcon.getIconWidth();
        int n5 = imageIcon.getIconHeight();
        int n6 = imageIcon2.getIconWidth();
        int n7 = imageIcon2.getIconHeight();
        switch (n) {
            case 0: {
                n2 = (n4 - n6) / 2;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 1: {
                n2 = (n4 - n6) / 2;
                n3 = insets.top;
                break;
            }
            case 5: {
                n2 = (n4 - n6) / 2;
                n3 = n5 - insets.bottom - n7;
                break;
            }
            case 7: {
                n2 = insets.left;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 3: {
                n2 = n4 - insets.right - n6;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 2: {
                n2 = n4 - insets.right - n6;
                n3 = insets.top;
                break;
            }
            case 8: {
                n2 = insets.left;
                n3 = insets.top;
                break;
            }
            case 6: {
                n2 = insets.left;
                n3 = n5 - insets.bottom - n7;
                break;
            }
            case 4: {
                n2 = n4 - insets.right - n6;
                n3 = n5 - insets.bottom - n7;
            }
        }
        return IconsFactory.getOverlayIcon(component, imageIcon, imageIcon2, n2, n3);
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2) {
        int n3 = imageIcon == null ? imageIcon2.getIconWidth() : imageIcon.getIconWidth();
        int n4 = imageIcon == null ? imageIcon2.getIconHeight() : imageIcon.getIconHeight();
        int n5 = imageIcon2.getIconWidth();
        int n6 = imageIcon2.getIconHeight();
        if (n != -1 && n2 != -1) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            if (imageIcon != null) {
                bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n3, n4, component);
            }
            bufferedImage.getGraphics().drawImage(imageIcon2.getImage(), n, n2, n5, n6, component);
            return new ImageIcon(bufferedImage);
        }
        return imageIcon;
    }

    public static ImageIcon getCombinedIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (imageIcon == null) {
            return imageIcon2;
        }
        if (imageIcon2 == null) {
            return imageIcon;
        }
        int n9 = imageIcon.getIconWidth();
        int n10 = imageIcon.getIconHeight();
        int n11 = imageIcon2.getIconWidth();
        int n12 = imageIcon2.getIconHeight();
        if (n == 0) {
            n8 = n9 + n11 + n2;
            n7 = Math.max(n10, n12);
            n6 = 0;
            n5 = n9 + n2;
            n4 = n10 > n12 ? 0 : (n12 - n10) / 2;
            n3 = n10 < n12 ? 0 : (n10 - n12) / 2;
        } else {
            n8 = Math.max(n9, n11);
            n7 = n10 + n12 + n2;
            n6 = n9 > n11 ? 0 : (n11 - n9) / 2;
            n5 = n9 < n11 ? 0 : (n9 - n11) / 2;
            n4 = 0;
            n3 = n10 + n2;
        }
        BufferedImage bufferedImage = new BufferedImage(n8, n7, 2);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), n6, n4, n9, n10, component);
        bufferedImage.getGraphics().drawImage(imageIcon2.getImage(), n5, n3, n11, n12, component);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getScaledImage(Component component, ImageIcon imageIcon, int n, int n2) {
        if (n >= imageIcon.getIconWidth() / 2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
        graphics2D.dispose();
        return new ImageIcon(JideSwingUtilities.getFasterScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true));
    }
}

