/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Calculator
extends JPanel
implements ActionListener {
    private double _result;
    private StringBuffer _op1 = new StringBuffer();
    private StringBuffer _op2 = new StringBuffer();
    private int _operator = -1;
    private String _displayText;
    private boolean _overflow = false;
    private boolean _negationOp1 = true;
    private boolean _backspaceOp1 = false;
    private boolean _backspaceOp2 = false;
    private boolean _clearOperatorPending = false;
    private boolean _isFakedEqualPressed = false;
    private boolean _resultCalculated = false;
    public static final int OPERATOR_NONE = -1;
    public static final int OPERATOR_ADD = 0;
    public static final int OPERATOR_MINUS = 1;
    public static final int OPERATOR_MULTIPLY = 2;
    public static final int OPERATOR_DIVIDE = 3;
    private AbstractButton _addButton;
    private AbstractButton _minusButton;
    private AbstractButton _multiplyButton;
    private AbstractButton _divideButton;
    private AbstractButton _pointButton;
    private AbstractButton _equalButton;
    private AbstractButton _backspaceButton;
    private AbstractButton _clearButton;
    private AbstractButton _negativeButton;
    private AbstractButton[] _numberButtons;
    private char _actualCharPoint;
    private NumberFormat _displayFormat = NumberFormat.getNumberInstance();
    public static final char CHAR_CLEAR = 'c';
    public static final char CHAR_POINT = '.';
    public static final char CHAR_ADD = '+';
    public static final char CHAR_MINUS = '-';
    public static final char CHAR_MULTIPLY = '*';
    public static final char CHAR_DIVIDE = '/';
    public static final char CHAR_EQUAL = '=';
    public static final char CHAR_NEGATIVE = '!';
    public static final char CHAR_BACKSPACE = '<';
    public static final char CHAR_0 = '0';
    public static final char CHAR_1 = '1';
    public static final char CHAR_2 = '2';
    public static final char CHAR_3 = '3';
    public static final char CHAR_4 = '4';
    public static final char CHAR_5 = '5';
    public static final char CHAR_6 = '6';
    public static final char CHAR_7 = '7';
    public static final char CHAR_8 = '8';
    public static final char CHAR_9 = '9';
    public static final String PROPERTY_DISPLAY_TEXT = "displayText";
    public static final String PROPERTY_OPERATOR = "operator";
    private int _buttonWidth = 24;
    private int _buttonHeight = 24;
    private int _buttonGap = 2;

    public Calculator() {
        this.configureNumberFormat();
        this.initComponents();
        this.registerKeyboardActions(this, 1);
    }

    public void setLocale(Locale locale) {
        this.unregisterKeyboardActions(this);
        super.setLocale(locale);
        this._op1 = new StringBuffer();
        this._op2 = new StringBuffer();
        this._displayFormat = NumberFormat.getNumberInstance(this.getLocale());
        this.configureNumberFormat();
        this._actualCharPoint = this.getDisplayFormat().format(2.01).charAt(1);
        this._pointButton.setText("" + this._actualCharPoint);
        this.registerKeyboardActions(this, 1);
    }

    protected void configureNumberFormat() {
        this._displayFormat.setMaximumFractionDigits(20);
        this._displayFormat.setMinimumFractionDigits(0);
        this._displayFormat.setGroupingUsed(false);
    }

    public static boolean isValidKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return (keyEvent.getModifiers() & 0xFFFFFFFE) != 0 || Character.isDigit(c) || Calculator.isOperator(keyEvent) || Calculator.isEnterOrEqual(keyEvent) || c == '.' || c == 'c' || Character.toLowerCase(c) == 'c' || c == '\u001b' || c == '\b';
    }

    public static boolean isOperator(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    public static boolean isEnterOrEqual(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return c == '\n' || c == '=';
    }

    public void registerKeyboardActions(JComponent jComponent, int n) {
        boolean bl = this.isCellEditor();
        jComponent.registerKeyboardAction(this, "+", KeyStroke.getKeyStroke('+'), n);
        jComponent.registerKeyboardAction(this, "-", KeyStroke.getKeyStroke('-'), n);
        jComponent.registerKeyboardAction(this, "*", KeyStroke.getKeyStroke('*'), n);
        jComponent.registerKeyboardAction(this, "/", KeyStroke.getKeyStroke('/'), n);
        jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke('='), n);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke(10, 0), n);
        }
        jComponent.registerKeyboardAction(this, "0", KeyStroke.getKeyStroke('0'), n);
        jComponent.registerKeyboardAction(this, "1", KeyStroke.getKeyStroke('1'), n);
        jComponent.registerKeyboardAction(this, "2", KeyStroke.getKeyStroke('2'), n);
        jComponent.registerKeyboardAction(this, "3", KeyStroke.getKeyStroke('3'), n);
        jComponent.registerKeyboardAction(this, "4", KeyStroke.getKeyStroke('4'), n);
        jComponent.registerKeyboardAction(this, "5", KeyStroke.getKeyStroke('5'), n);
        jComponent.registerKeyboardAction(this, "6", KeyStroke.getKeyStroke('6'), n);
        jComponent.registerKeyboardAction(this, "7", KeyStroke.getKeyStroke('7'), n);
        jComponent.registerKeyboardAction(this, "8", KeyStroke.getKeyStroke('8'), n);
        jComponent.registerKeyboardAction(this, "9", KeyStroke.getKeyStroke('9'), n);
        jComponent.registerKeyboardAction(this, "" + this._actualCharPoint, KeyStroke.getKeyStroke(this._actualCharPoint), n);
        jComponent.registerKeyboardAction(this, "<", KeyStroke.getKeyStroke(8, 0), n);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), n);
        }
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), 1);
        }
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toUpperCase('c')), n);
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toLowerCase('c')), n);
    }

    public void unregisterKeyboardActions(JComponent jComponent) {
        boolean bl = this.isCellEditor();
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('+'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('-'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('*'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('/'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('='));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('0'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('1'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('2'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('3'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('4'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('5'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('6'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('7'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('8'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('9'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(this._actualCharPoint));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toUpperCase('c')));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toLowerCase('c')));
    }

    protected void initComponents() {
        this.setLayout(new CalculatorLayoutManager());
        this._addButton = this.createButton("+");
        this.add(this._addButton);
        this._minusButton = this.createButton("-");
        this.add(this._minusButton);
        this._multiplyButton = this.createButton("*");
        this.add(this._multiplyButton);
        this._divideButton = this.createButton("/");
        this.add(this._divideButton);
        this._numberButtons = new AbstractButton[10];
        for (int i = 0; i <= 9; ++i) {
            this._numberButtons[i] = this.createButton("" + i);
            this.add(this._numberButtons[i]);
        }
        this._actualCharPoint = this.getDisplayFormat().format(2.01).charAt(1);
        this._pointButton = this.createButton("" + this._actualCharPoint);
        this.add(this._pointButton);
        this._equalButton = this.createButton("=");
        this.add(this._equalButton);
        this._backspaceButton = this.createButton(null, new BackspaceIcon());
        this.add(this._backspaceButton);
        this._negativeButton = this.createButton(null, new ToggleNegativeIcon());
        this.add(this._negativeButton);
        this._clearButton = this.createButton("C");
        this.add(this._clearButton);
    }

    public boolean isResultCalculated() {
        return this._resultCalculated;
    }

    public void setResultCalculated(boolean bl) {
        this._resultCalculated = bl;
    }

    protected AbstractButton createButton(String string) {
        return this.createButton(string, null);
    }

    protected AbstractButton createButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setOpaque(true);
        jideButton.setContentAreaFilled(true);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        jideButton.addActionListener(this);
        return jideButton;
    }

    public boolean isOverflow() {
        return this._overflow;
    }

    public void setOverflow(boolean bl) {
        this._overflow = bl;
    }

    public void input(char c) {
        if ('c' == Character.toLowerCase(c) || 'c' == Character.toUpperCase(c)) {
            this.clear();
            return;
        }
        if (this._overflow) {
            this.beep();
            return;
        }
        if (Character.isDigit(c) || this._actualCharPoint == c) {
            if (this._clearOperatorPending) {
                this.setOperator(-1);
                this._op1.setLength(0);
                this._clearOperatorPending = false;
            }
            if (this.getOperator() == -1) {
                if (this._actualCharPoint != c || this._op1.indexOf("" + this._actualCharPoint) == -1) {
                    this._op1.append(c);
                    this._backspaceOp1 = true;
                    this._backspaceOp2 = false;
                    this.setDisplayText(this._op1.toString());
                } else {
                    this.beep();
                }
            } else if (this._actualCharPoint != c || this._op2.indexOf("" + this._actualCharPoint) == -1) {
                this._op2.append(c);
                this._backspaceOp2 = true;
                this._backspaceOp1 = false;
                this.setDisplayText(this._op2.toString());
            } else {
                this.beep();
            }
        } else {
            switch (c) {
                case '+': {
                    this.operatorPressed(0);
                    break;
                }
                case '-': {
                    this.operatorPressed(1);
                    break;
                }
                case '*': {
                    this.operatorPressed(2);
                    break;
                }
                case '/': {
                    this.operatorPressed(3);
                    break;
                }
                case '=': {
                    this.calculateResult(true);
                    this._clearOperatorPending = true;
                    break;
                }
                case '!': {
                    if (this._negationOp1) {
                        this.negativePressed(this._op1);
                        this.setDisplayText(this._op1.toString());
                        break;
                    }
                    this.negativePressed(this._op2);
                    this.setDisplayText(this._op2.toString());
                    break;
                }
                case '<': {
                    if (this._backspaceOp1) {
                        this.backspacePressed(this._op1);
                        this.setDisplayText(this._op1.toString());
                        break;
                    }
                    if (this._backspaceOp2) {
                        this.backspacePressed(this._op2);
                        this.setDisplayText(this._op2.toString());
                        break;
                    }
                    this.beep();
                }
            }
        }
    }

    private void operatorPressed(int n) {
        if (this._op1.length() == 0) {
            this._op1.append("0");
        } else if (this.getOperator() == -1 || this._clearOperatorPending) {
            this._op2.setLength(0);
            this.calculateResult(false);
        } else {
            if (this._op2.length() == 0) {
                this.beep();
                return;
            }
            this._isFakedEqualPressed = false;
            this.calculateResult(true);
            this._op1.setLength(0);
            this._op1.append(Double.valueOf(this._result).toString());
            this._op2.setLength(0);
        }
        this.setOperator(n);
        this._negationOp1 = false;
        this._clearOperatorPending = false;
    }

    protected void beep() {
        PortingUtils.notifyUser();
    }

    private void negativePressed(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        if (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
        } else {
            stringBuffer.insert(0, '-');
        }
    }

    private void backspacePressed(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
    }

    public void updateResult() {
        this._isFakedEqualPressed = false;
        this.calculateResult(true);
    }

    private void calculateResult(boolean bl) {
        Double d;
        Double d2;
        if (this.getOperator() == -1) {
            return;
        }
        if (this._op1.length() == 0) {
            this.beep();
            return;
        }
        if (bl) {
            if (this._op2.length() == 0) {
                this._op2.append(this._op1);
            }
        } else if (this._op2.length() == 0) {
            return;
        }
        try {
            d2 = this.getDisplayFormat().parse(this._op1.toString()).doubleValue();
            d = this.getDisplayFormat().parse(this._op2.toString()).doubleValue();
        }
        catch (ParseException parseException) {
            d2 = 0.0;
            d = 0.0;
        }
        if (!this._isFakedEqualPressed) {
            try {
                switch (this.getOperator()) {
                    case 0: {
                        this._result = d2 + d;
                        break;
                    }
                    case 1: {
                        this._result = d2 - d;
                        break;
                    }
                    case 2: {
                        this._result = d2 * d;
                        break;
                    }
                    case 3: {
                        if (d == 0.0) {
                            this._result = Double.NaN;
                            this._overflow = true;
                            break;
                        }
                        this._result = d2 / d;
                    }
                }
            }
            catch (Exception exception) {
                this._overflow = true;
            }
        }
        if (this._overflow) {
            this.setDisplayText("E");
        } else {
            this.setResultCalculated(true);
            this._op1.setLength(0);
            if (this._displayFormat != null) {
                String string = this._displayFormat.format(this._result);
                this.setDisplayText(string);
            } else {
                this.setDisplayText("" + this._result);
            }
            this._op1.append(this.getDisplayText());
            this._negationOp1 = true;
            this._backspaceOp1 = true;
            this._backspaceOp2 = false;
        }
    }

    private void clearOps() {
        this.setOperator(-1);
        this._op1.setLength(0);
        this._op2.setLength(0);
    }

    public void clear() {
        this.clearOps();
        this._overflow = false;
        this._clearOperatorPending = false;
        this.setDisplayText("0");
    }

    public double getResult() {
        return this._result;
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public void setDisplayText(String string) {
        String string2 = this._displayText;
        this._displayText = string;
        this.firePropertyChange(PROPERTY_DISPLAY_TEXT, string2, this._displayText);
    }

    public int getOperator() {
        return this._operator;
    }

    public void setOperator(int n) {
        int n2 = this._operator;
        if (n2 != n) {
            this._operator = n;
            this.firePropertyChange(PROPERTY_OPERATOR, new Integer(n2), new Integer(n));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._addButton == object) {
            this.input('+');
        } else if (this._minusButton == object) {
            this.input('-');
        } else if (this._multiplyButton == object) {
            this.input('*');
        } else if (this._divideButton == object) {
            this.input('/');
        } else if (this._equalButton == object) {
            this._isFakedEqualPressed = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("Faked");
            this.input('=');
        } else if (this._pointButton == object) {
            this.input(this._actualCharPoint);
        } else if (this._negativeButton == object) {
            this.input('!');
        } else if (this._backspaceButton == object) {
            this.input('<');
        } else if (this._clearButton == object) {
            this.input('c');
        } else {
            boolean bl = false;
            for (int i = 0; i <= 9; ++i) {
                if (this._numberButtons[i] != object) continue;
                this.input(("" + i).charAt(0));
                bl = true;
                break;
            }
            if (!bl) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().length() > 0) {
                    this.fakePressButton(actionEvent.getActionCommand().charAt(0));
                } else {
                    this.fakePressButton('=');
                }
            }
        }
    }

    protected void fakePressButton(AbstractButton abstractButton) {
        this.actionPerformed(new ActionEvent(abstractButton, 0, null));
    }

    private void fakePressButton(char c) {
        if (c == this._actualCharPoint) {
            this.fakePressButton(this._pointButton);
            return;
        }
        switch (c) {
            case 'c': {
                this.fakePressButton(this._clearButton);
                break;
            }
            case '<': {
                this.fakePressButton(this._backspaceButton);
                break;
            }
            case '=': {
                this.fakePressButton(this._equalButton);
                break;
            }
            case '!': {
                this.fakePressButton(this._negativeButton);
                break;
            }
            case '+': {
                this.fakePressButton(this._addButton);
                break;
            }
            case '-': {
                this.fakePressButton(this._minusButton);
                break;
            }
            case '*': {
                this.fakePressButton(this._multiplyButton);
                break;
            }
            case '/': {
                this.fakePressButton(this._divideButton);
                break;
            }
            case '0': {
                this.fakePressButton(this._numberButtons[0]);
                break;
            }
            case '1': {
                this.fakePressButton(this._numberButtons[1]);
                break;
            }
            case '2': {
                this.fakePressButton(this._numberButtons[2]);
                break;
            }
            case '3': {
                this.fakePressButton(this._numberButtons[3]);
                break;
            }
            case '4': {
                this.fakePressButton(this._numberButtons[4]);
                break;
            }
            case '5': {
                this.fakePressButton(this._numberButtons[5]);
                break;
            }
            case '6': {
                this.fakePressButton(this._numberButtons[6]);
                break;
            }
            case '7': {
                this.fakePressButton(this._numberButtons[7]);
                break;
            }
            case '8': {
                this.fakePressButton(this._numberButtons[8]);
                break;
            }
            case '9': {
                this.fakePressButton(this._numberButtons[9]);
            }
        }
    }

    public NumberFormat getDisplayFormat() {
        return this._displayFormat;
    }

    public void setDisplayFormat(NumberFormat numberFormat) {
        this._displayFormat = numberFormat;
    }

    public void commit() {
        if (!this._clearOperatorPending) {
            this.actionPerformed(new ActionEvent(this._equalButton, 0, "Faked"));
        }
    }

    public int getButtonWidth() {
        return this._buttonWidth;
    }

    public void setButtonWidth(int n) {
        this._buttonWidth = n;
    }

    public int getButtonHeight() {
        return this._buttonHeight;
    }

    public void setButtonHeight(int n) {
        this._buttonHeight = n;
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int n) {
        this._buttonGap = n;
    }

    protected boolean isCellEditor() {
        return false;
    }

    public void setInitialValue(String string) {
        this._op1.setLength(0);
        this._op1.append(string);
        this._backspaceOp1 = true;
        this._backspaceOp2 = false;
        this.setDisplayText(this._op1.toString());
    }

    public static void main(String[] stringArray) {
        Calculator calculator = new Calculator();
        calculator.input('1');
        calculator.input('0');
        calculator.input('*');
        calculator.input('2');
        calculator.input('4');
        calculator.input('=');
    }

    private class CalculatorLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(Calculator.this.getButtonWidth() * 4 + Calculator.this.getButtonGap() * 3, Calculator.this.getButtonHeight() * 5 + Calculator.this.getButtonGap() * 4);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = Calculator.this.getButtonWidth();
            int n4 = Calculator.this.getButtonHeight();
            int n5 = Calculator.this.getButtonGap();
            Calculator.this._numberButtons[7].setBounds(n, n2, n3, n4);
            Calculator.this._numberButtons[8].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._numberButtons[9].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._divideButton.setBounds(n += n3 + n5, n2, n3, n4);
            n = 0;
            Calculator.this._numberButtons[4].setBounds(n, n2 += n4 + n5, n3, n4);
            Calculator.this._numberButtons[5].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._numberButtons[6].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._multiplyButton.setBounds(n += n3 + n5, n2, n3, n4);
            n = 0;
            Calculator.this._numberButtons[1].setBounds(n, n2 += n4 + n5, n3, n4);
            Calculator.this._numberButtons[2].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._numberButtons[3].setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._minusButton.setBounds(n += n3 + n5, n2, n3, n4);
            n = 0;
            Calculator.this._numberButtons[0].setBounds(n, n2 += n4 + n5, n3, n4);
            Calculator.this._pointButton.setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._negativeButton.setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._addButton.setBounds(n += n3 + n5, n2, n3, n4);
            n = 0;
            Calculator.this._clearButton.setBounds(n, n2 += n4 + n5, n3, n4);
            Calculator.this._backspaceButton.setBounds(n += n3 + n5, n2, n3, n4);
            Calculator.this._equalButton.setBounds(n += n3 + n5, n2, n3 * 2 + n5, n4);
        }
    }

    class ToggleNegativeIcon
    implements Icon {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics.setColor(component.getForeground());
            graphics.drawLine(n, n2 + 2, n + 6, n2 + 2);
            graphics.drawLine(n, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n + 3, n2, n + 3, n2 + 5);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    class BackspaceIcon
    implements Icon {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            Color color = graphics.getColor();
            graphics.setColor(component.getForeground());
            graphics.drawLine(n, n2 + 3, n + 3, n2);
            graphics.drawLine(n, n2 + 3, n + 3, n2 + 6);
            graphics.drawLine(n + 3, n2 + 3, n + 7, n2 + 3);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }
}

