/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms;

import BinNavi.API.disassembly.Instruction;
import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.OperandType;
import BinNavi.API.reil.ReilBlock;
import BinNavi.API.reil.ReilGraph;
import BinNavi.API.reil.ReilHelpers;
import BinNavi.API.reil.ReilInstruction;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.OperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.BTPosition;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;

public class ExpressionTreeExtractor {
    private static long addressToLong(ComparableReilOperand thirdOperand) {
        String[] temp = thirdOperand.getElement().getValue().split("\\.");
        return Long.parseLong(temp[0]) * 256L + Long.parseLong(temp[1]);
    }

    private static long calculateSkippedInstructions(ReilInstruction reilInstruction) {
        if (reilInstruction.getThirdOperand().getType() == OperandType.SUB_ADDRESS) {
            return ExpressionTreeExtractor.addressToLong(new ComparableReilOperand(reilInstruction.getThirdOperand())) - ExpressionTreeExtractor.instructionAddressToLong(reilInstruction) - 1L;
        }
        throw new IllegalStateException();
    }

    private static long handleBinaryInstructions(ReilInstruction reilInstruction, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        LinkedBinaryTree<ComparableReilOperand> operand1 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
        LinkedBinaryTree<ComparableReilOperand> operation = new LinkedBinaryTree<ComparableReilOperand>();
        Position<ComparableReilOperand> operationRoot = operation.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, reilInstruction.getMnemonic())));
        operation.attach(operationRoot, operand1, null);
        return ExpressionTreeExtractor.updateOperandTrees(reilInstruction.getThirdOperand(), operation, skippedInstructions, operandTrees, currentNativeInstructionAddress);
    }

    private static long handleJccInstruction(ReilInstruction reilInstruction, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        if (ReilHelpers.isUnconditionalJump((ReilInstruction)reilInstruction)) {
            LinkedBinaryTree<ComparableReilOperand> jumpTarget = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getThirdOperand()));
            return ExpressionTreeExtractor.updateOperandTrees(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC"), jumpTarget, skippedInstructions, operandTrees, currentNativeInstructionAddress);
        }
        if (skippedInstructions == 0L && reilInstruction.getThirdOperand().getType() == OperandType.INTEGER_LITERAL || reilInstruction.getThirdOperand().getType() == OperandType.REGISTER) {
            LinkedBinaryTree<ComparableReilOperand> operand1 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
            LinkedBinaryTree<ComparableReilOperand> falseExpression = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> falseRoot = falseExpression.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mul")));
            BTPosition<ComparableReilOperand> falseLeft = falseExpression.insertLeft(falseRoot, new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "bisz")));
            falseExpression.attach(falseLeft, operand1, null);
            LinkedBinaryTree<ComparableReilOperand> trueExpression = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> trueRoot = trueExpression.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mul")));
            trueExpression.attach(trueRoot, operand1, null);
            LinkedBinaryTree<ComparableReilOperand> jumpTarget = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getThirdOperand()));
            ComparableReilOperand pcOperand = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "PC_CONDITIONAL_" + currentNativeInstructionAddress));
            falseExpression.attachRight(falseRoot, jumpTarget);
            trueExpression.attachRight(trueRoot, jumpTarget);
            LinkedBinaryTree<ComparableReilOperand> conditionalExpressionTree = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> conditionRoot = conditionalExpressionTree.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "add")));
            conditionalExpressionTree.attach(conditionRoot, falseExpression, trueExpression);
            operandTrees.storeTree(pcOperand, conditionalExpressionTree);
        } else {
            skippedInstructions = ExpressionTreeExtractor.calculateSkippedInstructions(reilInstruction);
            LinkedBinaryTree<ComparableReilOperand> operand1 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
            LinkedBinaryTree<ComparableReilOperand> falseExpression = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> falseRoot = falseExpression.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mul")));
            BTPosition<ComparableReilOperand> falseLeft = falseExpression.insertLeft(falseRoot, new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "bisz")));
            falseExpression.attach(falseLeft, operand1, null);
            operandTrees.storeTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "FALSE")), falseExpression);
            LinkedBinaryTree<ComparableReilOperand> trueExpression = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> trueRoot = trueExpression.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mul")));
            trueExpression.attach(trueRoot, operand1, null);
            operandTrees.storeTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "TRUE")), trueExpression);
        }
        return skippedInstructions;
    }

    private static long handleStmInstruction(ReilInstruction reilInstruction, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        LinkedBinaryTree<ComparableReilOperand> operand1 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
        LinkedBinaryTree<ComparableReilOperand> operand3 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getThirdOperand()));
        LinkedBinaryTree<ComparableReilOperand> expressionTree = new LinkedBinaryTree<ComparableReilOperand>();
        expressionTree.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, reilInstruction.getMnemonic())));
        expressionTree.attach(expressionTree.root(), operand1, operand3);
        ReilOperand memoryReilOperand = new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "MEM_" + reilInstruction.getAddress().toHexString());
        return ExpressionTreeExtractor.updateOperandTrees(memoryReilOperand, expressionTree, skippedInstructions, operandTrees, currentNativeInstructionAddress);
    }

    private static long handleStrInstruction(ReilInstruction reilInstruction, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        LinkedBinaryTree<ComparableReilOperand> expressionTree = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
        return ExpressionTreeExtractor.updateOperandTrees(reilInstruction.getThirdOperand(), expressionTree, skippedInstructions, operandTrees, currentNativeInstructionAddress);
    }

    private static long handleTernaryInstruction(ReilInstruction reilInstruction, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        LinkedBinaryTree<ComparableReilOperand> operand1 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getFirstOperand()));
        LinkedBinaryTree<ComparableReilOperand> operand2 = operandTrees.getTree(new ComparableReilOperand(reilInstruction.getSecondOperand()));
        LinkedBinaryTree<ComparableReilOperand> expressionTree = new LinkedBinaryTree<ComparableReilOperand>();
        Position<ComparableReilOperand> expressionRoot = expressionTree.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, reilInstruction.getMnemonic())));
        expressionTree.attach(expressionRoot, operand1, operand2);
        return ExpressionTreeExtractor.updateOperandTrees(reilInstruction.getThirdOperand(), expressionTree, skippedInstructions, operandTrees, currentNativeInstructionAddress);
    }

    private static long instructionAddressToLong(ReilInstruction reilInstruction) {
        return Long.parseLong(reilInstruction.getAddress().toString(), 16);
    }

    private static boolean isUnconditionalExecution(long skippedInstructions) {
        return skippedInstructions == 0L;
    }

    private static long updateOperandTrees(ReilOperand resultReilOperand, LinkedBinaryTree<ComparableReilOperand> expressionTree, long skippedInstructions, OperandTreeMap operandTrees, String currentNativeInstructionAddress) {
        ComparableReilOperand resultRegisterComparableReilOperand = new ComparableReilOperand(resultReilOperand);
        if (ComparableReilOperandHelper.isNativeRegister(resultRegisterComparableReilOperand)) {
            resultRegisterComparableReilOperand.setValue(String.valueOf(resultRegisterComparableReilOperand.getValue()) + "-" + currentNativeInstructionAddress);
        }
        if (ExpressionTreeExtractor.isUnconditionalExecution(skippedInstructions)) {
            operandTrees.storeTree(resultRegisterComparableReilOperand, expressionTree);
        } else if (ReilHelpers.isReilRegister((ReilOperand)resultReilOperand)) {
            operandTrees.storeTree(resultRegisterComparableReilOperand, expressionTree);
            --skippedInstructions;
        } else {
            LinkedBinaryTree<ComparableReilOperand> falseConditionTree = operandTrees.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "FALSE")));
            LinkedBinaryTree<ComparableReilOperand> trueConditionTree = operandTrees.getTree(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "TRUE")));
            Position<ComparableReilOperand> falseRoot = falseConditionTree.root();
            falseConditionTree.attachRight(falseRoot, expressionTree);
            Position<ComparableReilOperand> trueRoot = trueConditionTree.root();
            trueConditionTree.attachRight(trueRoot, operandTrees.getTree(new ComparableReilOperand(new ReilOperand(resultReilOperand.getSize(), resultReilOperand.getValue()))));
            LinkedBinaryTree<ComparableReilOperand> conditionalExpressionTree = new LinkedBinaryTree<ComparableReilOperand>();
            Position<ComparableReilOperand> conditionRoot = conditionalExpressionTree.addRoot(new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "add")));
            conditionalExpressionTree.attach(conditionRoot, falseConditionTree, trueConditionTree);
            if (resultRegisterComparableReilOperand.getValue().startsWith("PC")) {
                resultRegisterComparableReilOperand.setValue("PC_CONDITIONAL_" + currentNativeInstructionAddress);
            }
            operandTrees.storeTree(resultRegisterComparableReilOperand, conditionalExpressionTree);
            --skippedInstructions;
        }
        return skippedInstructions;
    }

    public static OperandTreeMap extractor(ReilGraph reilGraph, Instruction currentInstruction) {
        String currentInstructionAddress = currentInstruction.getAddress().toHexString();
        OperandTreeMap operandTrees = new OperandTreeMap();
        long skippedInstructions = 0L;
        for (ReilBlock reilBlock : reilGraph.getNodes()) {
            for (ReilInstruction reilInst : reilBlock) {
                if (ReilHelpers.isTernaryInstruction((ReilInstruction)reilInst)) {
                    skippedInstructions = ExpressionTreeExtractor.handleTernaryInstruction(reilInst, skippedInstructions, operandTrees, currentInstructionAddress);
                    continue;
                }
                if (reilInst.getMnemonic().equalsIgnoreCase("LDM") || reilInst.getMnemonic().equalsIgnoreCase("BISZ")) {
                    skippedInstructions = ExpressionTreeExtractor.handleBinaryInstructions(reilInst, skippedInstructions, operandTrees, currentInstructionAddress);
                    continue;
                }
                if (reilInst.getMnemonic().equalsIgnoreCase("STM")) {
                    skippedInstructions = ExpressionTreeExtractor.handleStmInstruction(reilInst, skippedInstructions, operandTrees, currentInstructionAddress);
                    continue;
                }
                if (reilInst.getMnemonic().equalsIgnoreCase("STR")) {
                    skippedInstructions = ExpressionTreeExtractor.handleStrInstruction(reilInst, skippedInstructions, operandTrees, currentInstructionAddress);
                    continue;
                }
                if (reilInst.getMnemonic().equalsIgnoreCase("JCC")) {
                    skippedInstructions = ExpressionTreeExtractor.handleJccInstruction(reilInst, skippedInstructions, operandTrees, currentInstructionAddress);
                    continue;
                }
                if (!reilInst.getMnemonic().equalsIgnoreCase("UNKN")) continue;
                System.out.println("[!] Could not extract OperandTreeMap for unknown ReilTranslation of:" + currentInstruction.getMnemonic() + " @ " + currentInstructionAddress);
            }
        }
        OperandTreeMapHelper.removeObsoleteTrees(operandTrees);
        if (OperandTreeMapHelper.checkTreesForTemporaryRegisters(operandTrees)) {
            System.out.println("[!] instruction: " + currentInstruction.getMnemonic() + " must be checked for consistency");
        }
        return operandTrees;
    }
}

