/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms;

import BinNavi.API.reil.OperandSize;
import BinNavi.API.reil.OperandType;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.maps.PathOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.List;

public class OperandTreeMinimizer {
    private static final ComparableReilOperand ZERO_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "0"));
    private static final ComparableReilOperand TRUNCATION_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "4294967295"));
    private static final ComparableReilOperand BISZ_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "bisz"));
    private static final ComparableReilOperand ADD_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "add"));
    private static final ComparableReilOperand SUB_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "sub"));
    private static final ComparableReilOperand MUL_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mul"));
    private static final ComparableReilOperand OR_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "or"));
    private static final ComparableReilOperand MOD_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "mod"));
    private static final ComparableReilOperand DIV_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "div"));
    private static final ComparableReilOperand BSH_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "bsh"));
    private static final ComparableReilOperand AND_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "and"));
    private static final ComparableReilOperand XOR_VARIABLE = new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, "xor"));

    private static boolean evaluate(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, IBinaryExpressionEvaluator evaluator) {
        OperandType leftChildType = currentTree.left(currentPosition).element().getElement().getType();
        OperandType rightChildType = currentTree.right(currentPosition).element().getElement().getType();
        if (leftChildType.equals((Object)OperandType.INTEGER_LITERAL) && rightChildType.equals((Object)OperandType.INTEGER_LITERAL)) {
            Long leftChildValue = Long.parseLong(currentTree.left(currentPosition).element().getElement().getValue());
            Long rightChildValue = Long.parseLong(currentTree.right(currentPosition).element().getElement().getValue());
            Long newValue = evaluator.evaluate(leftChildValue, rightChildValue);
            currentTree.remove(currentTree.left(currentPosition));
            currentTree.remove(currentTree.right(currentPosition));
            currentTree.replace(currentPosition, new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, newValue.toString())));
            return true;
        }
        return false;
    }

    private static boolean evaluateAddOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, ADD_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs + rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateAndOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, AND_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs & rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateBiszOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, BISZ_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                OperandType leftChildType = currentTree.left(currentPosition).element().getElement().getType();
                if (leftChildType.equals((Object)OperandType.INTEGER_LITERAL)) {
                    Long leftChildValue = Long.parseLong(currentTree.left(currentPosition).element().getElement().getValue());
                    Long newValue = leftChildValue == 0L ? new Long(1L) : new Long(0L);
                    currentTree.remove(currentTree.left(currentPosition));
                    currentTree.replace(currentPosition, new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, newValue.toString())));
                    return true;
                }
                return false;
            }
        });
    }

    private static boolean evaluateBshOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, BSH_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        if (rhs > 0L) {
                            return lhs << (int)rhs;
                        }
                        return lhs >> (int)(-rhs);
                    }
                });
            }
        });
    }

    private static boolean evaluateDivOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, DIV_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs / rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateModOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, MOD_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs % rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateMulOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, MUL_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs * rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateOrOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, OR_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs | rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateSubOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, SUB_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs - rhs;
                    }
                });
            }
        });
    }

    private static boolean evaluateXorOperation(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, XOR_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                return OperandTreeMinimizer.evaluate(currentTree, currentPosition, new IBinaryExpressionEvaluator(){

                    @Override
                    public long evaluate(long lhs, long rhs) {
                        return lhs ^ rhs;
                    }
                });
            }
        });
    }

    private static boolean iterate(LinkedBinaryTree<ComparableReilOperand> currentTree, ComparableReilOperand searchedOperand, ITreeModifierCallback modifier) {
        boolean treeWasModified = false;
        for (Position<ComparableReilOperand> maskPosition : currentTree.find(searchedOperand)) {
            if (!currentTree.hasParent(maskPosition)) continue;
            Position<ComparableReilOperand> parentPosition = currentTree.parent(maskPosition);
            treeWasModified |= modifier.nextElement(currentTree, maskPosition, parentPosition);
        }
        return treeWasModified;
    }

    private static boolean mergeAdditiveOperations(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, ADD_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                String parentValue = parentPosition.element().getElement().getValue();
                if ((parentValue.equalsIgnoreCase("add") || parentValue.equalsIgnoreCase("sub")) && currentTree.isExternal(currentTree.right(parentPosition)) && currentTree.isExternal(currentTree.right(currentPosition))) {
                    OperandType parentType = currentTree.right(parentPosition).element().getElement().getType();
                    OperandType addPositionType = currentTree.right(currentPosition).element().getElement().getType();
                    if (!parentType.equals((Object)OperandType.REGISTER) && !addPositionType.equals((Object)OperandType.REGISTER)) {
                        Long parentChildValue = Long.parseLong(currentTree.right(parentPosition).element().getElement().getValue());
                        Long addPositionChildValue = Long.parseLong(currentTree.right(currentPosition).element().getElement().getValue());
                        Long newLongVar = parentValue.equalsIgnoreCase("add") ? parentChildValue + addPositionChildValue : parentChildValue - addPositionChildValue;
                        currentTree.remove(currentTree.right(currentPosition));
                        currentTree.remove(currentPosition);
                        currentTree.replace(currentTree.right(parentPosition), new ComparableReilOperand(new ReilOperand(OperandSize.OPERAND_SIZE_DWORD, newLongVar.toString())));
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static boolean mergeBiszs(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, BISZ_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                String parentValue = parentPosition.element().getElement().getValue();
                if (parentValue.equals("bisz")) {
                    currentTree.remove(currentPosition);
                    currentTree.remove(parentPosition);
                    return true;
                }
                return false;
            }
        });
    }

    private static boolean removeNeutralElementLeft(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, ZERO_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                String parentValue = parentPosition.element().getElement().getValue();
                if ((parentValue.equalsIgnoreCase("add") || parentValue.equalsIgnoreCase("xor") || parentValue.equalsIgnoreCase("or")) && currentTree.left(parentPosition) == currentPosition && currentTree.isExternal(currentPosition)) {
                    currentTree.remove(currentPosition);
                    currentTree.remove(parentPosition);
                    return true;
                }
                if ((parentValue.equalsIgnoreCase("and") || parentValue.equalsIgnoreCase("mul") || parentValue.equalsIgnoreCase("bsh") || parentValue.equalsIgnoreCase("div")) && currentTree.left(parentPosition) == currentPosition && currentTree.isExternal(currentTree.sibling(currentPosition))) {
                    currentTree.remove(currentTree.sibling(currentPosition));
                    currentTree.remove(parentPosition);
                    return true;
                }
                return false;
            }
        });
    }

    private static boolean removeNeutralElementRight(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, ZERO_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                String parentValue = parentPosition.element().getElement().getValue();
                if ((parentValue.equalsIgnoreCase("add") || parentValue.equalsIgnoreCase("sub") || parentValue.equalsIgnoreCase("bsh") || parentValue.equalsIgnoreCase("xor") || parentValue.equalsIgnoreCase("or")) && currentTree.right(parentPosition) == currentPosition && currentTree.isExternal(currentPosition)) {
                    currentTree.remove(currentPosition);
                    currentTree.remove(parentPosition);
                    return true;
                }
                if ((parentValue.equalsIgnoreCase("and") || parentValue.equalsIgnoreCase("mul")) && currentTree.right(parentPosition) == currentPosition && currentTree.isExternal(currentTree.sibling(currentPosition))) {
                    currentTree.remove(currentTree.sibling(currentPosition));
                    currentTree.remove(parentPosition);
                    return true;
                }
                return false;
            }
        });
    }

    private static boolean removeTruncationOperands(LinkedBinaryTree<ComparableReilOperand> currentTree) {
        return OperandTreeMinimizer.iterate(currentTree, TRUNCATION_VARIABLE, new ITreeModifierCallback(){

            @Override
            public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> currentTree, Position<ComparableReilOperand> currentPosition, Position<ComparableReilOperand> parentPosition) {
                if (parentPosition.element().getElement().getValue().equals("and") && currentTree.right(parentPosition) == currentPosition) {
                    currentTree.remove(currentPosition);
                    currentTree.remove(parentPosition);
                    return true;
                }
                return false;
            }
        });
    }

    public static void minimize(PathOperandTreeMap pathToOperandTreeMap) {
        for (Pair<Long, List<Long>> key : pathToOperandTreeMap.keySet()) {
            for (LinkedBinaryTree<ComparableReilOperand> currentTree : pathToOperandTreeMap.getTrees(key)) {
                do {
                    boolean treeWasModified = false;
                    treeWasModified |= OperandTreeMinimizer.removeTruncationOperands(currentTree);
                    treeWasModified |= OperandTreeMinimizer.removeNeutralElementRight(currentTree);
                    treeWasModified |= OperandTreeMinimizer.removeNeutralElementLeft(currentTree);
                    treeWasModified |= OperandTreeMinimizer.mergeBiszs(currentTree);
                    treeWasModified |= OperandTreeMinimizer.mergeAdditiveOperations(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateAddOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateAndOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateBiszOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateBshOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateDivOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateModOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateMulOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateOrOperation(currentTree);
                    treeWasModified |= OperandTreeMinimizer.evaluateSubOperation(currentTree);
                } while (treeWasModified |= OperandTreeMinimizer.evaluateXorOperation(currentTree));
            }
        }
    }

    private static interface IBinaryExpressionEvaluator {
        public long evaluate(long var1, long var3);
    }

    private static interface ITreeModifierCallback {
        public boolean nextElement(LinkedBinaryTree<ComparableReilOperand> var1, Position<ComparableReilOperand> var2, Position<ComparableReilOperand> var3);
    }
}

