/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.reil.ReilOperand;
import binnavi.plugins.gadgetfinder.algorithms.ExpressionTreeUpdater;
import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.helpers.AddressOperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.ComparableReilOperandHelper;
import binnavi.plugins.gadgetfinder.datastructures.helpers.OperandTreeMapHelper;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressBlocksPathMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.PathOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import binnavi.plugins.gadgetfinder.helper.Pair;
import java.util.List;
import java.util.Map;

public class PathOperandTreeMerger {
    private static OperandTreeMap buildTemporaryOperandTreeMap(OperandTreeMap currentPathOperandTreeMap) {
        OperandTreeMap tempOperandMap = new OperandTreeMap();
        for (ComparableReilOperand treeKey : currentPathOperandTreeMap.keySet()) {
            String[] treeKeyArray = treeKey.getValue().split("-");
            if (treeKeyArray.length <= 1) continue;
            LinkedBinaryTree<ComparableReilOperand> registerTree = currentPathOperandTreeMap.getTree(treeKey);
            tempOperandMap.storeTree(treeKey, registerTree);
        }
        return tempOperandMap;
    }

    private static void fixAddressSuffix(OperandTreeMap tempOperandMap, OperandTreeMap currentPathOperandTreeMap) {
        for (ComparableReilOperand oldKey : tempOperandMap.keySet()) {
            String[] keyArray = oldKey.getValue().split("-");
            String newKeyValue = keyArray[0];
            ComparableReilOperand newKey = new ComparableReilOperand(new ReilOperand(oldKey.getSize(), newKeyValue));
            currentPathOperandTreeMap.storeTree(newKey, tempOperandMap.getTree(oldKey));
            currentPathOperandTreeMap.deleteTree(oldKey);
        }
    }

    private static void traverseAndUpdateAddressOperandTreeMap(OperandTreeMap currentAddressOperandTreeMap, OperandTreeMap currentPathOperandTreeMap) {
        for (ComparableReilOperand operandTreeKey : currentAddressOperandTreeMap.keySet()) {
            if (!ComparableReilOperandHelper.isNativeRegister(operandTreeKey)) continue;
            ExpressionTreeUpdater.updateExpressionTree(currentAddressOperandTreeMap.getTree(operandTreeKey), currentPathOperandTreeMap, operandTreeKey);
        }
    }

    public static void mergePathOperandTrees(AddressBlocksPathMap addressToPath, AddressOperandTreeMap addressToForests, PathOperandTreeMap pathToOperandTreeMap) {
        int maximumTreeSize = 500;
        for (Map.Entry<Pair<Long, List<BasicBlock>>, List<Long>> addressToPathElement : addressToPath.entrySet()) {
            OperandTreeMap currentPathOperandTreeMap = new OperandTreeMap();
            boolean updateFlag = true;
            List<Long> addressToPathElementPath = addressToPathElement.getValue();
            for (Long currentAddressToPathElement : addressToPathElementPath) {
                OperandTreeMap currentAddressOperandTreeMap = AddressOperandTreeMapHelper.jumpConditionDeterminator(addressToForests, addressToPathElementPath, currentAddressToPathElement);
                PathOperandTreeMerger.traverseAndUpdateAddressOperandTreeMap(currentAddressOperandTreeMap, currentPathOperandTreeMap);
                OperandTreeMap tempOperandMap = PathOperandTreeMerger.buildTemporaryOperandTreeMap(currentPathOperandTreeMap);
                PathOperandTreeMerger.fixAddressSuffix(tempOperandMap, currentPathOperandTreeMap);
                if (OperandTreeMapHelper.checkTreeSize(currentPathOperandTreeMap, 500)) continue;
                currentPathOperandTreeMap.deleteAllTrees();
                updateFlag = false;
                break;
            }
            if (!updateFlag) continue;
            Pair<Long, List<Long>> pathToOperandTreeMapKey = new Pair<Long, List<Long>>(addressToPathElement.getKey().first(), addressToPathElement.getValue());
            pathToOperandTreeMap.put(pathToOperandTreeMapKey, currentPathOperandTreeMap);
        }
    }
}

