/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.algorithms.helpers;

import BinNavi.API.disassembly.BasicBlock;
import BinNavi.API.disassembly.Instruction;
import BinNavi.API.reil.InternalTranslationException;
import BinNavi.API.reil.ReilGraph;
import binnavi.plugins.gadgetfinder.algorithms.ExpressionTreeExtractor;
import binnavi.plugins.gadgetfinder.algorithms.helpers.ReverseTreeWalkerCallback;
import binnavi.plugins.gadgetfinder.datastructures.maps.AddressOperandTreeMap;
import binnavi.plugins.gadgetfinder.datastructures.maps.OperandTreeMap;
import java.util.List;

public class OperandTreemapCollectorCallback
implements ReverseTreeWalkerCallback {
    private final AddressOperandTreeMap m_addressToForests = new AddressOperandTreeMap();

    @Override
    public boolean call(List<BasicBlock> currentPath, BasicBlock currentBasicBlock, Instruction currentInstruction) {
        long currentAddress = currentInstruction.getAddress().toLong();
        if (this.m_addressToForests.hasTree(currentAddress)) {
            return true;
        }
        try {
            ReilGraph reilGraph = currentInstruction.getReilCode();
            OperandTreeMap operandTreeMap = ExpressionTreeExtractor.extractor(reilGraph, currentInstruction);
            this.m_addressToForests.put(currentAddress, operandTreeMap);
        }
        catch (InternalTranslationException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    public AddressOperandTreeMap getTreemap() {
        return this.m_addressToForests;
    }
}

